/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.definitionlists;

import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.definitionlists.ListDefinitionEditPanel;
import mausoleum.definitionlists.ListDefinitionTable;
import mausoleum.definitionlists.Microorganism;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.gui.SimpleList;
import mausoleum.helper.FontManager;
import mausoleum.main.MausoleumClient;
import mausoleum.ui.UIDef;

public class ListDefinitionPane
extends RequesterPane {
    private static final long serialVersionUID = 1L;
    private static final int TYP_WIDTH = UIDef.getScaled(240);
    private SimpleList ivTypesList = new SimpleList();
    private JScrollPane ivTypesPane = new JScrollPane(this.ivTypesList);
    private BorderPanel ivTypesPanel = new BorderPanel(this.ivTypesPane, Babel.get("DEFINITION_LISTS"));
    private ListDefinitionTable ivValueTable = new ListDefinitionTable();
    private JScrollPane ivValuePane = new JScrollPane(this.ivValueTable);
    private JTextPane ivDescriptionPane = new JTextPane();
    private JScrollPane ivDescrScrollPane = new JScrollPane(this.ivDescriptionPane);
    private JSplitPane ivValueSplitPane = new JSplitPane(0, false, new BorderPanel(this.ivValuePane, Babel.get("LIST_DEF_VALUES")), new BorderPanel(this.ivDescrScrollPane, Babel.get("DESCRIPTION")));
    private MGButton ivAddButton = new MGButton(Babel.get("LIST_ADD_DEFINITION"));
    private MGButton ivEditButton = new MGButton(Babel.get("LIST_EDIT_DEFINITION"));
    private MGButton ivRemoveButton = new MGButton(Babel.get("LIST_REMOVE_DEFINITION"));
    private MGButton ivReviveButton = new MGButton(Babel.get("LIST_REVIVE_DEFINITION"));

    public ListDefinitionPane() {
        super(null, "inspectorButton");
        this.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                int w2 = d.width - TYP_WIDTH - 2 * UIDef.RAND - UIDef.INNER_RAND;
                int ih = d.height - 2 * UIDef.RAND;
                int x = UIDef.RAND;
                int y = UIDef.RAND;
                ListDefinitionPane.this.ivTypesPanel.setBounds(x, y, TYP_WIDTH, ih);
                int th = ih - UIDef.BUT_HEIGHT - UIDef.INNER_RAND;
                ListDefinitionPane.this.ivValueSplitPane.setBounds(x += TYP_WIDTH + UIDef.INNER_RAND, y, w2, th);
                int lw = (w2 - 2 * UIDef.INNER_RAND) / 4;
                int rw = w2 - 3 * UIDef.INNER_RAND - 3 * lw;
                ListDefinitionPane.this.ivAddButton.setBounds(x, y += th + UIDef.INNER_RAND, lw, UIDef.BUT_HEIGHT);
                ListDefinitionPane.this.ivEditButton.setBounds(x += lw + UIDef.INNER_RAND, y, lw, UIDef.BUT_HEIGHT);
                ListDefinitionPane.this.ivRemoveButton.setBounds(x += lw + UIDef.INNER_RAND, y, lw, UIDef.BUT_HEIGHT);
                ListDefinitionPane.this.ivReviveButton.setBounds(x += lw + UIDef.INNER_RAND, y, rw, UIDef.BUT_HEIGHT);
            }
        });
        Vector<String> v = new Vector<String>(ListDefinition.KNOWN_TYPE_BABELS.length);
        int i = 0;
        while (i < ListDefinition.KNOWN_TYPE_BABELS.length) {
            v.add(" " + Babel.get(ListDefinition.KNOWN_TYPE_BABELS[i]) + " ");
            ++i;
        }
        this.ivTypesList.setListData(v);
        this.ivTypesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListDefinitionPane.this.typeListSelected();
                }
            }
        });
        this.add(this.ivTypesPanel);
        this.ivValueTable.setSelectionMode(0);
        this.ivValueTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                if (!arg0.getValueIsAdjusting()) {
                    ListDefinition ld = (ListDefinition)ListDefinitionPane.this.ivValueTable.getObjectAtRow(ListDefinitionPane.this.ivValueTable.getSelectedRow());
                    if (ld != null) {
                        ListDefinitionPane.this.ivDescriptionPane.setText(ld.ivDescription == null ? "" : ld.ivDescription);
                        ListDefinitionPane.this.ivDescriptionPane.setCaretPosition(0);
                    } else {
                        ListDefinitionPane.this.ivDescriptionPane.setText("");
                    }
                    ListDefinitionPane.this.checkButs();
                }
            }
        });
        this.ivDescriptionPane.setFont(FontManager.getFont("SSB12"));
        this.ivDescriptionPane.setEditable(false);
        this.ivDescriptionPane.setDisabledTextColor(Color.black);
        this.ivDescriptionPane.setMargin(new Insets(UIDef.getScaled(4), UIDef.getScaled(4), UIDef.getScaled(4), UIDef.getScaled(4)));
        this.ivValueSplitPane.setBorder(null);
        this.ivValueSplitPane.setOpaque(false);
        this.ivValueSplitPane.setResizeWeight(0.6);
        this.add(this.ivValueSplitPane);
        this.ivAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int selind = ListDefinitionPane.this.ivTypesList.getSelectedIndex();
                if (selind != -1) {
                    ListDefinition ld = null;
                    int typ = ListDefinition.KNOWN_TYPES[selind];
                    ld = ListDefinition.isKeimRelevant(typ) ? Microorganism.getNewDefinition(typ) : new ListDefinition(typ);
                    if (ListDefinitionEditPanel.editDefinition(ListDefinitionPane.this.ivAddButton, ld)) {
                        if (ListDefinition.isKeimRelevant(ld.ivTyp)) {
                            Microorganism.digestNewDefinition(ld);
                        } else {
                            ListDefinition.digestNewDefinition(ld, UserManager.getFirstGroup());
                        }
                        ListDefinitionPane.this.typeListSelected();
                    }
                }
            }
        });
        this.add(this.ivAddButton);
        this.ivEditButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ListDefinition ld;
                int selind = ListDefinitionPane.this.ivTypesList.getSelectedIndex();
                if (selind != -1 && (ld = (ListDefinition)ListDefinitionPane.this.ivValueTable.getObjectAtRow(ListDefinitionPane.this.ivValueTable.getSelectedRow())) != null && ListDefinitionEditPanel.editDefinition(ListDefinitionPane.this.ivEditButton, ld)) {
                    if (ListDefinition.isKeimRelevant(ld.ivTyp)) {
                        Microorganism.saveStandardsToServer();
                    } else {
                        ListDefinition.saveStandardsToServer(UserManager.getFirstGroup());
                    }
                    ListDefinitionPane.this.typeListSelected();
                }
            }
        });
        this.add(this.ivEditButton);
        this.ivRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ListDefinitionPane.this.changeActivation((ListDefinition)ListDefinitionPane.this.ivValueTable.getObjectAtRow(ListDefinitionPane.this.ivValueTable.getSelectedRow()), false);
            }
        });
        this.add(this.ivRemoveButton);
        this.ivReviveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ListDefinitionPane.this.changeActivation((ListDefinition)ListDefinitionPane.this.ivValueTable.getObjectAtRow(ListDefinitionPane.this.ivValueTable.getSelectedRow()), true);
            }
        });
        this.add(this.ivReviveButton);
        this.checkButs();
    }

    private void changeActivation(ListDefinition ld, boolean newValue) {
        if (ld != null && ld.ivActive != newValue) {
            ld.ivActive = newValue;
            if (ListDefinition.isKeimRelevant(ld.ivTyp)) {
                Microorganism.saveStandardsToServer();
            } else {
                ListDefinition.saveStandardsToServer(UserManager.getFirstGroup());
            }
            this.typeListSelected();
        }
    }

    public void typeListSelected() {
        ListDefinition previouslySelectedDefinition = (ListDefinition)this.ivValueTable.getObjectAtRow(this.ivValueTable.getSelectedRow());
        int indexOfSelectedListType = this.ivTypesList.getSelectedIndex();
        Vector values = ArrayHelper.LEER;
        if (indexOfSelectedListType != -1) {
            values = ListDefinition.getItems(null, ListDefinition.KNOWN_TYPES[indexOfSelectedListType], false, false, false);
        }
        this.ivValueTable.clearSelection();
        this.ivValueTable.setObjects(values, ListDefinition.KNOWN_TYPES[indexOfSelectedListType]);
        if (previouslySelectedDefinition != null) {
            int indTosel = -1;
            int i = 0;
            while (i < values.size()) {
                ListDefinition ld = (ListDefinition)values.elementAt(i);
                if (ld.ivTyp == previouslySelectedDefinition.ivTyp && ld.ivID == previouslySelectedDefinition.ivID) {
                    indTosel = i;
                }
                ++i;
            }
            if (indTosel != -1) {
                this.ivValueTable.getSelectionModel().setSelectionInterval(indTosel, indTosel);
            }
        }
        this.checkButs();
    }

    private void checkButs() {
        boolean[] enabled = new boolean[4];
        int i = 0;
        while (i < enabled.length) {
            enabled[i] = false;
            ++i;
        }
        if (this.ivTypesList.getSelectedIndex() != -1) {
            enabled[0] = Privileges.hasPrivilege("ADD_DEFINITION");
            ListDefinition ld = (ListDefinition)this.ivValueTable.getObjectAtRow(this.ivValueTable.getSelectedRow());
            if (ld != null) {
                boolean gruppePasst;
                boolean bl = UserManager.getFirstGroup().equals("service") ? ld.ivID > 5000 : (gruppePasst = ld.ivID < 5000);
                if (gruppePasst) {
                    if (ld.isActive()) {
                        enabled[1] = Privileges.hasPrivilege("EDIT_DEFINITION");
                        enabled[2] = Privileges.hasPrivilege("REMOVE_DEFINITION");
                    } else {
                        enabled[3] = Privileges.hasPrivilege("REVIVE_DEFINITION");
                    }
                }
            }
        }
        int selectedType = 0;
        int selind = this.ivTypesList.getSelectedIndex();
        if (selind != -1) {
            selectedType = ListDefinition.KNOWN_TYPES[selind];
        }
        if (!MausoleumClient.isHeadOfService()) {
            if (8 == selectedType || 9 == selectedType) {
                enabled[0] = false;
                enabled[1] = false;
                enabled[2] = false;
                enabled[3] = false;
            }
        } else if ((enabled[0] || enabled[1]) && (9 == selectedType || 8 == selectedType)) {
            enabled[0] = Privileges.hasPrivilege("ADD_DEFINITION");
            ListDefinition ld = (ListDefinition)this.ivValueTable.getObjectAtRow(this.ivValueTable.getSelectedRow());
            if (ld != null) {
                if (ld.isActive()) {
                    enabled[1] = Privileges.hasPrivilege("EDIT_DEFINITION");
                    enabled[2] = Privileges.hasPrivilege("REMOVE_DEFINITION");
                } else {
                    enabled[3] = Privileges.hasPrivilege("REVIVE_DEFINITION");
                }
            }
        }
        this.ivAddButton.setEnabled(enabled[0]);
        this.ivEditButton.setEnabled(enabled[1]);
        this.ivRemoveButton.setEnabled(enabled[2]);
        this.ivReviveButton.setEnabled(enabled[3]);
    }
}

