/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.definitionlists;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.definitionlists.Microorganism;
import mausoleum.gui.SortButton;
import mausoleum.helper.FontManager;
import mausoleum.ui.UIDef;
import mausoleum.ui.table.SortableTable;
import mausoleum.ui.table.TableSortable;

public class ListDefinitionTable
extends SortableTable
implements TableCellRenderer {
    private static final long serialVersionUID = 1232342L;
    private static final String[] KEIM_COL_BABELS = new String[]{"GETN_NAME", "GETN_TYPE", "GETN_FELASA", "GETN_METHOD"};
    private static final int[] KEIM_COL_ALIGNTMENTS;
    private int ivTyp;
    private JLabel ivListLabel = new JLabel();
    private static final String[] COL_BABELS;
    private static final int[] COL_ALIGNTMENTS;
    private SortButton ivColHeaderLabel = new SortButton("");
    private DefaultTableModel ivDTM = new DefaultTableModel();
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[1] = 2;
        nArray[3] = 2;
        KEIM_COL_ALIGNTMENTS = nArray;
        COL_BABELS = new String[]{"GETN_NAME"};
        COL_ALIGNTMENTS = new int[]{2};
    }

    public ListDefinitionTable() {
        this.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable arg0, Object value, boolean arg2, boolean arg3, int arg4, int arg5) {
                ListDefinitionTable.this.ivColHeaderLabel.setText((String)value);
                return ListDefinitionTable.this.ivColHeaderLabel;
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultRenderer(clazz, this);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                String tt = null;
                int row = ListDefinitionTable.this.rowAtPoint(e.getPoint());
                if (row >= 0 && row < ListDefinitionTable.this.ivObjects.size()) {
                    ListDefinition ld = (ListDefinition)ListDefinitionTable.this.ivObjects.elementAt(row);
                    tt = ld.getTooltip();
                }
                ListDefinitionTable.this.setToolTipText(tt);
            }
        });
    }

    public void setObjects(Vector v, int typ) {
        boolean changeCols;
        this.clearSelection();
        boolean bl = changeCols = this.getColumnCount(typ) != this.getColumnCount();
        if (changeCols) {
            this.ivObjects.clear();
            if (v != null) {
                this.ivObjects.addAll(v);
            }
            this.setModel(this.ivDTM);
            this.ivTyp = typ;
            this.setModel(this);
        } else {
            this.ivTyp = typ;
            super.setObjects(v);
        }
    }

    public int getColumnCount() {
        return this.getColumnCount(this.ivTyp);
    }

    public int getColumnCount(int typ) {
        return typ == 8 ? 4 : 1;
    }

    public String getColumnName(int columnIndex) {
        return this.ivTyp == 8 ? Babel.get(KEIM_COL_BABELS[columnIndex]) : Babel.get(COL_BABELS[columnIndex]);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ListDefinition ld = (ListDefinition)this.getObjectAtRow(rowIndex);
        if (ld != null) {
            Microorganism.Keim keim;
            if (this.ivTyp == 8 && ld instanceof Microorganism.Keim && (keim = (Microorganism.Keim)ld) != null) {
                switch (columnIndex) {
                    case 0: {
                        return keim.toString();
                    }
                    case 1: {
                        return keim.getTypString();
                    }
                    case 2: {
                        return keim.ivFelasaRelevant ? "x" : "";
                    }
                    case 3: {
                        return keim.getMethodString();
                    }
                }
                return "";
            }
            switch (columnIndex) {
                case 0: {
                    return ld.toString();
                }
            }
            return "";
        }
        return "";
    }

    public Vector fillSortablesVector(int col) {
        if (this.getRowCount() <= 1) {
            return null;
        }
        Vector<TableSortable> erg = new Vector<TableSortable>();
        if (this.ivTyp == 8) {
            int row = 0;
            while (row < this.getRowCount()) {
                Microorganism.Keim keim = (Microorganism.Keim)this.getObjectAtRow(row);
                switch (col) {
                    case 0: {
                        erg.addElement(new TableSortable(row, (Comparable)((Object)keim.toString())));
                        break;
                    }
                    case 1: {
                        erg.addElement(new TableSortable(row, (Comparable)((Object)keim.getTypString())));
                        break;
                    }
                    case 2: {
                        erg.addElement(new TableSortable(row, Boolean.valueOf(keim.ivFelasaRelevant)));
                        break;
                    }
                    case 3: {
                        erg.addElement(new TableSortable(row, (Comparable)((Object)keim.getMethodString())));
                    }
                }
                ++row;
            }
        } else {
            int row = 0;
            while (row < this.getRowCount()) {
                ListDefinition sci = (ListDefinition)this.getObjectAtRow(row);
                switch (col) {
                    case 0: {
                        erg.addElement(new TableSortable(row, (Comparable)((Object)sci.toString())));
                        break;
                    }
                }
                ++row;
            }
        }
        return erg;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ListDefinition ld = (ListDefinition)this.getObjectAtRow(row);
        this.ivListLabel.setIcon(null);
        if (ld.ivActive) {
            this.ivListLabel.setFont(FontManager.getFont("SSB11"));
        } else {
            this.ivListLabel.setFont(FontManager.getFont("SSP11"));
        }
        if (this.ivTyp == 8) {
            this.ivListLabel.setHorizontalAlignment(KEIM_COL_ALIGNTMENTS[column]);
            Microorganism.Keim k = (Microorganism.Keim)ld;
            this.ivListLabel.setForeground(k.getFG());
        } else {
            this.ivListLabel.setHorizontalAlignment(COL_ALIGNTMENTS[column]);
            this.ivListLabel.setForeground(Color.black);
        }
        StringBuffer msb = new StringBuffer();
        msb.append(" ").append(value).append(" ");
        this.ivListLabel.setText(msb.toString());
        this.ivListLabel.setBackground(isSelected ? UIDef.SELECTED_BACKGROUND : null);
        this.ivListLabel.setOpaque(isSelected);
        return this.ivListLabel;
    }
}

