/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.definitionlists;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.gui.ColorManager;
import mausoleum.helper.Zeile;
import mausoleum.util.InstallationType;

public class Microorganism {
    private static final String KEIM_FILE = "germs.stxt";
    private static final String KEIM_PATH = String.valueOf(GroupFileManager.getConfigDirPath("service")) + "/" + "germs.stxt";
    public static final int KEIM_TYPE_UNKNOWN = 0;
    public static final int KEIM_TYPE_VIRUS = 1;
    public static final int KEIM_TYPE_PROKARYONT = 2;
    public static final int KEIM_TYPE_EKTOPARASIT = 3;
    public static final int KEIM_TYPE_ENDOPARASIT = 4;
    public static final int KEIM_TYPE_PATHOLOGIE = 5;
    public static final int[] KEIM_TYPES = new int[]{1, 2, 3, 4, 5};
    public static final String[] KEIM_TYP_BABELS = new String[]{"GETY_VIRUS", "GETY_PROKARYONT", "GETY_EKTOPARASITE", "GETY_ENDOPARASITE", "GETY_PATHOLOGIE"};
    public static final Color[] KEIM_COLORS = new Color[]{ColorManager.getColorFromString("midnightblue"), ColorManager.getColorFromString("maroon"), ColorManager.getColorFromString("darkgreen"), ColorManager.getColorFromString("black"), ColorManager.getColorFromString("indigo")};
    private static HashMap DEFS_HM = new HashMap();
    public static final Comparator KEIM_OHNE_FELASA_COMP = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Keim && o2 instanceof Keim) {
                Keim keim1 = (Keim)o1;
                Keim keim2 = (Keim)o2;
                if (keim1.ivKeimTyp < keim2.ivKeimTyp) {
                    return -1;
                }
                if (keim1.ivKeimTyp > keim2.ivKeimTyp) {
                    return 1;
                }
                return keim1.ivName.compareToIgnoreCase(keim2.ivName);
            }
            return 0;
        }
    };

    public static void init(String group) {
        if (InstallationType.isMouse() && group.equals("service") && DEFS_HM.isEmpty()) {
            String sk = FileManager.getStringContentFromServer(String.valueOf(GroupFileManager.getConfigDirPath(group)) + "/" + KEIM_FILE);
            if (sk == null || sk.length() == 0) {
                Microorganism.initServiceValues(DEFS_HM);
                Microorganism.saveStandardsToServer();
            } else {
                Microorganism.handleFile(sk, DEFS_HM);
            }
        }
    }

    public static void digestNewDefinition(ListDefinition ld) {
        Vector v;
        if (ld instanceof KeimMethod) {
            KeimMethod km = (KeimMethod)ld;
            km.ivAktDisplayString = ListDefinition.getDisplayValue(km.ivValue, km.ivName);
        }
        if ((v = Microorganism.getMatchingVector("service", ld.ivTyp)) != null) {
            ld.ivID = 5000 + v.size() + 1;
            v.add(ld);
        }
        Microorganism.saveStandardsToServer();
    }

    public static void saveStandardsToServer() {
        ListDefinition.saveStandardsToServer(DEFS_HM, "service", KEIM_PATH);
    }

    public static Keim getKeim(int id) {
        return (Keim)Microorganism.getLD(8, id);
    }

    public static KeimMethod getKeimMethod(int id) {
        return (KeimMethod)Microorganism.getLD(9, id);
    }

    public static ListDefinition getNewDefinition(int typ) {
        if (typ == 9) {
            return new KeimMethod();
        }
        if (typ == 8) {
            return new Keim();
        }
        return null;
    }

    private static ListDefinition getLD(int type, int id) {
        Vector v = Microorganism.getMatchingVector("service", type);
        if (v != null) {
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                ListDefinition ld = (ListDefinition)iterator.next();
                if (ld.ivID != id) continue;
                return ld;
            }
        }
        return null;
    }

    public static Vector getMatchingVector(String group, int typ) {
        if (InstallationType.isMouse() && "service".equals(group)) {
            return (Vector)DEFS_HM.get(new Integer(typ));
        }
        return null;
    }

    private static final void handleFile(String s, HashMap groupTarget) {
        if (s != null) {
            Vector lines = StringHelper.splitStringByAny(s, "\n");
            Iterator iter = lines.iterator();
            while (iter.hasNext()) {
                String line = (String)iter.next();
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                Zeile z = new Zeile(line, '|');
                int pos = 0;
                int typ = z.getInt(pos++, 0);
                int id = z.getInt(pos++, 0);
                boolean active = "1".equals(z.getStringNONEmpty(pos++, "0"));
                String value = z.getStringB64(pos++, null);
                String name = z.getStringB64(pos++, null);
                String description = z.getStringB64(pos++, null);
                if (typ == 8) {
                    new Keim(typ, id, active, value, name, description, groupTarget);
                    continue;
                }
                new KeimMethod(typ, id, active, value, name, description, groupTarget);
            }
        }
    }

    private static void initServiceValues(HashMap systemTarget) {
        HashMap babelTarget = new HashMap();
        Microorganism.addMethod(5001, "GEDM_ELISA", systemTarget, babelTarget);
        Microorganism.addMethod(5002, "GEDM_CULTURE", systemTarget, babelTarget);
        Microorganism.addMethod(5003, "GEDM_PCR", systemTarget, babelTarget);
        Microorganism.addMethod(5004, "GEDM_BEAD", systemTarget, babelTarget);
        Microorganism.addMethod(5005, "GEDM_MICROSCOPY", systemTarget, babelTarget);
        Microorganism.addMethod(5006, "GEDM_VISUAL", systemTarget, babelTarget);
        int keimID = 5001;
        Microorganism.addKeim(keimID++, 5001, "Ectromelia (mousepox) virus", 1, true, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Lymphocitic choriomenigitis virus (LCMV)", 1, true, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Minute virus of mice (MVM)", 1, true, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Mouse adenovirus type 1 (Mad FL)", 1, true, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Mouse adenovirus type 2 (Mad K87)", 1, true, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Mouse hepatitis virus (MHV)", 1, true, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Mouse parvovirus (MPV 1, MPV 2)", 1, true, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Mouse rotavirus (EDIM)", 1, true, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Murine norovirus (MNV)", 1, true, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Pneumonia virus of mice (PVM)", 1, true, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Reovirus type 3 (Reo 3)", 1, true, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Sendai virus", 1, true, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Theiler's murine encephalomyelitis virus (GD-VII)", 1, true, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Hantavirus", 1, false, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Lactate-dehydrogenase elevating virus", 1, false, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Mouse K virus", 1, false, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Mouse cytomegalovirus (MCMV) [Herpesvirus]", 1, false, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Mouse polyoma virus", 1, false, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Mouse thymic virus [Herpesvirus]", 1, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Citrobacter rodentium", 2, true, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Clostridium piliforme (Tyzzer's disease)", 2, true, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Corynebacterium kutscheri", 2, true, systemTarget);
        Microorganism.addKeim(keimID++, 5003, "Helicobacter spp.", 2, true, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Mycoplasma spp. (pulmonis)", 2, true, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Pasteurella spp.", 2, true, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Salmonella spp.", 2, true, systemTarget);
        Microorganism.addKeim(keimID++, 5003, "Streptobacillus moniliformis", 2, true, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Streptococci beta-haemolytic (not group D)", 2, true, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Streptococcus pneumoniae", 2, true, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Actinobacillus spp.", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Bacillus spp.", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Bordetella bronchiseptica", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Chryseobacterium meningosepticum", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Cilia-associated respiratory bacillus", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Citrobacter freundii", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Citrobacter koseri", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5001, "Clostridium spp.", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Corynebacterium bovis", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Enterobacter spp.", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Enterococcus spp.", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Escherichia coli", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Haemophilus spp.", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5003, "Helicobacter bilis", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5003, "Helicobacter hepaticus", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5003, "Helicobacter muridarum", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5003, "Helicobacter rodentium", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5003, "Helicobacter typhlonius", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Klebsiell oxytoca", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Klebsiella pneumoniae", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Lactobacillus spp.", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Mannheimia (Pasteurella) haemolytica", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Ochrobactrum anthropi", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Pasteurella multocida", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Pasteurella pneumotropica", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Pneumocystis murina", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Proteus spp.", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Proteus mirabilis", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5004, "Pseudomonas spp. (bead)", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Pseudomonas aeruginosa", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Staphylococcus spp.", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Staphylococcus aureus", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Staphylococcus sciuri", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Staphylococcus xylosus", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Streptococci alpha-haemolytic, green", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Streptococci beta-haemolytic (group D)", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Streptococcus spp.", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Vibrio metschnikovii", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5002, "Yersinia pseudotuberculosis", 2, false, systemTarget);
        Microorganism.addKeim(keimID++, 5005, "Myobia musculis (Mites)", 3, true, systemTarget);
        Microorganism.addKeim(keimID++, 5005, "Myocoptes musculinis (Mites)", 3, true, systemTarget);
        Microorganism.addKeim(keimID++, 5005, "Radfordia spp. (Mites)", 3, true, systemTarget);
        Microorganism.addKeim(keimID++, 5005, "Aspiculuris tetraptera (Pinworm)", 4, true, systemTarget);
        Microorganism.addKeim(keimID++, 5005, "Chilomastix spp.", 4, true, systemTarget);
        Microorganism.addKeim(keimID++, 5005, "Encephalitozoon cuniculli", 4, true, systemTarget);
        Microorganism.addKeim(keimID++, 5005, "Entamoeba spp.", 4, true, systemTarget);
        Microorganism.addKeim(keimID++, 5005, "Giardia spp.", 4, true, systemTarget);
        Microorganism.addKeim(keimID++, 5005, "Hexamastix muris", 4, true, systemTarget);
        Microorganism.addKeim(keimID++, 5005, "Retortamonas sp.", 4, true, systemTarget);
        Microorganism.addKeim(keimID++, 5005, "Rodentolepis nana (Tapeworm)", 4, true, systemTarget);
        Microorganism.addKeim(keimID++, 5005, "Spironucleus muris", 4, true, systemTarget);
        Microorganism.addKeim(keimID++, 5005, "Syphacia muris (Pinworm)", 4, true, systemTarget);
        Microorganism.addKeim(keimID++, 5005, "Syphacia obvelata (Pinworm)", 4, true, systemTarget);
        Microorganism.addKeim(keimID++, 5005, "Trichomonas spp.", 4, true, systemTarget);
        Microorganism.addKeim(keimID++, 5006, "External & Necroscopy", 5, true, systemTarget);
        Microorganism.addKeim(keimID++, 5006, "Facial abscess (Staph. aureus)", 5, true, systemTarget);
    }

    private static void addKeim(int id, int methodID, String name, int keimTyp, boolean felasaRelevant, HashMap systemTarget) {
        new Keim(8, id, true, String.valueOf(keimTyp) + "|" + methodID + "|" + (felasaRelevant ? "1" : "0"), name, null, systemTarget);
    }

    private static void addMethod(int id, String babel, HashMap systemTarget, HashMap babelTarget) {
        String s;
        String dictString = babel;
        Babel.fillAllTranslations(babel, babelTarget);
        if (!babelTarget.isEmpty()) {
            StringBuilder msb = new StringBuilder("#Babel");
            Iterator iterator = babelTarget.keySet().iterator();
            while (iterator.hasNext()) {
                String lang = (String)iterator.next();
                String val = (String)babelTarget.get(lang);
                msb.append(";").append(lang).append(":").append(Base64Manager.encodeBase64(val));
            }
            dictString = msb.toString();
        }
        String name = (s = (String)babelTarget.get("en")) != null && s.length() != 0 ? s : babel;
        new KeimMethod(9, id, true, dictString, name, null, systemTarget);
    }

    public static class Keim
    extends ListDefinition {
        public int ivKeimTyp = 0;
        public int ivMethodID = 0;
        public boolean ivFelasaRelevant = false;

        public Keim(int typ, int id, boolean active, String value, String name, String description, HashMap target) {
            super(typ, id, active, value, name, description, target);
            Zeile z = new Zeile(value, '|');
            this.ivKeimTyp = z.getInt(0, 0);
            this.ivMethodID = z.getInt(1, 0);
            this.ivFelasaRelevant = z.getInt(2, 0) == 1;
        }

        private Keim() {
            super(8);
        }

        protected String getTransport() {
            this.ivValue = String.valueOf(this.ivKeimTyp) + "|" + this.ivMethodID + "|" + (this.ivFelasaRelevant ? "1" : "0");
            return super.getTransport();
        }

        public String toString() {
            return this.ivName;
        }

        public Color getFG() {
            int ind = ArrayHelper.findIndexInArray(this.ivKeimTyp, KEIM_TYPES);
            if (ind < 0) {
                ind = 0;
            }
            return KEIM_COLORS[ind];
        }

        public String getTypString() {
            return StringHelper.getStringForInt(this.ivKeimTyp, KEIM_TYPES, KEIM_TYP_BABELS, true, "?");
        }

        public String getMethodString() {
            Vector v = Microorganism.getMatchingVector("service", 9);
            if (v != null) {
                Iterator iterator = v.iterator();
                while (iterator.hasNext()) {
                    ListDefinition ld = (ListDefinition)iterator.next();
                    if (ld.ivID != this.ivMethodID) continue;
                    return ld.toString();
                }
            }
            return "";
        }

        public ListDefinition getMethodDefinition() {
            Vector v = Microorganism.getMatchingVector("service", 9);
            if (v != null) {
                Iterator iterator = v.iterator();
                while (iterator.hasNext()) {
                    ListDefinition ld = (ListDefinition)iterator.next();
                    if (ld.ivID != this.ivMethodID) continue;
                    return ld;
                }
            }
            return null;
        }

        public int compareTo(Object arg0) {
            if (arg0 instanceof Keim) {
                Keim k = (Keim)arg0;
                if (this.ivKeimTyp < k.ivKeimTyp) {
                    return -1;
                }
                if (this.ivKeimTyp > k.ivKeimTyp) {
                    return 1;
                }
                if (this.ivFelasaRelevant && !k.ivFelasaRelevant) {
                    return -1;
                }
                if (k.ivFelasaRelevant && !this.ivFelasaRelevant) {
                    return 1;
                }
                return this.ivName.compareToIgnoreCase(k.ivName);
            }
            return 0;
        }
    }

    public static class KeimMethod
    extends ListDefinition {
        private String ivAktDisplayString;

        public KeimMethod(int typ, int id, boolean active, String value, String name, String description, HashMap target) {
            super(typ, id, active, value, name, description, target);
            this.ivAktDisplayString = KeimMethod.getDisplayValue(value, name);
        }

        private KeimMethod() {
            super(9);
        }

        public String toString() {
            return this.ivAktDisplayString;
        }

        public String getTooltip() {
            return KeimMethod.getMultiLanguageTooltip(this.ivValue, this.ivName);
        }
    }
}

