/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.experiment;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import java.util.HashSet;
import java.util.Vector;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;

public class Experiment
extends IDObject {
    public static final long serialVersionUID = -9083185963290878852L;
    public static final String EXP_PREFIX = "EXP_";
    public static final String NAME = "EXP_NAME";
    public static final String EXP_TYPE = "EXP_TYPE";
    public static final String DESCRIPTION = "EXP_DESC";
    public static final String ENTERER_ID = "EXP_ENTERER";
    public static final String POS_VALUES = "EXP_POSV";
    public static final String UNIT = "EXP_UNIT";
    public static final String[] ATTRIBUTES_EXP;
    public static final String[] ORDERED_ATTRIBUTES;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_DOUBLE = 3;
    public static final int TYPE_CHOICE = 4;
    public static final int TYPE_FREE = 5;
    public static final int TYPE_IMAGE = 6;
    public static final int TYPE_GPS = 7;
    public static final int TYPE_EMPTY = 8;
    public static String TYPES_BOOLEAN;
    public static String TYPES_INTEGER;
    public static String TYPES_DOUBLE;
    public static String TYPES_CHOICE;
    public static String TYPES_FREE;
    public static String TYPES_IMAGE;
    public static String TYPES_GPS;
    public static String TYPES_UNKNOWN;
    public static String TYPES_EMPTY;
    private static int[] TYPEN;
    public static String[] TYPE_STRINGS;
    public static final String NO_UNIT = "#####";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        String[] stringArray = new String[12];
        stringArray[0] = NAME;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        stringArray[2] = EXP_TYPE;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[3] = clazz2.getName();
        stringArray[4] = DESCRIPTION;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[5] = clazz3.getName();
        stringArray[6] = ENTERER_ID;
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[7] = clazz4.getName();
        stringArray[8] = POS_VALUES;
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[9] = clazz5.getName();
        stringArray[10] = UNIT;
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[11] = clazz6.getName();
        ATTRIBUTES_EXP = stringArray;
        ORDERED_ATTRIBUTES = new String[]{"IDO_ID", "IDO_START_DATE", "IDO_END_DATE", "IDO_VERSION", "IDO_UNIQUELONG", "IDO_VISIBLE", "IDO_NEVER_EXISTED", "IDO_OGROUP", "IDO_FKEY", "IDO_DOK", "IDO_SERVID", "IDO_UGROUPS", "IDO_UGROUPIDS", "IDO_SUBTYP", NAME, EXP_TYPE, DESCRIPTION, ENTERER_ID, POS_VALUES, UNIT};
        TYPES_BOOLEAN = Babel.get("TRUE/FALSE");
        TYPES_INTEGER = Babel.get("INTEGERNUMBER");
        TYPES_DOUBLE = Babel.get("FLOATINGPOINTNUMBER");
        TYPES_CHOICE = Babel.get("CHOICE");
        TYPES_FREE = Babel.get("FREE");
        TYPES_IMAGE = Babel.get("IMAGE");
        TYPES_GPS = Babel.get("LOCATION");
        TYPES_UNKNOWN = Babel.get("UNKNOWN");
        TYPES_EMPTY = Babel.get("EXP_TYPE_EMPTY");
        TYPEN = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        TYPE_STRINGS = new String[]{TYPES_BOOLEAN, TYPES_INTEGER, TYPES_DOUBLE, TYPES_CHOICE, TYPES_FREE, TYPES_IMAGE, TYPES_GPS, TYPES_EMPTY};
    }

    public String getExperimentTypeString() {
        return StringHelper.getStringForInt(this.getInt(EXP_TYPE), TYPEN, TYPE_STRINGS, false, TYPES_UNKNOWN);
    }

    public static int getExperimentTypeForString(String s) {
        return StringHelper.getIntForString(s, TYPEN, TYPE_STRINGS, 0);
    }

    public static boolean isServiceExperiment(long experimentID) {
        return experimentID >= 5000L;
    }

    public static Experiment getExperiment(long experimentID, String mouseGroup) {
        if (Experiment.isServiceExperiment(experimentID)) {
            return (Experiment)ObjectStore.getObjectDeadOrAlive(12, experimentID, "service", null, false);
        }
        return (Experiment)ObjectStore.getObjectDeadOrAlive(12, experimentID, mouseGroup, null, false);
    }

    public String getName(String nullVal) {
        return this.getString(NAME, nullVal);
    }

    public String getName() {
        return this.getName(null);
    }

    public String getBrowseName() {
        return this.getName("Experiment ID " + this.getID());
    }

    public String getBrowseNameInclServicePrefix() {
        if (ProcessDefinition.isClient() && !MausoleumClient.isHeadOfService() && "service".equals(this.getGroup())) {
            return "[S] " + this.getBrowseName();
        }
        return this.getBrowseName();
    }

    public void addBrowserLines(Vector target, String group, HashSet wantedObjectTypes) {
        String s;
        long l;
        super.addBrowserLines(target, group, wantedObjectTypes);
        target.add("Name = " + this.getString(NAME, ""));
        target.add("Type = " + this.getExperimentTypeString());
        if ((wantedObjectTypes == null || wantedObjectTypes.contains(new Integer(6))) && (l = this.getLong(ENTERER_ID, 0L)) != 0L) {
            IDObject ido = ObjectStore.getObjectDeadOrAlive(6, l, group, null, false);
            target.add("Enterer: " + ido.getBrowseName() + "\t" + "object|" + group + "|" + 6 + "|" + l);
        }
        if ((s = this.getString(UNIT, null)) != null) {
            target.add("Unit = " + s);
        }
        if ((s = this.getString(DESCRIPTION, null)) != null && s.trim().length() != 0) {
            target.add("Description\t\t" + Base64Manager.encodeBase64(s));
        }
    }

    public String getPossValuesString(String defVal, boolean multiline) {
        String vals = defVal;
        Object[] posValues = (Object[])this.get(POS_VALUES);
        switch (this.getInt(EXP_TYPE)) {
            case 2: 
            case 3: {
                if (posValues == null || posValues.length != 2) break;
                String un = "";
                if (this.getString(UNIT) != null) {
                    un = this.getString(UNIT);
                }
                StringBuffer msb = new StringBuffer();
                msb.append(posValues[0]).append(" ");
                msb.append(un).append(" - ");
                msb.append(posValues[1]).append(" ").append(un);
                vals = msb.toString();
                if (vals.length() > 30) {
                    vals = String.valueOf(vals.substring(0, 27)) + "...";
                }
                vals = "[" + vals + "]";
                break;
            }
            case 4: {
                if (posValues == null) break;
                if (multiline) {
                    StringBuffer msb = new StringBuffer();
                    int i = 0;
                    while (i < posValues.length) {
                        if (i != 0) {
                            msb.append("\n");
                        }
                        msb.append(posValues[i]);
                        ++i;
                    }
                    vals = msb.toString();
                    break;
                }
                StringBuffer msb = new StringBuffer();
                int i = 0;
                while (i < posValues.length) {
                    if (i != 0) {
                        msb.append(", ");
                    }
                    msb.append(posValues[i]);
                    ++i;
                }
                vals = msb.toString();
                if (vals.length() > 30) {
                    vals = String.valueOf(vals.substring(0, 27)) + "...";
                }
                vals = "[" + vals + "]";
                break;
            }
        }
        return vals;
    }
}

