/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.extras;

import de.hannse.netobjects.datalayer.DataFile;
import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectIndex;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.MyDate;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.building.Building;
import mausoleum.cage.Cage;
import mausoleum.experiment.Experiment;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.license.License;
import mausoleum.line.Line;
import mausoleum.locus.Locus;
import mausoleum.mail.Mail;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.rack.Rack;
import mausoleum.result.MResult;
import mausoleum.room.Room;
import mausoleum.strain.Strain;
import mausoleum.visit.Visit;

public class FilesAnonymisierer {
    private static final String SERVICE = "service";
    private static final String BACKUP = "backups";
    private static final String DATA = "data";
    private static final String TEMP = "temp";
    private static final String ZTRE = "------------------------------------------------";
    private static final int LINE_LENGTH = 79;
    private static final int SUB_LINE_LENGTH = 69;
    private static final String SUB_LINE_PREFIX = "          ";
    private static final String[] COPY_DIRS = new String[]{"docs", "misc", "results", "tasks", "userspecific"};
    private static final String[] DELETE_IN_FILES = new String[]{"client", "log", "mros", "server", "windows"};
    private static HashMap cvNewUserNames = new HashMap();
    private static long cvMillisOffset = 0L;
    private static int cvTageOffset = 0;
    private static boolean cvMitDebug = false;
    private static String cvLang = "en";
    private static HashMap cvZipEntries;
    private static String cvSourcePath;

    public static void main(String[] args) {
        HashMap props = FilesAnonymisierer.screenArgs(args);
        cvMitDebug = FilesAnonymisierer.getProp(props, "debug", "false").equals("true");
        String outputDir = FilesAnonymisierer.getGroupTarget(props);
        cvLang = FilesAnonymisierer.getProp(props, "lang", cvLang);
        cvSourcePath = StringHelper.gSub(FilesAnonymisierer.getProp(props, "source", "files\\server"), "\\", "/", true);
        FileManager.prepareDirs(TEMP);
        IDObject.init();
        HashMap<String, String> newsByOld = new HashMap<String, String>();
        File f = new File(cvSourcePath);
        if (f.exists() && f.isDirectory()) {
            String[] groups = f.list();
            int i = 0;
            while (i < groups.length) {
                if (!groups[i].equals(SERVICE) && !groups[i].equals(BACKUP)) {
                    newsByOld.put(groups[i], "group" + (newsByOld.size() + 1));
                }
                ++i;
            }
        }
        System.out.println(newsByOld);
        FileManager.deleteDir(outputDir, true);
        Iterator iterator = newsByOld.keySet().iterator();
        while (iterator.hasNext()) {
            String oldGroup = (String)iterator.next();
            String newGroup = (String)newsByOld.get(oldGroup);
            FilesAnonymisierer.fromOldToNew(String.valueOf(cvSourcePath) + "/" + oldGroup, String.valueOf(outputDir) + "/" + newGroup, oldGroup, newGroup);
            new Wandler(oldGroup, outputDir, newGroup, newsByOld);
        }
        FilesAnonymisierer.fromOldToNew(String.valueOf(cvSourcePath) + "/" + SERVICE, String.valueOf(outputDir) + "/" + SERVICE, SERVICE, SERVICE);
        new Wandler(SERVICE, outputDir, SERVICE, newsByOld);
    }

    private static void fromOldToNew(String oldPath, String newPath, String oldGroup, String newGroup) {
        FileManager.prepareDirs(newPath);
        File f = new File(oldPath);
        String[] files = f.list();
        int i = 0;
        while (i < files.length) {
            String name = files[i];
            if (StringHelper.isIn(name, COPY_DIRS, true)) {
                FileManager.copyDir(String.valueOf(oldPath) + "/" + name, String.valueOf(newPath) + "/" + name, true);
            }
            ++i;
        }
    }

    private static HashMap screenArgs(String[] args) {
        HashMap<String, String> props = new HashMap<String, String>();
        int i = 0;
        while (i < args.length) {
            String s = args[i];
            int ind = s.indexOf("=");
            if (ind != -1) {
                String s1 = s.substring(0, ind).trim().toLowerCase();
                String s2 = s.substring(ind + 1, s.length()).trim();
                props.put(s1, s2);
            }
            ++i;
        }
        return props;
    }

    private static String getProp(HashMap props, String key, String defVal) {
        String res;
        if (props != null && key != null && (res = (String)props.get(key)) != null) {
            return res;
        }
        return defVal;
    }

    private static String getGroupTarget(HashMap props) {
        String outputMausoleumDir = FilesAnonymisierer.getProp(props, "target", "anonym");
        outputMausoleumDir = StringHelper.gSub(outputMausoleumDir, "\\", "/");
        String outputFilesDir = String.valueOf(outputMausoleumDir) + "/files";
        int i = 0;
        while (i < DELETE_IN_FILES.length) {
            String potDir = String.valueOf(outputFilesDir) + "/" + DELETE_IN_FILES[i];
            if (new File(potDir).exists()) {
                FileManager.deleteDir(potDir, true);
            }
            ++i;
        }
        String outputDir = String.valueOf(outputMausoleumDir) + "/files/server/";
        if (new File(outputDir).exists()) {
            FileManager.deleteDir(outputDir, true);
        }
        FileManager.prepareDirs(outputDir);
        return outputDir;
    }

    private static void print(String s) {
        if (cvMitDebug) {
            if (s.length() < 79) {
                System.out.println(s);
            } else {
                System.out.println(s.substring(0, 79));
                s = s.substring(79, s.length());
                while (s.length() > 69) {
                    System.out.println(SUB_LINE_PREFIX + s.substring(0, 69));
                    s = s.substring(69, s.length());
                }
                System.out.println(SUB_LINE_PREFIX + s);
            }
        }
    }

    public static class SessChecker
    implements ObjectConsumer {
        private long ivLastMillis = -1L;
        public long ivMillisOffset;
        public int ivDaysOffset;
        private int ivCheckedObjects = 0;
        private int ivCheckedDates = 0;

        public SessChecker(String groupName) {
            long aktMillis = System.currentTimeMillis();
            int aktTag = (int)(aktMillis / 86400000L);
            FilesAnonymisierer.print(FilesAnonymisierer.ZTRE);
            FilesAnonymisierer.print("SessChecker mit groupDir: " + groupName);
            String sessionPath = String.valueOf(groupName) + "/" + FilesAnonymisierer.DATA + "/session.data";
            FilesAnonymisierer.print("             sessionPath: " + sessionPath);
            byte[] arr = (byte[])cvZipEntries.get(sessionPath);
            if (arr != null) {
                String path = "temp/session.data";
                FileManager.saveBytesToFile(path, arr);
                DataFile sessFile = new DataFile(groupName, 5, path);
                sessFile.giveAllObjectsToConsumer(this);
                FilesAnonymisierer.print("         checked Objects: " + this.ivCheckedObjects);
                FilesAnonymisierer.print("           checked Dates: " + this.ivCheckedDates);
                FilesAnonymisierer.print("               last Date: " + new Date(this.ivLastMillis));
                FileManager.deleteFile(path);
            } else {
                FilesAnonymisierer.print("            Datei fehlt!: " + sessionPath);
            }
            if (this.ivLastMillis == -1L) {
                this.ivLastMillis = aktMillis;
            }
            int lastTag = (int)(this.ivLastMillis / 86400000L);
            FilesAnonymisierer.print("                last Tag: " + new MyDate(lastTag));
            this.ivDaysOffset = aktTag - lastTag;
            this.ivMillisOffset = 86400000L * (long)this.ivDaysOffset;
            FilesAnonymisierer.print("             Tage Offset: " + this.ivDaysOffset);
            FilesAnonymisierer.print("           Millis Offset: " + this.ivMillisOffset);
        }

        public void handleNewObjects(Vector idObjects) {
            Iterator iterator = idObjects.iterator();
            while (iterator.hasNext()) {
                this.handleNewObject((IDObject)iterator.next());
            }
        }

        public void handleNewObject(IDObject obj) {
            ++this.ivCheckedObjects;
            Date d = obj.getDate("IDO_END_DATE");
            if (d != null) {
                ++this.ivCheckedDates;
                long end = d.getTime();
                if (end > this.ivLastMillis) {
                    this.ivLastMillis = end;
                }
            }
        }

        public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        }
    }

    public static class Wandler
    implements ObjectConsumer {
        private DataFile ivOldFile;
        private DataFile ivNewFile;
        private String ivOldGroup;
        private String ivNewGroup;
        private final String ivIndexPath;
        private int ivObjCount = 0;
        private int ivGuruCount = 0;
        private int ivMasterCount = 0;
        private int ivSHeadCount = 0;
        private int ivSCTCount = 0;
        private int ivBreederCount = 0;
        private String[] ivTagAndPrefix = null;
        private HashMap ivNewsByOld;

        public Wandler(String oldGroup, String targetOhneGroup, String newGroup, HashMap newsByOld) {
            this.ivOldGroup = oldGroup;
            this.ivNewGroup = newGroup;
            this.ivNewsByOld = newsByOld;
            String dataNDir = String.valueOf(targetOhneGroup) + newGroup + "/" + FilesAnonymisierer.DATA;
            FileManager.prepareDirs(dataNDir);
            this.ivIndexPath = String.valueOf(dataNDir) + "/" + GroupFileManager.getIndexFilename();
            FileManager.pureAppend(this.ivIndexPath, String.valueOf(ObjectIndex.getAktVerion()) + "\n");
            String oldDataPath = String.valueOf(cvSourcePath) + "/" + oldGroup + "/" + FilesAnonymisierer.DATA;
            File f = new File(oldDataPath);
            if (f.exists() && f.isDirectory()) {
                String[] files = f.list();
                int i = 0;
                while (i < files.length) {
                    String fileName = files[i];
                    if (fileName.endsWith(".data") && !fileName.startsWith("mail")) {
                        String path = String.valueOf(oldDataPath) + "/" + fileName;
                        int type = IDObject.getTypeForStringServerSide(fileName.substring(0, fileName.length() - 5));
                        if (type > 0) {
                            String nfPath = String.valueOf(dataNDir) + "/" + fileName;
                            this.ivOldFile = new DataFile(oldGroup, type, path);
                            this.ivNewFile = new DataFile(newGroup, type, nfPath);
                            this.ivOldFile.ivCheckMice = false;
                            this.ivNewFile.ivCheckMice = false;
                            this.ivOldFile.ivWriteProtocol = false;
                            this.ivNewFile.ivWriteProtocol = false;
                            this.ivTagAndPrefix = this.getNameKeyAndPrefix(type);
                            this.ivObjCount = 0;
                            this.ivOldFile.giveAllObjectsToConsumer(this);
                            this.ivOldFile.dispose();
                            this.ivNewFile.dispose();
                        }
                    }
                    ++i;
                }
            }
        }

        public void handleNewObjects(Vector idObjects) {
            Iterator iterator = idObjects.iterator();
            while (iterator.hasNext()) {
                this.handleNewObject((IDObject)iterator.next());
            }
        }

        public void handleNewObject(IDObject obj) {
            String[] objGroups;
            ++this.ivObjCount;
            obj.set("IDO_GROUP", this.ivNewGroup);
            obj.set("IDO_DOK", null);
            obj.set("IDO_FKEY", null);
            this.manageDate(obj, "IDO_START_DATE", this.ivNewGroup);
            this.manageDate(obj, "IDO_END_DATE", this.ivNewGroup);
            if (FilesAnonymisierer.SERVICE.equals(obj.getGroup()) && (objGroups = (String[])obj.get("IDO_UGROUPS")) != null) {
                String[] nog = new String[objGroups.length];
                int i = 0;
                while (i < nog.length) {
                    nog[i] = (String)this.ivNewsByOld.get(objGroups[i]);
                    ++i;
                }
                obj.set("IDO_UGROUPS", nog);
            }
            if (obj instanceof User) {
                User user = (User)obj;
                int typ = user.getInt("USR_MODE", 0);
                String oldname = user.getName();
                String name = "user" + this.ivObjCount;
                if (typ == 500) {
                    name = "head" + this.ivSHeadCount;
                    ++this.ivSHeadCount;
                } else if (typ == 550) {
                    name = "sct" + this.ivSCTCount;
                    ++this.ivSCTCount;
                } else if (typ == 42) {
                    name = "guru" + this.ivGuruCount;
                    ++this.ivGuruCount;
                } else if (typ == 2) {
                    name = "master" + this.ivMasterCount;
                    ++this.ivMasterCount;
                }
                obj.set("USR_NAME", name);
                obj.set("USR_PASSWORD", StringHelper.encrypt(name));
                cvNewUserNames.put(String.valueOf(this.ivOldGroup) + "#" + oldname, name);
                obj.set("USR_EMAIL", null);
                obj.set("USR_LANGUAGE", cvLang);
            } else if (!(obj instanceof Mail)) {
                if (obj instanceof Mouse) {
                    this.manageDate(obj, "MOS_BIRTHDAY", this.ivNewGroup);
                    this.manageDate(obj, "MOS_VISIT", this.ivNewGroup);
                    this.manageDate(obj, "MOS_PLUGDATE", this.ivNewGroup);
                    this.manageDate(obj, "MOS_ALLPLUGDATES", this.ivNewGroup);
                    this.manageDate(obj, "MOS_KID_BD", this.ivNewGroup);
                    this.manageDate(obj, "MOS_TASKSEXT", this.ivNewGroup);
                    this.manageDate(obj, "MOS_MRESULTS", this.ivNewGroup);
                    obj.set("MOS_COMMENT", null);
                    FileManager.pureAppend(this.ivIndexPath, String.valueOf(obj.getID()) + "#" + ObjectIndex.getIndexInfo((Mouse)obj) + "\n");
                } else if (obj instanceof Cage) {
                    this.manageDate(obj, "CAG_VISIT", this.ivNewGroup);
                    this.manageDate(obj, "CAG_TASKS", this.ivNewGroup);
                    obj.set("CAG_COMMENT", null);
                } else if (obj instanceof Rack) {
                    this.manageName(obj, "RCK_NAME");
                } else if (obj instanceof Session) {
                    Vector coms = (Vector)obj.get("SES_COMMAND");
                    if (coms != null) {
                        Vector<String> v = new Vector<String>(coms.size());
                        Iterator iterator = coms.iterator();
                        while (iterator.hasNext()) {
                            String com = (String)iterator.next();
                            if (com.startsWith("[")) {
                                try {
                                    int ind = com.indexOf("]");
                                    if (ind != -1) {
                                        String hinten = com.substring(ind + 1, com.length());
                                        String vorne = com.substring(1, ind);
                                        long millis = 0L;
                                        int ind2 = vorne.indexOf("|");
                                        millis = ind2 != -1 ? Long.parseLong(vorne.substring(0, ind2)) + cvMillisOffset : Long.parseLong(vorne) + cvMillisOffset;
                                        com = "[" + millis + "]" + hinten;
                                    }
                                }
                                catch (Exception e) {
                                    FilesAnonymisierer.print("problem com " + com + " -> " + e);
                                }
                            }
                            v.add(com);
                        }
                        obj.set("SES_COMMAND", v);
                    }
                } else if (obj instanceof Line) {
                    obj.set("LIN_DESCRIPTION", null);
                    obj.set("LIN_ETPREFIX", null);
                    Line line = (Line)obj;
                    if (line.isBreeder()) {
                        if (this.ivBreederCount == 0) {
                            line.set("LIN_NAME", "breeder");
                        } else {
                            line.set("LIN_NAME", "breeder_" + this.ivBreederCount);
                        }
                        ++this.ivBreederCount;
                    } else {
                        this.manageName(obj, "LIN_NAME");
                    }
                } else if (obj instanceof Strain) {
                    obj.set("STR_DESCRIPTION", null);
                    obj.set("STR_ETPREFIX", null);
                    this.manageName(obj, "STR_NAME");
                } else if (obj instanceof Room) {
                    obj.set("ROM_DESC", null);
                    obj.set("ROM_ACCESSIBLE", new Boolean(true));
                    this.manageName(obj, "ROM_NAME");
                } else if (obj instanceof Experiment) {
                    obj.set("EXP_DESC", null);
                } else if (obj instanceof Locus) {
                    obj.set("LOC_DESCRIPTION", null);
                    obj.set("LOC_ALLEL_DESC", null);
                    this.manageName(obj, "LOC_NAME");
                } else if (obj instanceof License) {
                    obj.set("LIC_LH", "The License-Holder");
                    obj.set("LIC_CO", null);
                    this.manageDate(obj, "LIC_SD", this.ivNewGroup);
                    this.manageDate(obj, "LIC_ED", this.ivNewGroup);
                    this.manageName(obj, "LIC_NAME");
                } else if (obj instanceof IDObjectGroup) {
                    obj.set("IOG_COM", null);
                } else if (obj instanceof Building) {
                    obj.set("BLD_DESC", null);
                    this.manageName(obj, "BLD_NAME");
                }
            }
            obj.commit(false);
            this.ivNewFile.putObject(obj);
        }

        private String[] getNameKeyAndPrefix(int type) {
            if (type == 3) {
                return new String[]{"RCK_NAME", "rack"};
            }
            if (type == 7) {
                return new String[]{"LIN_NAME", "line"};
            }
            if (type == 8) {
                return new String[]{"STR_NAME", "strain"};
            }
            if (type == 10) {
                return new String[]{"ROM_NAME", "room"};
            }
            if (type == 12) {
                return new String[]{"EXP_NAME", "experiment"};
            }
            if (type == 14) {
                return new String[]{"LOC_NAME", "locus"};
            }
            if (type == 16) {
                return new String[]{"LIC_NAME", "license"};
            }
            if (type == 22) {
                return new String[]{"BLD_NAME", "building"};
            }
            if (type == 19) {
                return new String[]{"IOG_N", "coll"};
            }
            return null;
        }

        private void manageName(IDObject ido, String tag) {
            String clName = ido.getClass().getName();
            int ind = clName.lastIndexOf(".");
            if (ind != -1) {
                clName = clName.substring(ind + 1, clName.length());
            }
            String name = null;
            if (FilesAnonymisierer.SERVICE.equals(ido.getGroup())) {
                name = String.valueOf(clName) + "-S-" + ido.getID();
            } else {
                long servID = ido.getLong("IDO_SERVID", -1L);
                name = String.valueOf(clName) + (servID != -1L ? "-S-" + servID : "-G-" + ido.getID());
            }
            ido.set(tag, name);
        }

        private void manageDate(IDObject ido, String tag, String newGroup) {
            Object ooo = ido.get(tag);
            if (ooo != null) {
                if (ooo instanceof Date) {
                    Date date = (Date)ooo;
                    ido.set(tag, new Date(date.getTime() + cvMillisOffset));
                } else if (ooo instanceof Integer) {
                    Integer day = (Integer)ooo;
                    ido.set(tag, new Integer(day + cvTageOffset));
                } else if (ooo instanceof Long) {
                    Long millis = (Long)ooo;
                    ido.set(tag, new Long(millis + cvMillisOffset));
                } else if (ooo instanceof Visit[]) {
                    Visit[] arr = (Visit[])ooo;
                    Visit[] nrr = new Visit[arr.length];
                    int i = 0;
                    while (i < arr.length) {
                        Visit v = new Visit(arr[i]);
                        v.ivStartDate = v.ivStartDate == null ? null : new Date(v.ivStartDate.getTime() + cvMillisOffset);
                        v.ivEndDate = v.ivEndDate == null ? null : new Date(v.ivEndDate.getTime() + cvMillisOffset);
                        nrr[i] = v;
                        ++i;
                    }
                    ido.set(tag, nrr);
                } else if (ooo instanceof int[]) {
                    int[] arr = (int[])ooo;
                    int[] nrr = new int[arr.length];
                    int i = 0;
                    while (i < arr.length) {
                        nrr[i] = arr[i] == 0 ? 0 : arr[i] + cvTageOffset;
                        ++i;
                    }
                    ido.set(tag, nrr);
                } else if (ooo instanceof TaskExtended[]) {
                    TaskExtended[] arr = (TaskExtended[])ooo;
                    TaskExtended[] nrr = null;
                    Vector<TaskExtended> v = new Vector<TaskExtended>(arr.length);
                    int i = 0;
                    while (i < arr.length) {
                        if (arr[i].ivProcType < 5001) {
                            v.add(arr[i]);
                        }
                        ++i;
                    }
                    if (!v.isEmpty()) {
                        nrr = new TaskExtended[v.size()];
                        i = 0;
                        while (i < nrr.length) {
                            nrr[i] = new TaskExtended((TaskExtended)v.elementAt(i));
                            if (nrr[i].ivDatum != 0) {
                                nrr[i].ivDatum += cvTageOffset;
                            }
                            if (nrr[i].ivIssueMillis != 0L) {
                                nrr[i].ivIssueMillis += cvMillisOffset;
                            }
                            if (this.ivOldGroup.equals(nrr[i].ivIssuerGroup)) {
                                nrr[i].ivIssuerGroup = newGroup;
                            } else {
                                nrr[i].ivIssuerGroup = null;
                                nrr[i].ivIssuerID = 0L;
                            }
                            if (this.ivOldGroup.equals(nrr[i].ivErledigerGroup)) {
                                nrr[i].ivErledigerGroup = newGroup;
                            } else {
                                nrr[i].ivErledigerGroup = null;
                                nrr[i].ivErledigerID = 0L;
                            }
                            if (this.ivOldGroup.equals(nrr[i].ivFavoritGroup)) {
                                nrr[i].ivFavoritGroup = newGroup;
                            } else {
                                nrr[i].ivFavoritGroup = null;
                                nrr[i].ivFavoritID = 0L;
                            }
                            nrr[i].ivComment = null;
                            if (nrr[i].ivFinishMillis != 0L) {
                                nrr[i].ivFinishMillis += cvMillisOffset;
                            }
                            if (nrr[i].ivPeriodEnd != Integer.MIN_VALUE) {
                                nrr[i].ivPeriodEnd += cvTageOffset;
                            }
                            ++i;
                        }
                    }
                    ido.set(tag, nrr);
                } else if (ooo instanceof Vector) {
                    Vector oldVec = (Vector)ooo;
                    Vector<MResult> newVec = new Vector<MResult>(oldVec.size());
                    Iterator iterator = oldVec.iterator();
                    while (iterator.hasNext()) {
                        Object vo = iterator.next();
                        if (!(vo instanceof MResult)) continue;
                        MResult mres = (MResult)vo;
                        newVec.add(new MResult(mres, mres.ivDate + cvTageOffset, "Scientist"));
                    }
                    ido.set(tag, newVec);
                }
            }
        }

        public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        }
    }
}

