/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.extras;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import mausoleum.helper.Zeile;
import mausoleum.main.ProcessDefinition;

public class GentAltdaten {
    private static final String USERS_FILENAME = "users.txt";
    private static final int COL_U_ID = 0;
    private static final int COL_U_VORNAME = 1;
    private static final int COL_U_NACHNAME = 2;
    private static final int COL_U_GRUPPE = 3;
    private static final int COL_OWNERID = 0;
    private static final int COL_MOUSEID = 1;
    private static final int COL_EARTAGNUMBER = 2;
    private static final int COL_GENDER = 3;
    private static final int COL_GENOTYPE = 4;
    private static final int COL_CAGEOFMOUSE = 5;
    private static final int COL_BIRTHDATE = 6;
    private static final int COL_WEANINGDATE = 7;
    private static final int COL_DAYOFDEATH = 8;
    private static final int COL_FAHTERID = 9;
    private static final int COL_MOTHERSID = 10;
    private static final Integer TYP_USER = new Integer(6);
    private static final Integer TYP_MOUSE = new Integer(1);
    private static final Integer TYP_LINE = new Integer(7);
    private static final Integer TYP_CAGE = new Integer(2);
    private static final Integer TYP_LOCUS = new Integer(14);
    private static final Color[] COLORS = new Color[]{new Color(250, 220, 220), new Color(220, 250, 220), new Color(220, 220, 250), new Color(240, 240, 220), new Color(240, 220, 240), new Color(220, 240, 240), new Color(240, 230, 230), new Color(255, 255, 153)};
    private static final MyDate NOW = new MyDate(new GregorianCalendar());
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage mausoleum.extras.GentAltdaten [DIRNAME]");
            System.exit(1);
        }
        ProcessDefinition.setProcessType(1);
        Log.init();
        String dirname = args[0].replace("\\", "/");
        File f = new File(String.valueOf(dirname) + "/" + USERS_FILENAME);
        if (!f.exists()) {
            System.out.println("USER-File not found");
            System.exit(1);
        }
        try {
            HashMap objectsByGroup = new HashMap();
            LineNumberReader lnr = new LineNumberReader(new FileReader(String.valueOf(dirname) + "/" + USERS_FILENAME));
            String line = lnr.readLine();
            while (line != null) {
                if ((line = line.trim()).length() != 0) {
                    GAUser gauser = new GAUser(line);
                    GentAltdaten.putObject(objectsByGroup, gauser.ivGruppe, TYP_USER, gauser.ivID, gauser);
                }
                line = lnr.readLine();
            }
            lnr.close();
            Iterator iter = objectsByGroup.keySet().iterator();
            while (iter.hasNext()) {
                String group = (String)iter.next();
                String string = "Checking group: " + group;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("mausoleum.extras.GentAltdaten");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.info(string, clazz);
                String dataFileName = String.valueOf(dirname) + "/" + group + ".txt";
                File df = new File(dataFileName);
                if (!df.exists()) {
                    String string2 = "Group-File " + dataFileName + " not found";
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("mausoleum.extras.GentAltdaten");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string2, null, clazz2);
                    continue;
                }
                String string3 = "Group-File " + dataFileName + " exists";
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("mausoleum.extras.GentAltdaten");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.info(string3, clazz3);
                GentAltdaten.inspectGroupFile(df, objectsByGroup, group);
                GentAltdaten.writeGroupExcel(dirname, group, objectsByGroup);
            }
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.extras.GentAltdaten");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problem while importing Legacy data", e, clazz);
        }
        System.exit(0);
    }

    private static void writeGroupExcel(String dir, String group, HashMap objectsByGroup) {
        try {
            String path = String.valueOf(dir) + "/" + group + ".xls";
            WritableWorkbook workbook = Workbook.createWorkbook(new File(path));
            HashSet cagesInUse = new HashSet();
            int blattNr = 0;
            GentAltdaten.writeLoci(workbook.createSheet("loci", blattNr++), objectsByGroup, group);
            GentAltdaten.writeLines(workbook.createSheet("lines", blattNr++), objectsByGroup, group);
            GentAltdaten.writeStrains(workbook.createSheet("strains", blattNr++), objectsByGroup, group);
            GentAltdaten.writeMice(workbook.createSheet("mice", blattNr++), objectsByGroup, group, cagesInUse);
            GentAltdaten.writeUsers(workbook.createSheet("users", blattNr++), objectsByGroup, group);
            GentAltdaten.writeCages(workbook.createSheet("cages", blattNr++), objectsByGroup, group, cagesInUse);
            workbook.write();
            workbook.close();
        }
        catch (Exception e) {
            String string = "Problem while writing data for group >" + group + "<";
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.extras.GentAltdaten");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
        }
    }

    private static void writeLoci(WritableSheet sheet, HashMap objectsByGroup, String group) throws Exception {
        GentAltdaten.makeHeader(sheet, new String[]{"FOREIGN_ID", "NAME", "ALLELES", "WT", "COMMENT"});
        int row = 1;
        HashMap ohm = GentAltdaten.getObjectsHashmap(objectsByGroup, group, TYP_LOCUS);
        Iterator iter = ohm.values().iterator();
        while (iter.hasNext()) {
            int col = 0;
            GALocus locus = (GALocus)iter.next();
            GentAltdaten.add(sheet, col++, row, locus.ivID);
            GentAltdaten.add(sheet, col++, row, locus.ivID);
            String wt = null;
            StringBuffer msb = new StringBuffer();
            Iterator iterator = locus.ivAlleles.iterator();
            while (iterator.hasNext()) {
                String allel = (String)iterator.next();
                if (msb.length() != 0) {
                    msb.append("|");
                } else {
                    wt = allel;
                }
                msb.append(allel);
            }
            GentAltdaten.add(sheet, col++, row, msb.toString());
            if (locus.ivAlleles.contains("-")) {
                wt = "-";
            } else if (locus.ivAlleles.contains("+")) {
                wt = "+";
            }
            GentAltdaten.add(sheet, col++, row, wt);
            GentAltdaten.add(sheet, col++, row, "Generated from Maximuss data");
            ++row;
        }
    }

    private static void writeLines(WritableSheet sheet, HashMap objectsByGroup, String group) throws Exception {
        GentAltdaten.makeHeader(sheet, new String[]{"FOREIGN_ID", "NAME", "COLOR", "LOCI", "COMMENT"});
        int row = 1;
        HashMap ohm = GentAltdaten.getObjectsHashmap(objectsByGroup, group, TYP_LINE);
        Iterator iter = ohm.values().iterator();
        while (iter.hasNext()) {
            int col = 0;
            GALine line = (GALine)iter.next();
            GentAltdaten.add(sheet, col++, row, line.ivID);
            GentAltdaten.add(sheet, col++, row, line.ivID);
            GentAltdaten.add(sheet, col++, row, COLORS[row % COLORS.length]);
            StringBuffer msb = new StringBuffer();
            int i = 0;
            while (i < line.ivLoci.length) {
                if (i != 0) {
                    msb.append("|");
                }
                msb.append(line.ivLoci[i]);
                GALocus locus = (GALocus)GentAltdaten.getObject(objectsByGroup, group, TYP_LOCUS, line.ivLoci[i]);
                if (locus != null) {
                    Iterator iterator = locus.ivAlleles.iterator();
                    while (iterator.hasNext()) {
                        String allel = (String)iterator.next();
                        msb.append(";").append(allel);
                    }
                }
                ++i;
            }
            GentAltdaten.add(sheet, col++, row, msb.toString());
            GentAltdaten.add(sheet, col++, row, "Generated from Maximuss data");
            ++row;
        }
    }

    private static void writeStrains(WritableSheet sheet, HashMap objectsByGroup, String group) throws Exception {
        GentAltdaten.makeHeader(sheet, new String[]{"FOREIGN_ID", "NAME", "COLOR", "COMMENT"});
    }

    private static void writeMice(WritableSheet sheet, HashMap objectsByGroup, String group, HashSet cageIdsInUse) throws Exception {
        GentAltdaten.makeHeader(sheet, new String[]{"FOREIGN_ID", "EARTAG", "SEX", "FATHER", "MOTHER", "START_DATE", "START_MODE", "END_DATE", "END_MODE", "COAT_COLOR", "STRAIN", "LINE", "GENOTYPE", "VISITS", "OWNERS", "GENERATION", "COMMENT"});
        TreeSet<String> missingMice = new TreeSet<String>();
        int row = 1;
        HashMap ohm = GentAltdaten.getObjectsHashmap(objectsByGroup, group, TYP_MOUSE);
        Iterator iter = ohm.values().iterator();
        while (iter.hasNext()) {
            int col = 0;
            GAMouse mouse = (GAMouse)iter.next();
            GentAltdaten.add(sheet, col++, row, mouse.ivID);
            GentAltdaten.add(sheet, col++, row, mouse.ivEarTag != -1 ? Integer.toString(mouse.ivEarTag) : "");
            GentAltdaten.add(sheet, col++, row, mouse.ivSex);
            if (mouse.ivFatherID != null && GentAltdaten.getObject(objectsByGroup, group, TYP_MOUSE, mouse.ivFatherID) != null) {
                GentAltdaten.add(sheet, col++, row, mouse.ivFatherID);
            } else {
                if (mouse.ivFatherID != null) {
                    missingMice.add(mouse.ivFatherID);
                }
                ++col;
            }
            if (mouse.ivMotherID != null && GentAltdaten.getObject(objectsByGroup, group, TYP_MOUSE, mouse.ivMotherID) != null) {
                GentAltdaten.add(sheet, col++, row, mouse.ivMotherID);
            } else {
                if (mouse.ivMotherID != null) {
                    missingMice.add(mouse.ivMotherID);
                }
                ++col;
            }
            if (mouse.ivBirthDate != null) {
                GentAltdaten.add(sheet, col++, row, mouse.ivBirthDate);
                GentAltdaten.add(sheet, col++, row, "birth");
            } else {
                GentAltdaten.add(sheet, col++, row, NOW);
                GentAltdaten.add(sheet, col++, row, "import");
            }
            GentAltdaten.add(sheet, col++, row, mouse.ivDeathDate);
            GentAltdaten.add(sheet, col++, row, mouse.ivDeathDate != null ? "death" : null);
            GentAltdaten.add(sheet, col++, row, "");
            GentAltdaten.add(sheet, col++, row, "");
            GentAltdaten.add(sheet, col++, row, mouse.ivLineID == null ? "" : mouse.ivLineID);
            GentAltdaten.add(sheet, col++, row, mouse.ivGenotypeString == null ? "" : mouse.ivGenotypeString);
            StringBuffer visitSB = new StringBuffer();
            if (mouse.ivCageID != null) {
                GAMouse mother;
                MyDate finalVisitStartDate = mouse.ivBirthDate;
                String birthCageID = null;
                if (mouse.ivWeanDate != null && mouse.ivMotherID != null && (mother = (GAMouse)GentAltdaten.getObject(objectsByGroup, group, TYP_MOUSE, mouse.ivMotherID)) != null) {
                    birthCageID = mother.ivCageID;
                }
                if (birthCageID != null) {
                    visitSB.append(birthCageID);
                    visitSB.append(";");
                    visitSB.append(mouse.ivBirthDate.ivTag).append(".");
                    visitSB.append(mouse.ivBirthDate.ivMonat).append(".");
                    visitSB.append(mouse.ivBirthDate.ivJahr);
                    visitSB.append(";");
                    visitSB.append(mouse.ivWeanDate.ivTag).append(".");
                    visitSB.append(mouse.ivWeanDate.ivMonat).append(".");
                    visitSB.append(mouse.ivWeanDate.ivJahr);
                    visitSB.append("|");
                    finalVisitStartDate = mouse.ivWeanDate;
                }
                visitSB.append(mouse.ivCageID);
                visitSB.append(";");
                visitSB.append(finalVisitStartDate.ivTag).append(".");
                visitSB.append(finalVisitStartDate.ivMonat).append(".");
                visitSB.append(finalVisitStartDate.ivJahr);
                visitSB.append(";");
                if (mouse.ivDeathDate != null) {
                    visitSB.append(mouse.ivDeathDate.ivTag).append(".");
                    visitSB.append(mouse.ivDeathDate.ivMonat).append(".");
                    visitSB.append(mouse.ivDeathDate.ivJahr);
                } else {
                    cageIdsInUse.add(mouse.ivCageID);
                }
            }
            GentAltdaten.add(sheet, col++, row, visitSB.toString());
            GentAltdaten.add(sheet, col++, row, mouse.ivOwnerID);
            GentAltdaten.add(sheet, col++, row, "");
            GentAltdaten.add(sheet, col++, row, "Generated from Maximuss data");
            ++row;
        }
        if (!missingMice.isEmpty()) {
            String string = "Missing mice " + missingMice.toString();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.extras.GentAltdaten");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, null, clazz);
        }
    }

    private static void writeUsers(WritableSheet sheet, HashMap objectsByGroup, String group) throws Exception {
        GentAltdaten.makeHeader(sheet, new String[]{"FOREIGN_ID", "NAME", "PASSWORD", "ROLE", "COLOR", "LANGUAGE"});
        int row = 1;
        HashMap ohm = GentAltdaten.getObjectsHashmap(objectsByGroup, group, TYP_USER);
        Iterator iter = ohm.values().iterator();
        while (iter.hasNext()) {
            int col = 0;
            GAUser user = (GAUser)iter.next();
            GentAltdaten.add(sheet, col++, row, user.ivID);
            GentAltdaten.add(sheet, col++, row, user.ivNachname);
            GentAltdaten.add(sheet, col++, row, "x" + user.ivNachname);
            GentAltdaten.add(sheet, col++, row, user.ivRole);
            GentAltdaten.add(sheet, col++, row, COLORS[row % COLORS.length]);
            GentAltdaten.add(sheet, col++, row, "en");
            ++row;
        }
    }

    private static void writeCages(WritableSheet sheet, HashMap objectsByGroup, String group, HashSet cagesInUse) throws Exception {
        GentAltdaten.makeHeader(sheet, new String[]{"FOREIGN_ID", "START_DATE", "END_DATE", "CAGE_NUMBER"});
        int row = 1;
        HashMap ohm = GentAltdaten.getObjectsHashmap(objectsByGroup, group, TYP_CAGE);
        Iterator iter = ohm.values().iterator();
        while (iter.hasNext()) {
            int col = 0;
            GACage cage = (GACage)iter.next();
            if (!cagesInUse.contains(cage.ivID)) {
                cage.ivEndTage = MyDate.HEUTE;
            }
            GentAltdaten.add(sheet, col++, row, cage.ivID);
            if (cage.ivStartTage != Integer.MIN_VALUE) {
                GentAltdaten.add(sheet, col++, row, new MyDate(cage.ivStartTage));
            } else {
                ++col;
            }
            if (cage.ivEndTage != Integer.MIN_VALUE && cage.ivEndTage != -2147483584) {
                GentAltdaten.add(sheet, col++, row, new MyDate(cage.ivEndTage));
            }
            int n = ++col;
            ++col;
            GentAltdaten.add(sheet, n, row, Integer.toString(row));
            ++row;
        }
    }

    private static void makeHeader(WritableSheet sheet, String[] arr) throws Exception {
        int row = 0;
        int i = 0;
        while (i < arr.length) {
            sheet.addCell(new Label(i, row, arr[i]));
            ++i;
        }
    }

    private static HashMap getObjectsHashmap(HashMap objectsByGroup, String group, Integer type) {
        HashMap ohm;
        HashMap ghm = (HashMap)objectsByGroup.get(group);
        if (ghm == null) {
            ghm = new HashMap();
            objectsByGroup.put(group, ghm);
        }
        if ((ohm = (HashMap)ghm.get(type)) == null) {
            ohm = new HashMap();
            ghm.put(type, ohm);
        }
        return ohm;
    }

    private static Object getObject(HashMap objectsByGroup, String group, Integer type, String id) {
        HashMap ohm = GentAltdaten.getObjectsHashmap(objectsByGroup, group, type);
        return ohm != null ? ohm.get(id) : null;
    }

    private static void putObject(HashMap objectsByGroup, String group, Integer type, String id, Object o) {
        HashMap ohm = GentAltdaten.getObjectsHashmap(objectsByGroup, group, type);
        if (ohm != null) {
            ohm.put(id, o);
        }
    }

    private static void add(WritableSheet sheet, int col, int row, String s) throws Exception {
        if (s != null) {
            sheet.addCell(new Label(col, row, s));
        }
    }

    private static void add(WritableSheet sheet, int col, int row, Color color) throws Exception {
        if (color != null) {
            sheet.addCell(new Label(col, row, String.valueOf(color.getRed()) + "|" + color.getGreen() + "|" + color.getBlue()));
        }
    }

    private static void add(WritableSheet sheet, int col, int row, MyDate md) throws Exception {
        if (md != null) {
            sheet.addCell(new Label(col, row, String.valueOf(md.ivTag) + "." + md.ivMonat + "." + md.ivJahr));
        }
    }

    private static void inspectGroupFile(File f, HashMap objectsByGroup, String group) {
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(f));
            String line = lnr.readLine();
            while (line != null) {
                try {
                    GAMouse mouse = new GAMouse(new Zeile(line, '\t', '\"'), objectsByGroup, group);
                    GentAltdaten.putObject(objectsByGroup, group, TYP_MOUSE, mouse.ivID, mouse);
                    if (mouse.ivCageID != null && GentAltdaten.getObject(objectsByGroup, group, TYP_CAGE, mouse.ivCageID) == null) {
                        GentAltdaten.putObject(objectsByGroup, group, TYP_CAGE, mouse.ivCageID, new GACage(mouse.ivCageID));
                    }
                }
                catch (Exception e) {
                    System.out.println(Log.formatString("Problem while inspecting line >" + line + "< -> " + e, 5));
                }
                line = lnr.readLine();
            }
            lnr.close();
        }
        catch (Exception e) {
            String string = "Problem while inspecting file " + f.getName();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.extras.GentAltdaten");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
        }
    }

    public static class GACage {
        public String ivID;
        public int ivStartTage = MyDate.HEUTE;
        public int ivEndTage = Integer.MIN_VALUE;

        public GACage(String id) {
            this.ivID = id;
        }
    }

    public static class GALine {
        public final String ivID;
        public final String[] ivLoci;

        public static String[] getLineLoci(String locnameStr, HashMap objectsByGroup, String group) {
            HashMap linehm = GentAltdaten.getObjectsHashmap(objectsByGroup, group, TYP_LINE);
            GALine line = (GALine)linehm.get(locnameStr);
            if (line == null) {
                line = new GALine(locnameStr);
                linehm.put(line.ivID, line);
            }
            return line.ivLoci;
        }

        public GALine(String locnameStr) {
            this.ivID = locnameStr;
            Vector v = StringHelper.splitStringByAny(locnameStr, "//");
            this.ivLoci = new String[v.size()];
            int i = 0;
            while (i < v.size()) {
                this.ivLoci[i] = ((String)v.elementAt(i)).trim();
                ++i;
            }
        }
    }

    public static class GALocus {
        public final String ivID;
        public final TreeSet ivAlleles = new TreeSet();

        public static String[] getGTAlleles(String locusID, String allelesStr, HashMap objectsByGroup, String group) {
            HashMap locushm = GentAltdaten.getObjectsHashmap(objectsByGroup, group, TYP_LOCUS);
            GALocus locus = (GALocus)locushm.get(locusID);
            if (locus == null) {
                locus = new GALocus(locusID);
                locushm.put(locus.ivID, locus);
            }
            return locus.addAlleles(allelesStr);
        }

        public GALocus(String name) {
            this.ivID = name;
        }

        public String[] addAlleles(String alleles) {
            Zeile z = new Zeile(alleles, '/');
            String all1 = z.getStringNONEmpty(0, "?");
            String all2 = z.getStringNONEmpty(1, "?");
            if (!all1.equals("?") && !all2.equals("?")) {
                this.ivAlleles.add(all1);
                this.ivAlleles.add(all2);
                return new String[]{all1, all2};
            }
            return null;
        }
    }

    public static class GAMouse {
        public final String ivID;
        public final String ivOwnerID;
        public final String ivFatherID;
        public final String ivMotherID;
        public final String ivCageID;
        public final int ivEarTag;
        public final String ivSex;
        public final MyDate ivBirthDate;
        public final MyDate ivWeanDate;
        public final MyDate ivDeathDate;
        public String ivLineID = null;
        public String ivGenotypeString = null;

        public GAMouse(Zeile z, HashMap objectsByGroup, String group) {
            this.ivID = z.getStringNONEmpty(1, "?");
            this.ivOwnerID = GAMouse.noNAString(z.getStringNONEmpty(0, null));
            this.ivFatherID = GAMouse.noNAString(z.getStringNONEmpty(9, null));
            this.ivMotherID = GAMouse.noNAString(z.getStringNONEmpty(10, null));
            this.ivCageID = GAMouse.noNAString(z.getStringNONEmpty(5, null));
            this.ivEarTag = z.getInt(2, -1);
            this.ivSex = z.getStringNONEmpty(3, "").toLowerCase();
            this.ivBirthDate = GAMouse.getDate(z.getStringNONEmpty(6, null));
            this.ivWeanDate = GAMouse.getDate(z.getStringNONEmpty(7, null));
            this.ivDeathDate = GAMouse.getDate(z.getStringNONEmpty(8, null));
            String genotype = z.getStringNONEmpty(4, null);
            if (genotype != null && !genotype.equalsIgnoreCase("breeder")) {
                Zeile gtz = new Zeile(genotype, ' ');
                if (gtz.size() != 2) {
                    String string = "Malformed genotype: " + genotype;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("mausoleum.extras.GentAltdaten");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, null, clazz);
                } else {
                    String loci = gtz.getString(0);
                    String alleles = gtz.getString(1);
                    String[] lineloci = GALine.getLineLoci(loci, objectsByGroup, group);
                    if (lineloci != null) {
                        this.ivLineID = loci;
                        Vector v = StringHelper.splitStringByAny(alleles, "//");
                        StringBuffer msb = new StringBuffer();
                        int i = 0;
                        while (i < lineloci.length) {
                            String locus = lineloci[i];
                            String[] ral = GALocus.getGTAlleles(locus, (String)v.elementAt(i), objectsByGroup, group);
                            if (ral != null) {
                                if (msb.length() != 0) {
                                    msb.append("|");
                                }
                                msb.append(locus).append(";").append(ral[0]).append(";").append(ral[1]);
                            }
                            ++i;
                        }
                        if (msb.length() != 0) {
                            this.ivGenotypeString = msb.toString();
                        }
                    }
                }
            }
        }

        private static String noNAString(String s) {
            if (s != null) {
                if (s.equalsIgnoreCase("NA")) {
                    return null;
                }
                return s;
            }
            return null;
        }

        private static MyDate getDate(String s) {
            if (s != null && !s.equalsIgnoreCase("NA")) {
                if (s.length() > 10) {
                    s = s.substring(0, 10).trim();
                }
                Zeile z = new Zeile(s, '-');
                int tag = z.getIntWithPossLeading0(2, -1);
                int monat = z.getIntWithPossLeading0(1, -1);
                int jahr = z.getIntWithPossLeading0(0, -1);
                if (tag != -1 && monat != -1 && jahr != -1) {
                    return new MyDate(MyDate.getTage(tag, monat, jahr));
                }
            }
            return null;
        }
    }

    public static class GAUser {
        public final String ivID;
        public final String ivVorname;
        public final String ivNachname;
        public final String ivGruppe;
        public final String ivRole;

        public GAUser(String line) {
            Zeile z = new Zeile(line, '\t');
            this.ivID = z.getStringNONEmpty(0, "?");
            this.ivVorname = z.getStringNONEmpty(1, "?");
            this.ivNachname = GAUser.cleanNameString(z.getStringNONEmpty(2, "?"));
            String s = z.getStringNONEmpty(3, "?");
            this.ivGruppe = s.replace("/", "_");
            this.ivRole = "MASTER";
        }

        private static String cleanNameString(String s) {
            s = s.replaceAll("'", "");
            s = s.replaceAll(" ", "");
            return s.toLowerCase().trim();
        }
    }
}

