/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.extras;

import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.tools.StringHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ReportCrawler {
    public static void main(String[] args) {
        String file;
        if (args.length != 3) {
            System.out.println("java mausoleum.extras.ReportCrawler group [report prefix] ID");
            System.exit(1);
        }
        String group = args[0];
        String dir = String.valueOf(GroupFileManager.getGroupDir(group)) + "/protocols";
        String startToCheck = String.valueOf(args[2]) + ";";
        File dirF = new File(dir);
        TreeSet<String> ts = new TreeSet<String>();
        String[] files = dirF.list();
        int i = 0;
        while (i < files.length) {
            if (files[i].endsWith(".zip")) {
                ts.add(files[i]);
            }
            ++i;
        }
        Iterator iterator = ts.iterator();
        while (iterator.hasNext()) {
            file = (String)iterator.next();
            ReportCrawler.checkZip(String.valueOf(dir) + "/" + file, args[1], startToCheck);
        }
        ts.clear();
        i = 0;
        while (i < files.length) {
            if (!files[i].endsWith(".zip") && files[i].startsWith(args[1])) {
                ts.add(files[i]);
            }
            ++i;
        }
        iterator = ts.iterator();
        while (iterator.hasNext()) {
            file = (String)iterator.next();
            ReportCrawler.checkFile(dir, file, startToCheck);
        }
    }

    private static void checkFile(String dir, String file, String startToCheck) {
        String ff = String.valueOf(dir) + "/" + file;
        System.out.println("Check : " + ff);
        System.out.println("---------------------------------");
        try {
            LineNumberReader lnr = new LineNumberReader(new FileReader(ff));
            String line = lnr.readLine();
            while (line != null) {
                if (line.startsWith(startToCheck)) {
                    System.out.println(line);
                }
                line = lnr.readLine();
            }
            lnr.close();
            System.out.println("---------------------------------");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void checkString(String file, String startToCheck) {
        Vector v = StringHelper.splitStringByAny(file, "\n");
        Iterator iterator = v.iterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            if (!line.startsWith(startToCheck)) continue;
            System.out.println(line);
        }
        System.out.println("---------------------------------");
    }

    public static void checkZip(String zipPath, String entryPrefix, String startToCheck) {
        block7: {
            try {
                ZipInputStream zin;
                File f = new File(zipPath);
                if (!f.exists() || (zin = new ZipInputStream(new FileInputStream(f))) == null) break block7;
                try {
                    ZipEntry entry = zin.getNextEntry();
                    while (entry != null) {
                        String name = entry.getName();
                        if (name.startsWith(entryPrefix)) {
                            int readbyte;
                            System.out.println("Check : " + name);
                            System.out.println("---------------------------------");
                            ByteArrayOutputStream myOut = new ByteArrayOutputStream();
                            byte[] mybuf = new byte[1024];
                            while ((readbyte = zin.read(mybuf)) > 0) {
                                myOut.write(mybuf, 0, readbyte);
                            }
                            String res = new String(myOut.toByteArray());
                            myOut.close();
                            ReportCrawler.checkString(res, startToCheck);
                        }
                        entry = zin.getNextEntry();
                    }
                }
                catch (Exception e) {
                    System.out.println("Problem beim Ueberpruefen der Datei innen " + entryPrefix + " im Zip " + zipPath);
                }
                zin.close();
            }
            catch (Exception e) {
                System.out.println("Problem beim Ueberpruefen der Datei " + entryPrefix + " im Zip " + zipPath);
            }
        }
    }
}

