/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.extras.cecadrechereche;

import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;
import mausoleum.rack.RackPos;
import mausoleum.visit.Visit;

public class CECADRecherche20150723 {
    private static final String FROM_GROUP = "TCF";
    private static final String TO_GROUP = "nephrologie";
    private static final String CAGE_FROM_PATH = "files/server/TCF/protocols/cage_2016_7.prot";
    private static final String MOUSE_FROM_PATH = "files/server/TCF/protocols/mouse_2016_7.prot";
    private static final String CAGE_TO_PATH = "files/server/nephrologie/protocols/cage_2016_7.prot";
    private static final String MOUSE_TO_PATH = "files/server/nephrologie/protocols/mouse_2016_7.prot";
    private static final HashSet NON_KEY = new HashSet();
    private static final String OUT_FILE = "CECADRecherche20150723.txt";

    public static void main(String[] args) {
        FileManager.saveStringToFile(OUT_FILE, "Analyse " + DatumFormat.getDateTimeString() + "\n");
        NON_KEY.add("cl");
        NON_KEY.add("Ig");
        NON_KEY.add("IDO_TYPE_ID");
        NON_KEY.add("Mc");
        TreeMap mouselines = new TreeMap();
        Vector<String> deadCageLines = new Vector<String>();
        HashSet cageIDsInTarget = new HashSet();
        try {
            HashMap<String, Vector<String>> fkeyLines = new HashMap<String, Vector<String>>();
            LineNumberReader lnr = new LineNumberReader(new FileReader(MOUSE_TO_PATH));
            String line = lnr.readLine();
            while (line != null) {
                int ind = line.indexOf(" IDO_FKEY=");
                if (ind != -1) {
                    int ind2 = line.indexOf(" ", ind + 1);
                    String fkey = line.substring(ind, ind2 + 1);
                    Vector<String> lines = (Vector<String>)fkeyLines.get(fkey);
                    if (lines == null) {
                        lines = new Vector<String>();
                        fkeyLines.put(fkey, lines);
                    }
                    lines.add(line);
                }
                line = lnr.readLine();
            }
            lnr.close();
            lnr = new LineNumberReader(new FileReader(CAGE_FROM_PATH));
            line = lnr.readLine();
            while (line != null) {
                String[] idAndDate;
                if (line.contains(" IDO_END_DATE=") && (idAndDate = CECADRecherche20150723.extractIDandDate(line)) != null && idAndDate[1].startsWith("21. Jul 2016")) {
                    deadCageLines.add(line);
                    if (!mouselines.containsKey(idAndDate[1])) {
                        mouselines.put(idAndDate[1], new Vector());
                    }
                }
                line = lnr.readLine();
            }
            lnr.close();
            lnr = new LineNumberReader(new FileReader(MOUSE_FROM_PATH));
            line = lnr.readLine();
            while (line != null) {
                Vector v;
                String[] idAndDate = CECADRecherche20150723.extractIDandDate(line);
                if (idAndDate != null && (v = (Vector)mouselines.get(idAndDate[1])) != null) {
                    v.add(line);
                }
                line = lnr.readLine();
            }
            lnr.close();
            HashSet tmpCageIDsInTarget = new HashSet();
            HashMap oldCageLinesByTargetID = new HashMap();
            Iterator iterator = deadCageLines.iterator();
            while (iterator.hasNext()) {
                String cageLine = (String)iterator.next();
                String[] cageIDAndDate = CECADRecherche20150723.extractIDandDate(cageLine);
                Vector v = (Vector)mouselines.get(cageIDAndDate[1]);
                if (v.isEmpty()) continue;
                tmpCageIDsInTarget.clear();
                boolean cageWarDa = false;
                Iterator iterator2 = v.iterator();
                while (iterator2.hasNext()) {
                    Vector toLines;
                    String mouseline = (String)iterator2.next();
                    HashMap hm = CECADRecherche20150723.extractInfos(mouseline);
                    if (!CECADRecherche20150723.wasInCageAndLeftByGroupTransfer(cageIDAndDate[0], hm) || (toLines = (Vector)fkeyLines.get(CECADRecherche20150723.getForeignKey(mouseline))) == null) continue;
                    if (!cageWarDa) {
                        CECADRecherche20150723.output("---------------------------------------------");
                        CECADRecherche20150723.output("DATUM " + cageIDAndDate[1]);
                        CECADRecherche20150723.output(cageLine);
                        CECADRecherche20150723.output("---------------------------------------------");
                        cageWarDa = true;
                    }
                    CECADRecherche20150723.output("--------------- FROM --------------- ");
                    CECADRecherche20150723.showIDObject(hm, null);
                    CECADRecherche20150723.output("---------------- TO ---------------- ");
                    Iterator iterator3 = toLines.iterator();
                    while (iterator3.hasNext()) {
                        String toLine = (String)iterator3.next();
                        CECADRecherche20150723.showIDObject(CECADRecherche20150723.extractInfos(toLine), tmpCageIDsInTarget);
                        CECADRecherche20150723.output("------------------------------------ ");
                    }
                }
                iterator2 = tmpCageIDsInTarget.iterator();
                while (iterator2.hasNext()) {
                    oldCageLinesByTargetID.put(iterator2.next(), cageLine);
                }
                cageIDsInTarget.addAll(tmpCageIDsInTarget);
            }
            lnr.close();
            CECADRecherche20150723.output("*****************************************************");
            CECADRecherche20150723.output("Suche nach diesen K\u00e4figen " + cageIDsInTarget);
            CECADRecherche20150723.output("*****************************************************");
            lnr = new LineNumberReader(new FileReader(CAGE_TO_PATH));
            line = lnr.readLine();
            while (line != null) {
                Long l;
                int ind = line.indexOf(";");
                if (ind != -1 && cageIDsInTarget.contains(l = new Long(line.substring(0, ind)))) {
                    CECADRecherche20150723.output(line);
                    CECADRecherche20150723.showIDObject(CECADRecherche20150723.extractInfos(line), null);
                    CECADRecherche20150723.output("#-#-#-#-#-#-#-#-#-#####-####-#-#");
                }
                line = lnr.readLine();
            }
            lnr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    private static String getForeignKey(String mouseLine) {
        String[] idAndDate = CECADRecherche20150723.extractIDandDate(mouseLine);
        if (idAndDate != null) {
            return " IDO_FKEY=S@" + Base64Manager.encodeBase64("TCF:" + idAndDate[0]) + " ";
        }
        return null;
    }

    private static void showIDObject(HashMap infos, HashSet cageIDsInTarget) {
        Iterator iterator = infos.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (NON_KEY.contains(key)) continue;
            String val = (String)infos.get(key);
            Object ooo = IDObjectXMLHandler.getObject(val);
            if (ooo instanceof Visit[]) {
                Visit[] arr = (Visit[])ooo;
                int i = 0;
                while (i < arr.length) {
                    if (i == 0) {
                        CECADRecherche20150723.output("VISITS : C " + arr[i].ivCageID + " M " + arr[i].ivMouseID + " F " + (arr[i].ivEndDate != null));
                        if (cageIDsInTarget != null) {
                            cageIDsInTarget.add(new Long(arr[i].ivCageID));
                        }
                    } else {
                        CECADRecherche20150723.output("       : C " + arr[i].ivCageID + " M " + arr[i].ivMouseID + " F " + (arr[i].ivEndDate != null));
                    }
                    ++i;
                }
                continue;
            }
            if (ooo instanceof RackPos) {
                RackPos rp = (RackPos)ooo;
                CECADRecherche20150723.output("RACK POS: Rack " + rp.ivRackID + " S:" + rp.ivSide + " C:" + rp.ivColumn + " R:" + rp.ivRow);
                continue;
            }
            CECADRecherche20150723.output(String.valueOf(key) + " : " + ooo);
        }
    }

    private static String[] extractIDandDate(String line) {
        int ind2;
        int ind1;
        if (line != null && (ind1 = line.indexOf(";")) != -1 && (ind2 = line.indexOf(";", ind1 + 1)) != -1) {
            return new String[]{line.substring(0, ind1), line.substring(ind1 + 1, ind2)};
        }
        return null;
    }

    private static boolean wasInCageAndLeftByGroupTransfer(String cageID, HashMap infos) {
        String enddate = (String)infos.get("IDO_END_DATE");
        String visits = (String)infos.get("Mv");
        if (enddate != null && visits != null) {
            String search = String.valueOf(cageID) + "$";
            Zeile z = new Zeile(visits.substring(3, visits.length()), '|');
            String s = z.getStringNONEmpty(z.size() - 1, null);
            if (s != null && s.startsWith(search) && s.endsWith("$9")) {
                return true;
            }
        }
        return false;
    }

    private static HashMap extractInfos(String line) {
        HashMap<String, String> hm = new HashMap<String, String>();
        int ind = line.indexOf("<I ");
        if (ind != -1) {
            String rest = line.substring(ind + 3, line.length());
            Zeile z1 = new Zeile(rest, ' ');
            int i = 0;
            while (i < z1.size()) {
                String s = z1.getStringNONEmpty(i, null);
                if (s != null && (ind = s.indexOf("=")) != -1) {
                    hm.put(s.substring(0, ind), s.substring(ind + 1, s.length()));
                }
                ++i;
            }
        }
        return hm;
    }

    private static void output(String s) {
        System.out.println(s);
        FileManager.pureAppend(OUT_FILE, String.valueOf(s) + "\n");
    }
}

