/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.extras.cecadrechereche;

import de.hannse.netobjects.datalayer.DataFile;
import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.tools.FileManager;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;
import mausoleum.main.ProcessDefinition;

public class MiisingMice {
    public static void main(String[] args) {
        ProcessDefinition.setProcessType(1);
        IDObject.init();
        DataFile df = new DataFile("rugarli", 1, "files/server/rugarli/data/mouse.data");
        MiisingMice.output(df.getObject(9170L).getSessions());
        MiisingMice.output("===========================================");
        long l = -5L;
        while (l <= 5L) {
            MiisingMice.showSession("service", 29054L + l);
            ++l;
        }
        MiisingMice.output("===========================================");
        l = -5L;
        while (l <= 5L) {
            MiisingMice.showSession("rugarli", 3542L + l);
            ++l;
        }
        MiisingMice.output("===========================================");
    }

    private static void showSession(String group, long id) {
        DataFile df = new DataFile(group, 5, "files/server/" + group + "/data/session.data");
        Session sess = (Session)df.getObject(id);
        MiisingMice.output("------------------------------------------");
        MiisingMice.output(sess.get("IDO_ID"));
        MiisingMice.output(DatumFormat.getDateTimeString(sess.getDate("IDO_START_DATE").getTime()));
        MiisingMice.output(DatumFormat.getDateTimeString(sess.getDate("IDO_END_DATE").getTime()));
        MiisingMice.output(sess.get("SES_USER"));
        MiisingMice.output("------------------------------------------");
        Vector v = (Vector)sess.get("SES_COMMAND");
        if (v != null) {
            String[] arr = new String[3];
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                String comm = (String)iterator.next();
                MiisingMice.extractInfos(comm, arr);
                MiisingMice.output(String.valueOf(arr[1]) + " " + arr[0] + " " + arr[2]);
            }
        }
    }

    private static void output(Object o) {
        String s = o.toString();
        FileManager.pureAppend("miisingMice.txt", String.valueOf(s) + "\n");
        System.out.println(s);
    }

    private static void extractInfos(String commandLine, String[] target) {
        int ind;
        String commandDate = "";
        String objectGroup = null;
        if (commandLine.startsWith("[") && (ind = commandLine.indexOf("]")) != -1) {
            String eingeklammert = commandLine.substring(1, ind).trim();
            commandLine = commandLine.substring(ind + 1, commandLine.length()).trim();
            commandLine = CommandManagerExecutive.checkServiceRoomTag(commandLine, null);
            Zeile z = new Zeile(eingeklammert, '|');
            objectGroup = z.getStringNONEmpty(1, null);
            long millis = z.getLong(0, 0L);
            if (millis != 0L) {
                commandDate = objectGroup != null ? "[" + DatumFormat.getDateTimeString(millis) + "; group:" + objectGroup + "] " : "[" + DatumFormat.getDateTimeString(millis) + "] ";
            }
        }
        target[0] = commandLine;
        target[1] = commandDate;
        target[2] = objectGroup;
    }
}

