/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import mausoleum.factsheets.FactSheetPrintDelegate;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.helper.ClipboardObject;
import mausoleum.helper.WindowUtils;
import mausoleum.requester.Requester;
import mausoleum.tables.MausoleumTable;
import mausoleum.ui.UIDef;

public class FactSheetComponentScreen
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 148564861L;
    public static final int BREITE = 600;
    public static final int RAND = 10;
    private static final Color DRAG_FUELLUNG = new Color(255, 110, 110, 128);
    private static final Color DRAG_RAHMEN = new Color(255, 80, 80);
    private static final BasicStroke RECT_STROKE = new BasicStroke(3.0f);
    private static final BasicStroke DRAG_STROKE = new BasicStroke(0.8f);
    private static final Comparator LOC_COMPARATOR = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof PrintElementFactSheet && arg1 instanceof PrintElementFactSheet) {
                PrintElementFactSheet pe0 = (PrintElementFactSheet)arg0;
                PrintElementFactSheet pe1 = (PrintElementFactSheet)arg1;
                if (pe0.ivY > pe1.ivY) {
                    return 1;
                }
                if (pe0.ivY < pe1.ivY) {
                    return -1;
                }
                if (pe0.ivX > pe1.ivX) {
                    return 1;
                }
                if (pe0.ivX < pe1.ivX) {
                    return -1;
                }
            }
            return 0;
        }
    };
    private static String cvSearchText = null;
    protected final Vector ivElements = new Vector();
    protected Vector ivSonderElements = new Vector();
    protected int ivMaxY = 0;
    protected double ivFactor = Double.NaN;
    public boolean ivShowLinks = true;
    private final boolean ivMitDragSelektion;
    private Point ivStart = null;
    public Rectangle ivRectangle = null;
    public final HashMap ivDraggedElements = new HashMap();
    public final Vector ivDraggedElementRects = new Vector();
    private final Vector ivMatchingElements = new Vector();
    private FactSheetPrintDelegate ivPrintDelegate = null;
    private Action ivCopyAction = new AbstractAction(Babel.get("COPY_SELECTED_INFO")){
        private static final long serialVersionUID = 1342556L;

        public void actionPerformed(ActionEvent e) {
            FactSheetComponentScreen.this.copyDraggedElements();
        }
    };
    private KeyStroke ivCopyKS = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private Action ivSelAllAction = new AbstractAction(Babel.get("SEL_SELECT_ALL")){
        private static final long serialVersionUID = 1342556L;

        public void actionPerformed(ActionEvent e) {
            FactSheetComponentScreen.this.selectAll();
        }
    };
    private KeyStroke ivSelAllKS = KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private Action ivSelNoneAction = new AbstractAction(Babel.get("SEL_SELECT_NONE")){
        private static final long serialVersionUID = 1342556L;

        public void actionPerformed(ActionEvent e) {
            FactSheetComponentScreen.this.selectNone();
        }
    };
    private KeyStroke ivSelNoneKS = KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private Action ivFindAction = new AbstractAction(Babel.get("SEARCH_SEARCH")){
        private static final long serialVersionUID = 1342556L;

        public void actionPerformed(ActionEvent e) {
            String s = Requester.getString(WindowUtils.getJFrame((Component)e.getSource()), Babel.get("ENTER_SEARCH_VAL"), cvSearchText);
            if (s != null && s.trim().length() != 0) {
                FactSheetComponentScreen.this.search(s, true);
            }
        }
    };
    private KeyStroke ivFindKS = KeyStroke.getKeyStroke(114, 8);
    private Action ivFindNextAction = new AbstractAction(Babel.get("SEARCH_NEXT")){
        private static final long serialVersionUID = 1342556L;

        public void actionPerformed(ActionEvent e) {
            FactSheetComponentScreen.this.search(true);
        }
    };
    private KeyStroke ivFindNextKS = KeyStroke.getKeyStroke(114, 0);
    private Action ivFindPreviousAction = new AbstractAction(Babel.get("SEARCH_PREVIOUS")){
        private static final long serialVersionUID = 1342556L;

        public void actionPerformed(ActionEvent e) {
            FactSheetComponentScreen.this.search(false);
        }
    };
    private KeyStroke ivFindPreviousKS = KeyStroke.getKeyStroke(114, 2);
    private Action ivPrintAction = new AbstractAction(Babel.get("PRINT")){
        private static final long serialVersionUID = 1342556L;

        public void actionPerformed(ActionEvent e) {
            if (FactSheetComponentScreen.this.ivPrintDelegate != null) {
                FactSheetComponentScreen.this.ivPrintDelegate.printFactSheet(false);
            }
        }
    };
    private KeyStroke ivPrintKS = KeyStroke.getKeyStroke(80, 2);
    private Action ivPreviewAction = new AbstractAction(Babel.get("PREVIEW")){
        private static final long serialVersionUID = 1342556L;

        public void actionPerformed(ActionEvent e) {
            if (FactSheetComponentScreen.this.ivPrintDelegate != null) {
                FactSheetComponentScreen.this.ivPrintDelegate.printFactSheet(true);
            }
        }
    };
    private KeyStroke ivPreviewKS = KeyStroke.getKeyStroke(80, 3);

    public FactSheetComponentScreen(boolean mitDragSelection) {
        this.setBackground(Color.white);
        this.ivMitDragSelektion = mitDragSelection;
        if (this.ivMitDragSelektion) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
        this.setFocusable(true);
        this.setBorder(MausoleumTable.PASSIVE_BORDER);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                FactSheetComponentScreen.this.setBorder(MausoleumTable.ACTIVE_BORDER);
            }

            public void focusLost(FocusEvent e) {
                FactSheetComponentScreen.this.setBorder(MausoleumTable.PASSIVE_BORDER);
            }
        });
        this.makeAction(this.ivCopyKS, this.ivCopyAction, "control S");
        this.makeAction(this.ivSelAllKS, this.ivSelAllAction, "control A");
        this.makeAction(this.ivSelNoneKS, this.ivSelNoneAction, "control Q");
        this.makeAction(this.ivFindKS, this.ivFindAction, "control F");
        this.makeAction(this.ivFindNextKS, this.ivFindNextAction, "control N");
        this.makeAction(this.ivFindPreviousKS, this.ivFindPreviousAction, "control P");
        this.makeAction(this.ivPrintKS, this.ivPrintAction, "printit");
        this.makeAction(this.ivPreviewKS, this.ivPreviewAction, "previewit");
    }

    public void setPrintDelegate(FactSheetPrintDelegate delegate) {
        this.ivPrintDelegate = delegate;
    }

    public void makeAction(KeyStroke ks, Action action, String keyStrokeAndKey) {
        this.getInputMap().put(ks, keyStrokeAndKey);
        this.getActionMap().put(keyStrokeAndKey, action);
    }

    public void addPopupItems(JPopupMenu menu) {
        if (menu.getComponentCount() != 0) {
            menu.add(new JSeparator());
        }
        this.makeItem(this.ivFindKS, this.ivFindAction, menu);
        if (cvSearchText != null && cvSearchText.trim().length() != 0) {
            this.makeItem(this.ivFindNextKS, this.ivFindNextAction, menu);
            this.makeItem(this.ivFindPreviousKS, this.ivFindPreviousAction, menu);
        }
        menu.add(new JSeparator());
        this.makeItem(this.ivSelAllKS, this.ivSelAllAction, menu);
        this.makeItem(this.ivSelNoneKS, this.ivSelNoneAction, menu);
        if (this.hasSelecteds()) {
            this.makeItem(this.ivCopyKS, this.ivCopyAction, menu);
        }
        if (this.ivPrintDelegate != null) {
            menu.add(new JSeparator());
            this.makeItem(this.ivPrintKS, this.ivPrintAction, menu);
            this.makeItem(this.ivPreviewKS, this.ivPreviewAction, menu);
        }
    }

    public void makeItem(KeyStroke ks, Action action, JPopupMenu menu) {
        JMenuItem item = new JMenuItem(action);
        item.setAccelerator(ks);
        menu.add(item);
    }

    public void setElements(Vector elements, int maxY) {
        this.ivElements.clear();
        this.ivElements.addAll(elements);
        this.ivMaxY = maxY;
        this.ivFactor = Double.NaN;
    }

    public void manageResize() {
        this.ivFactor = 1.0;
        JScrollPane jsp = WindowUtils.getJScrollPane(this);
        if (jsp != null) {
            Dimension d = jsp.getViewport().getExtentSize();
            int innerWidth = d.width - 20;
            this.ivFactor = (double)innerWidth / 600.0;
        }
    }

    public void dispose() {
        this.ivElements.clear();
    }

    public Dimension getPreferredSize() {
        double f = this.ivFactor;
        if (Double.isNaN(this.ivFactor)) {
            f = 1.0;
        }
        return new Dimension((int)(f * 600.0) + 20, (int)(f * (double)this.ivMaxY) + 20);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics g) {
        Rectangle rect;
        Dimension d = this.getSize();
        Color bg = this.getBackground();
        g.setColor(bg != null ? bg : Color.white);
        g.fillRect(0, 0, d.width, d.height);
        super.paintBorder(g);
        if (Double.isNaN(this.ivFactor)) {
            this.manageResize();
        }
        int miny = 0;
        int maxy = this.ivMaxY;
        JScrollPane scrollPane = WindowUtils.getJScrollPane(this);
        if (scrollPane != null && (rect = scrollPane.getViewport().getViewRect()) != null) {
            int oben = rect.y;
            int unten = oben + rect.height;
            miny = (int)((double)(oben - 10) / this.ivFactor) - 20;
            if (miny < 0) {
                miny = 0;
            }
            maxy = (int)((double)(unten - 10) / this.ivFactor) + 20;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(10, 10);
        g2d.scale(this.ivFactor, this.ivFactor);
        if (this.ivMitDragSelektion && this.ivRectangle != null) {
            g.setColor(UIDef.SELECTED_BACKGROUND_TRANSP);
            g.fillRect(this.ivRectangle.x, this.ivRectangle.y, this.ivRectangle.width, this.ivRectangle.height);
            g.setColor(UIDef.SELECTED_BACKGROUND);
            g2d.setStroke(RECT_STROKE);
            g2d.drawRect(this.ivRectangle.x, this.ivRectangle.y, this.ivRectangle.width, this.ivRectangle.height);
        }
        this.printElements(this.ivElements, g2d, miny, maxy);
        this.printElements(this.ivSonderElements, g2d, miny, maxy);
        if (this.ivMitDragSelektion && this.ivDraggedElementRects != null && !this.ivDraggedElementRects.isEmpty()) {
            Iterator iter = this.ivDraggedElementRects.iterator();
            while (iter.hasNext()) {
                Rectangle r = (Rectangle)iter.next();
                g.setColor(DRAG_FUELLUNG);
                g.fillRect(r.x, r.y, r.width, r.height);
                g.setColor(DRAG_RAHMEN);
                g2d.setStroke(DRAG_STROKE);
                g2d.drawRect(r.x, r.y, r.width, r.height);
            }
        }
        g2d.scale(1.0 / this.ivFactor, 1.0 / this.ivFactor);
        g2d.translate(-10, -10);
    }

    private void printElements(Vector elements, Graphics2D g2d, int miny, int maxy) {
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            PrintElementFactSheet element = (PrintElementFactSheet)iter.next();
            if (!element.isWithin(miny, maxy)) continue;
            element.print(g2d, this.ivShowLinks);
        }
    }

    public Object getElementAt(Point p, int printElementTyp) {
        p = this.getScaledPoint(p);
        Iterator iter = this.ivElements.iterator();
        while (iter.hasNext()) {
            PrintElementFactSheet element = (PrintElementFactSheet)iter.next();
            Object ooo = element.getElementAtScaledPoint(p, printElementTyp);
            if (ooo == null) continue;
            return ooo;
        }
        return null;
    }

    protected Point getScaledPoint(Point p) {
        return new Point((int)((double)(p.x - 10) / this.ivFactor), (int)((double)(p.y - 10) / this.ivFactor));
    }

    public void search(String text, boolean nextOne) {
        if (text != null && text.trim().length() != 0) {
            cvSearchText = text.toLowerCase().trim();
            this.search(nextOne);
        }
    }

    public void search(boolean nextOne) {
        if (cvSearchText != null && cvSearchText.trim().length() != 0) {
            this.collectMatchingElements();
            if (!this.ivMatchingElements.isEmpty()) {
                PrintElementFactSheet fpe = nextOne ? this.findNextInMatchings(this.getLastDraggedElement()) : this.findPreviousInMatchings(this.getFirstDraggedElement());
                this.ivStart = null;
                this.ivRectangle = null;
                this.ivDraggedElements.clear();
                this.ivDraggedElementRects.clear();
                Iterator iter = this.ivElements.iterator();
                while (iter.hasNext()) {
                    PrintElementFactSheet element = (PrintElementFactSheet)iter.next();
                    element.addIfItsMe(fpe, this.ivDraggedElements, this.ivDraggedElementRects);
                }
                this.scrollToFirstDragged();
            } else {
                this.ivStart = null;
                this.ivRectangle = null;
                this.ivDraggedElements.clear();
                this.ivDraggedElementRects.clear();
            }
            this.repaint();
        }
    }

    public void selectAll() {
        this.ivDraggedElements.clear();
        this.ivDraggedElementRects.clear();
        Iterator iter = this.ivElements.iterator();
        while (iter.hasNext()) {
            PrintElementFactSheet element = (PrintElementFactSheet)iter.next();
            element.addIntersecting(null, this.ivDraggedElements, this.ivDraggedElementRects);
        }
        this.ivRectangle = null;
        this.repaint();
    }

    public void selectNone() {
        this.ivDraggedElements.clear();
        this.ivDraggedElementRects.clear();
        this.ivRectangle = null;
        this.repaint();
    }

    private void collectMatchingElements() {
        this.ivMatchingElements.clear();
        Iterator iterator = this.ivElements.iterator();
        while (iterator.hasNext()) {
            PrintElementFactSheet pe = (PrintElementFactSheet)iterator.next();
            pe.addIfContaining(cvSearchText, this.ivMatchingElements);
        }
    }

    private Point getLastDraggedElement() {
        Point p = new Point(0, 0);
        if (this.ivDraggedElements != null) {
            Iterator iterator = this.ivDraggedElements.keySet().iterator();
            while (iterator.hasNext()) {
                Point tp = (Point)iterator.next();
                if (tp.y <= p.y && (tp.y != p.y || tp.x <= p.x)) continue;
                p.y = tp.y;
                p.x = tp.x;
            }
        }
        return p;
    }

    private Point getFirstDraggedElement() {
        Point p = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
        if (this.ivDraggedElements != null) {
            Iterator iterator = this.ivDraggedElements.keySet().iterator();
            while (iterator.hasNext()) {
                Point tp = (Point)iterator.next();
                if (tp.y >= p.y && (tp.y != p.y || tp.x >= p.x)) continue;
                p.y = tp.y;
                p.x = tp.x;
            }
        }
        return p;
    }

    private PrintElementFactSheet findNextInMatchings(Point p) {
        Collections.sort(this.ivMatchingElements, LOC_COMPARATOR);
        Iterator iterator = this.ivMatchingElements.iterator();
        while (iterator.hasNext()) {
            PrintElementFactSheet tpef = (PrintElementFactSheet)iterator.next();
            if (tpef.ivY <= p.y && (tpef.ivY != p.y || tpef.ivX <= p.x)) continue;
            return tpef;
        }
        return (PrintElementFactSheet)this.ivMatchingElements.firstElement();
    }

    private PrintElementFactSheet findPreviousInMatchings(Point p) {
        Collections.sort(this.ivMatchingElements, LOC_COMPARATOR);
        Collections.reverse(this.ivMatchingElements);
        Iterator iterator = this.ivMatchingElements.iterator();
        while (iterator.hasNext()) {
            PrintElementFactSheet tpef = (PrintElementFactSheet)iterator.next();
            if (tpef.ivY >= p.y && (tpef.ivY != p.y || tpef.ivX >= p.x)) continue;
            return tpef;
        }
        return (PrintElementFactSheet)this.ivMatchingElements.firstElement();
    }

    public void scrollToFirstDragged() {
        if (!this.ivDraggedElementRects.isEmpty()) {
            Rectangle r = (Rectangle)this.ivDraggedElementRects.firstElement();
            JScrollPane sp = WindowUtils.getJScrollPane(this);
            if (sp != null) {
                double f = Double.isNaN(this.ivFactor) ? 1.0 : this.ivFactor;
                Rectangle nr = new Rectangle((int)((double)r.x * f) - 10, (int)((double)r.y * f) - 10, (int)((double)r.width * f) + 20, (int)((double)r.height * f) + 20);
                this.scrollRectToVisible(nr);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        if (this.ivMitDragSelektion && !e.isMetaDown()) {
            this.ivStart = this.getScaledPoint(e.getPoint());
            this.ivRectangle = null;
            this.ivDraggedElements.clear();
            this.ivDraggedElementRects.clear();
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.ivMitDragSelektion && this.ivStart != null && this.ivRectangle != null) {
            this.ivDraggedElements.clear();
            this.ivDraggedElementRects.clear();
            Iterator iter = this.ivElements.iterator();
            while (iter.hasNext()) {
                PrintElementFactSheet element = (PrintElementFactSheet)iter.next();
                element.addIntersecting(this.ivRectangle, this.ivDraggedElements, this.ivDraggedElementRects);
            }
            this.ivRectangle = null;
            this.repaint();
        }
    }

    public boolean hasSelecteds() {
        return !this.ivDraggedElements.isEmpty();
    }

    public void copyDraggedElements() {
        if (!this.ivDraggedElements.isEmpty()) {
            FactSheetComponentScreen.copyDraggedElements(this.ivDraggedElements);
            this.repaint();
        }
    }

    public static void copyDraggedElements(HashMap draggedElements) {
        HashSet<Integer> hsx = new HashSet<Integer>(20);
        HashSet<Integer> hsy = new HashSet<Integer>(20);
        Iterator iter = draggedElements.keySet().iterator();
        while (iter.hasNext()) {
            Point p = (Point)iter.next();
            hsx.add(new Integer(p.x));
            hsy.add(new Integer(p.y));
        }
        Vector<Integer> vx = new Vector<Integer>(hsx.size());
        Vector<Integer> vy = new Vector<Integer>(hsy.size());
        vx.addAll(hsx);
        vy.addAll(hsy);
        Collections.sort(vx);
        Collections.sort(vy);
        StringBuffer msb = new StringBuffer();
        Point hol = new Point();
        Iterator iter2 = vy.iterator();
        while (iter2.hasNext()) {
            Integer iy = (Integer)iter2.next();
            hol.y = iy;
            Iterator iterator = vx.iterator();
            while (iterator.hasNext()) {
                Integer ix = (Integer)iterator.next();
                hol.x = ix;
                PrintElementFactSheet pen = (PrintElementFactSheet)draggedElements.get(hol);
                if (pen != null) {
                    String rein = pen.ivAltText != null ? pen.ivAltText : pen.ivText;
                    rein = StringHelper.gSub(rein, "\"", "'");
                    msb.append("\"").append(rein).append("\"");
                }
                if (!iterator.hasNext()) continue;
                msb.append("\t");
            }
            if (!iter2.hasNext()) continue;
            msb.append("\r\n");
        }
        ClipboardObject.manageCopy(null, msb.toString());
    }

    public void mouseDragged(MouseEvent e) {
        if (this.ivMitDragSelektion && this.ivStart != null && !e.isMetaDown()) {
            Point np = this.getScaledPoint(e.getPoint());
            int x = this.ivStart.x;
            int y = this.ivStart.y;
            int w = np.x - x;
            int h = np.y - y;
            if (w < 0) {
                x += w;
                w = -w;
            }
            if (h < 0) {
                y += h;
                h = -h;
            }
            this.ivRectangle = new Rectangle(x, y, w, h);
            this.ivDraggedElements.clear();
            this.ivDraggedElementRects.clear();
            Iterator iter = this.ivElements.iterator();
            while (iter.hasNext()) {
                PrintElementFactSheet element = (PrintElementFactSheet)iter.next();
                element.addIntersecting(this.ivRectangle, this.ivDraggedElements, this.ivDraggedElementRects);
            }
            this.scrollRectToVisible(new Rectangle(e.getX(), e.getY(), 1, 1));
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }
}

