/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mausoleum.factsheets.FactSheetGroup;
import mausoleum.factsheets.FactSheetPanel;
import mausoleum.gui.ClosableTabbedPane;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.FocusHoler;
import mausoleum.helper.KomfortHashMap;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.Inspector;
import mausoleum.tables.MausoleumTable;
import mausoleum.ui.UIDef;
import mausoleum.usergroup.UserGroup;

public class FactSheetFrame
extends JFrame
implements LayoutManager {
    private static final long serialVersionUID = 11681351353L;
    private static final Vector OPEN_FRAMES = new Vector();
    private static final int RAND = UIDef.getScaled(5);
    private static final FactSheetFrame MAIN_INSTANCE = new FactSheetFrame(0, 0);
    private final ClosableTabbedPane ivTabbedPane = new ClosableTabbedPane(true, true);

    public static void closeOpenFrames() {
        Vector v = new Vector(OPEN_FRAMES);
        Iterator iterator = v.iterator();
        while (iterator.hasNext()) {
            FactSheetFrame mdf = (FactSheetFrame)iterator.next();
            mdf.ivTabbedPane.clearCompletely();
            mdf.setVisible(false);
            if (mdf == MAIN_INSTANCE) continue;
            mdf.dispose();
            OPEN_FRAMES.remove(mdf);
        }
    }

    public static void showTab(String group, Vector objects, String title) {
        MAIN_INSTANCE.addNewTab(group, objects, null, null, title, null, true);
    }

    public static void showTab(Vector objects, String title) {
        MAIN_INSTANCE.addNewTab(null, objects, null, null, title, null, true);
    }

    public static void showTab(Vector objects, String singleClass, String singleSelection, String title, String sonderVorspann) {
        MAIN_INSTANCE.addNewTab(null, objects, singleClass, singleSelection, title, sonderVorspann, true);
    }

    public static void showTableTab(MausoleumTable mt, String titel) {
        MAIN_INSTANCE.addNewTableTab(mt, titel);
        WindowUtils.bringUpFrame(MAIN_INSTANCE);
    }

    public FactSheetFrame(int xoff, int yoff) {
        this.setContentPane(new RequesterPane(this));
        this.setIconImage(MausoleumImageStore.getLogo());
        this.ivTabbedPane.setOpaque(false);
        this.ivTabbedPane.setBackground(new Color(220, 220, 220, 70));
        this.getContentPane().add(this.ivTabbedPane);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                FactSheetFrame.this.adaptToTab();
            }
        });
        this.ivTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                FactSheetFrame.this.adaptToTab();
            }
        });
        int ww = 0;
        int wh = 0;
        this.pack();
        Insets inni = this.getInsets();
        ww = inni.left + inni.right + UIDef.getScaled(600) + 2 * RAND + RAND;
        wh = UIDef.getScaled(800);
        WindowUtils.setSizeAndCenterOnScreen(this, ww, wh);
        if (xoff != 0 || yoff != 0) {
            Point p = this.getLocation();
            p.x += xoff;
            p.y += yoff;
            this.setLocation(p);
        }
        OPEN_FRAMES.add(this);
    }

    public void addNewTableTab(MausoleumTable mt, String titel) {
        this.ivTabbedPane.addTab(titel, mt);
        this.ivTabbedPane.setSelectedComponent(mt);
    }

    public FactSheetPanel addNewTab(Vector objects) {
        return this.addNewTab(null, objects, null, null, this.getTitle(), null, false);
    }

    public FactSheetPanel addNewTab(String group, Vector objects, String singleClass, String singleSelection, String title, String sonderVorspann, boolean bringitUp) {
        if (!objects.isEmpty() && objects.firstElement() instanceof UserGroup) {
            try {
                if (FactSheetGroup.groupReportForHeadOfService(objects) && bringitUp) {
                    WindowUtils.bringUpFrame(this);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            return null;
        }
        KomfortHashMap infoSelection = null;
        if (singleClass != null && singleSelection != null) {
            infoSelection = KomfortHashMap.getHashsetHashmap(singleClass, singleSelection);
        }
        if (sonderVorspann != null && infoSelection != null) {
            infoSelection.put((Object)"SONDER_VORSPANN", sonderVorspann);
        }
        FactSheetPanel fsp = this.addNewTab(group, objects, infoSelection, title);
        if (bringitUp) {
            WindowUtils.bringUpFrame(this);
        }
        return fsp;
    }

    public FactSheetPanel addNewTab(String group, Vector objects, KomfortHashMap infoSelection, String title) {
        FactSheetPanel fsp = new FactSheetPanel(group, objects, infoSelection, title);
        this.ivTabbedPane.addTab(fsp.ivTabName, fsp);
        this.ivTabbedPane.setSelectedComponent(fsp);
        fsp.requestFocusInWindow();
        fsp.checkButs();
        return fsp;
    }

    private void adaptToTab() {
        String title = null;
        Component ooo = this.ivTabbedPane.getSelectedComponent();
        if (ooo != null) {
            if (ooo instanceof MausoleumTable) {
                Inspector.adjustToTable((MausoleumTable)ooo);
            }
            if (ooo instanceof FactSheetPanel) {
                FactSheetPanel fsp = (FactSheetPanel)ooo;
                title = fsp.ivTitle;
                if (!fsp.ivComponent.hasFocus()) {
                    new FocusHoler(fsp.ivComponent);
                }
            }
        } else {
            Inspector.adjustToTable(null);
        }
        this.setTitle(title);
    }

    public void addLayoutComponent(String s, Component c) {
    }

    public void layoutContainer(Container c) {
        Dimension d = c.getSize();
        this.ivTabbedPane.setBounds(RAND, RAND, d.width - 2 * RAND, d.height - 2 * RAND);
    }

    public Dimension minimumLayoutSize(Container c) {
        return new Dimension(400, 300);
    }

    public Dimension preferredLayoutSize(Container c) {
        return new Dimension(800, 600);
    }

    public void removeLayoutComponent(Component c) {
    }
}

