/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.cage.colors.MixColorMode;
import mausoleum.factsheets.FactSheet;
import mausoleum.factsheets.FactSheetFrame;
import mausoleum.factsheets.FactSheetServiceInfo;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.factsheets.groupreport.GroupQuotaReport;
import mausoleum.helper.DatumFormat;
import mausoleum.inspector.Inspector;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.AllgPickRequester;
import mausoleum.ui.UIDef;
import mausoleum.usergroup.UserGroup;
import mausoleum.usergroup.UsergroupManager;

public class FactSheetQuotaReport
extends FactSheet {
    public static void makeQuotaReport() {
        Vector<GroupQuotaReport.GQInfoLineVector> sammler = new Vector<GroupQuotaReport.GQInfoLineVector>();
        Vector<String> groups = null;
        if (MausoleumClient.isHeadOfService()) {
            Vector groupObjects = AllgPickRequester.pickFromList(Inspector.getInspector(), UsergroupManager.cvInstance.getActualObjectVectorAllGroups(), "SELECT_GROUP", "GROUPS", new int[]{1, 2}, new String[]{"APR_SELECT_ALL", "APR_SELECT_NONE"}, 2);
            if (groupObjects != null) {
                groups = new Vector(groupObjects.size());
                Iterator iterator = groupObjects.iterator();
                while (iterator.hasNext()) {
                    UserGroup ug = (UserGroup)iterator.next();
                    groups.add(ug.ivName);
                }
            }
        } else {
            groups = new Vector<String>(1);
            groups.add(UserManager.getFirstGroup());
        }
        if (groups != null) {
            Iterator iterator = groups.iterator();
            while (iterator.hasNext()) {
                GroupQuotaReport.GQInfoLineVector gqInfoLines;
                String group = (String)iterator.next();
                String quotaRep = (String)RequestManager.createSendAndGetObjectIfFinished((byte)74, group, UserManager.getFirstGroup());
                if (quotaRep == null || (gqInfoLines = GroupQuotaReport.GQBlock.generateInfoLinesFromTransport(quotaRep, group)) == null) continue;
                sammler.add(gqInfoLines);
            }
            if (!sammler.isEmpty()) {
                FactSheetFrame.showTab(UserManager.getFirstGroup(), sammler, Babel.get("QUOTA_REPORT"));
            } else {
                Alert.showAlert(Babel.get("NO_DATA_AVAILABLE"), true);
            }
        }
    }

    public int addPrintElements(String group, Object object, int y, int width, Vector target, HashSet selection, String sonderVorspann) {
        if (object instanceof GroupQuotaReport.GQInfoLineVector) {
            GroupQuotaReport.GQInfoLineVector gqiv = (GroupQuotaReport.GQInfoLineVector)object;
            int lw = 120;
            int rx = lw + UIDef.INNER_RAND;
            String mainTitel = String.valueOf(Babel.get("FS_QUOT_REP_FOR_GROUP")) + " " + gqiv.ivGroup;
            y = FactSheetQuotaReport.createStandardStartLines(null, mainTitel, y, rx, width, target, null, sonderVorspann);
            Vector lines = new Vector();
            Vector<Integer> horizLineYPos = new Vector<Integer>();
            Vector<Integer> lineYs = new Vector<Integer>();
            Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
            lines.add(line);
            horizLineYPos.add(new Integer(y));
            lineYs.add(new Integer(y));
            line.add(PrintElementFactSheet.getTextElement(0, y += 4, DatumFormat.getDateTimeString(System.currentTimeMillis()), FactSheet.TABHEADER_FONT));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_QUOTA"), TABHEADER_FONT, 0));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_QUOTAPERC"), TABHEADER_FONT, 0));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_TOTAL_CAGES"), TABHEADER_FONT, 0));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_EMPTY_CAGES"), TABHEADER_FONT, 0));
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_MATINGS"), TABHEADER_FONT, 0));
            y += TABHEADER_FONT.getSize() + 2;
            horizLineYPos.add(new Integer(y += 4));
            lineYs.add(new Integer(y));
            y += 4;
            Vector<GroupQuotaReport.GQInfoLine> buildingLines = new Vector<GroupQuotaReport.GQInfoLine>();
            Iterator iterator = gqiv.iterator();
            while (iterator.hasNext()) {
                GroupQuotaReport.GQInfoLine infoLine = (GroupQuotaReport.GQInfoLine)iterator.next();
                if (infoLine.ivTyp != 22) continue;
                buildingLines.add(infoLine);
            }
            Vector<GroupQuotaReport.GQInfoLine> oneBlock = new Vector<GroupQuotaReport.GQInfoLine>();
            Iterator iterator2 = buildingLines.iterator();
            while (iterator2.hasNext()) {
                oneBlock.clear();
                GroupQuotaReport.GQInfoLine buildingLine = (GroupQuotaReport.GQInfoLine)iterator2.next();
                oneBlock.add(buildingLine);
                Vector roomVec = FactSheetQuotaReport.collect(gqiv, buildingLine);
                Iterator iterator22 = roomVec.iterator();
                while (iterator22.hasNext()) {
                    GroupQuotaReport.GQInfoLine roomLine = (GroupQuotaReport.GQInfoLine)iterator22.next();
                    Vector rackVec = FactSheetQuotaReport.collect(gqiv, roomLine);
                    oneBlock.add(roomLine);
                    oneBlock.addAll(rackVec);
                }
                y = FactSheetQuotaReport.makeBlock(oneBlock, y, lines, horizLineYPos, lineYs);
            }
            lineYs.add(new Integer(y += 3));
            horizLineYPos.add(new Integer(y));
            return FactSheetQuotaReport.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
        }
        return 0;
    }

    private static Vector collect(GroupQuotaReport.GQInfoLineVector gqiv, GroupQuotaReport.GQInfoLine superLine) {
        Vector<GroupQuotaReport.GQInfoLine> res = new Vector<GroupQuotaReport.GQInfoLine>();
        Iterator iterator = gqiv.iterator();
        while (iterator.hasNext()) {
            GroupQuotaReport.GQInfoLine infoLine = (GroupQuotaReport.GQInfoLine)iterator.next();
            if (infoLine.ivSuperTyp != superLine.ivTyp || infoLine.ivSuperObjectID != superLine.ivObjectID) continue;
            res.add(infoLine);
        }
        Collections.sort(res);
        return res;
    }

    private static int makeBlock(Vector v, int y, Vector lines, Vector horizLineYPos, Vector lineYs) {
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
            lines.add(line);
            GroupQuotaReport.GQInfoLine mpo = (GroupQuotaReport.GQInfoLine)iter.next();
            if (mpo.ivTyp == 10) {
                horizLineYPos.add(new Integer(y += 3));
                lineYs.add(new Integer(y));
            }
            int myLineY = y;
            int myLineHeight = STANDARD_FONT.getSize() + 5;
            lineYs.add(new Integer(y));
            line.add(PrintElementFactSheet.getTextElement(0, y += 3, FactSheetQuotaReport.getN(mpo.ivName, mpo.ivTyp), FETT_FONT, 2));
            Color col = null;
            int proz = -1;
            if (mpo.ivQuota > 0 && mpo.ivCages > 0) {
                proz = mpo.ivCages * 100 / mpo.ivQuota;
                col = MixColorMode.getColor(proz, FactSheetServiceInfo.QUOTA_VALUES, FactSheetServiceInfo.QUOTA_COLORS);
            }
            if (col == null) {
                line.add(PrintElementFactSheet.getTextElement(0, y, FactSheetQuotaReport.getIS(mpo.ivQuota), FETT_FONT, 4));
            } else {
                line.add(PrintElementFactSheet.getFilledTextBox(0, myLineY, 0, myLineHeight, FactSheetQuotaReport.getIS(mpo.ivQuota), FETT_FONT, col, Color.black, null, 4));
            }
            if (proz < 0 || col == null) {
                line.add(PrintElementFactSheet.getTextElement(0, y, "", FETT_FONT, 4));
            } else {
                line.add(PrintElementFactSheet.getFilledTextBox(0, myLineY, 0, myLineHeight, String.valueOf(Integer.toString(proz)) + "%", FETT_FONT, col, Color.black, null, 4));
            }
            if (col == null) {
                line.add(PrintElementFactSheet.getTextElement(0, y, FactSheetQuotaReport.getIS(mpo.ivCages), FETT_FONT, 4));
            } else {
                line.add(PrintElementFactSheet.getFilledTextBox(0, myLineY, 0, myLineHeight, FactSheetQuotaReport.getIS(mpo.ivCages), FETT_FONT, col, Color.black, null, 4));
            }
            line.add(PrintElementFactSheet.getTextElement(0, y, FactSheetQuotaReport.getIS(mpo.ivEmptyCages), FETT_FONT, 4));
            line.add(PrintElementFactSheet.getTextElement(0, y, FactSheetQuotaReport.getIS(mpo.ivMatingCages), FETT_FONT, 4));
            y += STANDARD_FONT.getSize() + 2;
        }
        return y;
    }

    private static String getIS(int val) {
        return val > 0 ? Integer.toString(val) : "";
    }

    private static String getN(String name, int typ) {
        if (typ == 22) {
            return name;
        }
        if (typ == 10) {
            return "     " + name;
        }
        if (typ == 3) {
            return "          " + name;
        }
        return name;
    }
}

