/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.building.BuildingManager;
import mausoleum.cage.colors.MixColorMode;
import mausoleum.factsheets.FactSheet;
import mausoleum.factsheets.FactSheetFrame;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.factsheets.service.ServiceInfoCollector;
import mausoleum.helper.DatumFormat;
import mausoleum.main.MausoleumClient;
import mausoleum.ui.UIDef;

public class FactSheetServiceInfo
extends FactSheet {
    private static final int BLOCK_HEIGHT_L = 30;
    private static final int BLOCK_HEIGHT_S = 20;
    private static final int LABEL_TOTAL_WIDTH = 40;
    private static final int LABEL_NAME_WIDTH = 120;
    private static final DecimalFormat PERC_2NKS_FORMAT = new DecimalFormat("0.00%");
    private static final DecimalFormat INTEGER_FORMAT = new DecimalFormat("#,##0");
    private static final Color MATING_PART_COLOR = new Color(80, 80, 80, 80);
    public static final Color[] QUOTA_COLORS = new Color[]{new Color(70, 250, 0), new Color(250, 250, 0), new Color(250, 70, 0)};
    public static final int[] QUOTA_VALUES;

    static {
        int[] nArray = new int[3];
        nArray[1] = 90;
        nArray[2] = 120;
        QUOTA_VALUES = nArray;
    }

    public static void createServiceReport() {
        if (MausoleumClient.isHeadOfService()) {
            Vector<ServiceInfoCollector> v = new Vector<ServiceInfoCollector>();
            v.add(new ServiceInfoCollector());
            FactSheetFrame.showTab(UserManager.getFirstGroup(), v, Babel.get("FS_SERV_SERVICE_REPORT"));
        }
    }

    public int addPrintElements(String group, Object object, int y, int width, Vector target, HashSet selection, String sonderVorspann) {
        if (object instanceof ServiceInfoCollector) {
            String roomName;
            Iterator iter;
            ServiceInfoCollector sic = (ServiceInfoCollector)object;
            int lw = 120;
            int rx = lw + UIDef.INNER_RAND;
            int balkenStart = 40 + UIDef.INNER_RAND;
            y = FactSheetServiceInfo.createStandardStartLines(null, String.valueOf(Babel.get("FS_SERV_SERVICE_REPORT")) + ": " + DatumFormat.getDateTimeString(System.currentTimeMillis()), y, rx, width, target, null, "");
            y += UIDef.INNER_RAND;
            y = FactSheetServiceInfo.createPEHeader(y, target, Babel.get("FS_SERV_WHOLE_UNIT"), width);
            ServiceInfoCollector.SIBlock siBlock = sic.ivSIBlock;
            sic.fillTotalBlock(siBlock);
            y = FactSheetServiceInfo.createBalken(0, 40, Babel.get("FS_SERV_TOTAL"), balkenStart, y, width - balkenStart, 30, siBlock.ivPercents, siBlock.ivColors, target, siBlock.ivMatingPercents, siBlock.ivEmptyPercents);
            y += 15;
            if (BuildingManager.areThereBuildings()) {
                iter = sic.getBuildingNames().iterator();
                while (iter.hasNext()) {
                    String buildingName = (String)iter.next();
                    String buildingNameLabel = buildingName;
                    buildingNameLabel = buildingNameLabel.equals("#*#*BUILDINGLESS") ? Babel.get("FS_SERV_WITHOUT_BUILDING") : String.valueOf(Babel.get("BUILDING")) + ": " + buildingName;
                    if (!sic.fillBuildingBlock(siBlock, buildingName)) continue;
                    y = FactSheetServiceInfo.createBalken(balkenStart, 120, buildingNameLabel, balkenStart + 120, y, width - balkenStart - 120, 20, siBlock.ivPercents, siBlock.ivColors, target, siBlock.ivMatingPercents, siBlock.ivEmptyPercents);
                    y += 5;
                }
                y += 15;
            }
            iter = sic.getRoomNames().iterator();
            while (iter.hasNext()) {
                roomName = (String)iter.next();
                String roomNameLabel = roomName;
                roomNameLabel = roomNameLabel.equals("#*#*ROOMLESS") ? Babel.get("FS_SERV_WITHOUT_ROOM") : String.valueOf(Babel.get("ROOM")) + ": " + roomName;
                if (!sic.fillRoomBlock(siBlock, roomName)) continue;
                y = FactSheetServiceInfo.createBalken(balkenStart, 120, roomNameLabel, balkenStart + 120, y, width - balkenStart - 120, 20, siBlock.ivPercents, siBlock.ivColors, target, siBlock.ivMatingPercents, siBlock.ivEmptyPercents);
                y += 5;
            }
            y += 15;
            y = FactSheetServiceInfo.collectTotalTable(sic, y, width, target, siBlock);
            y = FactSheetServiceInfo.createRecordBreak(target, 0, y, false);
            y += 15;
            iter = sic.getRoomNames().iterator();
            while (iter.hasNext()) {
                roomName = (String)iter.next();
                Vector rackIDS = sic.getRackIDs(roomName);
                if (rackIDS != null) {
                    String roomNameLabel = roomName;
                    roomNameLabel = roomNameLabel.equals("#*#*ROOMLESS") ? Babel.get("FS_SERV_WITHOUT_ROOM") : String.valueOf(Babel.get("ROOM")) + ": " + roomName;
                    y = FactSheetServiceInfo.createPEHeader(y, target, roomNameLabel, width);
                    sic.fillRoomBlock(siBlock, roomName);
                    y = FactSheetServiceInfo.createBalken(0, 40, Babel.get("FS_SERV_TOTAL"), balkenStart, y, width - balkenStart, 30, siBlock.ivPercents, siBlock.ivColors, target, siBlock.ivMatingPercents, siBlock.ivEmptyPercents);
                    y += 15;
                    Iterator iterator = rackIDS.iterator();
                    while (iterator.hasNext()) {
                        Long rackID = (Long)iterator.next();
                        String rackName = sic.fillRackBlock(siBlock, rackID);
                        if (rackName == null) continue;
                        y = FactSheetServiceInfo.createBalken(balkenStart, 120, String.valueOf(Babel.get("RACK")) + ": " + rackName, balkenStart + 120, y, width - balkenStart - 120, 20, siBlock.ivPercents, siBlock.ivColors, target, siBlock.ivMatingPercents, siBlock.ivEmptyPercents);
                        y += 5;
                    }
                    y += 15;
                    y = FactSheetServiceInfo.collectRoomTable(roomName, sic, y, width, target, siBlock);
                }
                y = FactSheetServiceInfo.createRecordBreak(target, 0, y, false);
                y += 15;
            }
        }
        return y;
    }

    private static int createBalken(int lx, int lw, String label, int x, int y, int width, int height, double[] percentages, Color[] colors, Vector target, double[] matingpercentages, double[] emptypercentages) {
        int unten;
        Vector<PrintElementFactSheet> sammel = new Vector<PrintElementFactSheet>();
        int yl = FactSheetServiceInfo.addFullLongText(label, lw, y, sammel, FETT_FONT, 2, 0);
        if (yl > (unten = y + height)) {
            unten = yl;
        } else {
            int off = (unten - yl) / 2;
            Iterator iter = sammel.iterator();
            while (iter.hasNext()) {
                PrintElementFactSheet element = (PrintElementFactSheet)iter.next();
                element.translateY(off);
            }
        }
        Iterator iter = sammel.iterator();
        while (iter.hasNext()) {
            PrintElementFactSheet element = (PrintElementFactSheet)iter.next();
            element.ivX += lx;
        }
        int ax = x;
        PrintElementFactSheet pef = PrintElementFactSheet.getBoxElement(x, y, width, height);
        sammel.add(pef);
        int awsum = 0;
        int i = 0;
        while (i < colors.length) {
            int actWidth = (int)(percentages[i] * (double)width);
            if (i == colors.length - 1) {
                actWidth = width - awsum;
            }
            pef = PrintElementFactSheet.getFilledBoxElement(ax, y, actWidth, height, colors[i], Color.black);
            pef.ivLineWidth = 0.8f;
            sammel.add(pef);
            if (emptypercentages[i] != 0.0) {
                int emptyHeight = (int)(emptypercentages[i] * (double)height);
                pef = PrintElementFactSheet.getFilledBoxElement(ax, y, actWidth, emptyHeight, Color.white, Color.black);
                pef.ivLineWidth = 0.8f;
                sammel.add(pef);
            }
            if (matingpercentages[i] != 0.0) {
                int matHeight = (int)(matingpercentages[i] * (double)height);
                pef = PrintElementFactSheet.getFilledBoxElement(ax, y + height - matHeight, actWidth, matHeight, MATING_PART_COLOR, Color.black);
                pef.ivLineWidth = 0.8f;
                sammel.add(pef);
            }
            ax += actWidth;
            awsum += actWidth;
            ++i;
        }
        target.add(PrintElementFactSheet.getVectorElement(sammel));
        return unten;
    }

    private static int collectTotalTable(ServiceInfoCollector sic, int y, int width, Vector target, ServiceInfoCollector.SIBlock siBlock) {
        Iterator iter;
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        y += 4;
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        if (BuildingManager.areThereBuildings()) {
            line.add(PrintElementFactSheet.getTextElement(0, y, String.valueOf(Babel.get("BUILDING")) + "/" + Babel.get("ROOM"), TABHEADER_FONT));
        } else {
            line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("ROOM"), TABHEADER_FONT));
        }
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("GROUP"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("QUOTA"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FILLED_CAGES"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("TOTAL_CAGES"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("WEDDINGS"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("MICE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_SERV_PERCENT"), TABHEADER_FONT));
        y += TABHEADER_FONT.getSize() + 2;
        horizLineYPos.add(new Integer(y += 4));
        if (BuildingManager.areThereBuildings()) {
            iter = sic.getBuildingNames().iterator();
            while (iter.hasNext()) {
                String buildingName = (String)iter.next();
                if (!sic.fillBuildingBlock(siBlock, buildingName)) continue;
                String buildingNameLabel = buildingName;
                if (buildingNameLabel.equals("#*#*BUILDINGLESS")) {
                    buildingNameLabel = Babel.get("FS_SERV_WITHOUT_BUILDING");
                }
                y = FactSheetServiceInfo.fillTableBlock(y, buildingNameLabel, lines, lineYs, horizLineYPos, sic, siBlock);
            }
            lineYs.add(new Integer(y));
            horizLineYPos.add(new Integer(y += 2));
            lineYs.add(new Integer(y));
        }
        iter = sic.getRoomNames().iterator();
        while (iter.hasNext()) {
            String roomName = (String)iter.next();
            if (!sic.fillRoomBlock(siBlock, roomName)) continue;
            String roomNameLabel = roomName;
            if (roomNameLabel.equals("#*#*ROOMLESS")) {
                roomNameLabel = Babel.get("FS_SERV_WITHOUT_ROOM");
            }
            y = FactSheetServiceInfo.fillTableBlock(y, roomNameLabel, lines, lineYs, horizLineYPos, sic, siBlock);
        }
        lineYs.add(new Integer(y));
        sic.fillTotalBlock(siBlock);
        y = FactSheetServiceInfo.fillTableBlock(y, Babel.get("FS_SERV_TOTAL"), lines, lineYs, horizLineYPos, sic, siBlock);
        lineYs.add(new Integer(y));
        return FactSheetServiceInfo.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
    }

    private static int collectRoomTable(String roomName, ServiceInfoCollector sic, int y, int width, Vector target, ServiceInfoCollector.SIBlock siBlock) {
        Vector lines = new Vector();
        Vector<Integer> horizLineYPos = new Vector<Integer>();
        Vector<Integer> lineYs = new Vector<Integer>();
        horizLineYPos.add(new Integer(y));
        lineYs.add(new Integer(y));
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        line.add(PrintElementFactSheet.getTextElement(0, y += 4, Babel.get("RACK"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("GROUP"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("QUOTA"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FILLED_CAGES"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("TOTAL_CAGES"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("WEDDINGS"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("MICE"), TABHEADER_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_SERV_PERCENT"), TABHEADER_FONT));
        y += TABHEADER_FONT.getSize() + 2;
        horizLineYPos.add(new Integer(y += 4));
        Vector rackIDS = sic.getRackIDs(roomName);
        if (rackIDS != null) {
            Iterator iterator = rackIDS.iterator();
            while (iterator.hasNext()) {
                Long rackID = (Long)iterator.next();
                String rackName = sic.fillRackBlock(siBlock, rackID);
                if (rackName == null) continue;
                y = FactSheetServiceInfo.fillTableBlock(y, rackName, lines, lineYs, horizLineYPos, sic, siBlock);
            }
        }
        lineYs.add(new Integer(y));
        sic.fillRoomBlock(siBlock, roomName);
        y = FactSheetServiceInfo.fillTableBlock(y, Babel.get("FS_SERV_TOTAL"), lines, lineYs, horizLineYPos, sic, siBlock);
        lineYs.add(new Integer(y));
        return FactSheetServiceInfo.createTable(lines, horizLineYPos, target, width, lineYs, null, null);
    }

    private static int fillTableBlock(int y, String name, Vector lines, Vector lineYs, Vector horizLineYPos, ServiceInfoCollector sic, ServiceInfoCollector.SIBlock siBlock) {
        int sumCages = 0;
        int sumMatings = 0;
        int sumMice = 0;
        int sumFilledCages = 0;
        Vector<PrintElementFactSheet> line = new Vector<PrintElementFactSheet>();
        lines.add(line);
        lineYs.add(new Integer(y));
        line.add(PrintElementFactSheet.getTextElement(0, y, name, FETT_FONT));
        boolean zeileAdded = false;
        int i = 0;
        while (i < sic.ivGroupNames.size() - 1) {
            if (siBlock.ivCages[i] != 0) {
                boolean freeSpace = false;
                String groupName = (String)sic.ivGroupNames.elementAt(i);
                if (zeileAdded) {
                    line = new Vector();
                    lines.add(line);
                    lineYs.add(new Integer(y));
                    line.add(PrintElementFactSheet.getTextElement(0, y, "", STANDARD_FONT));
                }
                line.add(PrintElementFactSheet.getFilledTextBox(0, y, 0, STANDARD_FONT.getSize() + 2, groupName, STANDARD_FONT, siBlock.ivColors[i], Color.black, null));
                if (siBlock.ivQuota[i] <= 0) {
                    line.add(PrintElementFactSheet.getFilledTextBox(0, y, 0, STANDARD_FONT.getSize() + 2, " ", STANDARD_FONT, siBlock.ivColors[i], Color.black, null));
                } else {
                    int proz = siBlock.ivFilledCages[i] * 100 / siBlock.ivQuota[i];
                    Color col = MixColorMode.getColor(proz, QUOTA_VALUES, QUOTA_COLORS);
                    line.add(PrintElementFactSheet.getFilledTextBox(0, y, 0, STANDARD_FONT.getSize() + 2, Integer.toString(siBlock.ivQuota[i]), STANDARD_FONT, col, Color.black, null, 4));
                }
                line.add(PrintElementFactSheet.getFilledTextBox(0, y, 0, STANDARD_FONT.getSize() + 2, INTEGER_FORMAT.format(siBlock.ivFilledCages[i]), STANDARD_FONT, siBlock.ivColors[i], Color.black, null, 4));
                if (freeSpace) {
                    line.add(PrintElementFactSheet.getFilledTextBox(0, y, 0, STANDARD_FONT.getSize() + 2, " ", STANDARD_FONT, siBlock.ivColors[i], Color.black, null, 4));
                } else {
                    line.add(PrintElementFactSheet.getFilledTextBox(0, y, 0, STANDARD_FONT.getSize() + 2, INTEGER_FORMAT.format(siBlock.ivCages[i]), STANDARD_FONT, siBlock.ivColors[i], Color.black, null, 4));
                }
                if (freeSpace) {
                    line.add(PrintElementFactSheet.getFilledTextBox(0, y, 0, STANDARD_FONT.getSize() + 2, " ", STANDARD_FONT, siBlock.ivColors[i], Color.black, null, 4));
                } else {
                    line.add(PrintElementFactSheet.getFilledTextBox(0, y, 0, STANDARD_FONT.getSize() + 2, INTEGER_FORMAT.format(siBlock.ivMatings[i]), STANDARD_FONT, siBlock.ivColors[i], Color.black, null, 4));
                }
                if (siBlock.ivMice[i] != 0) {
                    line.add(PrintElementFactSheet.getFilledTextBox(0, y, 0, STANDARD_FONT.getSize() + 2, INTEGER_FORMAT.format(siBlock.ivMice[i]), STANDARD_FONT, siBlock.ivColors[i], Color.black, null, 4));
                } else {
                    line.add(PrintElementFactSheet.getFilledTextBox(0, y, 0, STANDARD_FONT.getSize() + 2, " ", STANDARD_FONT, siBlock.ivColors[i], Color.black, null, 4));
                }
                line.add(PrintElementFactSheet.getFilledTextBox(0, y, 0, STANDARD_FONT.getSize() + 2, PERC_2NKS_FORMAT.format(siBlock.ivPercents[i]), STANDARD_FONT, siBlock.ivColors[i], Color.black, null, 4));
                y += STANDARD_FONT.getSize() + 2;
                sumCages += siBlock.ivCages[i];
                sumMatings += siBlock.ivMatings[i];
                sumMice += siBlock.ivMice[i];
                sumFilledCages += siBlock.ivFilledCages[i];
                zeileAdded = true;
            }
            ++i;
        }
        y += 4;
        int freieCages = siBlock.ivCages[sic.ivGroupNames.size() - 1];
        int totalCages = sumCages + freieCages;
        if (zeileAdded) {
            line = new Vector();
            lines.add(line);
            lineYs.add(new Integer(y));
            line.add(PrintElementFactSheet.getTextElement(0, y, "", STANDARD_FONT));
        }
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_SERV_USED_SPACE"), STANDARD_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", STANDARD_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", STANDARD_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, INTEGER_FORMAT.format(sumCages), STANDARD_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, INTEGER_FORMAT.format(sumMatings), STANDARD_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, INTEGER_FORMAT.format(sumMice), STANDARD_FONT, 4));
        double proz = (double)sumCages / (double)totalCages;
        line.add(PrintElementFactSheet.getTextElement(0, y, PERC_2NKS_FORMAT.format(proz), STANDARD_FONT, 4));
        line = new Vector();
        lines.add(line);
        lineYs.add(new Integer(y += STANDARD_FONT.getSize() + 2));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", STANDARD_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_SERV_FREE_SPACE"), STANDARD_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", STANDARD_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", STANDARD_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, INTEGER_FORMAT.format(freieCages), STANDARD_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", STANDARD_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", STANDARD_FONT, 4));
        proz = (double)freieCages / (double)totalCages;
        line.add(PrintElementFactSheet.getTextElement(0, y, PERC_2NKS_FORMAT.format(proz), STANDARD_FONT, 4));
        y += STANDARD_FONT.getSize() + 2;
        sumCages += freieCages;
        line = new Vector();
        lines.add(line);
        lineYs.add(new Integer(y += 2));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", STANDARD_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, Babel.get("FS_SERV_TOTAL"), FETT_FONT));
        line.add(PrintElementFactSheet.getTextElement(0, y, "", STANDARD_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, INTEGER_FORMAT.format(sumFilledCages), FETT_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, INTEGER_FORMAT.format(sumCages), FETT_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, INTEGER_FORMAT.format(sumMatings), FETT_FONT, 4));
        line.add(PrintElementFactSheet.getTextElement(0, y, INTEGER_FORMAT.format(sumMice), FETT_FONT, 4));
        y += FETT_FONT.getSize() + 2;
        horizLineYPos.add(new Integer(y += 4));
        return y;
    }
}

