/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import java.util.Iterator;
import java.util.Vector;
import mausoleum.mouse.Mouse;
import mausoleum.visit.Visit;

public class PlugReportObject
implements Comparable {
    public Mouse ivMouse = null;
    public int ivInDate = Integer.MIN_VALUE;
    public int ivPlugDate = Integer.MIN_VALUE;
    public int ivOutDate = Integer.MIN_VALUE;

    public static void addObjects(Mouse mouse, Vector relevantVisitsOfThisMouse, Vector target, long nullVal) {
        int[] plugDates = (int[])mouse.get("MOS_ALLPLUGDATES");
        Iterator iter = relevantVisitsOfThisMouse.iterator();
        while (iter.hasNext()) {
            Visit visit = (Visit)iter.next();
            boolean hadPlugDate = false;
            if (plugDates != null) {
                int i = 0;
                while (i < plugDates.length) {
                    if (visit.isEnclosed(plugDates[i], 0, 2)) {
                        target.add(new PlugReportObject(mouse, visit, plugDates[i], nullVal));
                        hadPlugDate = true;
                    }
                    ++i;
                }
            }
            if (hadPlugDate) continue;
            target.add(new PlugReportObject(mouse, visit, Integer.MIN_VALUE, nullVal));
        }
    }

    private PlugReportObject(Mouse mouse, Visit visit, int plugDate, long nullVal) {
        this.ivMouse = mouse;
        this.ivPlugDate = plugDate;
        long start = visit.getStart(nullVal);
        this.ivInDate = start == nullVal ? Integer.MIN_VALUE : (int)(start / 86400000L);
        long end = visit.getEnd(nullVal);
        this.ivOutDate = end == nullVal ? Integer.MIN_VALUE : (int)(end / 86400000L);
    }

    public int compareTo(Object o) {
        if (o instanceof PlugReportObject) {
            PlugReportObject pro = (PlugReportObject)o;
            int d1 = this.ivInDate;
            int d2 = pro.ivInDate;
            if (d1 == Integer.MIN_VALUE) {
                d1 = Integer.MIN_VALUE;
            }
            if (d2 == Integer.MIN_VALUE) {
                d2 = Integer.MIN_VALUE;
            }
            if (d1 < d2) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
        }
        return 0;
    }
}

