/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.NULLObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import mausoleum.cage.Cage;
import mausoleum.factsheets.TextWrapComponentNeu;
import mausoleum.factsheets.TextWrapElementNeu;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MusterColor;
import mausoleum.gui.PralineColor;
import mausoleum.helper.FontManager;
import mausoleum.helper.Zeile;
import mausoleum.printing.PrintElement;
import mausoleum.printing.labelprinters.LabelPrinter;

public class PrintElementFactSheet {
    public static final int TYP_UNDEF = 0;
    public static final int TYP_LINE = 1;
    public static final int TYP_BOX = 2;
    public static final int TYP_TEXT = 3;
    public static final int TYP_IMAGE = 4;
    public static final int TYP_VECTOR = 5;
    public static final int TYP_FILLEDBOX = 6;
    public static final int TYP_FILLEDTEXTBOX = 7;
    public static final int TYP_POLYGON = 8;
    public static final int TYP_ENCAPSULATED_VECTOR = 9;
    public static final int TYP_RECORD_BREAK = 10;
    private static final Color LINK_COLOR = new Color(0, 0, 160);
    public static final String HTML_LINK_COLOR_STRING = ColorManager.getColorString(LINK_COLOR);
    private static final int INTER_LINE_MARGIN = 3;
    public int ivX = -1;
    public int ivY = -1;
    public int ivX2 = -1;
    public int ivY2 = -1;
    public int ivWidth = -1;
    public int ivHeight = -1;
    public int ivMargin = 0;
    public float ivLineWidth = 0.1f;
    public int ivOrientation = 2;
    public Color ivBackground = null;
    public Color ivForeground = Color.black;
    public Color ivBorderColor = null;
    public Font ivFont;
    public String ivText;
    public String ivAltText = null;
    public Image ivImage;
    public Vector ivVector = null;
    public Polygon ivPolygon = null;
    public int ivType = 0;
    public boolean ivFramed = false;
    public String ivLink = null;
    public int ivReferenzX = 0;
    public double ivFaktorForEncapsulated = 1.0;
    public int ivColspan = 0;
    public boolean ivSplittable = false;
    public String ivLinkDescr = null;

    public static PrintElementFactSheet getVectorElement(Vector v) {
        return new PrintElementFactSheet(v);
    }

    public static PrintElementFactSheet getTextElement(int x, int y, String s, Font f) {
        return PrintElementFactSheet.getTextElement(x, y, s, f, null, 2);
    }

    public static PrintElementFactSheet getTextElementMaxWidthSingleLine(int x, int y, String s, Font f, int maxWidth) {
        Zeile z = new Zeile(s, '\n');
        String sls = z.getString(0, "").trim();
        PrintElementFactSheet pefs = PrintElementFactSheet.getTextElement(x, y, sls, f, null, 2);
        pefs.ivAltText = s;
        if (pefs.ivWidth > maxWidth) {
            FontMetrics fm = FontManager.getFontMetrics(pefs.ivFont);
            int tmw = maxWidth - 2 * pefs.ivMargin - fm.stringWidth("...");
            String testString = pefs.ivText;
            int aktWidth = pefs.ivWidth - 2 * pefs.ivMargin;
            while (aktWidth > tmw && testString.length() >= 1) {
                testString = testString.substring(0, testString.length() - 1);
                aktWidth = fm.stringWidth(testString);
            }
            if (testString.length() != 0) {
                pefs.ivText = String.valueOf(testString) + "...";
                pefs.calcTextBoxDimension();
            } else {
                pefs.ivText = ".";
                pefs.calcTextBoxDimension();
            }
        }
        return pefs;
    }

    public static PrintElementFactSheet getTextElement(int x, int y, String s, Font f, int orientation) {
        return PrintElementFactSheet.getTextElement(x, y, s, f, null, orientation);
    }

    public static PrintElementFactSheet getTextElement(int x, int y, String s, Font f, String link) {
        PrintElementFactSheet pen = PrintElementFactSheet.getTextElement(x, y, s, f, null, 2);
        pen.ivLink = link;
        return pen;
    }

    public static PrintElementFactSheet getTextElement(int x, int y, String s, Font f, String link, Color background) {
        if (background != null && s == null || s.length() == 0) {
            s = " ";
        }
        PrintElementFactSheet pen = PrintElementFactSheet.getTextElement(x, y, s, f, null, 2);
        pen.ivLink = link;
        pen.ivBackground = background;
        return pen;
    }

    public static PrintElementFactSheet getTextElement(int x, int y, String s, Font f, int orientation, String link) {
        PrintElementFactSheet pen = PrintElementFactSheet.getTextElement(x, y, s, f, null, orientation);
        pen.ivLink = link;
        return pen;
    }

    public static PrintElementFactSheet getTextElement(int x, int y, String s, Font f, int orientation, String link, int margin) {
        PrintElementFactSheet pen = PrintElementFactSheet.getTextElement(x, y, s, f, null, orientation, margin);
        pen.ivLink = link;
        return pen;
    }

    public static PrintElementFactSheet getTextElement(int x, int y, String s, Font f, Color background, int orientation) {
        return PrintElementFactSheet.getTextElement(x, y, s, f, background, orientation, 0);
    }

    public static PrintElementFactSheet getTextElement(int x, int y, String s, Font f, Color background, int orientation, int margin) {
        PrintElementFactSheet tpe = new PrintElementFactSheet(s, x, y);
        tpe.ivFont = f;
        tpe.ivType = 3;
        tpe.ivBackground = background;
        tpe.ivOrientation = orientation;
        tpe.ivMargin = margin;
        tpe.calcTextBoxDimension();
        return tpe;
    }

    public static PrintElementFactSheet getBoxElement(int x, int y, int width, int height) {
        return PrintElementFactSheet.getBoxElement(x, y, width, height, 0.1f, Color.black);
    }

    public static PrintElementFactSheet getBoxElement(int x, int y, int width, int height, float linewidth) {
        return PrintElementFactSheet.getBoxElement(x, y, width, height, linewidth, Color.black);
    }

    public static PrintElementFactSheet getBoxElement(int x, int y, int width, int height, float linewidth, Color lineColor) {
        PrintElementFactSheet tpe = new PrintElementFactSheet(x, y, width, height);
        tpe.ivType = 2;
        tpe.ivLineWidth = linewidth;
        tpe.ivBorderColor = lineColor;
        return tpe;
    }

    public static PrintElementFactSheet getFilledBoxElement(int x, int y, int width, int height, Color background) {
        return PrintElementFactSheet.getFilledBoxElement(x, y, width, height, background, null);
    }

    public static PrintElementFactSheet getFilledBoxElement(int x, int y, int width, int height, Color background, Color borderColor) {
        PrintElementFactSheet tpe = new PrintElementFactSheet(x, y, width, height);
        tpe.ivType = 6;
        tpe.ivBackground = background;
        tpe.ivBorderColor = borderColor;
        return tpe;
    }

    public static PrintElementFactSheet getFilledTextBox(int x, int y, int width, int height, String s, Font f, Color background) {
        return PrintElementFactSheet.getFilledTextBox(x, y, width, height, s, f, background, Color.black, Color.black);
    }

    public static PrintElementFactSheet getFilledTextBox(int x, int y, int width, int height, String s, Font f, Color background, Color foreground, Color borderColor) {
        PrintElementFactSheet tpe = new PrintElementFactSheet(x, y, width, height);
        tpe.ivText = s;
        tpe.ivFont = f;
        tpe.ivType = 7;
        tpe.ivBackground = background;
        tpe.ivForeground = foreground;
        tpe.ivBorderColor = borderColor;
        return tpe;
    }

    public static PrintElementFactSheet getFilledTextBox(int x, int y, int width, int height, String s, Font f, Color background, Color foreground, Color borderColor, int orientation) {
        PrintElementFactSheet tpe = new PrintElementFactSheet(x, y, width, height);
        tpe.ivText = s;
        tpe.ivFont = f;
        tpe.ivType = 7;
        tpe.ivBackground = background;
        tpe.ivForeground = foreground;
        tpe.ivBorderColor = borderColor;
        tpe.ivOrientation = orientation;
        return tpe;
    }

    public static PrintElementFactSheet getLineElement(int x1, int y1, int x2, int y2) {
        return PrintElementFactSheet.getLineElement(x1, y1, x2, y2, Color.black, 0.1f);
    }

    public static PrintElementFactSheet getLineElement(int x1, int y1, int x2, int y2, Color lineColor) {
        return PrintElementFactSheet.getLineElement(x1, y1, x2, y2, lineColor, 0.1f);
    }

    public static PrintElementFactSheet getLineElement(int x1, int y1, int x2, int y2, Color lineColor, float lineWidth) {
        int x = x1;
        int width = x2 - x1;
        if (width < 0) {
            width = -width;
            x = x2;
        }
        int y = y1;
        int height = y2 - y1;
        if (height < 0) {
            height = -height;
            y = y2;
        }
        PrintElementFactSheet tpe = new PrintElementFactSheet(x, y, width, height);
        tpe.ivX = x1;
        tpe.ivX2 = x2;
        tpe.ivY = y1;
        tpe.ivY2 = y2;
        tpe.ivType = 1;
        tpe.ivBorderColor = lineColor;
        tpe.ivLineWidth = lineWidth;
        return tpe;
    }

    public static PrintElementFactSheet getPolygonElement(Polygon poly, Color color) {
        PrintElementFactSheet tpe = new PrintElementFactSheet(0, 0, 0, 0);
        tpe.ivPolygon = poly;
        tpe.ivType = 8;
        tpe.ivBorderColor = color;
        return tpe;
    }

    public static PrintElementFactSheet getImageElement(int x, int y, ImageIcon icon, double scale) {
        PrintElementFactSheet tpe = new PrintElementFactSheet(x, y, 0, 0);
        tpe.ivX = x;
        tpe.ivY = y;
        tpe.ivType = 4;
        tpe.ivImage = icon.getImage();
        tpe.ivWidth = (int)((double)icon.getIconWidth() * scale);
        tpe.ivHeight = (int)((double)icon.getIconHeight() * scale);
        if (scale != 1.0) {
            tpe.ivImage = tpe.ivImage.getScaledInstance(tpe.ivWidth, tpe.ivHeight, 2);
        }
        return tpe;
    }

    public static PrintElementFactSheet getImageElement(int x, int y, Image image) {
        PrintElementFactSheet tpe = new PrintElementFactSheet(x, y, 0, 0);
        tpe.ivX = x;
        tpe.ivY = y;
        tpe.ivType = 4;
        tpe.ivImage = image;
        if (image != null) {
            tpe.ivWidth = image.getWidth(null);
            while (tpe.ivWidth <= 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                tpe.ivWidth = image.getWidth(null);
            }
            tpe.ivHeight = image.getHeight(null);
        }
        return tpe;
    }

    public static PrintElementFactSheet getEncapsulatedElement(int x, int y, int width, int height, Vector subElements, double factor, boolean splittable, boolean translate) {
        PrintElementFactSheet tpe = new PrintElementFactSheet(x, y, width, height);
        tpe.ivType = 9;
        tpe.ivFaktorForEncapsulated = factor;
        tpe.ivVector = subElements;
        tpe.ivSplittable = splittable;
        if (translate) {
            PrintElementFactSheet pe;
            int miny = Integer.MAX_VALUE;
            int maxy = Integer.MIN_VALUE;
            Iterator iter = subElements.iterator();
            while (iter.hasNext()) {
                pe = (PrintElementFactSheet)iter.next();
                if (pe.ivY < miny) {
                    miny = pe.ivY;
                }
                if (pe.ivY + pe.ivHeight <= maxy) continue;
                maxy = pe.ivY + pe.ivHeight;
            }
            iter = subElements.iterator();
            while (iter.hasNext()) {
                pe = (PrintElementFactSheet)iter.next();
                pe.translateY(-miny);
            }
            tpe.ivHeight = maxy - miny;
        }
        return tpe;
    }

    public static String getTranportString(Vector elements) {
        StringBuffer msb = new StringBuffer();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            PrintElementFactSheet element = (PrintElementFactSheet)iter.next();
            msb.append(element.getTransportString());
            if (!iter.hasNext()) continue;
            msb.append("\u00a7");
        }
        return msb.toString();
    }

    public static Vector getElements(String transportString, int[] maxY) {
        Vector v = StringHelper.splitStringByAny(transportString, "\u00a7");
        int anz = v.size();
        int max = 0;
        int i = 0;
        while (i < anz) {
            PrintElementFactSheet element = new PrintElementFactSheet((String)v.elementAt(i));
            int y = element.getMaxY();
            if (y > max) {
                max = y;
            }
            v.setElementAt(element, i);
            ++i;
        }
        maxY[0] = max;
        return v;
    }

    public static TreeMap groupByY(Vector elements) {
        TreeMap<Integer, Vector<PrintElementFactSheet>> linesByY = new TreeMap<Integer, Vector<PrintElementFactSheet>>();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            PrintElementFactSheet pe = (PrintElementFactSheet)iter.next();
            Integer key = new Integer(pe.ivY);
            Vector<PrintElementFactSheet> line = (Vector<PrintElementFactSheet>)linesByY.get(key);
            if (line == null) {
                line = new Vector<PrintElementFactSheet>();
                linesByY.put(key, line);
            }
            line.add(pe);
        }
        return linesByY;
    }

    public static Vector createPageContigsAndEliminateByRecordBreaks(Vector source, boolean onlyOneRecordPerPage) {
        Vector res = new Vector();
        Vector<PrintElementFactSheet> aktV = new Vector<PrintElementFactSheet>();
        res.add(aktV);
        Iterator iter = source.iterator();
        while (iter.hasNext()) {
            PrintElementFactSheet pefs = (PrintElementFactSheet)iter.next();
            if (pefs.ivType == 10) {
                if (!onlyOneRecordPerPage) continue;
                aktV = new Vector();
                res.add(aktV);
                continue;
            }
            aktV.add(pefs);
        }
        return res;
    }

    public static int getHeightOfLine(Vector line) {
        int maxh = 0;
        Iterator iterator = line.iterator();
        while (iterator.hasNext()) {
            PrintElementFactSheet pe = (PrintElementFactSheet)iterator.next();
            if (pe.ivHeight <= maxh) continue;
            maxh = pe.ivHeight;
        }
        return maxh;
    }

    private PrintElementFactSheet(String transportString) {
        Zeile z = new Zeile(Base64Manager.getDecodedString(transportString), '#');
        int col = 0;
        this.ivType = z.getInt(col++, 0);
        this.ivX = z.getInt(col++, 0);
        this.ivY = z.getInt(col++, 0);
        this.ivX2 = z.getInt(col++, 0);
        this.ivY2 = z.getInt(col++, 0);
        this.ivWidth = z.getInt(col++, 0);
        this.ivHeight = z.getInt(col++, 0);
        this.ivMargin = z.getInt(col++, 0);
        this.ivColspan = z.getInt(col++, 0);
        this.ivReferenzX = z.getInt(col++, 0);
        this.ivOrientation = z.getInt(col++, 0);
        this.ivLineWidth = (float)z.getDouble(col++, 0.0);
        this.ivFaktorForEncapsulated = z.getDouble(col++, 0.0);
        this.ivFramed = z.getString(col++, "0").equals("1");
        this.ivText = (String)IDObjectXMLHandler.getObject(z.getString(col++, null));
        this.ivLink = (String)IDObjectXMLHandler.getObject(z.getString(col++, null));
        this.ivBackground = (Color)IDObjectXMLHandler.getObject(z.getString(col++, null));
        this.ivForeground = (Color)IDObjectXMLHandler.getObject(z.getString(col++, null));
        this.ivBorderColor = (Color)IDObjectXMLHandler.getObject(z.getString(col++, null));
        this.ivFont = (Font)IDObjectXMLHandler.getObject(z.getString(col++, null));
        this.ivImage = (Image)IDObjectXMLHandler.getObject(z.getString(col++, null));
        this.ivPolygon = (Polygon)IDObjectXMLHandler.getObject(z.getString(col++, null));
        String vectorVal = z.getStringNONEmpty(col++, null);
        if (vectorVal != null) {
            this.ivVector = new Vector();
            Zeile iz = new Zeile(vectorVal, '@');
            int zc = 0;
            while (zc < iz.size()) {
                this.ivVector.add(new PrintElementFactSheet(iz.getString(zc, "")));
                ++zc;
            }
        }
        this.ivSplittable = z.getString(col++, "0").equals("1");
    }

    private PrintElementFactSheet(Vector v) {
        Rectangle unionRect = null;
        Iterator iterator = v.iterator();
        while (iterator.hasNext()) {
            PrintElementFactSheet pen = (PrintElementFactSheet)iterator.next();
            unionRect = unionRect == null ? pen.getBounds() : unionRect.union(pen.getBounds());
        }
        if (unionRect != null) {
            this.ivVector = v;
            this.ivX = unionRect.x;
            this.ivY = unionRect.y;
            this.ivWidth = unionRect.width;
            this.ivHeight = unionRect.height;
            this.ivType = 5;
        }
    }

    private PrintElementFactSheet(int x, int y, int width, int height) {
        this.ivX = x;
        this.ivY = y;
        this.ivWidth = width;
        this.ivHeight = height;
    }

    public PrintElementFactSheet(String s, int x, int y) {
        this.ivX = x;
        this.ivY = y;
        this.ivText = s;
        this.ivReferenzX = x;
    }

    public PrintElementFactSheet(int x, int y, int typ) {
        this.ivX = x;
        this.ivY = y;
        this.ivReferenzX = x;
        this.ivType = typ;
    }

    public boolean isWithin(int oben, int unten) {
        if (this.ivY > unten) {
            return false;
        }
        if (this.ivType == 1 && this.ivY2 < oben) {
            return false;
        }
        return this.ivY + this.ivHeight >= oben;
    }

    public boolean isWithin(int links, int rechts, int oben, int unten) {
        if (this.ivY > unten) {
            return false;
        }
        if (this.ivType == 1 ? this.ivY2 < oben : this.ivY + this.ivHeight < oben) {
            return false;
        }
        if (this.ivX > rechts) {
            return false;
        }
        return !(this.ivType == 1 ? this.ivX2 < links : this.ivX + this.ivWidth < links);
    }

    public int getTextHeight() {
        if (this.ivType == 5) {
            return this.ivHeight;
        }
        if (this.ivType == 4) {
            return this.ivHeight + 2 * this.ivMargin;
        }
        if ((this.ivType == 3 || this.ivType == 7) && this.ivFont != null) {
            FontMetrics fm = FontManager.getFontMetrics(this.ivFont);
            int ascent = fm.getAscent();
            int descent = fm.getDescent();
            int rfh = ascent + descent;
            if (this.ivVector != null && !this.ivVector.isEmpty()) {
                int anzLines = this.ivVector.size();
                if (anzLines == 1) {
                    return rfh + 2 * this.ivMargin;
                }
                return anzLines * rfh + (anzLines - 1) * 3 + 2 * this.ivMargin;
            }
            if (this.ivText != null) {
                return rfh + 2 * this.ivMargin;
            }
        }
        return 0;
    }

    public int getTextWidth() {
        if (this.ivType == 5) {
            return this.ivWidth;
        }
        if (this.ivType == 4) {
            return this.ivWidth + 2 * this.ivMargin;
        }
        if ((this.ivType == 3 || this.ivType == 7) && this.ivFont != null) {
            FontMetrics fm = FontManager.getFontMetrics(this.ivFont);
            if (this.ivVector != null && !this.ivVector.isEmpty()) {
                int maxw = 0;
                Iterator iter = this.ivVector.iterator();
                while (iter.hasNext()) {
                    String s = (String)iter.next();
                    int sw = fm.stringWidth(s);
                    if (sw <= maxw) continue;
                    maxw = sw;
                }
                return maxw + 2 * this.ivMargin;
            }
            if (this.ivText != null) {
                return fm.stringWidth(this.ivText) + 2 * this.ivMargin;
            }
        }
        return 0;
    }

    public void addIntersecting(Rectangle test, HashMap target, Vector rectTarget) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (this.ivType != 3) break block5;
                        if (test != null && !test.intersects(new Rectangle(this.ivX, this.ivY, this.ivWidth, this.ivHeight))) break block6;
                        target.put(new Point(this.ivReferenzX, this.ivY), this);
                        rectTarget.add(this.getBounds());
                        break block6;
                    }
                    if (this.ivType != 7) break block7;
                    if (test != null && !test.intersects(new Rectangle(this.ivX, this.ivY, this.ivWidth, this.ivHeight))) break block6;
                    target.put(new Point(this.ivReferenzX, this.ivY), this);
                    rectTarget.add(this.getBounds());
                    break block6;
                }
                if (this.ivType != 5) break block8;
                if (this.ivVector == null || this.ivVector.isEmpty()) break block6;
                Iterator iter = this.ivVector.iterator();
                while (iter.hasNext()) {
                    PrintElementFactSheet pen = (PrintElementFactSheet)iter.next();
                    pen.addIntersecting(test, target, rectTarget);
                }
                break block6;
            }
            if (this.ivType == 9) {
                Vector scheintarget = new Vector();
                Rectangle ich = this.getBounds();
                if (this.ivVector != null && !this.ivVector.isEmpty() && (test == null || test.intersects(ich))) {
                    Rectangle ntest = null;
                    if (test != null) {
                        int ulx = this.getScaledInner(test.x, this.ivX, this.ivWidth);
                        int uly = this.getScaledInner(test.y, this.ivY, this.ivHeight);
                        int lrx = this.getScaledInner(test.x + test.width, this.ivX, this.ivWidth);
                        int lry = this.getScaledInner(test.y + test.height, this.ivY, this.ivHeight);
                        ntest = new Rectangle(ulx, uly, lrx - ulx, lry - uly);
                    }
                    Iterator iter = this.ivVector.iterator();
                    while (iter.hasNext()) {
                        Object ooo = iter.next();
                        if (!(ooo instanceof PrintElementFactSheet)) continue;
                        PrintElementFactSheet pen = (PrintElementFactSheet)ooo;
                        scheintarget.clear();
                        pen.addIntersecting(ntest, target, scheintarget);
                        if (scheintarget.isEmpty()) continue;
                        Rectangle r = (Rectangle)scheintarget.firstElement();
                        r.x = (int)((double)r.x * this.ivFaktorForEncapsulated) + this.ivX;
                        r.y = (int)((double)r.y * this.ivFaktorForEncapsulated) + this.ivY;
                        r.width = (int)((double)r.width * this.ivFaktorForEncapsulated);
                        r.height = (int)((double)r.height * this.ivFaktorForEncapsulated);
                        rectTarget.add(r);
                    }
                }
            }
        }
    }

    public void addIfItsMe(PrintElementFactSheet ich, HashMap target, Vector rectTarget) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (this.ivType != 3) break block4;
                        if (this != ich) break block5;
                        target.put(new Point(this.ivReferenzX, this.ivY), this);
                        rectTarget.add(this.getBounds());
                        break block5;
                    }
                    if (this.ivType != 7) break block6;
                    if (this != ich) break block5;
                    target.put(new Point(this.ivReferenzX, this.ivY), this);
                    rectTarget.add(this.getBounds());
                    break block5;
                }
                if (this.ivType != 5) break block7;
                if (this.ivVector == null || this.ivVector.isEmpty()) break block5;
                Iterator iter = this.ivVector.iterator();
                while (iter.hasNext()) {
                    PrintElementFactSheet pen = (PrintElementFactSheet)iter.next();
                    pen.addIfItsMe(ich, target, rectTarget);
                }
                break block5;
            }
            if (this.ivType == 9) {
                Vector scheintarget = new Vector();
                if (this.ivVector != null && !this.ivVector.isEmpty()) {
                    Iterator iter = this.ivVector.iterator();
                    while (iter.hasNext()) {
                        Object ooo = iter.next();
                        if (!(ooo instanceof PrintElementFactSheet)) continue;
                        PrintElementFactSheet pen = (PrintElementFactSheet)ooo;
                        scheintarget.clear();
                        pen.addIfItsMe(ich, target, scheintarget);
                        if (scheintarget.isEmpty()) continue;
                        Rectangle r = (Rectangle)scheintarget.firstElement();
                        r.x = (int)((double)r.x * this.ivFaktorForEncapsulated) + this.ivX;
                        r.y = (int)((double)r.y * this.ivFaktorForEncapsulated) + this.ivY;
                        r.width = (int)((double)r.width * this.ivFaktorForEncapsulated);
                        r.height = (int)((double)r.height * this.ivFaktorForEncapsulated);
                        rectTarget.add(r);
                    }
                }
            }
        }
    }

    public Object getElementAtScaledPoint(Point p, int printElementTyp) {
        if (this.ivType == 5) {
            if (this.ivY <= p.y && this.ivY + this.ivHeight >= p.y && this.ivX <= p.x && this.ivX + this.ivWidth >= p.x) {
                Iterator iter = this.ivVector.iterator();
                while (iter.hasNext()) {
                    PrintElementFactSheet pfs = (PrintElementFactSheet)iter.next();
                    Object ooo = pfs.getElementAtScaledPoint(p, printElementTyp);
                    if (ooo == null) continue;
                    return ooo;
                }
            }
        } else if (this.ivType == 9) {
            if (this.ivVector != null && !this.ivVector.isEmpty() && this.ivY <= p.y && this.ivY + this.ivHeight >= p.y && this.ivX <= p.x && this.ivX + this.ivWidth >= p.x) {
                Point np = new Point(this.getScaledInner(p.x, this.ivX, this.ivWidth), this.getScaledInner(p.y, this.ivY, this.ivHeight));
                Iterator iter = this.ivVector.iterator();
                while (iter.hasNext()) {
                    PrintElementFactSheet pen;
                    Object ooo2;
                    Object ooo = iter.next();
                    if (!(ooo instanceof PrintElementFactSheet) || (ooo2 = (pen = (PrintElementFactSheet)ooo).getElementAtScaledPoint(np, printElementTyp)) == null) continue;
                    return ooo2;
                }
            }
        } else if ((printElementTyp == -1 || this.ivType == printElementTyp) && this.ivY <= p.y && this.ivY + this.ivHeight >= p.y && this.ivX <= p.x && this.ivX + this.ivWidth >= p.x) {
            return this;
        }
        return null;
    }

    private int getScaledInner(int outer, int myStart, int myExt) {
        int res = outer - myStart;
        res = res < 0 ? 0 : (res > myExt ? (int)((double)myExt / this.ivFaktorForEncapsulated) + (res - myExt) : (int)((double)res / this.ivFaktorForEncapsulated));
        return res;
    }

    public void translateY(int dy) {
        this.ivY += dy;
        if (this.ivType == 1) {
            this.ivY2 += dy;
        }
        if (this.ivType == 5 && this.ivVector != null && !this.ivVector.isEmpty()) {
            Iterator iter = this.ivVector.iterator();
            while (iter.hasNext()) {
                PrintElementFactSheet pen = (PrintElementFactSheet)iter.next();
                pen.translateY(dy);
            }
        }
    }

    public Rectangle getBounds() {
        if (this.ivType == 1) {
            return new Rectangle(this.ivX, this.ivY, this.ivX2 - this.ivX, this.ivY2 - this.ivY);
        }
        return new Rectangle(this.ivX, this.ivY, this.ivWidth, this.ivHeight);
    }

    public int getMaxY() {
        if (this.ivType == 1) {
            return this.ivY2;
        }
        return this.ivY + this.ivHeight;
    }

    public void addIfContaining(String text, Vector target) {
        if (this.ivText != null && this.ivText.toLowerCase().contains(text)) {
            target.add(this);
        }
        if (this.ivVector != null) {
            Iterator iterator = this.ivVector.iterator();
            while (iterator.hasNext()) {
                PrintElementFactSheet pfe = (PrintElementFactSheet)iterator.next();
                pfe.addIfContaining(text, target);
            }
        }
    }

    public void print(Graphics g, boolean showLinks) {
        Graphics2D g2d;
        if (this.ivBackground != null) {
            Color mc;
            if (this.ivBackground instanceof MusterColor) {
                mc = (MusterColor)this.ivBackground;
                ((MusterColor)mc).fill(this.ivX, this.ivY, this.ivWidth, this.ivHeight, g);
            } else if (this.ivBackground instanceof PralineColor) {
                mc = (PralineColor)this.ivBackground;
                ((PralineColor)mc).fill(this.ivX, this.ivY, this.ivWidth, this.ivHeight, g);
            } else {
                g.setColor(this.ivBackground);
                g.fillRect(this.ivX, this.ivY, this.ivWidth, this.ivHeight);
            }
        }
        if (this.ivType == 4) {
            if (this.ivImage != null) {
                if (this.ivOrientation == 4) {
                    int fw = this.ivWidth - 2 * this.ivMargin;
                    int w = this.ivImage.getWidth(null);
                    g.drawImage(this.ivImage, this.ivX + this.ivMargin + (fw - w), this.ivY + this.ivMargin, null);
                } else if (this.ivOrientation == 0) {
                    int fw = this.ivWidth - 2 * this.ivMargin;
                    int w = this.ivImage.getWidth(null);
                    g.drawImage(this.ivImage, this.ivX + this.ivMargin + (fw - w) / 2, this.ivY + this.ivMargin, null);
                } else {
                    g.drawImage(this.ivImage, this.ivX + this.ivMargin, this.ivY + this.ivMargin, null);
                }
            }
        } else if (this.ivType == 3) {
            this.drawText(g, showLinks);
        } else if (this.ivType == 1) {
            if (g instanceof Graphics2D) {
                g2d = (Graphics2D)g;
                Stroke stroke = g2d.getStroke();
                g.setColor(this.ivBorderColor);
                g2d.setStroke(new BasicStroke(this.ivLineWidth));
                g2d.drawLine(this.ivX, this.ivY, this.ivX2, this.ivY2);
                g2d.setStroke(stroke);
            }
        } else if (this.ivType == 2) {
            if (g instanceof Graphics2D) {
                this.drawTheBox(g);
            }
        } else if (this.ivType == 6) {
            this.drawTheBox(g);
        } else if (this.ivType == 7) {
            this.drawTheBox(g);
            this.drawText(g, showLinks);
        } else if (this.ivType == 5) {
            if (this.ivVector != null) {
                int i = 0;
                while (i < this.ivVector.size()) {
                    PrintElementFactSheet pe = (PrintElementFactSheet)this.ivVector.elementAt(i);
                    pe.print(g, showLinks);
                    ++i;
                }
            }
        } else if (this.ivType == 8) {
            if (this.ivPolygon != null) {
                g.setColor(this.ivBorderColor);
                g.fillPolygon(this.ivPolygon);
            }
        } else if (this.ivType == 9 && g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.translate(this.ivX, this.ivY);
            if (this.ivFaktorForEncapsulated != 1.0) {
                g2d.scale(this.ivFaktorForEncapsulated, this.ivFaktorForEncapsulated);
            }
            if (this.ivVector != null && !this.ivVector.isEmpty()) {
                if (this.ivVector.size() == 2 && this.ivVector.firstElement() instanceof LabelPrinter) {
                    LabelPrinter slp = (LabelPrinter)this.ivVector.elementAt(0);
                    slp.simplePrint((Cage)this.ivVector.elementAt(1), (Graphics)g2d);
                } else {
                    Iterator iter = this.ivVector.iterator();
                    while (iter.hasNext()) {
                        Object ooo = iter.next();
                        if (ooo instanceof PrintElementFactSheet) {
                            PrintElementFactSheet pfs = (PrintElementFactSheet)ooo;
                            pfs.print(g2d, showLinks);
                            continue;
                        }
                        if (!(ooo instanceof PrintElement)) continue;
                        PrintElement pe = (PrintElement)ooo;
                        pe.print(g2d);
                    }
                }
            }
            if (this.ivFaktorForEncapsulated != 1.0) {
                g2d.scale(1.0 / this.ivFaktorForEncapsulated, 1.0 / this.ivFaktorForEncapsulated);
            }
            g2d.translate(-this.ivX, -this.ivY);
        }
        if (this.ivFramed) {
            if (this.ivBorderColor == null) {
                g.setColor(Color.black);
            } else {
                g.setColor(this.ivBorderColor);
            }
            g.drawRect(this.ivX, this.ivY, this.ivWidth, this.ivHeight);
        }
    }

    private void drawTheBox(Graphics g) {
        if (this.ivBorderColor != null) {
            Graphics2D g2d = (Graphics2D)g;
            Stroke stroke = g2d.getStroke();
            g.setColor(this.ivBorderColor);
            g2d.setStroke(new BasicStroke(this.ivLineWidth));
            g2d.drawRect(this.ivX, this.ivY, this.ivWidth, this.ivHeight);
            g2d.setStroke(stroke);
        }
    }

    private void drawText(Graphics g, boolean showLinks) {
        if (showLinks && this.ivLink != null && this.ivLink.length() != 0) {
            g.setColor(LINK_COLOR);
        } else {
            g.setColor(this.ivForeground);
        }
        g.setFont(this.ivFont);
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        int rfh = ascent + descent;
        if (this.ivVector != null && !this.ivVector.isEmpty()) {
            int anzlines = this.ivVector.size();
            int ypos = this.ivY + (this.ivHeight - anzlines * rfh - (anzlines - 1) * 3) / 2 + ascent;
            Iterator iter = this.ivVector.iterator();
            while (iter.hasNext()) {
                String s = (String)iter.next();
                int offset = 0;
                if (this.ivOrientation == 4) {
                    offset = this.ivWidth - 2 * this.ivMargin - fm.stringWidth(s);
                } else if (this.ivOrientation == 0) {
                    offset = (this.ivWidth - 2 * this.ivMargin - fm.stringWidth(s)) / 2;
                }
                if (offset < 0) {
                    offset = 0;
                }
                g.drawString(s, this.ivX + this.ivMargin + offset, ypos);
                ypos += rfh + 3;
            }
        } else if (this.ivText != null) {
            int ypos = this.ivY + (this.ivHeight - rfh) / 2 + ascent;
            int offset = 0;
            if (this.ivOrientation == 4) {
                offset = this.ivWidth - 2 * this.ivMargin - fm.stringWidth(this.ivText);
            } else if (this.ivOrientation == 0) {
                offset = (this.ivWidth - 2 * this.ivMargin - fm.stringWidth(this.ivText)) / 2;
            }
            if (offset < 0) {
                offset = 0;
            }
            g.drawString(this.ivText, this.ivX + this.ivMargin + offset, ypos);
        }
    }

    public void calcTextBoxDimension() {
        if (this.ivFont == null) {
            this.ivWidth = 0;
            this.ivHeight = 0;
        } else if (this.ivText == null) {
            this.ivWidth = 0;
            this.ivHeight = this.ivFont.getSize() + 2 * this.ivMargin;
        } else {
            FontMetrics fm = FontManager.getFontMetrics(this.ivFont);
            this.ivWidth = fm.stringWidth(this.ivText) + 2 * this.ivMargin;
            this.ivHeight = fm.getAscent() + fm.getDescent() + 2 * this.ivMargin;
        }
    }

    public void setMaxWidth(int maxWidth) {
        if ((this.ivType == 3 || this.ivType == 7) && this.ivFont != null && this.ivText != null) {
            if (this.ivVector == null) {
                this.ivVector = new Vector();
            }
            this.ivVector.clear();
            TextWrapComponentNeu twcn = new TextWrapComponentNeu(this.ivText, this.ivFont, maxWidth);
            Iterator iter = twcn.ivElements.iterator();
            while (iter.hasNext()) {
                TextWrapElementNeu twe = (TextWrapElementNeu)iter.next();
                this.ivVector.add(twe.ivText);
            }
        }
    }

    public Vector getSplittedElements(int maxYFirst, int maxY, int yOnPageOfTotal) {
        maxYFirst = (int)((double)maxYFirst / this.ivFaktorForEncapsulated);
        maxY = (int)((double)maxY / this.ivFaktorForEncapsulated);
        TreeMap linesByY = PrintElementFactSheet.groupByY(this.ivVector);
        int tMaxY = maxYFirst;
        int aktYOffset = -1;
        Vector<Object> res = new Vector<Object>();
        Vector aktCollection = new Vector();
        int yOnPage = 0;
        int sply = yOnPageOfTotal;
        Iterator iter = linesByY.keySet().iterator();
        while (iter.hasNext()) {
            int maxh;
            Integer lineYCoord = (Integer)iter.next();
            Vector line = (Vector)linesByY.get(lineYCoord);
            if (line == null || line.isEmpty()) continue;
            if (aktYOffset == -1) {
                aktYOffset = lineYCoord;
            }
            if ((yOnPage = lineYCoord - aktYOffset) + (maxh = PrintElementFactSheet.getHeightOfLine(line)) > tMaxY) {
                if (aktCollection.isEmpty()) {
                    if (res.isEmpty()) {
                        res.add(NULLObject.INSTANCE);
                    }
                } else {
                    res.addElement(PrintElementFactSheet.getEncapsulatedElement(this.ivX, sply, this.ivWidth, 0, aktCollection, this.ivFaktorForEncapsulated, false, true));
                }
                aktCollection = new Vector();
                aktYOffset = lineYCoord;
                tMaxY = maxY;
                sply = 0;
            }
            aktCollection.addAll(line);
        }
        if (!aktCollection.isEmpty()) {
            res.addElement(PrintElementFactSheet.getEncapsulatedElement(this.ivX, sply, this.ivWidth, 0, aktCollection, this.ivFaktorForEncapsulated, false, true));
        }
        return res;
    }

    public String getTransportString() {
        StringBuffer msb = new StringBuffer();
        msb.append(this.ivType).append("#");
        msb.append(this.ivX).append("#");
        msb.append(this.ivY).append("#");
        msb.append(this.ivX2).append("#");
        msb.append(this.ivY2).append("#");
        msb.append(this.ivWidth).append("#");
        msb.append(this.ivHeight).append("#");
        msb.append(this.ivMargin).append("#");
        msb.append(this.ivColspan).append("#");
        msb.append(this.ivReferenzX).append("#");
        msb.append(this.ivOrientation).append("#");
        msb.append(this.ivLineWidth).append("#");
        msb.append(this.ivFaktorForEncapsulated).append("#");
        msb.append(this.ivFramed ? "1" : "0").append("#");
        msb.append(IDObjectXMLHandler.getTransport(this.ivText, false, true)).append("#");
        msb.append("#");
        msb.append(IDObjectXMLHandler.getTransport(this.ivBackground, false, true)).append("#");
        msb.append(IDObjectXMLHandler.getTransport(this.ivForeground, false, true)).append("#");
        msb.append(IDObjectXMLHandler.getTransport(this.ivBorderColor, false, true)).append("#");
        msb.append(IDObjectXMLHandler.getTransport(this.ivFont, false, true)).append("#");
        msb.append(IDObjectXMLHandler.getTransport(this.ivImage, false, true)).append("#");
        msb.append(IDObjectXMLHandler.getTransport(this.ivPolygon, false, true)).append("#");
        if (this.ivVector != null && !this.ivVector.isEmpty()) {
            StringBuffer vsb = new StringBuffer();
            Iterator iter = this.ivVector.iterator();
            while (iter.hasNext()) {
                Object ooo = iter.next();
                if (ooo instanceof PrintElementFactSheet) {
                    PrintElementFactSheet pfs = (PrintElementFactSheet)ooo;
                    if (vsb.length() != 0) {
                        vsb.append("@");
                    }
                    vsb.append(pfs.getTransportString());
                    continue;
                }
                System.out.println("KOMISCH: " + ooo);
            }
            msb.append(vsb.toString());
        }
        msb.append("#");
        msb.append(this.ivSplittable ? "1" : "0").append("#");
        return Base64Manager.encodeBase64(msb.toString());
    }

    public String toString() {
        if (this.ivType == 3) {
            return "Text: " + this.ivText;
        }
        return super.toString();
    }
}

