/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets;

import de.hannse.netobjects.objectstore.ObjectStore;
import java.awt.Point;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.mouse.Mouse;
import mausoleum.visit.Visit;

public abstract class VisitReport {
    public static HashMap collectCages(Mouse mouse) {
        HashMap<Object, Cage> neededCages = new HashMap<Object, Cage>();
        if (mouse != null) {
            HashSet<Long> cageIdHash = new HashSet<Long>();
            Visit[] visArr = (Visit[])mouse.get("MOS_VISIT");
            if (visArr != null) {
                int vi = 0;
                while (vi < visArr.length) {
                    cageIdHash.add(new Long(visArr[vi].ivCageID));
                    ++vi;
                }
            }
            if (!cageIdHash.isEmpty()) {
                long[] wantedCages = new long[cageIdHash.size()];
                int pos = 0;
                Iterator iter = cageIdHash.iterator();
                while (iter.hasNext()) {
                    Long cageID = (Long)iter.next();
                    wantedCages[pos++] = cageID;
                }
                Vector receievedCages = ObjectStore.getObjects(2, wantedCages, mouse.getGroup());
                if (receievedCages != null) {
                    int i = 0;
                    while (i < receievedCages.size()) {
                        Cage c = (Cage)receievedCages.elementAt(i);
                        neededCages.put(c.get("IDO_ID"), c);
                        ++i;
                    }
                }
            }
        }
        return neededCages;
    }

    public static HashMap collectMice(HashMap cages, String group) {
        HashMap<Object, Mouse> mice = new HashMap<Object, Mouse>();
        if (cages != null && !cages.isEmpty()) {
            HashSet<Long> mouseIdHash = new HashSet<Long>();
            Iterator iter = cages.values().iterator();
            while (iter.hasNext()) {
                Cage c = (Cage)iter.next();
                Visit[] visarr = (Visit[])c.get("CAG_VISIT");
                int i = 0;
                while (i < visarr.length) {
                    mouseIdHash.add(new Long(visarr[i].ivMouseID));
                    ++i;
                }
            }
            if (!mouseIdHash.isEmpty()) {
                long[] wantedMice = new long[mouseIdHash.size()];
                int pos = 0;
                Iterator iter2 = mouseIdHash.iterator();
                while (iter2.hasNext()) {
                    Long mouseID = (Long)iter2.next();
                    wantedMice[pos++] = mouseID;
                }
                Vector receivedMice = ObjectStore.getObjects(1, wantedMice, group);
                if (receivedMice != null) {
                    int i = 0;
                    while (i < receivedMice.size()) {
                        Mouse m = (Mouse)receivedMice.elementAt(i);
                        mice.put(m.get("IDO_ID"), m);
                        ++i;
                    }
                }
            }
        }
        return mice;
    }

    public static Vector getCagePals(Cage cage, Mouse maus, Visit visit, HashMap allMice, HashMap meetingsByPartnerID) {
        Vector mausSammler = new Vector();
        if (cage != null) {
            long myMouseId = maus.getID();
            HashSet collectedMiceIds = new HashSet();
            Visit[] cageVisits = (Visit[])cage.get("CAG_VISIT");
            if (cageVisits != null) {
                long startMillis = visit.getStart(Long.MIN_VALUE);
                long endMillis = visit.getEnd(Long.MAX_VALUE);
                int i = 0;
                while (i < cageVisits.length) {
                    Point p;
                    if (cageVisits[i].ivMouseID != myMouseId && (p = VisitReport.getOverlapInDays(cageVisits[i], startMillis, endMillis)) != null) {
                        VisitReport.addVisit(cageVisits[i], mausSammler, myMouseId, collectedMiceIds, allMice);
                        if (meetingsByPartnerID != null) {
                            Long key = new Long(cageVisits[i].ivMouseID);
                            Point[] marr = (Point[])meetingsByPartnerID.get(key);
                            if (marr == null) {
                                meetingsByPartnerID.put(key, new Point[]{p});
                            } else {
                                Point[] parr = new Point[marr.length + 1];
                                int j = 0;
                                while (j < marr.length) {
                                    parr[j] = marr[j];
                                    ++j;
                                }
                                parr[parr.length - 1] = p;
                                meetingsByPartnerID.put(key, parr);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return mausSammler;
    }

    public static Point getOverlapInDays(Visit tVis, long startMillis, long endMillis) {
        long hintenM;
        long tSM = tVis.getStart(Long.MIN_VALUE);
        long tEM = tVis.getEnd(Long.MAX_VALUE);
        long vorneM = tSM > startMillis ? tSM : startMillis;
        long l = hintenM = tEM < endMillis ? tEM : endMillis;
        if (vorneM < hintenM) {
            int sd = vorneM == Long.MIN_VALUE ? Integer.MIN_VALUE : (int)(vorneM / 86400000L);
            int ed = hintenM == Long.MAX_VALUE ? Integer.MIN_VALUE : (int)(hintenM / 86400000L);
            return new Point(sd, ed);
        }
        return null;
    }

    private static void addVisit(Visit visit, Vector mouseVec, long myMouseID, HashSet collectedMiceIds, HashMap allMice) {
        Long key;
        if (visit.ivMouseID != myMouseID && !collectedMiceIds.contains(key = new Long(visit.ivMouseID))) {
            collectedMiceIds.add(key);
            Mouse m = (Mouse)allMice.get(key);
            if (m != null) {
                mouseVec.addElement(m);
            }
        }
    }
}

