/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets.groupreport;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Log;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.factsheets.IDObjectMerker;
import mausoleum.factsheets.groupreport.GroupMetaLine;
import mausoleum.factsheets.groupreport.GroupReportLine;
import mausoleum.factsheets.groupreport.GroupReportLineOL;
import mausoleum.factsheets.groupreport.GroupStatistics;
import mausoleum.helper.Zeile;
import mausoleum.license.License;
import mausoleum.line.Line;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.rack.Rack;
import mausoleum.rack.RackPos;
import mausoleum.room.Room;
import mausoleum.strain.Strain;
import mausoleum.util.InstallationType;

public class GroupInfoCollector
extends HashMap {
    private static final long serialVersionUID = 1486835135L;
    private static final String VECTOR_SIGN = "V@";
    private static final String STRING_SIGN = "S@";
    private static final String PERDIEM_SIGN = "**PERDIEM**";
    private static final String NULL_STRING = "";

    public static GroupInfoCollector collectInfosForAdHocGroupReportClientSide(String group) {
        if (ProcessDefinition.isClient() && MausoleumClient.isRegularOrTGService()) {
            return GroupInfoCollector.collectInfos(group, null, true, true);
        }
        return null;
    }

    public static GroupInfoCollector collectInfosForGroupStatisticsHeadOfService(String group) {
        if (ProcessDefinition.isServer()) {
            return GroupInfoCollector.collectInfos(group, GroupStatistics.SELECTION, false, true);
        }
        return null;
    }

    public static GroupInfoCollector collectInfosForStatisticsFileClientSide(String group, HashSet selection) {
        if (ProcessDefinition.isClient() && MausoleumClient.isRegularOrTGService()) {
            return GroupInfoCollector.collectInfos(group, selection, false, false);
        }
        return null;
    }

    public static GroupInfoCollector collectInfosForStatisticsFileServerSide(String group, HashSet selection) {
        if (ProcessDefinition.isServer()) {
            return GroupInfoCollector.collectInfos(group, selection, false, false);
        }
        return null;
    }

    private static GroupMetaLine getProperLine(boolean mitLink) {
        if (mitLink) {
            return new GroupReportLine();
        }
        return new GroupReportLineOL();
    }

    private static GroupInfoCollector collectInfos(String group, HashSet selection, boolean mitLinks, boolean encodeTitel) {
        Iterator iter;
        GroupInfoCollector erg = new GroupInfoCollector();
        erg.put("GROUP", group);
        GroupMetaLine totalLine = GroupInfoCollector.getProperLine(mitLinks);
        GroupMetaLine mitETLine = GroupInfoCollector.getProperLine(mitLinks);
        GroupMetaLine ohneETLine = GroupInfoCollector.getProperLine(mitLinks);
        TreeMap linesByUser = new TreeMap();
        TreeMap linesByStrain = new TreeMap();
        TreeMap linesByLine = new TreeMap();
        TreeMap linesByLicense = new TreeMap();
        TreeMap linesByRack = new TreeMap();
        TreeMap linesByRoom = new TreeMap();
        HashMap<Integer, Integer> mouseCountByMonths = new HashMap<Integer, Integer>(30);
        int maxMonth = 0;
        int maxmmCount = 0;
        HashMap<Integer, Integer> cageCountByFill = new HashMap<Integer, Integer>(30);
        int maxFill = 0;
        int maxcageCount = 0;
        GICKeyMerker keyMerker = new GICKeyMerker();
        Vector clearableHashsets = new Vector();
        HashSet byLine = new HashSet();
        HashSet byLineM = InstallationType.useMatings() ? new HashSet() : null;
        clearableHashsets.add(byLine);
        if (byLineM != null) {
            clearableHashsets.add(byLineM);
        }
        HashSet byLicense = new HashSet();
        HashSet byLicenseM = InstallationType.useMatings() ? new HashSet() : null;
        clearableHashsets.add(byLicense);
        if (byLicenseM != null) {
            clearableHashsets.add(byLicenseM);
        }
        HashSet byStrain = new HashSet();
        HashSet byStrainM = InstallationType.useMatings() ? new HashSet() : null;
        clearableHashsets.add(byStrain);
        if (byStrainM != null) {
            clearableHashsets.add(byStrainM);
        }
        HashSet byUser = new HashSet();
        HashSet byUserM = InstallationType.useMatings() ? new HashSet() : null;
        clearableHashsets.add(byUser);
        if (byUserM != null) {
            clearableHashsets.add(byUserM);
        }
        HashSet byRack = new HashSet();
        HashSet byRackM = InstallationType.useMatings() ? new HashSet() : null;
        clearableHashsets.add(byRack);
        if (byRackM != null) {
            clearableHashsets.add(byRackM);
        }
        HashSet byRoom = new HashSet();
        HashSet byRoomM = InstallationType.useMatings() ? new HashSet() : null;
        clearableHashsets.add(byRoom);
        if (byRoomM != null) {
            clearableHashsets.add(byRoomM);
        }
        Long[] licIDTarget = new Long[Mouse.LICENSE_TAGS.length];
        long ivNow = System.currentTimeMillis();
        boolean mitLine = selection == null || selection.contains("FS_GR_BY_LINE");
        boolean mitLicense = selection == null || selection.contains("FS_GR_BY_LICENSE");
        boolean mitStrain = selection == null || selection.contains("FS_GR_BY_STRAIN");
        boolean mitUser = selection == null || selection.contains("FS_GR_BY_USER");
        boolean mitRackRoom = selection == null || selection.contains("FS_GR_BY_RACK") || selection.contains("FS_GR_BY_ROOM");
        Iterator miter = ObjectStore.getActualObjectsITER(1, group);
        if (miter != null) {
            while (miter.hasNext()) {
                Date d;
                Mouse mouse = (Mouse)miter.next();
                totalLine.handleMouse(mouse);
                if ((selection == null || selection.contains("FS_GR_AGE_STRUCTURE")) && (d = mouse.getDate("MOS_BIRTHDAY")) != null) {
                    int months = (int)((ivNow - d.getTime()) / 2592000000L);
                    if (months > maxMonth) {
                        maxMonth = months;
                    }
                    Integer key = new Integer(months);
                    Integer count = (Integer)mouseCountByMonths.get(key);
                    int countNeu = 1;
                    if (count != null) {
                        countNeu = count + 1;
                    }
                    if (countNeu > maxmmCount) {
                        maxmmCount = countNeu;
                    }
                    mouseCountByMonths.put(key, new Integer(countNeu));
                }
                if (selection == null || selection.contains("FS_GR_BY_EARTAG")) {
                    if (mouse.getInt("MOS_EARTAG", 0) == 0) {
                        ohneETLine.handleMouse(mouse);
                    } else {
                        mitETLine.handleMouse(mouse);
                    }
                }
                Iterator iterator = clearableHashsets.iterator();
                while (iterator.hasNext()) {
                    HashSet hs = (HashSet)iterator.next();
                    hs.clear();
                }
                if (mitLine) {
                    GroupInfoCollector.addMouseLineInfo(mouse, byLine, null, keyMerker, group);
                    GroupInfoCollector.addObject(byLine, linesByLine, mouse, null, mitLinks);
                }
                if (mitLicense) {
                    GroupInfoCollector.addMouseLicenseInfo(mouse, byLicense, null, keyMerker, licIDTarget, group);
                    GroupInfoCollector.addObject(byLicense, linesByLicense, mouse, null, mitLinks);
                }
                if (mitStrain) {
                    GroupInfoCollector.addMouseStrainInfo(mouse, byStrain, null, keyMerker, group);
                    GroupInfoCollector.addObject(byStrain, linesByStrain, mouse, null, mitLinks);
                }
                if (mitUser) {
                    GroupInfoCollector.addMouseOwnerInfo(mouse, byUser, null, keyMerker, group);
                    GroupInfoCollector.addObject(byUser, linesByUser, mouse, null, mitLinks);
                }
                if (!mitRackRoom) continue;
                GroupInfoCollector.fillRackRoomKeys(mouse, byRack, byRoom, null, null, keyMerker, group);
                GroupInfoCollector.addObject(byRack, linesByRack, mouse, null, mitLinks);
                GroupInfoCollector.addObject(byRoom, linesByRoom, mouse, null, mitLinks);
            }
        }
        Vector cMice = new Vector();
        Iterator citer = ObjectStore.getActualObjectsITER(2, group);
        while (citer.hasNext()) {
            Cage cage = (Cage)citer.next();
            totalLine.handleCage(cage, true);
            cMice.clear();
            cage.addActualMice(cMice);
            if (selection == null || selection.contains("FS_GR_CAGE_FILL")) {
                int fill = cMice.size();
                if (fill > maxFill) {
                    maxFill = fill;
                }
                Integer key = new Integer(cMice.size());
                Integer count = (Integer)cageCountByFill.get(key);
                int countNeu = 1;
                if (count != null) {
                    countNeu = count + 1;
                }
                if (countNeu > maxcageCount) {
                    maxcageCount = countNeu;
                }
                cageCountByFill.put(key, new Integer(countNeu));
            }
            Iterator iterator = clearableHashsets.iterator();
            while (iterator.hasNext()) {
                HashSet hs = (HashSet)iterator.next();
                hs.clear();
            }
            iterator = cMice.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                if (mouse.isPossMatingPartner()) {
                    if (mitLine) {
                        GroupInfoCollector.addMouseLineInfo(mouse, byLine, byLineM, keyMerker, group);
                        GroupInfoCollector.addObject(byLine, linesByLine, cage, byLineM, mitLinks);
                    }
                    if (mitLicense) {
                        GroupInfoCollector.addMouseLicenseInfo(mouse, byLicense, byLicenseM, keyMerker, licIDTarget, group);
                        GroupInfoCollector.addObject(byLicense, linesByLicense, cage, byLicenseM, mitLinks);
                    }
                    if (mitStrain) {
                        GroupInfoCollector.addMouseStrainInfo(mouse, byStrain, byStrainM, keyMerker, group);
                        GroupInfoCollector.addObject(byStrain, linesByStrain, cage, byStrainM, mitLinks);
                    }
                    if (mitUser) {
                        GroupInfoCollector.addMouseOwnerInfo(mouse, byUser, byUserM, keyMerker, group);
                        GroupInfoCollector.addObject(byUser, linesByUser, cage, byUserM, mitLinks);
                    }
                    if (!mitRackRoom) continue;
                    GroupInfoCollector.fillRackRoomKeys(mouse, byRack, byRoom, byRackM, byRoomM, keyMerker, group);
                    GroupInfoCollector.addObject(byRack, linesByRack, cage, byRackM, mitLinks);
                    GroupInfoCollector.addObject(byRoom, linesByRoom, cage, byRoomM, mitLinks);
                    continue;
                }
                if (mitLine) {
                    GroupInfoCollector.addMouseLineInfo(mouse, byLine, null, keyMerker, group);
                    GroupInfoCollector.addObject(byLine, linesByLine, cage, null, mitLinks);
                }
                if (mitLicense) {
                    GroupInfoCollector.addMouseLicenseInfo(mouse, byLicense, null, keyMerker, licIDTarget, group);
                    GroupInfoCollector.addObject(byLicense, linesByLicense, cage, null, mitLinks);
                }
                if (mitStrain) {
                    GroupInfoCollector.addMouseStrainInfo(mouse, byStrain, null, keyMerker, group);
                    GroupInfoCollector.addObject(byStrain, linesByStrain, cage, null, mitLinks);
                }
                if (mitUser) {
                    GroupInfoCollector.addMouseOwnerInfo(mouse, byUser, null, keyMerker, group);
                    GroupInfoCollector.addObject(byUser, linesByUser, cage, null, mitLinks);
                }
                if (!mitRackRoom) continue;
                GroupInfoCollector.fillRackRoomKeys(mouse, byRack, byRoom, null, null, keyMerker, group);
                GroupInfoCollector.addObject(byRack, linesByRack, cage, null, mitLinks);
                GroupInfoCollector.addObject(byRoom, linesByRoom, cage, null, mitLinks);
            }
        }
        if (selection == null || selection.contains("FS_GR_AGE_STRUCTURE")) {
            StringBuffer asb = new StringBuffer();
            asb.append(maxMonth);
            asb.append("|").append(maxmmCount);
            iter = mouseCountByMonths.keySet().iterator();
            while (iter.hasNext()) {
                Integer month = (Integer)iter.next();
                Integer count = (Integer)mouseCountByMonths.get(month);
                asb.append("|").append(month).append(",").append(count);
            }
            erg.put("FS_GR_AGE_STRUCTURE", asb.toString());
        }
        if (selection == null || selection.contains("FS_GR_CAGE_FILL")) {
            StringBuffer asb = new StringBuffer();
            asb.append(maxFill);
            asb.append("|").append(maxcageCount);
            iter = cageCountByFill.keySet().iterator();
            while (iter.hasNext()) {
                Integer fill = (Integer)iter.next();
                Integer count = (Integer)cageCountByFill.get(fill);
                asb.append("|").append(fill).append(",").append(count);
            }
            erg.put("FS_GR_CAGE_FILL", asb.toString());
        }
        if (selection == null || selection.contains("FS_M_TOTAL")) {
            Vector<String> v = new Vector<String>();
            v.add(totalLine.getTransportString(NULL_STRING, group, encodeTitel));
            erg.put("FS_M_TOTAL", v);
        }
        if (selection == null || selection.contains("FS_GR_BY_EARTAG")) {
            Vector<String> v = new Vector<String>();
            v.add(mitETLine.getTransportString(NULL_STRING, group, encodeTitel));
            v.add(ohneETLine.getTransportString(NULL_STRING, group, encodeTitel));
            erg.put("FS_GR_BY_EARTAG", v);
        }
        GroupInfoCollector.addLines(linesByLine, "FS_GR_BY_LINE", selection, erg, group, encodeTitel);
        GroupInfoCollector.addLines(linesByLicense, "FS_GR_BY_LICENSE", selection, erg, group, encodeTitel);
        GroupInfoCollector.addLines(linesByStrain, "FS_GR_BY_STRAIN", selection, erg, group, encodeTitel);
        GroupInfoCollector.addLines(linesByUser, "FS_GR_BY_USER", selection, erg, group, encodeTitel);
        GroupInfoCollector.addLines(linesByRack, "FS_GR_BY_RACK", selection, erg, group, encodeTitel);
        GroupInfoCollector.addLines(linesByRoom, "FS_GR_BY_ROOM", selection, erg, group, encodeTitel);
        totalLine.dispose();
        mitETLine.dispose();
        ohneETLine.dispose();
        keyMerker.dispose();
        keyMerker = null;
        GroupInfoCollector.dispose(linesByLine);
        GroupInfoCollector.dispose(linesByLicense);
        GroupInfoCollector.dispose(linesByStrain);
        GroupInfoCollector.dispose(linesByUser);
        GroupInfoCollector.dispose(linesByRack);
        GroupInfoCollector.dispose(linesByRoom);
        return erg;
    }

    private static void dispose(TreeMap map) {
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            GroupMetaLine grl = (GroupMetaLine)iter.next();
            grl.dispose();
        }
        map.clear();
    }

    private static void addLines(TreeMap map, String selKey, HashSet selection, HashMap erg, String group, boolean encodeTitel) {
        if (selection == null || selection.contains(selKey)) {
            Vector<String> v = new Vector<String>(2000);
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                GroupMetaLine grl = (GroupMetaLine)map.get(key);
                v.add(grl.getTransportString(key, group, encodeTitel));
            }
            erg.put(selKey, v);
        }
    }

    private static final void addObject(HashSet sammler, TreeMap tm, Object obj, HashSet sammlerMating, boolean mitLink) {
        Iterator iter = sammler.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            GroupMetaLine grl = (GroupMetaLine)tm.get(key);
            if (grl == null) {
                grl = GroupInfoCollector.getProperLine(mitLink);
                tm.put(key, grl);
            }
            if (obj instanceof Mouse) {
                grl.handleMouse((Mouse)obj);
                continue;
            }
            if (!(obj instanceof Cage)) continue;
            boolean checkMating = sammlerMating != null && sammlerMating.contains(key);
            grl.handleCage((Cage)obj, checkMating);
        }
    }

    private static final void addMouseLineInfo(Mouse mouse, HashSet keySammler, HashSet keySammlerMating, GICKeyMerker keyMerker, String group) {
        String key = NULL_STRING;
        long linID = mouse.getLong("MOS_LINEID", 0L);
        if (linID > 0L) {
            key = keyMerker.getKey(7, linID, group);
        }
        keySammler.add(key);
        if (keySammlerMating != null) {
            keySammlerMating.add(key);
        }
    }

    private static final void addMouseLicenseInfo(Mouse mouse, HashSet keySammler, HashSet keySammlerMating, GICKeyMerker keyMerker, Long[] licIDTarget, String group) {
        boolean addRealKey = false;
        int i = 0;
        while (i < licIDTarget.length) {
            licIDTarget[i] = null;
            ++i;
        }
        int anzfound = mouse.getLicenseIds(licIDTarget);
        if (anzfound != 0) {
            int i2 = 0;
            while (i2 < licIDTarget.length) {
                String key;
                if (licIDTarget[i2] != null && licIDTarget[i2] > 0L && !(key = keyMerker.getKey(16, licIDTarget[i2], group)).equals(NULL_STRING)) {
                    addRealKey = true;
                    keySammler.add(key);
                    if (keySammlerMating != null) {
                        keySammlerMating.add(key);
                    }
                }
                ++i2;
            }
        }
        if (!addRealKey) {
            keySammler.add(NULL_STRING);
            if (keySammlerMating != null) {
                keySammlerMating.add(NULL_STRING);
            }
        }
    }

    private static final void addMouseStrainInfo(Mouse mouse, HashSet keySammler, HashSet keySammlerMating, GICKeyMerker keyMerker, String group) {
        boolean addrealKey = false;
        IndexObject[] strains = (IndexObject[])mouse.get("MOS_STRAIN");
        if (strains != null) {
            int i = 0;
            while (i < strains.length) {
                String key;
                if (strains[i] != null && strains[i].ivObjectID > 0L && !(key = keyMerker.getKey(8, strains[i].ivObjectID, group)).equals(NULL_STRING)) {
                    addrealKey = true;
                    keySammler.add(key);
                    if (keySammlerMating != null) {
                        keySammlerMating.add(key);
                    }
                }
                ++i;
            }
        }
        if (!addrealKey) {
            keySammler.add(NULL_STRING);
            if (keySammlerMating != null) {
                keySammlerMating.add(NULL_STRING);
            }
        }
    }

    private static final void addMouseOwnerInfo(Mouse mouse, HashSet keySammler, HashSet keySammlerMating, GICKeyMerker keyMerker, String group) {
        boolean addrealKey = false;
        long[] owners = (long[])mouse.get("MOS_OWNER");
        if (owners != null && owners.length != 0) {
            int i = 0;
            while (i < owners.length) {
                String key;
                if (owners[i] != 0L && !(key = keyMerker.getKey(6, owners[i], group)).equals(NULL_STRING)) {
                    addrealKey = true;
                    keySammler.add(key);
                    if (keySammlerMating != null) {
                        keySammlerMating.add(key);
                    }
                }
                ++i;
            }
        }
        if (!addrealKey) {
            keySammler.add(NULL_STRING);
            if (keySammlerMating != null) {
                keySammlerMating.add(NULL_STRING);
            }
        }
    }

    private static final void fillRackRoomKeys(Mouse mouse, HashSet keySammlerRack, HashSet keySammlerRoom, HashSet keySammlerRackMating, HashSet keySammlerRoomMating, GICKeyMerker keyMerker, String group) {
        String rackKey = NULL_STRING;
        String roomKey = NULL_STRING;
        Cage cage = mouse.getActCage();
        if (cage != null) {
            Rack rack;
            RackPos rp = (RackPos)cage.getSuperCageIfThere().get("CAG_POS");
            if (rp != null && (rack = (Rack)ObjectStore.getObjectDeadOrAlive(3, rp.ivRackID, group, null, false)) != null) {
                rackKey = keyMerker.getKey(rack);
                long roomID = rack.getLong("RCK_ROOM", 0L);
                if (roomID > 0L) {
                    roomKey = keyMerker.getKey(10, roomID, group);
                }
            }
            keySammlerRack.add(rackKey);
            if (keySammlerRackMating != null) {
                keySammlerRackMating.add(rackKey);
            }
            keySammlerRoom.add(roomKey);
            if (keySammlerRoomMating != null) {
                keySammlerRoomMating.add(roomKey);
            }
        }
    }

    public boolean isPerDiem() {
        return this.containsKey(PERDIEM_SIGN);
    }

    public void setPerDiem() {
        this.put(PERDIEM_SIGN, PERDIEM_SIGN);
    }

    public String getPerDiemString() {
        StringBuffer tsb = new StringBuffer();
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object ooo = this.get(key);
            String val = null;
            if (ooo instanceof String) {
                val = STRING_SIGN + Base64Manager.encodeBase64((String)ooo);
            } else if (ooo instanceof Vector) {
                Vector v = (Vector)ooo;
                StringBuffer msb = new StringBuffer();
                Iterator iterator = v.iterator();
                while (iterator.hasNext()) {
                    String s = (String)iterator.next();
                    if (msb.length() != 0) {
                        msb.append("|");
                    }
                    msb.append(Base64Manager.encodeBase64(s));
                }
                val = VECTOR_SIGN + Base64Manager.encodeBase64(msb.toString());
            }
            if (val == null) {
                Log.warn("No value for per Deim String", this);
                continue;
            }
            if (tsb.length() != 0) {
                tsb.append("|");
            }
            tsb.append(Base64Manager.encodeBase64(String.valueOf(key) + "|" + val));
        }
        return tsb.toString();
    }

    public void initFromPerDiemString(String s) {
        Zeile z1 = new Zeile(s, '|');
        int i1 = 0;
        while (i1 < z1.size()) {
            Zeile z2;
            String val1 = Base64Manager.getDecodedString(z1.getString(i1, NULL_STRING));
            if (val1 != null && (z2 = new Zeile(val1, '|')).size() >= 2) {
                String key = z2.getString(0, NULL_STRING);
                String val = z2.getString(1, NULL_STRING);
                Object obj = null;
                if (val.startsWith(STRING_SIGN)) {
                    obj = Base64Manager.getDecodedString(val.substring(STRING_SIGN.length(), val.length()), NULL_STRING);
                } else if (val.startsWith(VECTOR_SIGN)) {
                    Vector<String> target = new Vector<String>();
                    obj = target;
                    String vs = Base64Manager.getDecodedString(val.substring(VECTOR_SIGN.length(), val.length()), NULL_STRING);
                    Zeile z3 = new Zeile(vs, '|');
                    int i3 = 0;
                    while (i3 < z3.size()) {
                        target.add(Base64Manager.getDecodedString(z3.getString(i3, NULL_STRING)));
                        ++i3;
                    }
                }
                if (obj != null) {
                    this.put(key, obj);
                }
            }
            ++i1;
        }
    }

    public static class GICKeyMerker {
        private HashMap ivKeyByLine = new HashMap(100);
        private HashMap ivKeyByLicense = new HashMap(50);
        private HashMap ivKeyByStrain = new HashMap(60);
        private HashMap ivKeyByUser = new HashMap(50);
        private HashMap ivKeyByRack = new HashMap(50);
        private HashMap ivKeyByRoom = new HashMap(20);

        public String getKey(int typ, long id, String group) {
            String key = GroupInfoCollector.NULL_STRING;
            if (id > 0L) {
                Long lkey = new Long(id);
                if (typ == 6) {
                    key = (String)this.ivKeyByUser.get(lkey);
                    if (key == null) {
                        User user = (User)ObjectStore.getObjectDeadOrAlive(6, id, group, null, false);
                        key = user != null ? String.valueOf(user.getString("USR_NAME", GroupInfoCollector.NULL_STRING)) + "#\u00a7#" + IDObjectMerker.getLink(user, GroupInfoCollector.NULL_STRING) : GroupInfoCollector.NULL_STRING;
                        this.ivKeyByUser.put(lkey, key);
                    }
                } else if (typ == 7) {
                    key = (String)this.ivKeyByLine.get(lkey);
                    if (key == null) {
                        Line line = (Line)ObjectStore.getObjectDeadOrAlive(7, id, group, null, false);
                        key = line != null ? String.valueOf(line.getString("LIN_NAME", GroupInfoCollector.NULL_STRING)) + "#\u00a7#" + IDObjectMerker.getLink(line, GroupInfoCollector.NULL_STRING) : GroupInfoCollector.NULL_STRING;
                        this.ivKeyByLine.put(lkey, key);
                    }
                } else if (typ == 16) {
                    key = (String)this.ivKeyByLicense.get(lkey);
                    if (key == null) {
                        License license = (License)ObjectStore.getObjectDeadOrAlive(16, id, group, null, false);
                        key = license != null ? String.valueOf(license.getString("LIC_NAME", GroupInfoCollector.NULL_STRING)) + "#\u00a7#" + IDObjectMerker.getLink(license, GroupInfoCollector.NULL_STRING) : GroupInfoCollector.NULL_STRING;
                        this.ivKeyByLicense.put(lkey, key);
                    }
                } else if (typ == 8) {
                    key = (String)this.ivKeyByStrain.get(lkey);
                    if (key == null) {
                        Strain strain = (Strain)ObjectStore.getObjectDeadOrAlive(8, id, group, null, false);
                        key = strain != null ? String.valueOf(strain.getString("STR_NAME")) + "#\u00a7#" + IDObjectMerker.getLink(strain, GroupInfoCollector.NULL_STRING) : GroupInfoCollector.NULL_STRING;
                        this.ivKeyByStrain.put(lkey, key);
                    }
                } else if (typ == 10 && (key = (String)this.ivKeyByRoom.get(lkey)) == null) {
                    Room room = (Room)ObjectStore.getObjectDeadOrAlive(10, id, group, null, false);
                    key = room != null ? String.valueOf(room.getString("ROM_NAME", GroupInfoCollector.NULL_STRING)) + "#\u00a7#" + IDObjectMerker.getLink(room, GroupInfoCollector.NULL_STRING) : GroupInfoCollector.NULL_STRING;
                    this.ivKeyByRoom.put(lkey, key);
                }
            }
            return key;
        }

        public String getKey(IDObject ido) {
            String key = GroupInfoCollector.NULL_STRING;
            if (ido instanceof Rack && (key = (String)this.ivKeyByRack.get(ido.getLongID())) == null) {
                Rack rack = (Rack)ido;
                key = String.valueOf(rack.getString("RCK_NAME", GroupInfoCollector.NULL_STRING)) + "#\u00a7#" + IDObjectMerker.getLink(rack, GroupInfoCollector.NULL_STRING);
                this.ivKeyByRack.put(ido.getLongID(), key);
            }
            return key;
        }

        public void dispose() {
            this.ivKeyByLine.clear();
            this.ivKeyByLine = null;
            this.ivKeyByLicense.clear();
            this.ivKeyByLicense = null;
            this.ivKeyByStrain.clear();
            this.ivKeyByStrain = null;
            this.ivKeyByUser.clear();
            this.ivKeyByUser = null;
            this.ivKeyByRack.clear();
            this.ivKeyByRack = null;
            this.ivKeyByRoom.clear();
            this.ivKeyByRoom = null;
        }
    }
}

