/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets.groupreport;

import de.hannse.netobjects.tools.Base64Manager;
import java.util.HashSet;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.factsheets.IDObjectMerker;
import mausoleum.factsheets.groupreport.GroupMetaLine;
import mausoleum.mouse.Mouse;
import mausoleum.util.InstallationType;

public class GroupReportLine
implements GroupMetaLine {
    public final Vector ivMale = new Vector(100);
    public final Vector ivFemale = new Vector(100);
    public final Vector ivUnset = new Vector(100);
    public final Vector ivTotal = new Vector(100);
    public final HashSet ivCages = new HashSet();
    public final HashSet ivMatings = InstallationType.useMatings() ? new HashSet() : null;

    public String getTransportString(String prefix, String group, boolean encodeTitel) {
        String vorn = "";
        if (encodeTitel) {
            int ind = prefix.lastIndexOf("#\u00a7#");
            if (ind != -1) {
                String vorn1 = prefix.substring(0, ind);
                String vorn2 = prefix.substring(ind + "#\u00a7#".length(), prefix.length());
                vorn = String.valueOf(Base64Manager.encodeBase64(vorn1)) + "#\u00a7#" + vorn2;
            } else {
                vorn = Base64Manager.encodeBase64(prefix);
            }
        }
        StringBuilder msb = new StringBuilder(vorn);
        msb.append("|").append(this.ivMale.size());
        msb.append("@").append(Base64Manager.encodeBase64(IDObjectMerker.getLink(this.ivMale, "")));
        msb.append("|").append(this.ivFemale.size());
        msb.append("@").append(Base64Manager.encodeBase64(IDObjectMerker.getLink(this.ivFemale, "")));
        msb.append("|").append(this.ivUnset.size());
        msb.append("@").append(Base64Manager.encodeBase64(IDObjectMerker.getLink(this.ivUnset, "")));
        msb.append("|").append(this.ivTotal.size());
        msb.append("@").append(Base64Manager.encodeBase64(IDObjectMerker.getLink(this.ivTotal, "")));
        msb.append("|").append(this.ivCages.size());
        msb.append("@").append(Base64Manager.encodeBase64(IDObjectMerker.getLink(this.ivCages, "", 2, group)));
        if (this.ivMatings != null) {
            msb.append("|").append(this.ivMatings.size());
            msb.append("@").append(Base64Manager.encodeBase64(IDObjectMerker.getLink(this.ivMatings, "", 2, group)));
        }
        return msb.toString();
    }

    public void handleMouse(Mouse mouse) {
        switch (mouse.getSex()) {
            case 1: {
                this.ivMale.add(mouse);
                break;
            }
            case 2: {
                this.ivFemale.add(mouse);
                break;
            }
            default: {
                this.ivUnset.add(mouse);
            }
        }
        this.ivTotal.add(mouse);
    }

    public void handleCage(Cage cage, boolean checkMating) {
        this.ivCages.add(cage.get("IDO_ID"));
        if (this.ivMatings != null && checkMating && cage.isMatingCage()) {
            this.ivMatings.add(cage.get("IDO_ID"));
        }
    }

    public void dispose() {
        this.ivMale.clear();
        this.ivFemale.clear();
        this.ivUnset.clear();
        this.ivTotal.clear();
        this.ivCages.clear();
        if (this.ivMatings != null) {
            this.ivMatings.clear();
        }
    }
}

