/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets.groupreport;

import de.hannse.netobjects.tools.Base64Manager;
import java.util.HashSet;
import mausoleum.cage.Cage;
import mausoleum.factsheets.groupreport.GroupMetaLine;
import mausoleum.mouse.Mouse;
import mausoleum.util.InstallationType;

public class GroupReportLineOL
implements GroupMetaLine {
    private int ivMale = 0;
    private int ivFemale = 0;
    private int ivUnset = 0;
    private int ivTotal = 0;
    public final HashSet ivCages = new HashSet();
    public final HashSet ivMatings = InstallationType.useMatings() ? new HashSet() : null;

    public String getTransportString(String prefix, String group, boolean encodeTitel) {
        String vorn = "";
        int ind = prefix.lastIndexOf("#\u00a7#");
        vorn = ind != -1 ? prefix.substring(0, ind) : prefix;
        if (encodeTitel) {
            vorn = Base64Manager.encodeBase64(vorn);
        }
        StringBuilder msb = new StringBuilder(vorn);
        msb.append("|").append(this.ivMale);
        msb.append("|").append(this.ivFemale);
        msb.append("|").append(this.ivUnset);
        msb.append("|").append(this.ivTotal);
        msb.append("|").append(this.ivCages.size());
        if (this.ivMatings != null) {
            msb.append("|").append(this.ivMatings.size());
        }
        return msb.toString();
    }

    public void handleMouse(Mouse mouse) {
        switch (mouse.getSex()) {
            case 1: {
                ++this.ivMale;
                break;
            }
            case 2: {
                ++this.ivFemale;
                break;
            }
            default: {
                ++this.ivUnset;
            }
        }
        ++this.ivTotal;
    }

    public void handleCage(Cage cage, boolean checkMating) {
        this.ivCages.add(cage.get("IDO_ID"));
        if (this.ivMatings != null && checkMating && cage.isMatingCage()) {
            this.ivMatings.add(cage.get("IDO_ID"));
        }
    }

    public void dispose() {
        this.ivCages.clear();
        if (this.ivMatings != null) {
            this.ivMatings.clear();
        }
    }

    public String toString() {
        StringBuilder msb = new StringBuilder();
        msb.append("GRL");
        msb.append("|").append(this.ivMale);
        msb.append("|").append(this.ivFemale);
        msb.append("|").append(this.ivUnset);
        msb.append("|").append(this.ivTotal);
        msb.append("|").append(this.ivCages.size());
        if (this.ivMatings != null) {
            msb.append("|").append(this.ivMatings.size());
        }
        return msb.toString();
    }
}

