/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets.groupreport;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.network.client.TimeMachine;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Point;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import mausoleum.factsheets.groupreport.GroupInfoCollector;
import mausoleum.helper.Zeile;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;

public class GroupStatistics {
    private static final int ANZAHL_WERTE_INFO_LINE = 6;
    public static final String STAT_TAG_ROOM = "ROOM";
    public static final String STAT_TAG_RACK = "RACK";
    private static final int TAGE_TOLERANZ = 7;
    public static final HashSet SELECTION = new HashSet();
    public static final String[] NORMALE = new String[]{"FS_M_TOTAL", "FS_GR_BY_ROOM", "FS_GR_BY_RACK", "FS_GR_BY_LICENSE", "FS_GR_BY_USER", "FS_GR_BY_LINE"};
    public static final String[] BESONDERE = new String[]{"FS_GR_AGE_STRUCTURE", "FS_GR_CAGE_FILL"};
    private static Integer SONDER_KOORDINATE = new Integer(-1);
    public static final String SIGNAL_FOR_SERVER = "==()$%#";
    static /* synthetic */ Class class$0;

    static {
        SELECTION.add("FS_M_TOTAL");
        SELECTION.add("FS_GR_BY_LICENSE");
        SELECTION.add("FS_GR_BY_RACK");
        SELECTION.add("FS_GR_BY_ROOM");
        SELECTION.add("FS_GR_BY_USER");
        SELECTION.add("FS_GR_BY_LINE");
        SELECTION.add("FS_GR_AGE_STRUCTURE");
        SELECTION.add("FS_GR_CAGE_FILL");
    }

    public static void saveStatisticsFromClient() {
        if (ProcessDefinition.isClient() && MausoleumClient.isRegularOrTGService()) {
            int jahr = MyDate.getMyDate((long)System.currentTimeMillis()).ivJahr;
            try {
                GroupInfoCollector gic = GroupInfoCollector.collectInfosForStatisticsFileClientSide(UserManager.getFirstGroup(), SELECTION);
                if (gic != null) {
                    RequestManager.sendObjectRequestAndForget(new ObjectRequest(30, Base64Manager.encodeBase64(String.valueOf(TimeMachine.getCurrentMillis()) + ";" + gic.getPerDiemString() + "\n"), UserManager.getFirstGroup(), StringHelper.gSub(GroupFileManager.getReportsFileNamePattern(), "YEAR", Integer.toString(jahr), true)));
                }
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.factsheets.groupreport.GroupStatistics");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn("MausoleumClient Probleme bei saveStatistics ", e, clazz);
            }
        }
    }

    public static void saveStatisticsFromServerAllGroups() {
        int jahr = MyDate.getMyDate((long)System.currentTimeMillis()).ivJahr;
        String filename = StringHelper.gSub(GroupFileManager.getReportsFileNamePattern(), "YEAR", Integer.toString(jahr), true);
        Enumeration en = DataLayer.cvDataLayer.getAllGroupnames(true);
        while (en.hasMoreElements()) {
            String group = (String)en.nextElement();
            if ("service".equals(group)) continue;
            GroupStatistics.saveStatisticsFromServer(group, filename);
        }
    }

    private static void saveStatisticsFromServer(String group, String filename) {
        if (ProcessDefinition.isServer()) {
            try {
                GroupInfoCollector gic = GroupInfoCollector.collectInfosForStatisticsFileServerSide(group, SELECTION);
                if (gic != null) {
                    FileManager.pureAppend(String.valueOf(GroupFileManager.getReportsDir(group)) + "/" + filename, String.valueOf(MilliSpender.getMillis()) + ";" + gic.getPerDiemString() + SIGNAL_FOR_SERVER + "\n");
                }
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.factsheets.groupreport.GroupStatistics");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn("MausoleumClient Probleme bei saveStatistics ", e, clazz);
            }
        }
    }

    public static boolean getPerDiemReport(ObjectRequest or) {
        boolean res = false;
        String group = (String)or.ivObject;
        Point p = (Point)or.ivExtraObject;
        int start = p.x < p.y ? p.x : p.y;
        int ende = p.x < p.y ? p.y : p.x;
        long startMillis = (long)start * 86400000L;
        long endMillis = (long)ende * 86400000L + 86400000L - 1L;
        int startjahr = new MyDate((int)(start - 7)).ivJahr;
        int endjahr = new MyDate((int)(ende + 7)).ivJahr;
        Vector zeilensammler = new Vector();
        int jahr = startjahr;
        while (jahr <= endjahr) {
            String filename = StringHelper.gSub(GroupFileManager.getReportsFileNamePattern(), "YEAR", Integer.toString(jahr), true);
            GroupStatistics.readReportLines(String.valueOf(GroupFileManager.getReportsDir(group)) + "/" + filename, startMillis, endMillis, zeilensammler, start == ende);
            ++jahr;
        }
        if (!zeilensammler.isEmpty()) {
            HashMap results = new HashMap();
            Iterator iter = zeilensammler.iterator();
            while (iter.hasNext()) {
                String line = (String)iter.next();
                if (line.endsWith(SIGNAL_FOR_SERVER)) {
                    line = line.substring(0, line.length() - SIGNAL_FOR_SERVER.length());
                }
                GroupInfoCollector gic = new GroupInfoCollector();
                gic.initFromPerDiemString(line);
                GroupStatistics.holeNormalInformationen(gic, results);
                GroupStatistics.holeBesondereInformationen(gic, results);
            }
            GroupInfoCollector finalGic = new GroupInfoCollector();
            finalGic.setPerDiem();
            finalGic.put("GROUP", group);
            finalGic.put("PD_START", Integer.toString(start));
            finalGic.put("PD_END", Integer.toString(ende));
            GroupStatistics.schreibeNormalInformationen(finalGic, results);
            GroupStatistics.schreibeSonderInformationen(finalGic, results);
            or.ivObject = finalGic;
            res = true;
        }
        return res;
    }

    private static void holeBesondereInformationen(GroupInfoCollector gic, HashMap results) {
        int i = 0;
        while (i < BESONDERE.length) {
            String typKey = BESONDERE[i];
            String valString = (String)gic.get(typKey);
            if (valString != null) {
                Integer anzahl;
                TreeMap<Integer, Object> tm = (TreeMap<Integer, Object>)results.get(typKey);
                if (tm == null) {
                    tm = new TreeMap<Integer, Object>();
                    results.put(typKey, tm);
                }
                if ((anzahl = (Integer)tm.get(SONDER_KOORDINATE)) == null) {
                    tm.put(SONDER_KOORDINATE, new Integer(1));
                } else {
                    tm.put(SONDER_KOORDINATE, new Integer(anzahl + 1));
                }
                Zeile z = new Zeile(valString, '|');
                if (z.size() > 2) {
                    HashSet<Integer> vorhandeneXKoordinaten = new HashSet<Integer>();
                    int pos = 2;
                    while (pos < z.size()) {
                        int ind;
                        String ks = z.getString(pos, null);
                        if (ks != null && (ind = ks.indexOf(",")) != -1) {
                            try {
                                Integer x = new Integer(ks.substring(0, ind));
                                vorhandeneXKoordinaten.add(x);
                                int y = Integer.parseInt(ks.substring(ind + 1, ks.length()));
                                int[] arr = (int[])tm.get(x);
                                if (arr == null) {
                                    arr = new int[]{0, Integer.MAX_VALUE, Integer.MIN_VALUE};
                                    tm.put(x, arr);
                                }
                                arr[0] = arr[0] + y;
                                if (y > arr[2]) {
                                    arr[2] = y;
                                }
                                if (y < arr[1]) {
                                    arr[1] = y;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++pos;
                    }
                    Iterator iter = tm.keySet().iterator();
                    while (iter.hasNext()) {
                        int[] arr;
                        Integer koordinate = (Integer)iter.next();
                        if (koordinate.equals(SONDER_KOORDINATE) || vorhandeneXKoordinaten.contains(koordinate) || (arr = (int[])tm.get(koordinate)) == null) continue;
                        arr[1] = 0;
                    }
                }
            }
            ++i;
        }
    }

    private static void schreibeSonderInformationen(GroupInfoCollector gic, HashMap results) {
        int i = 0;
        while (i < BESONDERE.length) {
            String typKey = BESONDERE[i];
            TreeMap tm = (TreeMap)results.get(typKey);
            if (tm != null && tm.containsKey(SONDER_KOORDINATE)) {
                Integer anzI = (Integer)tm.get(SONDER_KOORDINATE);
                tm.remove(SONDER_KOORDINATE);
                double anz = anzI.doubleValue();
                int maxX = 0;
                int maxY = 0;
                Iterator iter = tm.keySet().iterator();
                while (iter.hasNext()) {
                    Integer xI = (Integer)iter.next();
                    int[] arr = (int[])tm.get(xI);
                    if (xI > maxX) {
                        maxX = xI;
                    }
                    if (arr[2] <= maxY) continue;
                    maxY = arr[2];
                }
                StringBuffer msb = new StringBuffer();
                msb.append(maxX).append("|").append(maxY);
                Iterator iter2 = tm.keySet().iterator();
                while (iter2.hasNext()) {
                    Integer xI = (Integer)iter2.next();
                    int[] arr = (int[])tm.get(xI);
                    msb.append("|").append(xI).append(",");
                    msb.append((double)arr[0] / anz).append("=").append(arr[1]).append("=").append(arr[2]);
                }
                gic.put(typKey, msb.toString());
            }
            ++i;
        }
    }

    private static void holeNormalInformationen(GroupInfoCollector gic, HashMap numberArraysByKennung) {
        int i = 0;
        while (i < NORMALE.length) {
            String typKey = NORMALE[i];
            Vector v = (Vector)gic.get(typKey);
            if (v != null) {
                TreeMap<String, int[][]> typHM = (TreeMap<String, int[][]>)numberArraysByKennung.get(typKey);
                if (typHM == null) {
                    typHM = new TreeMap<String, int[][]>();
                    numberArraysByKennung.put(typKey, typHM);
                }
                Iterator iterator = v.iterator();
                while (iterator.hasNext()) {
                    int[][] sammler;
                    String info = (String)iterator.next();
                    Zeile z = new Zeile(info, '|');
                    String kennung = z.getString(0, "");
                    int diff = z.size() - 7;
                    if (diff > 0) {
                        StringBuilder msb = new StringBuilder();
                        int nzi = 0;
                        while (nzi <= diff) {
                            if (nzi != 0) {
                                msb.append("|");
                            }
                            msb.append(z.getString(nzi, ""));
                            ++nzi;
                        }
                        kennung = msb.toString();
                    }
                    if (kennung.startsWith("[S] ")) {
                        kennung = kennung.substring("[S] ".length(), kennung.length());
                    }
                    if ((sammler = (int[][])typHM.get(kennung)) == null) {
                        sammler = new int[4][6];
                        int y = 0;
                        while (y < 6) {
                            sammler[0][y] = 0;
                            sammler[1][y] = Integer.MAX_VALUE;
                            sammler[2][y] = Integer.MIN_VALUE;
                            sammler[3][y] = 0;
                            ++y;
                        }
                        typHM.put(kennung, sammler);
                    }
                    int[] nArray = sammler[3];
                    nArray[0] = nArray[0] + 1;
                    int j = 0;
                    while (j < 6) {
                        int value = z.getInt(j + 1 + diff, 0);
                        int[] nArray2 = sammler[0];
                        int n = j;
                        nArray2[n] = nArray2[n] + value;
                        if (value < sammler[1][j]) {
                            sammler[1][j] = value;
                        }
                        if (value > sammler[2][j]) {
                            sammler[2][j] = value;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private static void schreibeNormalInformationen(GroupInfoCollector gic, HashMap numberArraysByKennung) {
        int i = 0;
        while (i < NORMALE.length) {
            TreeMap typHM = (TreeMap)numberArraysByKennung.get(NORMALE[i]);
            if (typHM != null) {
                Vector<String> sammelVec = new Vector<String>(typHM.size());
                gic.put(NORMALE[i], sammelVec);
                Iterator iter = typHM.keySet().iterator();
                while (iter.hasNext()) {
                    String kennung = (String)iter.next();
                    int[][] sammler = (int[][])typHM.get(kennung);
                    double anzahl = sammler[3][0];
                    StringBuffer msb = new StringBuffer(Base64Manager.encodeBase64(kennung));
                    int y = 0;
                    while (y < 6) {
                        msb.append("|").append(Double.toString((double)sammler[0][y] / anzahl));
                        msb.append("=").append(sammler[1][y]);
                        msb.append("=").append(sammler[2][y]);
                        ++y;
                    }
                    sammelVec.add(msb.toString());
                }
            }
            ++i;
        }
    }

    private static void readReportLines(String path, long startMillis, long endMillis, Vector target, boolean singleDay) {
        long idiff = endMillis - startMillis;
        String lastBefore = null;
        if (new File(path).exists()) {
            try {
                LineNumberReader lnr = new LineNumberReader(new FileReader(path));
                String line = lnr.readLine();
                while (line != null) {
                    int ind = line.indexOf(";");
                    if (ind != -1) {
                        try {
                            long diff = Long.parseLong(line.substring(0, ind)) - startMillis;
                            if (diff < 0L) {
                                lastBefore = line.substring(ind + 1, line.length());
                            } else if (diff < idiff) {
                                target.add(line.substring(ind + 1, line.length()));
                            }
                        }
                        catch (Exception e) {
                            String string = "Problem reading report file " + path + " while interpreting line: " + line;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("mausoleum.factsheets.groupreport.GroupStatistics");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error(string, e, clazz);
                        }
                    }
                    line = lnr.readLine();
                }
                lnr.close();
                boolean useLasBefore = false;
                useLasBefore = singleDay ? target.isEmpty() : true;
                if (useLasBefore && lastBefore != null) {
                    target.insertElementAt(lastBefore, 0);
                }
            }
            catch (Exception e) {
                String string = "Problem reading report file " + path;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.factsheets.groupreport.GroupStatistics");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
    }
}

