/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets.multidimreport;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.awt.Point;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.factsheets.FactSheet;
import mausoleum.factsheets.IDObjectMerker;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.factsheets.multidimreport.MultiDimAnalyzer;
import mausoleum.helper.Zeile;

public abstract class MultiDimDistributor {
    public static MultiDimAnalyzer distribute(Vector objects, Vector xCoordVecsVec, Vector yCoordVecsVec, int[] xTypes, int[] yTypes, boolean serviceGroupMode, int objectType, int cageMode, String collectionTicket) {
        xCoordVecsVec.clear();
        yCoordVecsVec.clear();
        MultiDimAnalyzer analyzer = null;
        if (xTypes.length != 0 || yTypes.length != 0) {
            int[] fullTypes = new int[xTypes.length + yTypes.length];
            int i = 0;
            while (i < yTypes.length) {
                fullTypes[i] = yTypes[i];
                ++i;
            }
            i = 0;
            while (i < xTypes.length) {
                fullTypes[i + yTypes.length] = xTypes[i];
                ++i;
            }
            if (serviceGroupMode) {
                MultiDimAnalyzer.AnalyzerInfo analyzerInfo = new MultiDimAnalyzer.AnalyzerInfo(fullTypes, yTypes.length, objectType, cageMode, collectionTicket);
                String result = (String)RequestManager.createSendAndGetObjectIfFinished((byte)70, analyzerInfo, UserManager.getFirstGroup());
                if (result != null) {
                    analyzer = (MultiDimAnalyzer)IDObjectXMLHandler.getObject(result, "service", true);
                }
            } else {
                analyzer = MultiDimAnalyzer.analyze(objects, fullTypes, yTypes.length);
            }
            if (analyzer != null) {
                TreeSet yCoordVecs = new TreeSet(MultiDimAnalyzer.VECTOR_COMPARER);
                TreeSet xCoordVecs = new TreeSet(MultiDimAnalyzer.VECTOR_COMPARER);
                analyzer.addCoordinates(null, xCoordVecs, yCoordVecs);
                xCoordVecsVec.addAll(xCoordVecs);
                yCoordVecsVec.addAll(yCoordVecs);
            }
        }
        return analyzer;
    }

    public static Vector createElements(Vector xCoordVecsVec, Vector yCoordVecsVec, MultiDimAnalyzer analyzer, int[] xTypes, int[] yTypes, int[] maxCoords, int[] origo, boolean withTotalCol, boolean withTotalRow, boolean regularClientMode, boolean forExcel, Vector allObjects, int objectType) {
        PrintElementFactSheet pe;
        int x;
        int rowToDelete;
        PrintElementFactSheet pe2;
        int anzYDims = yTypes.length;
        int anzXDims = xTypes.length;
        HashMap<Point, PrintElementFactSheet> contents = new HashMap<Point, PrintElementFactSheet>();
        int lineHeight = -1;
        HashSet donts = new HashSet();
        Point p = new Point();
        p.y = 0;
        while (p.y < anzXDims) {
            p.x = 0;
            while (p.x < xCoordVecsVec.size()) {
                if (!donts.contains(p)) {
                    contents.put(new Point(p.x + anzYDims, p.y), MultiDimDistributor.gPE(p.x, p.y, xCoordVecsVec, 0, donts));
                }
                ++p.x;
            }
            ++p.y;
        }
        donts.clear();
        p.y = 0;
        while (p.y < yCoordVecsVec.size()) {
            Vector v = (Vector)yCoordVecsVec.elementAt(p.y);
            p.x = 0;
            while (p.x < anzYDims) {
                if (!donts.contains(new Point(p.y, p.x))) {
                    contents.put(new Point(p.x, p.y + anzXDims), MultiDimDistributor.gPE(p.y, p.x, yCoordVecsVec, 2, donts));
                }
                ++p.x;
            }
            p.x = 0;
            while (p.x < xCoordVecsVec.size()) {
                Vector sh = (Vector)xCoordVecsVec.elementAt(p.x);
                Vector al = new Vector();
                al.addAll(v);
                al.addAll(sh);
                pe2 = MultiDimDistributor.gPE(analyzer, al);
                if (pe2 != null) {
                    if (lineHeight == -1) {
                        lineHeight = pe2.ivHeight;
                    }
                    contents.put(new Point(p.x + anzYDims, p.y + anzXDims), pe2);
                }
                ++p.x;
            }
            ++p.y;
        }
        if (withTotalCol) {
            PrintElementFactSheet pe3 = PrintElementFactSheet.getTextElement(0, 0, Babel.get("FS_M_TOTAL"), FactSheet.FETT_FONT, null, 0, 3);
            contents.put(new Point(xCoordVecsVec.size() + anzYDims, 0), pe3);
            Point key = new Point();
            if (regularClientMode) {
                HashMap tobjects = new HashMap();
                p.y = 0;
                while (p.y < yCoordVecsVec.size()) {
                    tobjects.clear();
                    p.x = 0;
                    while (p.x < xCoordVecsVec.size()) {
                        MultiDimDistributor.collectTotals(key, p.x + anzYDims, p.y + anzXDims, contents, tobjects, allObjects, objectType);
                        ++p.x;
                    }
                    MultiDimDistributor.addTotalCell(tobjects, null, contents, xCoordVecsVec.size() + anzYDims, key.y);
                    ++p.y;
                }
            } else {
                p.y = 0;
                while (p.y < yCoordVecsVec.size()) {
                    int sumSoFar = 0;
                    p.x = 0;
                    while (p.x < xCoordVecsVec.size()) {
                        sumSoFar = MultiDimDistributor.collectTotalCount(key, p.x + anzYDims, p.y + anzXDims, contents, sumSoFar);
                        ++p.x;
                    }
                    MultiDimDistributor.addTotalCell(sumSoFar, contents, xCoordVecsVec.size() + anzYDims, key.y);
                    ++p.y;
                }
            }
        }
        if (withTotalRow) {
            boolean totalTotalWanted = withTotalCol && withTotalRow;
            int totalSum = 0;
            HashMap allesSammler = regularClientMode && totalTotalWanted ? new HashMap() : null;
            pe2 = PrintElementFactSheet.getTextElement(0, 0, Babel.get("FS_M_TOTAL"), FactSheet.FETT_FONT, null, 2, 3);
            contents.put(new Point(0, yCoordVecsVec.size() + anzXDims), pe2);
            Point key = new Point();
            if (regularClientMode) {
                HashMap tobjects = regularClientMode ? new HashMap() : null;
                p.x = 0;
                while (p.x < xCoordVecsVec.size()) {
                    tobjects.clear();
                    p.y = 0;
                    while (p.y < yCoordVecsVec.size()) {
                        MultiDimDistributor.collectTotals(key, p.x + anzYDims, p.y + anzXDims, contents, tobjects, allObjects, objectType);
                        ++p.y;
                    }
                    MultiDimDistributor.addTotalCell(tobjects, null, contents, key.x, yCoordVecsVec.size() + anzXDims);
                    if (allesSammler != null) {
                        Iterator iterator = tobjects.keySet().iterator();
                        while (iterator.hasNext()) {
                            Object key2 = iterator.next();
                            allesSammler.put(key2, tobjects.get(key2));
                        }
                    }
                    ++p.x;
                }
            } else {
                p.x = 0;
                while (p.x < xCoordVecsVec.size()) {
                    int sumSoFar = 0;
                    p.y = 0;
                    while (p.y < yCoordVecsVec.size()) {
                        sumSoFar = MultiDimDistributor.collectTotalCount(key, p.x + anzYDims, p.y + anzXDims, contents, sumSoFar);
                        ++p.y;
                    }
                    MultiDimDistributor.addTotalCell(sumSoFar, contents, key.x, yCoordVecsVec.size() + anzXDims);
                    totalSum += sumSoFar;
                    ++p.x;
                }
            }
            if (totalTotalWanted) {
                if (allesSammler != null) {
                    MultiDimDistributor.addTotalCell(allesSammler, null, contents, xCoordVecsVec.size() + anzYDims, yCoordVecsVec.size() + anzXDims);
                } else {
                    MultiDimDistributor.addTotalCell(totalSum, contents, xCoordVecsVec.size() + anzYDims, yCoordVecsVec.size() + anzXDims);
                }
            }
        }
        int colToDelete = MultiDimDistributor.isMDNixVector(xCoordVecsVec) ? anzYDims : -1;
        int n = rowToDelete = MultiDimDistributor.isMDNixVector(yCoordVecsVec) ? anzXDims : -1;
        if (forExcel) {
            PrintElementFactSheet pe4;
            if (withTotalRow && (pe4 = (PrintElementFactSheet)contents.get(new Point(0, yCoordVecsVec.size() + anzXDims))) != null) {
                pe4.ivColspan = -anzYDims;
            }
            if (withTotalCol && (pe4 = (PrintElementFactSheet)contents.get(new Point(xCoordVecsVec.size() + anzYDims, 0))) != null) {
                pe4.ivColspan = -anzXDims;
            }
            MultiDimDistributor.manageNIXModeAndDetermineMax(contents, colToDelete, rowToDelete);
            Vector<PrintElementFactSheet> bag = new Vector<PrintElementFactSheet>(contents.size());
            Iterator iterator = contents.keySet().iterator();
            while (iterator.hasNext()) {
                p = (Point)iterator.next();
                PrintElementFactSheet pe5 = (PrintElementFactSheet)contents.get(p);
                pe5.ivX = p.x;
                pe5.ivY = p.y;
                bag.add(pe5);
            }
            return bag;
        }
        Point maxPoint = MultiDimDistributor.manageNIXModeAndDetermineMax(contents, colToDelete, rowToDelete);
        int cols = maxPoint.x + 1;
        int rows = maxPoint.y + 1;
        int[] widths = MultiDimDistributor.determineColWidths(cols, rows, contents);
        maxCoords[0] = 0;
        origo[0] = 0;
        int i = 0;
        while (i < widths.length) {
            maxCoords[0] = maxCoords[0] + widths[i];
            if (i < anzYDims) {
                origo[0] = origo[0] + widths[i];
            }
            ++i;
        }
        Vector<PrintElementFactSheet> bag = new Vector<PrintElementFactSheet>(contents.size() * 3 / 2);
        int y = 0;
        p.y = 0;
        while (p.y < rows) {
            if (p.y == anzXDims) {
                origo[1] = y;
            }
            x = 0;
            p.x = 0;
            while (p.x < cols) {
                pe = (PrintElementFactSheet)contents.get(p);
                if (pe != null) {
                    pe.ivX = x;
                    pe.ivY = y;
                    pe.ivWidth = widths[p.x];
                    if (pe.ivColspan > 1) {
                        int i2;
                        if (MultiDimDistributor.isColHeader(pe)) {
                            i2 = 1;
                            while (i2 < pe.ivColspan) {
                                pe.ivWidth += widths[p.x + i2];
                                ++i2;
                            }
                        } else {
                            i2 = 1;
                            while (i2 < pe.ivColspan) {
                                pe.ivHeight += lineHeight;
                                ++i2;
                            }
                        }
                    }
                    bag.add(pe);
                }
                x += widths[p.x];
                ++p.x;
            }
            y += lineHeight;
            ++p.y;
        }
        maxCoords[1] = y;
        y = 0;
        p.y = 0;
        while (p.y < rows) {
            int xstart = -1;
            if (p.y == 0) {
                xstart = 0;
            } else {
                int tys = 0;
                int i3 = 0;
                while (i3 <= anzYDims && xstart == -1) {
                    if (contents.get(new Point(i3, p.y)) != null) {
                        xstart = tys;
                    } else {
                        tys += widths[i3];
                    }
                    ++i3;
                }
            }
            if (xstart != -1) {
                int max = maxCoords[0];
                Color col = Color.lightGray;
                float lwidth = 0.1f;
                if (xstart == 0 || y == 0) {
                    lwidth = 0.5f;
                    col = Color.black;
                } else if (withTotalCol && p.y < anzXDims) {
                    max -= widths[widths.length - 1];
                }
                bag.add(PrintElementFactSheet.getLineElement(xstart, y, max, y, col, lwidth));
            }
            y += lineHeight;
            ++p.y;
        }
        bag.add(PrintElementFactSheet.getLineElement(0, y, maxCoords[0], y, Color.black, 0.5f));
        x = 0;
        p.x = 0;
        while (p.x < cols) {
            int ystart = -1;
            if (p.x == 0) {
                ystart = 0;
            } else {
                int txs = 0;
                int i4 = 0;
                while (i4 <= anzXDims && ystart == -1) {
                    if (contents.get(new Point(p.x, i4)) != null) {
                        ystart = txs;
                    } else {
                        txs += lineHeight;
                    }
                    ++i4;
                }
            }
            if (ystart != -1) {
                int max = maxCoords[1];
                float lwidth = 0.1f;
                Color col = Color.lightGray;
                if (ystart == 0 || y == 0) {
                    lwidth = 0.5f;
                    col = Color.black;
                } else if (withTotalRow && p.x < anzYDims) {
                    max -= lineHeight;
                }
                bag.add(PrintElementFactSheet.getLineElement(x, ystart, x, max, col, lwidth));
            }
            x += widths[p.x];
            ++p.x;
        }
        bag.add(PrintElementFactSheet.getLineElement(x, 0, x, maxCoords[1], Color.black, 0.5f));
        if (withTotalRow && (pe = (PrintElementFactSheet)contents.get(new Point(0, yCoordVecsVec.size() + anzXDims))) != null) {
            pe.ivWidth = origo[0];
        }
        if (withTotalCol && (pe = (PrintElementFactSheet)contents.get(new Point(xCoordVecsVec.size() + anzYDims, 0))) != null) {
            pe.ivHeight = origo[1];
        }
        return bag;
    }

    private static Point manageNIXModeAndDetermineMax(HashMap contents, int colToDelete, int rowToDelete) {
        Point max = new Point(0, 0);
        if (colToDelete != -1 || rowToDelete != -1) {
            HashMap<Point, PrintElementFactSheet> tco = new HashMap<Point, PrintElementFactSheet>();
            Iterator iterator = contents.keySet().iterator();
            while (iterator.hasNext()) {
                Point p = (Point)iterator.next();
                PrintElementFactSheet pe = (PrintElementFactSheet)contents.get(p);
                if (colToDelete == -1 && rowToDelete == -1) {
                    tco.put(p, pe);
                    continue;
                }
                if (colToDelete != -1 && rowToDelete == -1) {
                    if (p.x == colToDelete) continue;
                    tco.put(new Point(colToDelete < p.x ? p.x - 1 : p.x, p.y), pe);
                    continue;
                }
                if (colToDelete == -1 && rowToDelete != -1) {
                    if (p.y == rowToDelete) continue;
                    tco.put(new Point(p.x, rowToDelete < p.y ? p.y - 1 : p.y), pe);
                    continue;
                }
                if (colToDelete == -1 || rowToDelete == -1 || p.y == rowToDelete || p.x == colToDelete) continue;
                tco.put(new Point(colToDelete < p.x ? p.x - 1 : p.x, rowToDelete < p.y ? p.y - 1 : p.y), pe);
            }
            contents.clear();
            iterator = tco.keySet().iterator();
            while (iterator.hasNext()) {
                Point tp = (Point)iterator.next();
                if (tp.x > max.x) {
                    max.x = tp.x;
                }
                if (tp.y > max.y) {
                    max.y = tp.y;
                }
                contents.put(tp, tco.get(tp));
            }
        } else {
            Iterator iterator = contents.keySet().iterator();
            while (iterator.hasNext()) {
                Point p = (Point)iterator.next();
                if (p.x > max.x) {
                    max.x = p.x;
                }
                if (p.y <= max.y) continue;
                max.y = p.y;
            }
        }
        return max;
    }

    private static void collectTotals(Point key, int x, int y, HashMap contents, HashMap objectsTarget, Vector allObjects, int objType) {
        block3: {
            PrintElementFactSheet tpe;
            block4: {
                key.x = x;
                key.y = y;
                tpe = (PrintElementFactSheet)contents.get(key);
                if (tpe == null || tpe.ivLink == null || tpe.ivLink.length() == 0) break block3;
                if (objType == 15) break block4;
                Vector v = IDObjectMerker.getObjectsFromLink(tpe.ivLink);
                if (v == null) break block3;
                Iterator iterator2 = v.iterator();
                while (iterator2.hasNext()) {
                    IDObject ido = (IDObject)iterator2.next();
                    objectsTarget.put(ido.getIdentifierString(), ido);
                }
                break block3;
            }
            Vector zv = StringHelper.splitStringByAny(tpe.ivLink, "|");
            Iterator iterator = zv.iterator();
            while (iterator.hasNext()) {
                String link = (String)iterator.next();
                Zeile z = new Zeile(link, ',');
                if (z.size() != 3) continue;
                String group = z.getString(2, "");
                Long id = new Long(z.getLong(1, 0L));
                IDObject ido = null;
                Iterator iterator2 = allObjects.iterator();
                while (iterator2.hasNext() && ido == null) {
                    IDObject tido = (IDObject)iterator2.next();
                    if (!group.equals(tido.get("IDO_GROUP")) || !id.equals(tido.get("IDO_ID"))) continue;
                    ido = tido;
                }
                if (ido == null) continue;
                objectsTarget.put(link, ido);
            }
        }
    }

    private static int collectTotalCount(Point key, int x, int y, HashMap contents, int sumSoFar) {
        key.x = x;
        key.y = y;
        PrintElementFactSheet tpe = (PrintElementFactSheet)contents.get(key);
        if (tpe != null && tpe.ivText != null) {
            String s = tpe.ivText.trim();
            try {
                sumSoFar += Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sumSoFar;
    }

    private static void addTotalCell(HashMap tobjects, Vector v, HashMap contents, int x, int y) {
        if (v == null) {
            v = new Vector();
            if (!tobjects.isEmpty()) {
                v.addAll(tobjects.values());
            }
        }
        if (!v.isEmpty()) {
            PrintElementFactSheet pe = PrintElementFactSheet.getTextElement(0, 0, Integer.toString(v.size()), FactSheet.FETT_FONT, 4, IDObjectMerker.getLink(v, null), 3);
            pe.ivMargin = 3;
            contents.put(new Point(x, y), pe);
        }
    }

    private static void addTotalCell(int sum, HashMap contents, int x, int y) {
        if (sum != 0) {
            PrintElementFactSheet pe = PrintElementFactSheet.getTextElement(0, 0, Integer.toString(sum), FactSheet.FETT_FONT, 4, null, 3);
            pe.ivMargin = 3;
            contents.put(new Point(x, y), pe);
        }
    }

    private static int[] determineColWidths(int cols, int rows, HashMap contents) {
        PrintElementFactSheet pe;
        int[] widths = new int[cols];
        Point p = new Point();
        p.x = 0;
        while (p.x < cols) {
            widths[p.x] = 0;
            p.y = 0;
            while (p.y < rows) {
                pe = (PrintElementFactSheet)contents.get(p);
                if (!(pe == null || pe.ivColspan > 1 && MultiDimDistributor.isColHeader(pe) || pe.ivWidth <= widths[p.x])) {
                    widths[p.x] = pe.ivWidth;
                }
                ++p.y;
            }
            ++p.x;
        }
        p.x = 0;
        while (p.x < cols) {
            p.y = 0;
            while (p.y < rows) {
                pe = (PrintElementFactSheet)contents.get(p);
                if (pe != null && pe.ivColspan > 1 && MultiDimDistributor.isColHeader(pe)) {
                    int vcw = 0;
                    int i = 0;
                    while (i < pe.ivColspan) {
                        vcw += widths[p.x + i];
                        ++i;
                    }
                    if (pe.ivWidth > vcw) {
                        int diff = pe.ivWidth - vcw;
                        int gd = diff / pe.ivColspan;
                        int rd = diff - gd * pe.ivColspan;
                        int i2 = 0;
                        while (i2 < pe.ivColspan) {
                            int n = p.x + i2;
                            widths[n] = widths[n] + gd;
                            if (rd > 0) {
                                int n2 = p.x + i2;
                                widths[n2] = widths[n2] + 1;
                                --rd;
                            }
                            ++i2;
                        }
                    }
                }
                ++p.y;
            }
            ++p.x;
        }
        return widths;
    }

    private static boolean isColHeader(PrintElementFactSheet pe) {
        return pe.ivOrientation == 0;
    }

    private static boolean isMDNixVector(Vector coordsVec) {
        Vector mdKeyVector;
        if (coordsVec.size() == 1 && (mdKeyVector = (Vector)coordsVec.firstElement()).size() == 1) {
            MultiDimAnalyzer.MDKey mdk = (MultiDimAnalyzer.MDKey)mdKeyVector.firstElement();
            return mdk.ivDimTyp == 123456;
        }
        return false;
    }

    private static PrintElementFactSheet gPE(int x, int y, Vector coordsVec, int orientation, HashSet donts) {
        Vector mdKeyVector = (Vector)coordsVec.elementAt(x);
        MultiDimAnalyzer.MDKey mdk = (MultiDimAnalyzer.MDKey)mdKeyVector.elementAt(y);
        int span = 1;
        int tx = x;
        boolean cont = true;
        while (cont) {
            if (MultiDimDistributor.passt(coordsVec, tx, y)) {
                donts.add(new Point(tx + 1, y));
                ++span;
                ++tx;
                continue;
            }
            cont = false;
        }
        PrintElementFactSheet pe = PrintElementFactSheet.getTextElement(0, 0, mdk.toString(), FactSheet.FETT_FONT, null, orientation, 3);
        pe.ivColspan = span;
        return pe;
    }

    private static boolean passt(Vector coordsVec, int x, int y) {
        if (x < coordsVec.size() - 1) {
            Vector v1 = (Vector)coordsVec.elementAt(x);
            Vector v2 = (Vector)coordsVec.elementAt(x + 1);
            int i = 0;
            while (i <= y) {
                MultiDimAnalyzer.MDKey mdk1 = (MultiDimAnalyzer.MDKey)v1.elementAt(i);
                MultiDimAnalyzer.MDKey mdk2 = (MultiDimAnalyzer.MDKey)v2.elementAt(i);
                if (!mdk1.ivKey.equals(mdk2.ivKey)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private static PrintElementFactSheet gPE(MultiDimAnalyzer analyzer, Vector al) {
        Object ooo = analyzer.getVectorDimRes(al, 0);
        if (ooo != null) {
            Integer anz;
            if (ooo instanceof Vector) {
                Vector v = (Vector)ooo;
                if (v != null && !v.isEmpty()) {
                    PrintElementFactSheet pe = PrintElementFactSheet.getTextElement(0, 0, Integer.toString(v.size()), FactSheet.FETT_FONT, 4, IDObjectMerker.getLink(v, null), 3);
                    pe.ivMargin = 3;
                    return pe;
                }
            } else if (ooo instanceof Integer && (anz = (Integer)ooo) != 0) {
                PrintElementFactSheet pe = PrintElementFactSheet.getTextElement(0, 0, Integer.toString(anz), FactSheet.FETT_FONT, 4, null, 3);
                pe.ivMargin = 3;
                return pe;
            }
        }
        return null;
    }
}

