/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets.multidimreport;

import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectStoreClient;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import mausoleum.alert.Alert;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.factsheets.multidimreport.FSCompScreenMD;
import mausoleum.factsheets.multidimreport.MultiDimAnalyzer;
import mausoleum.factsheets.multidimreport.MultiDimDistributor;
import mausoleum.factsheets.multidimreport.MultidimSettings;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.dnd.DNDHandler;
import mausoleum.helper.FileHelper;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.helper.MFF;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.helper.Zeile;
import mausoleum.main.MausoleumClient;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.models.MTCageMultiDim;
import mausoleum.tables.models.MTMouseMultiDim;
import mausoleum.task.TaskTreeNode;
import mausoleum.ui.UIDef;
import mausoleum.util.GeneralSetting;

public class MultiDimReportFrame
extends JFrame {
    private static final long serialVersionUID = 1234L;
    private static final int LISTS_HEIGHT = UIDef.getScaled(200);
    private static final Vector OPEN_FRAMES = new Vector();
    private final int ivObjectType;
    private final int ivCageMode;
    private final Vector ivAllIDObjects = new Vector();
    public JList ivSettingsList = new JList();
    public JScrollPane ivSettingsPane = new JScrollPane(this.ivSettingsList);
    private final MausoleumTableModel ivMTModel;
    private final MausoleumTable ivTable;
    private final FSCompScreenMD ivFactSheetComp;
    private final Vector ivXCoordVecsVec = new Vector();
    private final Vector ivYCoordVecsVec = new Vector();
    private MultiDimAnalyzer ivLastUsedAnalyzer = null;
    private final JList ivAllList;
    private final JList ivXDimensionList = new JList();
    private final JList ivYDimensionList = new JList();
    private final JList ivXValueList = new JList();
    private final JList ivYValueList = new JList();
    private final int[] ivMaxCoords = new int[2];
    private final int[] ivOrigo = new int[2];
    private final JLabel ivObjectLabel = new JLabel();
    private final JLabel ivKeyLabel = new JLabel();
    private final MGButton ivResetButton = new MGButton(Babel.get("MDRF_RESET"));
    private final MGButton ivToColumnButton = new MGButton(Babel.get("MDRF_TO_COLUMN"));
    private final MGButton ivToRowButton = new MGButton(Babel.get("MDRF_TO_ROW"));
    private final MGButton ivRemoveButton = new MGButton(Babel.get("MDRF_REMOVE"));
    private final MGButton ivUpButton = new MGButton(Babel.get("MDRF_UP"));
    private final MGButton ivDownButton = new MGButton(Babel.get("MDRF_DOWN"));
    private final MGButton ivSubTotalButton = new MGButton(Babel.get("MDRF_SUBTOTAL"));
    private final MGButton ivSwitchButton = new MGButton(Babel.get("MDRF_SWITCH"));
    private final JCheckBox ivTotalColBox = new JCheckBox(Babel.get("MDRF_ADD_TOTAL_COL"));
    private final JCheckBox ivTotalRowBox = new JCheckBox(Babel.get("MDRF_ADD_TOTAL_ROW"));
    public MGButton ivSaveDefButton = new MGButton(Babel.get("FST_SAVE_DEF"));
    public MGButton ivLoadDefButton = new MGButton(Babel.get("FST_LOAD_DEF"));
    public MGButton ivDeletedDefButton = new MGButton(Babel.get("FST_DELETE_DEF"));
    private JLabel ivListLabel = new JLabel();
    private boolean ivReact = true;
    private HashSet ivNONOKeys = new HashSet();
    private String ivObjectCollectionTicket = null;
    private final ActionListener ivAdaptListener = new ActionListener(){

        public void actionPerformed(ActionEvent arg0) {
            MultiDimReportFrame.this.definitionsChanged();
        }
    };
    private ListCellRenderer ivDimensionListRenderer = new ListCellRenderer(){

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MultiDimAnalyzer.MDTypeObject to = (MultiDimAnalyzer.MDTypeObject)value;
            if (list == MultiDimReportFrame.this.ivAllList) {
                MultiDimReportFrame.this.ivObjectLabel.setIcon(null);
            } else {
                boolean subtotal = value instanceof MultiDimAnalyzer.MDTypeObject && ((MultiDimAnalyzer.MDTypeObject)value).ivWithTotal;
                MultiDimReportFrame.this.ivObjectLabel.setIcon(subtotal ? ImageProvider.SUM_ICON : ImageProvider.EMPTY_SUM_ICON);
            }
            if (isSelected) {
                MultiDimReportFrame.this.ivObjectLabel.setOpaque(true);
                MultiDimReportFrame.this.ivObjectLabel.setBackground(UIDef.SELECTED_BACKGROUND);
            } else {
                MultiDimReportFrame.this.ivObjectLabel.setOpaque(false);
                MultiDimReportFrame.this.ivObjectLabel.setBackground(null);
            }
            boolean hatNonos = false;
            Iterator iterator = MultiDimReportFrame.this.ivNONOKeys.iterator();
            while (iterator.hasNext() && !hatNonos) {
                MultiDimAnalyzer.MDKey key = (MultiDimAnalyzer.MDKey)iterator.next();
                if (key.ivDimTyp != to.ivType) continue;
                hatNonos = true;
            }
            MultiDimReportFrame.this.ivObjectLabel.setText(" " + (hatNonos ? "\u2022 " : "") + value.toString() + " ");
            MultiDimReportFrame.this.ivObjectLabel.setForeground(hatNonos ? UIDef.CHANGED_BACKGROUND : Color.black);
            return MultiDimReportFrame.this.ivObjectLabel;
        }
    };
    private ListCellRenderer ivValueListRenderer = new ListCellRenderer(){

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MultiDimAnalyzer.MDKey key = (MultiDimAnalyzer.MDKey)value;
            if (MultiDimReportFrame.this.ivNONOKeys.contains(key)) {
                MultiDimReportFrame.this.ivKeyLabel.setIcon(ImageProvider.CLEAR_BULLET_ICON);
                MultiDimReportFrame.this.ivKeyLabel.setFont(FontManager.getFont("SSP11"));
            } else {
                MultiDimReportFrame.this.ivKeyLabel.setIcon(ImageProvider.getBulletIcon(Color.green));
                MultiDimReportFrame.this.ivKeyLabel.setFont(FontManager.getFont("SSB11"));
            }
            MultiDimReportFrame.this.ivKeyLabel.setText(" " + key.toString() + " ");
            if (isSelected) {
                MultiDimReportFrame.this.ivKeyLabel.setOpaque(true);
                MultiDimReportFrame.this.ivKeyLabel.setBackground(UIDef.SELECTED_BACKGROUND);
            } else {
                MultiDimReportFrame.this.ivKeyLabel.setOpaque(false);
                MultiDimReportFrame.this.ivKeyLabel.setBackground(null);
            }
            return MultiDimReportFrame.this.ivKeyLabel;
        }
    };

    public static void closeOpenFrames() {
        Vector v = new Vector(OPEN_FRAMES);
        Iterator iterator = v.iterator();
        while (iterator.hasNext()) {
            MultiDimReportFrame mdf = (MultiDimReportFrame)iterator.next();
            mdf.setVisible(false);
            mdf.dispose();
        }
    }

    public MultiDimReportFrame(Vector idObjects, int objectType, int cageType, String objectCollectionTicket) {
        Vector v;
        boolean isNormalModeWithTable;
        this.ivObjectType = objectType;
        this.ivCageMode = cageType;
        this.ivObjectCollectionTicket = objectCollectionTicket;
        boolean bl = isNormalModeWithTable = !this.isForDeadObjects() && (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker());
        if (isNormalModeWithTable) {
            if (idObjects == null) {
                if (objectType == 15) {
                    v = new Vector();
                    TaskTreeNode.PENDING.collectTasks(v);
                    this.ivAllIDObjects.addAll(v);
                } else {
                    ObjectManager om = ObjectStoreClient.getManager(this.ivObjectType);
                    if (om != null) {
                        if (objectType == 2) {
                            MultiDimAnalyzer.fetchCageBaseSet(om.getActualObjectVectorAllGroups(), this.ivAllIDObjects, cageType);
                        } else {
                            this.ivAllIDObjects.addAll(om.getActualObjectVectorAllGroups());
                        }
                    }
                }
            } else {
                this.ivAllIDObjects.addAll(idObjects);
            }
        }
        this.setBigTitle(objectType, idObjects != null);
        this.setIconImage(MausoleumImageStore.getLogo());
        v = MultiDimAnalyzer.getAllTypeObjects(this.ivObjectType, this.isForDeadObjects());
        this.ivAllList = new JList(v == null ? new Vector() : v);
        MausoleumTableModel model = null;
        if (isNormalModeWithTable) {
            switch (this.ivObjectType) {
                case 1: {
                    model = new MTMouseMultiDim();
                    break;
                }
                case 2: {
                    model = new MTCageMultiDim();
                    break;
                }
            }
        }
        this.ivMTModel = model;
        if (this.ivMTModel != null) {
            this.ivTable = new MausoleumTable(this.ivMTModel, false);
            this.ivTable.setIsSubdisplay();
            this.ivTable.setHeader("");
            this.ivMTModel.setTable(ArrayHelper.LEER);
            this.ivTable.setOwnerButtonState(true);
        } else {
            this.ivTable = null;
        }
        this.ivFactSheetComp = new FSCompScreenMD(this.ivMTModel);
        this.ivFactSheetComp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (arg0.getActionCommand().equals("EXCEL")) {
                    MultiDimReportFrame.this.exportToExcel();
                }
            }
        });
        this.ivObjectLabel.setFont(FontManager.getFont("SSB12"));
        RequesterPane jp = new RequesterPane(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
        JSplitPane asplit = new JSplitPane(0, this.prepareLists(), this.ivFactSheetComp.ivPanel);
        asplit.setResizeWeight(0.4);
        jp.add("Center", asplit);
        if (this.ivTable != null) {
            JSplitPane split = new JSplitPane(0, jp, this.ivTable.ivScrollPane);
            split.setResizeWeight(0.8);
            this.getContentPane().add(split);
        } else {
            this.getContentPane().add(jp);
        }
        this.setBounds(UIDef.getScaled(10), UIDef.getScaled(10), UIDef.getScaled(860), UIDef.getScaled(500));
        this.setVisible(true);
        if (this.ivObjectCollectionTicket != null) {
            new Thread(new Runnable(){

                public void run() {
                    while (MultiDimReportFrame.this.ivObjectCollectionTicket != null) {
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (MultiDimReportFrame.this.ivObjectCollectionTicket == null) continue;
                        RequestManager.createSendAndGetAnswer((byte)86, "REFRESH", UserManager.getFirstGroup(), MultiDimReportFrame.this.ivObjectCollectionTicket);
                    }
                }
            }).start();
        }
        OPEN_FRAMES.add(this);
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            OPEN_FRAMES.remove(this);
            if (this.ivObjectCollectionTicket != null) {
                RequestManager.createSendAndGetAnswer((byte)86, "RELASE", UserManager.getFirstGroup(), this.ivObjectCollectionTicket);
                this.ivObjectCollectionTicket = null;
            }
        }
        super.setVisible(visible);
    }

    private boolean isForDeadObjects() {
        return this.ivObjectCollectionTicket != null;
    }

    private void setBigTitle(int objectType, boolean teilmenge) {
        String title = null;
        if (teilmenge) {
            title = String.valueOf(Babel.get("MULTIDIM_ANALYSIS")) + " [" + (objectType == 1 ? Babel.get("MICE_SUBSET") : Babel.get("CAGE_SUBSET")) + "]";
        } else {
            StringBuilder msb = new StringBuilder();
            msb.append(Babel.get("MULTIDIM_ANALYSIS")).append(" [");
            if (objectType == 1) {
                msb.append(Babel.get("ALL")).append(" ").append(Babel.get("MICE"));
            } else if (objectType == 15) {
                msb.append(Babel.get("ALL")).append(" ").append(Babel.get("TASKS"));
            } else {
                msb.append(StringHelper.getStringForInt(this.ivCageMode, MultiDimAnalyzer.CAGE_MODE_INTS, MultiDimAnalyzer.CAGE_MODE_STRINGS, false, "?"));
            }
            msb.append("]");
            title = msb.toString();
        }
        this.setTitle(title);
    }

    private JPanel prepareLists() {
        this.ivAllList.setCellRenderer(this.ivDimensionListRenderer);
        this.ivXDimensionList.setCellRenderer(this.ivDimensionListRenderer);
        this.ivYDimensionList.setCellRenderer(this.ivDimensionListRenderer);
        this.ivAllList.setSelectionMode(0);
        this.ivXDimensionList.setSelectionMode(0);
        this.ivYDimensionList.setSelectionMode(0);
        this.ivAllList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (MultiDimReportFrame.this.ivReact) {
                    MultiDimReportFrame.this.ivReact = false;
                    MultiDimReportFrame.this.ivXDimensionList.clearSelection();
                    MultiDimReportFrame.this.ivXValueList.setListData(ArrayHelper.LEER);
                    MultiDimReportFrame.this.ivYDimensionList.clearSelection();
                    MultiDimReportFrame.this.ivYValueList.setListData(ArrayHelper.LEER);
                    MultiDimReportFrame.this.ivReact = true;
                    MultiDimReportFrame.this.adaptButtons();
                }
            }
        });
        this.ivXDimensionList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (MultiDimReportFrame.this.ivReact) {
                    MultiDimReportFrame.this.ivReact = false;
                    MultiDimReportFrame.this.ivAllList.clearSelection();
                    MultiDimReportFrame.this.ivYDimensionList.clearSelection();
                    MultiDimReportFrame.this.ivYValueList.setListData(ArrayHelper.LEER);
                    MultiDimReportFrame.this.ivReact = true;
                    MultiDimReportFrame.this.dimensionListSelected(true, MultiDimReportFrame.this.ivXDimensionList.getSelectedIndex());
                    MultiDimReportFrame.this.adaptButtons();
                }
            }
        });
        this.ivYDimensionList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (MultiDimReportFrame.this.ivReact) {
                    MultiDimReportFrame.this.ivReact = false;
                    MultiDimReportFrame.this.ivXDimensionList.clearSelection();
                    MultiDimReportFrame.this.ivXValueList.setListData(ArrayHelper.LEER);
                    MultiDimReportFrame.this.ivAllList.clearSelection();
                    MultiDimReportFrame.this.ivReact = true;
                    MultiDimReportFrame.this.dimensionListSelected(false, MultiDimReportFrame.this.ivYDimensionList.getSelectedIndex());
                    MultiDimReportFrame.this.adaptButtons();
                }
            }
        });
        new DNDHandler(this.ivAllList, new JList[]{this.ivXDimensionList, this.ivYDimensionList}, this.ivAdaptListener, null);
        this.ivXValueList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getClickCount() == 2) {
                    MultiDimReportFrame.this.changeNonoByDoubleClick(MultiDimReportFrame.this.ivXValueList, MultiDimReportFrame.this.ivXDimensionList);
                }
            }

            public void mousePressed(MouseEvent e) {
                JPopupMenu menu;
                if (e.isMetaDown() && (menu = MultiDimReportFrame.this.getPopuMenuForValueList(true)) != null) {
                    JComponent comp = (JComponent)e.getSource();
                    menu.show(comp, e.getX(), e.getY());
                }
            }
        });
        this.ivXValueList.setSelectionMode(2);
        this.ivXValueList.setBackground(UIDef.BACKGROUND_LIGHT_SUB);
        this.ivXValueList.setCellRenderer(this.ivValueListRenderer);
        this.ivYValueList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getClickCount() == 2) {
                    MultiDimReportFrame.this.changeNonoByDoubleClick(MultiDimReportFrame.this.ivYValueList, MultiDimReportFrame.this.ivYDimensionList);
                }
            }

            public void mousePressed(MouseEvent e) {
                JPopupMenu menu;
                if (e.isMetaDown() && (menu = MultiDimReportFrame.this.getPopuMenuForValueList(false)) != null) {
                    JComponent comp = (JComponent)e.getSource();
                    menu.show(comp, e.getX(), e.getY());
                }
            }
        });
        this.ivXValueList.setSelectionMode(2);
        this.ivYValueList.setBackground(UIDef.BACKGROUND_LIGHT_SUB);
        this.ivYValueList.setCellRenderer(this.ivValueListRenderer);
        this.ivTotalColBox.setSelected(true);
        this.ivTotalColBox.addActionListener(this.ivAdaptListener);
        this.ivTotalRowBox.setSelected(true);
        this.ivTotalRowBox.addActionListener(this.ivAdaptListener);
        JPanel listenPanel = new JPanel(new GridLayout(1, 3, UIDef.INNER_RAND, UIDef.INNER_RAND));
        listenPanel.setOpaque(false);
        JPanel knopfPanel = new JPanel(new GridLayout(1, 8, UIDef.INNER_RAND, UIDef.INNER_RAND));
        JPanel settingsPanel = new JPanel(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
        JPanel rechtsPanel = new JPanel(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
        JPanel obenPanel = new JPanel(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
        obenPanel.setPreferredSize(new Dimension(UIDef.getScaled(2000), LISTS_HEIGHT));
        obenPanel.setOpaque(false);
        rechtsPanel.setOpaque(false);
        rechtsPanel.setBorder(UIDef.getTitleBorder("CRITERIA"));
        rechtsPanel.add("Center", listenPanel);
        rechtsPanel.add("South", knopfPanel);
        settingsPanel.setPreferredSize(new Dimension(UIDef.getScaled(180), UIDef.getScaled(200)));
        obenPanel.add("West", settingsPanel);
        rechtsPanel.setPreferredSize(new Dimension(UIDef.getScaled(600), UIDef.getScaled(200)));
        obenPanel.add("Center", rechtsPanel);
        settingsPanel.setOpaque(false);
        settingsPanel.add("Center", this.ivSettingsPane);
        settingsPanel.setBorder(UIDef.getTitleBorder("FST_STORED_DEFINITIONS"));
        JPanel settingsKnopfPanel = new JPanel(new GridLayout(3, 1, UIDef.INNER_RAND, UIDef.INNER_RAND));
        settingsKnopfPanel.setOpaque(false);
        settingsPanel.add("South", settingsKnopfPanel);
        settingsKnopfPanel.add(this.ivSaveDefButton);
        settingsKnopfPanel.add(this.ivLoadDefButton);
        settingsKnopfPanel.add(this.ivDeletedDefButton);
        this.ivSettingsList.setSelectionMode(0);
        this.ivSettingsList.setListData(MultidimSettings.getSettings(this.ivObjectType));
        this.ivSettingsList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                boolean sel = MultiDimReportFrame.this.ivSettingsList.getSelectedIndex() != -1;
                MultiDimReportFrame.this.ivDeletedDefButton.setEnabled(sel);
                MultiDimReportFrame.this.ivLoadDefButton.setEnabled(sel);
            }
        });
        this.ivSettingsList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && MultiDimReportFrame.this.ivLoadDefButton != null && MultiDimReportFrame.this.ivLoadDefButton.isEnabled()) {
                    MultiDimReportFrame.this.loadSetting();
                }
            }
        });
        this.ivSettingsList.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int row, boolean isSelected, boolean hasFocus) {
                Font font = FontManager.getTableFont(true, true, 1.0);
                GeneralSetting ss = (GeneralSetting)value;
                MultiDimReportFrame.this.ivListLabel.setText(" " + ss.ivName + " ");
                MultiDimReportFrame.this.ivListLabel.setFont(font);
                MultiDimReportFrame.this.ivListLabel.setOpaque(isSelected);
                return MultiDimReportFrame.this.ivListLabel;
            }
        });
        this.ivListLabel.setBackground(UIDef.SELECTED_BACKGROUND);
        this.ivSaveDefButton.setImage("blueButton");
        this.ivLoadDefButton.setImage("blueButton");
        this.ivDeletedDefButton.setImage("blueButton");
        this.ivSaveDefButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MultidimSettings.saveAktSetting(MultiDimReportFrame.this.ivObjectType, WindowUtils.getJFrame(MultiDimReportFrame.this.ivSaveDefButton), MultiDimReportFrame.this.getTransportString());
                MultiDimReportFrame.this.ivSettingsList.setListData(MultidimSettings.getSettings(MultiDimReportFrame.this.ivObjectType));
                MultiDimReportFrame.this.ivSettingsList.repaint();
            }
        });
        this.ivLoadDefButton.setEnabled(false);
        this.ivLoadDefButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MultiDimReportFrame.this.loadSetting();
            }
        });
        this.ivDeletedDefButton.setEnabled(false);
        this.ivDeletedDefButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                GeneralSetting ss = (GeneralSetting)MultiDimReportFrame.this.ivSettingsList.getSelectedValue();
                if (ss != null) {
                    MultidimSettings.deleteSetting(MultiDimReportFrame.this.ivObjectType, ss);
                    MultiDimReportFrame.this.ivSettingsList.setListData(MultidimSettings.getSettings(MultiDimReportFrame.this.ivObjectType));
                    MultiDimReportFrame.this.ivSettingsList.repaint();
                }
            }
        });
        this.makeCritPanel(this.ivAllList, null, "AVAILABLECRITERIA", listenPanel, null);
        this.makeCritPanel(this.ivXDimensionList, this.ivXValueList, "COLUMN_CRITERIA", listenPanel, this.ivTotalColBox);
        this.makeCritPanel(this.ivYDimensionList, this.ivYValueList, "ROW_CRITERIA", listenPanel, this.ivTotalRowBox);
        this.ivResetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Vector v = MultiDimAnalyzer.getAllTypeObjects(MultiDimReportFrame.this.ivObjectType, MultiDimReportFrame.this.isForDeadObjects());
                MultiDimReportFrame.this.ivAllList.setListData(v != null ? v : new Vector());
                MultiDimReportFrame.this.ivXDimensionList.setListData(ArrayHelper.LEER);
                MultiDimReportFrame.this.ivYDimensionList.setListData(ArrayHelper.LEER);
                MultiDimReportFrame.this.definitionsChanged();
            }
        });
        knopfPanel.add(this.ivResetButton);
        this.ivToColumnButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (!MultiDimReportFrame.this.haengeUm(MultiDimReportFrame.this.ivAllList, MultiDimReportFrame.this.ivXDimensionList)) {
                    MultiDimReportFrame.this.haengeUm(MultiDimReportFrame.this.ivYDimensionList, MultiDimReportFrame.this.ivXDimensionList);
                }
            }
        });
        knopfPanel.add(this.ivToColumnButton);
        this.ivToRowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (!MultiDimReportFrame.this.haengeUm(MultiDimReportFrame.this.ivAllList, MultiDimReportFrame.this.ivYDimensionList)) {
                    MultiDimReportFrame.this.haengeUm(MultiDimReportFrame.this.ivXDimensionList, MultiDimReportFrame.this.ivYDimensionList);
                }
            }
        });
        knopfPanel.add(this.ivToRowButton);
        this.ivRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (!MultiDimReportFrame.this.haengeUm(MultiDimReportFrame.this.ivYDimensionList, MultiDimReportFrame.this.ivAllList)) {
                    MultiDimReportFrame.this.haengeUm(MultiDimReportFrame.this.ivXDimensionList, MultiDimReportFrame.this.ivAllList);
                }
            }
        });
        knopfPanel.add(this.ivRemoveButton);
        this.ivUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MultiDimReportFrame.this.up(MultiDimReportFrame.this.ivXDimensionList);
                MultiDimReportFrame.this.up(MultiDimReportFrame.this.ivYDimensionList);
            }
        });
        knopfPanel.add(this.ivUpButton);
        this.ivDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MultiDimReportFrame.this.down(MultiDimReportFrame.this.ivXDimensionList);
                MultiDimReportFrame.this.down(MultiDimReportFrame.this.ivYDimensionList);
            }
        });
        knopfPanel.add(this.ivDownButton);
        this.ivSubTotalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MultiDimReportFrame.this.subtotal(MultiDimReportFrame.this.ivXDimensionList);
                MultiDimReportFrame.this.subtotal(MultiDimReportFrame.this.ivYDimensionList);
            }
        });
        knopfPanel.add(this.ivSubTotalButton);
        this.ivSwitchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Vector tyv = MultiDimReportFrame.getElements(MultiDimReportFrame.this.ivXDimensionList);
                Vector txv = MultiDimReportFrame.getElements(MultiDimReportFrame.this.ivYDimensionList);
                MultiDimReportFrame.this.ivXDimensionList.setListData(txv);
                MultiDimReportFrame.this.ivYDimensionList.setListData(tyv);
                MultiDimReportFrame.this.definitionsChanged();
            }
        });
        knopfPanel.add(this.ivSwitchButton);
        this.adaptButtons();
        knopfPanel.setOpaque(false);
        return obenPanel;
    }

    private void loadSetting() {
        GeneralSetting ss = (GeneralSetting)this.ivSettingsList.getSelectedValue();
        if (ss != null) {
            Vector v = MultiDimAnalyzer.getAllTypeObjects(this.ivObjectType, this.isForDeadObjects());
            this.ivAllList.setListData(v != null ? v : new Vector());
            this.ivXDimensionList.setListData(ArrayHelper.LEER);
            this.ivYDimensionList.setListData(ArrayHelper.LEER);
            this.adjustToTransport(ss.ivPayload);
        }
    }

    private void makeCritPanel(JList list, JList keyList, String labelBabel, JPanel target, JCheckBox box) {
        JPanel pan = new JPanel(new BorderLayout());
        pan.setOpaque(false);
        pan.add("North", new MGButton(Babel.get(labelBabel), true));
        if (keyList != null) {
            JSplitPane subPanel = new JSplitPane(1);
            subPanel.setResizeWeight(0.5);
            subPanel.setOpaque(false);
            subPanel.add(new JScrollPane(list));
            subPanel.add(new JScrollPane(keyList));
            pan.add("Center", subPanel);
        } else {
            pan.add("Center", new JScrollPane(list));
        }
        if (box != null) {
            box.setOpaque(false);
            box.setFocusPainted(false);
            box.setFont(FontManager.getFont("SSB11"));
            pan.add("South", box);
        }
        target.add(pan);
    }

    private static Vector getElements(JList list) {
        Vector erg = new Vector();
        ListModel model = list.getModel();
        int i = 0;
        while (i < model.getSize()) {
            erg.addElement(model.getElementAt(i));
            ++i;
        }
        return erg;
    }

    private boolean haengeUm(JList source, JList target) {
        int xSel = source.getSelectedIndex();
        if (xSel != -1) {
            Vector sv = MultiDimReportFrame.getElements(source);
            Vector tv = MultiDimReportFrame.getElements(target);
            if (target == this.ivAllList) {
                ((MultiDimAnalyzer.MDTypeObject)sv.elementAt((int)xSel)).ivWithTotal = false;
            }
            tv.addElement(sv.elementAt(xSel));
            sv.removeElementAt(xSel);
            source.setListData(sv);
            if (target == this.ivAllList) {
                Collections.sort(tv);
            }
            target.setListData(tv);
            this.definitionsChanged();
            return true;
        }
        return false;
    }

    private void subtotal(JList list) {
        MultiDimAnalyzer.MDTypeObject mto = (MultiDimAnalyzer.MDTypeObject)list.getSelectedValue();
        if (mto != null) {
            mto.ivWithTotal = !mto.ivWithTotal;
            this.definitionsChanged();
            list.repaint();
        }
    }

    private void up(JList list) {
        int xSel = list.getSelectedIndex();
        if (xSel > 0) {
            Vector sv = MultiDimReportFrame.getElements(list);
            Object ooo = sv.elementAt(xSel);
            sv.removeElementAt(xSel);
            sv.insertElementAt(ooo, xSel - 1);
            list.setListData(sv);
            list.setSelectedIndex(xSel - 1);
            this.definitionsChanged();
            this.dimensionListSelected(list == this.ivXDimensionList, list.getSelectedIndex());
        }
    }

    private void down(JList list) {
        Vector sv;
        int xSel = list.getSelectedIndex();
        if (xSel >= 0 && xSel < (sv = MultiDimReportFrame.getElements(list)).size() - 1) {
            Object ooo = sv.elementAt(xSel);
            sv.removeElementAt(xSel);
            sv.insertElementAt(ooo, xSel + 1);
            list.setListData(sv);
            list.setSelectedIndex(xSel + 1);
            this.definitionsChanged();
            this.dimensionListSelected(list == this.ivXDimensionList, list.getSelectedIndex());
        }
    }

    private void definitionsChanged() {
        boolean serviceMode = MausoleumClient.isHeadOfService() || this.ivObjectCollectionTicket != null;
        this.ivLastUsedAnalyzer = MultiDimDistributor.distribute(serviceMode ? null : this.ivAllIDObjects, this.ivXCoordVecsVec, this.ivYCoordVecsVec, this.getTypes(this.ivXDimensionList, this.oneListUsed()), this.getTypes(this.ivYDimensionList, this.oneListUsed()), serviceMode, this.ivObjectType, this.ivCageMode, this.ivObjectCollectionTicket);
        this.changePrintElements();
        this.adaptButtons();
    }

    private void changePrintElements() {
        if (this.ivLastUsedAnalyzer != null) {
            Vector xcoord = this.removeUnwantedCriteria(this.ivXCoordVecsVec);
            Vector ycoord = this.removeUnwantedCriteria(this.ivYCoordVecsVec);
            this.removeEmptyRowsAndColumns(xcoord, ycoord);
            boolean restricted = xcoord.size() != this.ivXCoordVecsVec.size() || ycoord.size() != this.ivYCoordVecsVec.size();
            boolean regularClientMode = this.ivObjectCollectionTicket == null && (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker());
            this.ivFactSheetComp.setBackground(restricted ? UIDef.BACKGROUND_RESTRICTED : Color.white);
            this.ivFactSheetComp.setElements(MultiDimDistributor.createElements(xcoord, ycoord, this.ivLastUsedAnalyzer, this.getTypes(this.ivXDimensionList, this.oneListUsed()), this.getTypes(this.ivYDimensionList, this.oneListUsed()), this.ivMaxCoords, this.ivOrigo, this.wantsTotal(true), this.wantsTotal(false), regularClientMode, false, this.ivAllIDObjects, this.ivObjectType), this.ivMaxCoords, this.ivOrigo);
        } else {
            this.ivFactSheetComp.setBackground(Color.white);
            this.ivFactSheetComp.setElements(ArrayHelper.LEER, this.ivMaxCoords, this.ivOrigo);
        }
    }

    private boolean wantsTotal(boolean forCol) {
        if (forCol) {
            return this.ivTotalColBox.isSelected() || this.oneListUsed() && this.ivXDimensionList.getModel().getSize() == 0;
        }
        return this.ivTotalRowBox.isSelected() || this.oneListUsed() && this.ivYDimensionList.getModel().getSize() == 0;
    }

    private void exportToExcel() {
        if (this.ivLastUsedAnalyzer != null) {
            Vector xcoord = this.removeUnwantedCriteria(this.ivXCoordVecsVec);
            Vector ycoord = this.removeUnwantedCriteria(this.ivYCoordVecsVec);
            this.removeEmptyRowsAndColumns(xcoord, ycoord);
            if (xcoord.size() >= 255 || ycoord.size() >= 65535) {
                Alert.showAlert(Babel.get("EXPORT_TABLE_TOO_BIG"), true);
                return;
            }
            File file = FileHelper.selectFile(this, Babel.get("SELECT_OUTPUT_FILE"), true, MFF.getFilter(2), null);
            if (file != null) {
                int[] xtypes = this.getTypes(this.ivXDimensionList, this.oneListUsed());
                int[] ytypes = this.getTypes(this.ivYDimensionList, this.oneListUsed());
                Vector elements = MultiDimDistributor.createElements(xcoord, ycoord, this.ivLastUsedAnalyzer, xtypes, ytypes, this.ivMaxCoords, this.ivOrigo, this.wantsTotal(true), this.wantsTotal(false), MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker(), true, this.ivAllIDObjects, this.ivObjectType);
                try {
                    WritableWorkbook workbook = Workbook.createWorkbook(file);
                    WritableSheet sheet = workbook.createSheet("MD-Analysis", 0);
                    WritableCellFormat centerFormat = new WritableCellFormat();
                    centerFormat.setAlignment(Alignment.CENTRE);
                    centerFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
                    centerFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
                    centerFormat.setBackground(Colour.IVORY);
                    WritableCellFormat leftFormat = new WritableCellFormat();
                    leftFormat.setAlignment(Alignment.LEFT);
                    leftFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
                    leftFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
                    leftFormat.setBackground(Colour.IVORY);
                    WritableCellFormat rightFormat = new WritableCellFormat();
                    rightFormat.setAlignment(Alignment.RIGHT);
                    rightFormat.setVerticalAlignment(VerticalAlignment.CENTRE);
                    rightFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
                    rightFormat.setBackground(Colour.VERY_LIGHT_YELLOW);
                    WritableCellFormat emptyFormat = new WritableCellFormat();
                    emptyFormat.setBorder(Border.ALL, BorderLineStyle.THIN);
                    emptyFormat.setBackground(Colour.GRAY_25);
                    int maxx = 0;
                    int maxy = 0;
                    HashSet<Point> da = new HashSet<Point>(elements.size() * 3 / 2);
                    Iterator iterator = elements.iterator();
                    while (iterator.hasNext()) {
                        PrintElementFactSheet pe = (PrintElementFactSheet)iterator.next();
                        maxx = pe.ivX > maxx ? pe.ivX : maxx;
                        maxy = pe.ivY > maxy ? pe.ivY : maxy;
                        da.add(new Point(pe.ivX, pe.ivY));
                        if (pe.ivOrientation == 4) {
                            sheet.addCell(new Number(pe.ivX, pe.ivY, Double.parseDouble(pe.ivText), (CellFormat)rightFormat));
                            continue;
                        }
                        if (pe.ivOrientation == 2) {
                            sheet.addCell(new Label(pe.ivX, pe.ivY, pe.ivText, (CellFormat)leftFormat));
                            if (pe.ivColspan > 1) {
                                sheet.mergeCells(pe.ivX, pe.ivY, pe.ivX, pe.ivY + pe.ivColspan - 1);
                                continue;
                            }
                            if (pe.ivColspan >= 1) continue;
                            sheet.mergeCells(pe.ivX, pe.ivY, pe.ivX - pe.ivColspan - 1, pe.ivY);
                            continue;
                        }
                        if (pe.ivOrientation != 0) continue;
                        sheet.addCell(new Label(pe.ivX, pe.ivY, pe.ivText, (CellFormat)centerFormat));
                        if (pe.ivColspan > 1) {
                            sheet.mergeCells(pe.ivX, pe.ivY, pe.ivX + pe.ivColspan - 1, pe.ivY);
                            continue;
                        }
                        if (pe.ivColspan >= 1) continue;
                        sheet.mergeCells(pe.ivX, pe.ivY, pe.ivX, pe.ivY - pe.ivColspan - 1);
                    }
                    Point p = new Point();
                    p.y = xtypes.length;
                    while (p.y < maxy) {
                        p.x = ytypes.length;
                        while (p.x < maxx) {
                            if (!da.contains(p)) {
                                sheet.addCell(new Label(p.x, p.y, "", (CellFormat)emptyFormat));
                            }
                            ++p.x;
                        }
                        ++p.y;
                    }
                    sheet.getSettings().setHorizontalFreeze(xtypes.length);
                    sheet.getSettings().setVerticalFreeze(ytypes.length);
                    workbook.write();
                    workbook.close();
                    String s = StringHelper.gSub(Babel.get("EXPORT_SUCCESSFUL"), "_FILE_", file.getName(), true);
                    Alert.showAlert(s, true);
                }
                catch (Exception e) {
                    String s = StringHelper.gSub(Babel.get("EXPORT_CRASHED"), "_FILE_", file.getName(), true);
                    Alert.showAlert(s, true);
                }
            }
        }
    }

    private void adaptButtons() {
        int aSel = this.ivAllList.getSelectedIndex();
        int xSel = this.ivXDimensionList.getSelectedIndex();
        int ySel = this.ivYDimensionList.getSelectedIndex();
        this.ivToColumnButton.setEnabled(aSel != -1 || ySel != -1);
        this.ivToRowButton.setEnabled(aSel != -1 || xSel != -1);
        this.ivRemoveButton.setEnabled(xSel != -1 || ySel != -1);
        int siz = -1;
        int sel = -1;
        if (xSel != -1) {
            siz = this.ivXDimensionList.getModel().getSize();
            sel = xSel;
        } else if (ySel != -1) {
            siz = this.ivYDimensionList.getModel().getSize();
            sel = ySel;
        }
        if (siz < 2) {
            this.ivUpButton.setEnabled(false);
            this.ivDownButton.setEnabled(false);
        } else {
            this.ivUpButton.setEnabled(sel > 0);
            this.ivDownButton.setEnabled(sel < siz - 1);
        }
        this.ivSubTotalButton.setEnabled(xSel != -1 || ySel != -1);
        this.ivSwitchButton.setEnabled(this.ivXDimensionList.getModel().getSize() > 0 || this.ivYDimensionList.getModel().getSize() > 0);
    }

    private int[] getTypes(JList list, boolean giveNIX) {
        if (list.getModel().getSize() == 0 && giveNIX) {
            return new int[]{123456};
        }
        int[] types = new int[list.getModel().getSize()];
        int i = 0;
        while (i < types.length) {
            MultiDimAnalyzer.MDTypeObject mdto = (MultiDimAnalyzer.MDTypeObject)list.getModel().getElementAt(i);
            types[i] = mdto.ivWithTotal ? -mdto.ivType : mdto.ivType;
            ++i;
        }
        return types;
    }

    private boolean oneListUsed() {
        return this.ivXDimensionList.getModel().getSize() != 0 || this.ivYDimensionList.getModel().getSize() != 0;
    }

    private void dimensionListSelected(boolean isX, int index) {
        Vector mdKeys = new Vector();
        if (index >= 0) {
            Vector toAnalyze = isX ? this.ivXCoordVecsVec : this.ivYCoordVecsVec;
            TreeSet ts = new TreeSet();
            Iterator iterator = toAnalyze.iterator();
            while (iterator.hasNext()) {
                Vector v = (Vector)iterator.next();
                if (v.size() <= index) continue;
                ts.add(v.elementAt(index));
            }
            mdKeys.addAll(ts);
        }
        if (isX) {
            this.ivXValueList.setListData(mdKeys);
        } else {
            this.ivYValueList.setListData(mdKeys);
        }
    }

    private Vector removeUnwantedCriteria(Vector original) {
        if (this.ivNONOKeys.isEmpty()) {
            return original;
        }
        Vector<Vector> filteredVector = new Vector<Vector>();
        Iterator iterator = original.iterator();
        while (iterator.hasNext()) {
            Vector mdKeyVector = (Vector)iterator.next();
            boolean takeit = true;
            Iterator iterator2 = mdKeyVector.iterator();
            while (iterator2.hasNext() && takeit) {
                MultiDimAnalyzer.MDKey key = (MultiDimAnalyzer.MDKey)iterator2.next();
                if (!this.ivNONOKeys.contains(key)) continue;
                takeit = false;
            }
            if (!takeit) continue;
            filteredVector.add(mdKeyVector);
        }
        return filteredVector;
    }

    private void removeEmptyRowsAndColumns(Vector xCoordVecsVec, Vector yCoordVecsVec) {
        if (!(this.ivNONOKeys.isEmpty() || xCoordVecsVec.isEmpty() || yCoordVecsVec.isEmpty())) {
            HashSet<Integer> colsWithValues = new HashSet<Integer>();
            HashSet<Integer> rowsWithValues = new HashSet<Integer>();
            Vector cellCoordinatesAsMDKeyVector = new Vector();
            int y = 0;
            while (y < yCoordVecsVec.size()) {
                Vector zeilenMDKeys = (Vector)yCoordVecsVec.elementAt(y);
                int x = 0;
                while (x < xCoordVecsVec.size()) {
                    cellCoordinatesAsMDKeyVector.clear();
                    cellCoordinatesAsMDKeyVector.addAll(zeilenMDKeys);
                    cellCoordinatesAsMDKeyVector.addAll((Vector)xCoordVecsVec.elementAt(x));
                    if (this.hasCellValues(cellCoordinatesAsMDKeyVector)) {
                        colsWithValues.add(new Integer(x));
                        rowsWithValues.add(new Integer(y));
                    }
                    ++x;
                }
                ++y;
            }
            this.stripVector(xCoordVecsVec, colsWithValues);
            colsWithValues.clear();
            colsWithValues = null;
            this.stripVector(yCoordVecsVec, rowsWithValues);
            rowsWithValues.clear();
            rowsWithValues = null;
        }
    }

    private boolean hasCellValues(Vector cellCoordinatesAsMDKeyVector) {
        Integer anz;
        Vector vw;
        Object ooo = this.ivLastUsedAnalyzer.getVectorDimRes(cellCoordinatesAsMDKeyVector, 0);
        return ooo != null && (ooo instanceof Vector ? (vw = (Vector)ooo) != null && !vw.isEmpty() : ooo instanceof Integer && (anz = (Integer)ooo) != 0);
    }

    private void stripVector(Vector target, HashSet keepIndices) {
        Vector tempV = new Vector(target.size());
        int i = 0;
        while (i < target.size()) {
            if (keepIndices.contains(new Integer(i))) {
                tempV.add(target.elementAt(i));
            }
            ++i;
        }
        target.clear();
        target.addAll(tempV);
    }

    private String getTransportString() {
        StringBuilder msb = new StringBuilder();
        msb.append(IDObjectXMLHandler.getTransport(this.getTypes(this.ivXDimensionList, this.oneListUsed()), true, true)).append("|");
        msb.append(IDObjectXMLHandler.getTransport(this.getTypes(this.ivYDimensionList, this.oneListUsed()), true, true)).append("|");
        msb.append(this.ivTotalColBox.isSelected() ? "1" : "0").append("|");
        msb.append(this.ivTotalRowBox.isSelected() ? "1" : "0").append("|");
        msb.append(IDObjectXMLHandler.getTransport(this.ivNONOKeys, true, true)).append("|");
        return msb.toString();
    }

    private void adjustToTransport(String s) {
        Zeile z = new Zeile(s, '|');
        Vector alltypes = MultiDimAnalyzer.getAllTypeObjects(this.ivObjectType, this.isForDeadObjects());
        if (alltypes != null) {
            boolean[] fullSuccess = new boolean[]{true};
            Vector xTypes = this.makeTypeVec(z, 0, alltypes, fullSuccess);
            Vector yTypes = this.makeTypeVec(z, 1, alltypes, fullSuccess);
            if (!fullSuccess[0] && !Alert.showAlert(Babel.get("NOT_ALL_SETTINGS_MATCHED"), false)) {
                return;
            }
            this.ivNONOKeys = (HashSet)IDObjectXMLHandler.getObject(z.getStringNONEmpty(4, ""), "", true);
            this.ivAllList.setListData(alltypes);
            this.ivXDimensionList.setListData(xTypes);
            this.ivYDimensionList.setListData(yTypes);
            this.ivTotalColBox.setSelected(z.getString(2, "").equals("1"));
            this.ivTotalRowBox.setSelected(z.getString(3, "").equals("1"));
            this.definitionsChanged();
        }
    }

    private Vector makeTypeVec(Zeile z, int col, Vector alltypes, boolean[] fullSuccess) {
        int[] xdim = (int[])IDObjectXMLHandler.getObject(z.getStringNONEmpty(col, ""), "", true);
        xdim = MultiDimAnalyzer.checkArray(xdim);
        Vector<MultiDimAnalyzer.MDTypeObject> res = new Vector<MultiDimAnalyzer.MDTypeObject>(xdim.length);
        int i = 0;
        while (i < xdim.length) {
            int type = xdim[i];
            MultiDimAnalyzer.MDTypeObject mdto = this.find(type > 0 ? type : -type, alltypes);
            if (mdto != null) {
                mdto.ivWithTotal = type < 0;
                alltypes.remove(mdto);
                res.add(mdto);
            } else {
                fullSuccess[0] = false;
            }
            ++i;
        }
        return res;
    }

    private MultiDimAnalyzer.MDTypeObject find(int type, Vector v) {
        Iterator iterator = v.iterator();
        while (iterator.hasNext()) {
            MultiDimAnalyzer.MDTypeObject mdto = (MultiDimAnalyzer.MDTypeObject)iterator.next();
            if (mdto.ivType != type) continue;
            return mdto;
        }
        return null;
    }

    private void adjustDisplayToNonoChange(JList valueList, JList dimensionList) {
        valueList.repaint();
        dimensionList.repaint();
        this.changePrintElements();
    }

    private void changeNonoByDoubleClick(JList valueList, JList dimensionList) {
        MultiDimAnalyzer.MDKey key = (MultiDimAnalyzer.MDKey)valueList.getSelectedValue();
        if (key != null) {
            boolean done = false;
            if (this.ivNONOKeys.contains(key)) {
                this.ivNONOKeys.remove(key);
                done = true;
            } else {
                int anzpresent = 0;
                ListModel model = valueList.getModel();
                int anz = model.getSize();
                int i = 0;
                while (i < anz) {
                    if (!this.ivNONOKeys.contains(model.getElementAt(i))) {
                        ++anzpresent;
                    }
                    ++i;
                }
                if (anzpresent >= 2) {
                    this.ivNONOKeys.add(key);
                    done = true;
                }
            }
            if (done) {
                this.adjustDisplayToNonoChange(valueList, dimensionList);
            }
        }
    }

    private void showAllValues(JList dimensionList, JList valueList) {
        ListModel model = valueList.getModel();
        if (model.getSize() != 0) {
            MultiDimAnalyzer.MDKey key = (MultiDimAnalyzer.MDKey)model.getElementAt(0);
            Vector<MultiDimAnalyzer.MDKey> toRemove = new Vector<MultiDimAnalyzer.MDKey>();
            Iterator iterator = this.ivNONOKeys.iterator();
            while (iterator.hasNext()) {
                MultiDimAnalyzer.MDKey nkey = (MultiDimAnalyzer.MDKey)iterator.next();
                if (nkey.ivDimTyp != key.ivDimTyp) continue;
                toRemove.add(nkey);
            }
            if (!toRemove.isEmpty()) {
                iterator = toRemove.iterator();
                while (iterator.hasNext()) {
                    this.ivNONOKeys.remove(iterator.next());
                }
                this.adjustDisplayToNonoChange(valueList, dimensionList);
            }
        }
    }

    private void showSelectedValues(JList dimensionList, JList valueList) {
        ListModel model = valueList.getModel();
        if (model.getSize() != 0) {
            int sizeVorher = this.ivNONOKeys.size();
            int[] selIndices = valueList.getSelectedIndices();
            if (selIndices != null && selIndices.length != 0) {
                int i = 0;
                while (i < selIndices.length) {
                    this.ivNONOKeys.remove(model.getElementAt(selIndices[i]));
                    ++i;
                }
            }
            if (this.ivNONOKeys.size() != sizeVorher) {
                this.adjustDisplayToNonoChange(valueList, dimensionList);
            }
        }
    }

    private void showOnlySelectedValues(JList dimensionList, JList valueList) {
        ListModel model = valueList.getModel();
        if (model.getSize() != 0) {
            int sizeVorher = this.ivNONOKeys.size();
            int[] selIndices = valueList.getSelectedIndices();
            if (selIndices != null && selIndices.length != 0) {
                int anz = model.getSize();
                int i = 0;
                while (i < anz) {
                    this.ivNONOKeys.add(model.getElementAt(i));
                    ++i;
                }
                i = 0;
                while (i < selIndices.length) {
                    this.ivNONOKeys.remove(model.getElementAt(selIndices[i]));
                    ++i;
                }
            }
            if (this.ivNONOKeys.size() != sizeVorher) {
                this.adjustDisplayToNonoChange(valueList, dimensionList);
            }
        }
    }

    private void dontShowSelectedValues(JList dimensionList, JList valueList) {
        ListModel model = valueList.getModel();
        if (model.getSize() != 0 && this.dontShowSelectedValuesPossible(valueList)) {
            int sizeVorher = this.ivNONOKeys.size();
            int[] selIndices = valueList.getSelectedIndices();
            if (selIndices != null && selIndices.length != 0) {
                int i = 0;
                while (i < selIndices.length) {
                    this.ivNONOKeys.add(model.getElementAt(selIndices[i]));
                    ++i;
                }
            }
            if (this.ivNONOKeys.size() != sizeVorher) {
                this.adjustDisplayToNonoChange(valueList, dimensionList);
            }
        }
    }

    private boolean dontShowSelectedValuesPossible(JList valueList) {
        ListModel model = valueList.getModel();
        if (model.getSize() != 0) {
            int anz = model.getSize();
            int i = 0;
            while (i < anz) {
                if (!valueList.getSelectionModel().isSelectedIndex(i) && !this.ivNONOKeys.contains(model.getElementAt(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private JPopupMenu getPopuMenuForValueList(boolean isX) {
        JList valueList;
        String ac = isX ? "X" : "Y";
        JList jList = valueList = isX ? this.ivXValueList : this.ivYValueList;
        if (valueList.getModel().getSize() != 0) {
            Vector<JMenuItem> v = new Vector<JMenuItem>();
            JMenuItem item = null;
            boolean hiddenPresent = false;
            ListModel model = valueList.getModel();
            int anz = model.getSize();
            int i = 0;
            while (i < anz && !hiddenPresent) {
                if (this.ivNONOKeys.contains(model.getElementAt(i))) {
                    hiddenPresent = true;
                }
                ++i;
            }
            if (hiddenPresent) {
                item = new JMenuItem(Babel.get("MD_VN_SHOW_ALL"));
                item.setActionCommand(ac);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        boolean isX = arg0.getActionCommand().equals("X");
                        JList dimensionList = isX ? MultiDimReportFrame.this.ivXDimensionList : MultiDimReportFrame.this.ivYDimensionList;
                        JList valueList = isX ? MultiDimReportFrame.this.ivXValueList : MultiDimReportFrame.this.ivYValueList;
                        MultiDimReportFrame.this.showAllValues(dimensionList, valueList);
                    }
                });
                v.add(item);
            }
            if (!valueList.getSelectionModel().isSelectionEmpty()) {
                item = new JMenuItem(Babel.get("MD_VN_SHOW_SELECTEDS"));
                item.setActionCommand(ac);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        boolean isX = arg0.getActionCommand().equals("X");
                        JList dimensionList = isX ? MultiDimReportFrame.this.ivXDimensionList : MultiDimReportFrame.this.ivYDimensionList;
                        JList valueList = isX ? MultiDimReportFrame.this.ivXValueList : MultiDimReportFrame.this.ivYValueList;
                        MultiDimReportFrame.this.showSelectedValues(dimensionList, valueList);
                    }
                });
                v.add(item);
                if (this.dontShowSelectedValuesPossible(valueList)) {
                    item = new JMenuItem(Babel.get("MD_VN_DONT_SHOW_SELECTEDS"));
                    item.setActionCommand(ac);
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent arg0) {
                            boolean isX = arg0.getActionCommand().equals("X");
                            JList dimensionList = isX ? MultiDimReportFrame.this.ivXDimensionList : MultiDimReportFrame.this.ivYDimensionList;
                            JList valueList = isX ? MultiDimReportFrame.this.ivXValueList : MultiDimReportFrame.this.ivYValueList;
                            MultiDimReportFrame.this.dontShowSelectedValues(dimensionList, valueList);
                        }
                    });
                    v.add(item);
                }
                item = new JMenuItem(Babel.get("MD_VN_SHOW_ONLY_SELECTEDS"));
                item.setActionCommand(ac);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent arg0) {
                        boolean isX = arg0.getActionCommand().equals("X");
                        JList dimensionList = isX ? MultiDimReportFrame.this.ivXDimensionList : MultiDimReportFrame.this.ivYDimensionList;
                        JList valueList = isX ? MultiDimReportFrame.this.ivXValueList : MultiDimReportFrame.this.ivYValueList;
                        MultiDimReportFrame.this.showOnlySelectedValues(dimensionList, valueList);
                    }
                });
                v.add(item);
            }
            if (!v.isEmpty()) {
                JPopupMenu menu = new JPopupMenu();
                Iterator iterator = v.iterator();
                while (iterator.hasNext()) {
                    menu.add((JMenuItem)iterator.next());
                }
                return menu;
            }
        }
        return null;
    }
}

