/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets.sessionreports;

import java.io.Serializable;
import java.util.Date;
import mausoleum.factsheets.IDObjectMerker;
import mausoleum.helper.DatumFormat;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.visit.Visit;

public class SessionMouseLine
implements Serializable {
    private static final long serialVersionUID = 1138315315L;
    public String ivLink = null;
    public String ivID = "";
    public String ivBirthday = "";
    public String ivSex = "";
    public String ivTag = "";
    public String ivCage = "";
    public String ivLine = "";
    public String ivStrain = "";
    public String ivGenotype = "";
    public boolean ivIsMale = false;
    public String ivMode = "";
    public String ivCageLink = null;
    public String ivLineLink = null;
    public String ivStrainLink = null;

    public SessionMouseLine(Mouse mouse, int typ) {
        if (MausoleumClient.isRegularOrTGService()) {
            this.ivLink = IDObjectMerker.getLink(mouse, null);
        }
        this.ivID = Long.toString(mouse.getID());
        this.ivSex = DefaultManager.getSexString(mouse, false);
        this.ivTag = mouse.getCLLWEartagString("", true, true);
        this.ivLine = mouse.getCLLWLineString();
        if (MausoleumClient.isRegularOrTGService()) {
            this.ivLineLink = IDObjectMerker.getLink(mouse.getLine(), null);
        }
        this.ivStrain = mouse.getCLLWStrainString(true, true, true);
        if (MausoleumClient.isRegularOrTGService()) {
            this.ivStrainLink = IDObjectMerker.getLink(mouse.getStrains(), null);
        }
        if (typ == 2) {
            this.ivGenotype = mouse.getGenotype("");
            this.ivMode = Visit.translateMode(mouse.getInt("MOS_ENDMODE", 0));
        } else if (typ == 1) {
            this.ivGenotype = mouse.getGenotype("");
        } else if (typ == 4) {
            Date bd = mouse.getDate("MOS_BIRTHDAY");
            if (bd != null) {
                this.ivBirthday = DatumFormat.getJustDateString(bd.getTime());
            }
            this.ivCage = mouse.getCageString();
            if (MausoleumClient.isRegularOrTGService()) {
                this.ivCageLink = IDObjectMerker.getLink(mouse.getActCage(), null);
            }
            if (Mouse.isGenotypeComplete(mouse, -1L)) {
                this.ivGenotype = mouse.getGenotype("");
            }
        } else if (typ == 5) {
            this.ivCage = mouse.getCageString();
            if (MausoleumClient.isRegularOrTGService()) {
                this.ivCageLink = IDObjectMerker.getLink(mouse.getActCage(), null);
            }
            this.ivGenotype = mouse.getGenotype("");
            this.ivIsMale = mouse.getSex() == 1;
            Date bd = mouse.getDate("MOS_BIRTHDAY");
            if (bd != null) {
                this.ivBirthday = DatumFormat.getJustDateString(bd.getTime());
            }
        }
    }
}

