/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.factsheets.sessionreports;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.factsheets.FactSheetFrame;
import mausoleum.factsheets.IDObjectMerker;
import mausoleum.factsheets.sessionreports.SelectSessionReportsRequester;
import mausoleum.factsheets.sessionreports.SessionCageLine;
import mausoleum.factsheets.sessionreports.SessionMouseLine;
import mausoleum.factsheets.sessionreports.WeaningLine;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.KomfortHashMap;
import mausoleum.helper.LongPunkt;
import mausoleum.inspector.Inspector;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.tables.TableFrameCage;
import mausoleum.tables.TableFrameMouse;

public class SessionReport
extends KomfortHashMap {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_NEW = 1;
    public static final int TYPE_KILLED = 2;
    public static final int TYPE_WEANED = 3;
    public static final int TYPE_WEANED_KID = 4;
    public static final int TYPE_WEANED_PARENT = 5;
    public static final int TYPE_NEW_CAGES = 6;
    public static final int TYPE_TOUCHED_CAGES = 7;
    public static final String TAG_TITLE = "TITLE";
    public static final String TAG_USERNAME = "USERNAME";
    public static final String TAG_DATE = "DATE";
    public static final String TAG_GROUP = "GROUP";
    public static final String TAG_NEW_MICE = "NEW_MICE";
    public static final String TAG_KILLED_MICE = "KILLED_MICE";
    public static final String TAG_WEANED_MICE = "WEANED_MICE";
    public static final String TAG_NEW_CAGES = "NEW_CAGES";
    public static final String TAG_TOUCHED_CAGES = "TOUCHED_CAGES";
    public static final String TAG_TOTAL_NR = "TOTAL_NR";
    public static final String TAG_TOTAL_LINK = "TOTAL_LINK";
    public static final Comparator MOUSECOMPARER = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof Mouse && arg1 instanceof Mouse) {
                Mouse mouse0 = (Mouse)arg0;
                Mouse mouse1 = (Mouse)arg1;
                int et0 = mouse0.getInt("MOS_EARTAG", -1);
                int et1 = mouse1.getInt("MOS_EARTAG", -1);
                if (et0 != -1 && et1 != -1) {
                    if (et0 < et1) {
                        return -1;
                    }
                    if (et0 > et1) {
                        return 1;
                    }
                    return 0;
                }
                if (et0 != -1) {
                    return -1;
                }
                if (et1 != -1) {
                    return 1;
                }
                return mouse0.getCLLWEartagString("", true, true).compareToIgnoreCase(mouse1.getCLLWEartagString("", true, true));
            }
            return 0;
        }
    };
    public static final Comparator CAGECOMPARER = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof Cage && arg1 instanceof Cage) {
                int et1;
                Cage cage0 = (Cage)arg0;
                Cage cage1 = (Cage)arg1;
                int et0 = cage0.getIntNumber();
                if (et0 < (et1 = cage1.getIntNumber())) {
                    return -1;
                }
                if (et0 > et1) {
                    return 1;
                }
            }
            return 0;
        }
    };
    private static boolean cvNewMiceDirty = false;
    private static boolean cvKilledMiceDirty = false;
    private static boolean cvWeanedMiceDirty = false;
    private static boolean cvNewCagesDirty = false;
    private static boolean cvTouchedCagesDirty = false;
    public static boolean cvSessionReportAvailable = false;
    static /* synthetic */ Class class$0;

    public static boolean isNewMiceDirty() {
        return cvNewMiceDirty;
    }

    public static boolean isKilledMiceDirty() {
        return cvKilledMiceDirty;
    }

    public static boolean isWeanedMiceDirty() {
        return cvWeanedMiceDirty;
    }

    public static boolean isNewCagesDirty() {
        return cvNewCagesDirty;
    }

    public static boolean isTouchedCagesDirty() {
        return cvTouchedCagesDirty;
    }

    public static void setDirty(int typ) {
        switch (typ) {
            case 1: {
                cvNewMiceDirty = true;
                break;
            }
            case 2: {
                cvKilledMiceDirty = true;
                break;
            }
            case 3: {
                cvWeanedMiceDirty = true;
                break;
            }
            case 6: {
                cvNewCagesDirty = true;
                break;
            }
            case 7: {
                cvTouchedCagesDirty = true;
                break;
            }
        }
        cvSessionReportAvailable = true;
        Inspector.checkReportButton();
    }

    public static void showSessionReport() {
        int[] wantedTypes = SelectSessionReportsRequester.getWantedReportTypes();
        if (wantedTypes != null) {
            HashMap sammler = new HashMap();
            int i = 0;
            while (i < wantedTypes.length) {
                SessionReport.addReport(wantedTypes[i], sammler);
                ++i;
            }
            if (!sammler.isEmpty()) {
                Iterator iter = sammler.keySet().iterator();
                while (iter.hasNext()) {
                    String group = (String)iter.next();
                    Vector reports = (Vector)sammler.get(group);
                    if (reports == null || reports.isEmpty()) continue;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("mausoleum.mouse.Mouse");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    FactSheetFrame.showTab(reports, clazz.getName(), null, Babel.get("SESSION_REPORT"), null);
                }
            }
        }
    }

    private static void addReport(int type, HashMap sammler) {
        HashMap obsByGroup;
        Vector v = new Vector();
        if (type == 1) {
            TableFrameMouse.getNewMiceOfSession(v);
            cvNewMiceDirty = false;
        } else if (type == 2) {
            TableFrameMouse.getKilledMiceOfSession(v);
            cvKilledMiceDirty = false;
        } else if (type == 3) {
            TableFrameMouse.getWeanedMiceOfSession(v);
            cvWeanedMiceDirty = false;
        } else if (type == 6) {
            TableFrameCage.getNewCagesOfSession(v);
            cvNewCagesDirty = false;
        } else if (type == 7) {
            TableFrameCage.getTouchedCagesOfSession(v);
            cvTouchedCagesDirty = false;
        }
        if (!v.isEmpty() && (obsByGroup = IDObject.sortByGroup(v)) != null) {
            Iterator iter = obsByGroup.keySet().iterator();
            while (iter.hasNext()) {
                Vector idObjects;
                String group = (String)iter.next();
                SessionReport report = SessionReport.createReport(group, idObjects = (Vector)obsByGroup.get(group), type);
                if (report == null) continue;
                Vector<SessionReport> sv = (Vector<SessionReport>)sammler.get(group);
                if (sv == null) {
                    sv = new Vector<SessionReport>();
                    sammler.put(group, sv);
                }
                sv.add(report);
            }
        }
        v.clear();
        v = null;
    }

    private static SessionReport makeReport(Vector idObjects, String group, String titel, String linesTag, Vector lines, String singular, String plural) {
        SessionReport report = new SessionReport(group, titel);
        report.put((Object)linesTag, lines);
        int nr = idObjects.size();
        String total = nr == 1 ? String.valueOf(nr) + " " + Babel.get(singular) : String.valueOf(nr) + " " + Babel.get(plural);
        report.put((Object)TAG_TOTAL_NR, total);
        if (MausoleumClient.isRegularOrTGService()) {
            report.put((Object)TAG_TOTAL_LINK, IDObjectMerker.getLink(idObjects, null));
        }
        return report;
    }

    private static SessionReport createReport(String group, Vector idObjects, int typ) {
        Vector<Object> lines = new Vector<Object>();
        if (typ == 2 || typ == 1) {
            String titel = typ == 2 ? "SESSION_REPORT_KILLED_MICE" : "SESSION_REPORT_CREATED_MICE";
            String tag = typ == 2 ? TAG_KILLED_MICE : TAG_NEW_MICE;
            Collections.sort(idObjects, MOUSECOMPARER);
            Iterator iter = idObjects.iterator();
            while (iter.hasNext()) {
                Mouse mouse = (Mouse)iter.next();
                lines.add(new SessionMouseLine(mouse, typ));
            }
            return SessionReport.makeReport(idObjects, group, titel, tag, lines, "FS_MOUSE", "FS_MICE");
        }
        if (typ == 3) {
            HashMap<LongPunkt, Vector<Mouse>> families = new HashMap<LongPunkt, Vector<Mouse>>();
            Iterator<Object> iter = idObjects.iterator();
            while (iter.hasNext()) {
                Mouse mouse = (Mouse)iter.next();
                LongPunkt key = new LongPunkt(mouse.getLong("MOS_FATHER", -1L), mouse.getLong("MOS_MOTHER", -1L));
                Vector<Mouse> family = (Vector<Mouse>)families.get(key);
                if (family == null) {
                    family = new Vector<Mouse>();
                    families.put(key, family);
                }
                family.add(mouse);
            }
            iter = families.keySet().iterator();
            while (iter.hasNext()) {
                LongPunkt key = (LongPunkt)iter.next();
                Vector kids = (Vector)families.get(key);
                Collections.sort(kids, MOUSECOMPARER);
                lines.add(new WeaningLine(group, kids, key));
            }
            return SessionReport.makeReport(idObjects, group, "SESSION_REPORT_WEANED_MICE", TAG_WEANED_MICE, lines, "FS_MOUSE", "FS_MICE");
        }
        if (typ == 6 || typ == 7) {
            String titel = typ == 6 ? "SESSION_REPORT_NEW_CAGES" : "SESSION_REPORT_TOUCHED_CAGES";
            String tag = typ == 6 ? TAG_NEW_CAGES : TAG_TOUCHED_CAGES;
            Collections.sort(idObjects, CAGECOMPARER);
            Iterator iter = idObjects.iterator();
            while (iter.hasNext()) {
                Cage cage = (Cage)iter.next();
                lines.add(new SessionCageLine(cage, typ));
            }
            return SessionReport.makeReport(idObjects, group, titel, tag, lines, "FS_CAGE", "FS_CAGES");
        }
        return null;
    }

    public SessionReport(String group, String titleBabel) {
        this.put((Object)TAG_TITLE, String.valueOf(Babel.get(titleBabel)) + " - " + Babel.get(TAG_GROUP) + ": " + group);
        this.put((Object)TAG_DATE, DatumFormat.getDateTimeString(new MyDate(new GregorianCalendar())));
        this.put((Object)TAG_USERNAME, UserManager.getUser().getName());
        this.put((Object)TAG_GROUP, group);
    }
}

