/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JToolTip;
import mausoleum.cage.Cage;
import mausoleum.helper.FocusHoler;
import mausoleum.helper.FontManager;
import mausoleum.main.DefaultManager;
import mausoleum.printing.labelprinters.LabelPrinter;
import mausoleum.requester.LabelPrintRequester;
import mausoleum.ui.UIDef;

public class CageCardToolTip
extends JToolTip {
    private static final long serialVersionUID = 11861816L;
    public static final CageCardToolTip INSTANCE = new CageCardToolTip();
    private static final String SUB_LABEL = Babel.get("P_TO_PRINT");
    public static final String MUTEX = "MUTEX";
    public static final String MUTEX2 = "MUTEX2";
    private static final int UNTEN_EXTRA = UIDef.getScaled(20);
    private static final Dimension DEFAULT_DIM = new Dimension(UIDef.getScaled(100), UIDef.getScaled(100));
    private static final Dimension IMAGE_DIM = new Dimension(UIDef.getScaled(200), UIDef.getScaled(100));
    private static BufferedImage cvImage = null;
    private static BufferedImage cvAltesImage = null;
    private static int cvSubLabelWidth = -1;
    private Cage ivCage = null;

    protected void processKeyEvent(KeyEvent e) {
        char kp;
        int eventId = e.getID();
        if (eventId == 401 && ((kp = e.getKeyChar()) == 'P' || kp == 'p') && this.ivCage != null) {
            Vector<Cage> cages = new Vector<Cage>();
            cages.add(this.ivCage);
            LabelPrinter.printIt(cages, LabelPrintRequester.getLastUsedLabelPrinter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCage(Cage c) {
        String string = MUTEX2;
        synchronized (MUTEX2) {
            this.ivCage = c;
            if (this.isVisible()) {
                this.prepareImage();
                this.repaint();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean isFocusable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepareToShow() {
        String string = MUTEX2;
        synchronized (MUTEX2) {
            block4: {
                this.prepareImage();
                if (cvImage == null) break block4;
                FocusHoler.startCageCartFocusHoler(this, 50);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    private synchronized void prepareImage() {
        if (this.ivCage != null) {
            BufferedImage img = LabelPrinter.getTooltipImage(this.ivCage, UNTEN_EXTRA, cvAltesImage, DefaultManager.getCageTooltipZoom());
            if (img != null) {
                cvAltesImage = img;
                int w = img.getWidth();
                int h = img.getHeight();
                int y = h - UNTEN_EXTRA;
                Graphics g = img.getGraphics();
                g.setColor(UIDef.TOOLTIP_BACKGROUND);
                g.fillRect(0, y + 1, w, UNTEN_EXTRA);
                g.setColor(Color.black);
                g.drawLine(0, y, w, y);
                g.setFont(FontManager.getFont("SSB12"));
                int sw = cvSubLabelWidth;
                if (sw < 0) {
                    FontMetrics fm = g.getFontMetrics();
                    sw = cvSubLabelWidth = fm.stringWidth(SUB_LABEL);
                }
                g.drawString(SUB_LABEL, (w - sw) / 2, y + UIDef.getScaled(14));
                g.drawRect(0, 0, w - 1, h - 1);
                CageCardToolTip.IMAGE_DIM.width = w;
                CageCardToolTip.IMAGE_DIM.height = h;
            }
            cvImage = img;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        String string = MUTEX2;
        synchronized (MUTEX2) {
            if (this.ivCage != null) {
                if (cvImage != null) {
                    g.drawImage(cvImage, 0, 0, null);
                    if (!this.hasFocus()) {
                        int w = this.getWidth();
                        int h = this.getHeight();
                        int y = h - UNTEN_EXTRA;
                        g.setColor(UIDef.TOOLTIP_BACKGROUND);
                        g.fillRect(0, y + 1, w, UNTEN_EXTRA);
                        g.setColor(Color.black);
                        g.drawLine(0, y, w, y);
                        g.drawRect(0, 0, w - 1, h - 1);
                    }
                } else {
                    g.setColor(UIDef.TOOLTIP_BACKGROUND);
                    g.fillRect(0, 0, this.getSize().width, this.getSize().height);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        String string = MUTEX2;
        synchronized (MUTEX2) {
            if (this.ivCage != null && cvImage != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return IMAGE_DIM;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DEFAULT_DIM;
        }
    }
}

