/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import de.hannse.netobjects.tools.StringHelper;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import mausoleum.gui.KomfortTextField;

public class DoubleField
extends KomfortTextField {
    private static final long serialVersionUID = 1L;
    private static final int NO_NEW_POS = -99;
    private static char cvDecTrennerChar = (char)44;
    private static String cvDecTrennerString = null;
    private static String cvNullEnder = null;
    private static DecimalFormat cvFormat = null;
    private int ivNewPos = -99;
    private boolean ivNewPosWait = true;
    private boolean ivNurPositiv = false;

    static {
        cvFormat = new DecimalFormat();
        cvFormat.setMaximumFractionDigits(200);
        cvFormat.setMaximumIntegerDigits(200);
        cvFormat.setGroupingUsed(false);
        cvDecTrennerChar = cvFormat.getDecimalFormatSymbols().getDecimalSeparator();
        cvDecTrennerString = Character.toString(cvDecTrennerChar);
        cvNullEnder = String.valueOf(cvDecTrennerString) + "0";
    }

    public DoubleField() {
        this.setHorizontalAlignment(4);
    }

    public DoubleField(boolean nurPositiv) {
        this.ivNurPositiv = nurPositiv;
        this.setHorizontalAlignment(4);
    }

    public DoubleField(boolean nurPositiv, double d) {
        this.ivNurPositiv = nurPositiv;
        this.setDouble(d);
        this.setHorizontalAlignment(4);
    }

    public void setDouble(double val) {
        String text = "";
        if (!Double.isNaN(val)) {
            text = cvFormat.format(val);
            if ((text = StringHelper.gSub(text, ".", cvDecTrennerString, true)).endsWith(cvNullEnder)) {
                text = text.substring(0, text.length() - cvNullEnder.length());
            }
        }
        this.setText(text);
    }

    public double getDouble(double defVal) {
        String s = this.getText();
        if ((s = s.trim()).length() != 0) {
            try {
                return Double.parseDouble(StringHelper.gSub(s, ",", ".", true));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defVal;
    }

    protected void processKeyEvent(KeyEvent e) {
        if (!e.isActionKey()) {
            switch (e.getKeyChar()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (!this.getText().startsWith("-") || this.getCaretPosition() != 0) break;
                    e.consume();
                    return;
                }
                case '\b': 
                case '\t': 
                case '\n': {
                    break;
                }
                case ',': 
                case '.': {
                    if (e.getKeyChar() != cvDecTrennerChar) {
                        e.consume();
                        return;
                    }
                    String s = this.getText();
                    if (s == null) break;
                    if (s.startsWith("-") && this.getCaretPosition() == 0) {
                        e.consume();
                        return;
                    }
                    if (s.indexOf(cvDecTrennerString) < 0) break;
                    e.consume();
                    return;
                }
                case '-': {
                    if (this.ivNurPositiv) {
                        e.consume();
                        return;
                    }
                    String s = this.getText();
                    if (s != null && s.indexOf("-") >= 0) {
                        e.consume();
                        return;
                    }
                    if (this.ivNewPos == -99) {
                        this.ivNewPos = this.getCaretPosition() + 1;
                    }
                    this.setCaretPosition(0);
                    break;
                }
                case '+': {
                    if (this.ivNurPositiv) {
                        e.consume();
                        return;
                    }
                    e.consume();
                    String s = this.getText();
                    if (!s.startsWith("-")) break;
                    if (this.ivNewPos == -99) {
                        this.ivNewPos = this.getCaretPosition() - 1;
                    }
                    if (this.ivNewPos < 0) {
                        this.ivNewPos = 0;
                    }
                    s = s.substring(1);
                    this.setText(s);
                    return;
                }
                default: {
                    if (e.getKeyCode() == 127) break;
                    e.consume();
                    return;
                }
            }
        }
        super.processKeyEvent(e);
        if (this.ivNewPos != -99 && this.ivNewPosWait) {
            this.ivNewPosWait = false;
        } else if (this.ivNewPos != -99 && this.getText() != null && this.ivNewPos <= this.getText().length()) {
            this.setCaretPosition(this.ivNewPos);
            this.ivNewPos = -99;
            this.ivNewPosWait = true;
        }
    }
}

