/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class FlexGridLayout
implements LayoutManager {
    private final int ivCols;
    private final int ivRows;
    private final int ivHGap;
    private final int ivVGap;
    private final Component[] ivComps;
    private int ivNCPos;
    private final int[] ivHeights;
    private final int[] ivWidths;
    private final boolean ivFillLastWidth;
    private final boolean ivFillLastHeight;
    private final boolean ivCenterHorizontal;
    private final boolean ivCenterVertical;
    private int ivXOff = 0;
    private int ivYOff = 0;

    public FlexGridLayout(int rows, int cols, int vgap, int hgap) {
        this(rows, cols, vgap, hgap, false, false);
    }

    public FlexGridLayout(int rows, int cols, int vgap, int hgap, boolean fillLastWidth, boolean fillLastHeight) {
        this(rows, cols, vgap, hgap, fillLastWidth, fillLastHeight, false, false);
    }

    public FlexGridLayout(int rows, int cols, int vgap, int hgap, boolean fillLastWidth, boolean fillLastHeight, boolean centerHorizontal, boolean centerVertical) {
        this.ivCols = cols;
        this.ivRows = rows;
        this.ivHGap = hgap;
        this.ivVGap = vgap;
        this.ivComps = new Component[cols * rows];
        this.ivHeights = new int[rows];
        this.ivWidths = new int[cols];
        this.ivFillLastWidth = fillLastWidth;
        this.ivFillLastHeight = fillLastHeight;
        this.ivCenterHorizontal = centerHorizontal;
        this.ivCenterVertical = centerVertical;
    }

    public void addLayoutComponent(String arg0, Component arg1) {
        if (this.ivNCPos < this.ivComps.length) {
            this.ivComps[this.ivNCPos++] = arg1;
        }
    }

    public void layoutContainer(Container cont) {
        this.determineDims(cont);
        int by = this.ivYOff;
        int y = 0;
        while (y < this.ivRows) {
            int bx = this.ivXOff;
            int x = 0;
            while (x < this.ivCols) {
                Component comp = cont.getComponent(y * this.ivCols + x);
                if (comp != null) {
                    comp.setBounds(bx, by, this.ivWidths[x], this.ivHeights[y]);
                }
                bx += this.ivWidths[x] + this.ivHGap;
                ++x;
            }
            by += this.ivHeights[y] + this.ivVGap;
            ++y;
        }
    }

    public Dimension minimumLayoutSize(Container arg0) {
        return this.preferredLayoutSize(arg0);
    }

    public Dimension preferredLayoutSize(Container arg0) {
        this.determineDims(arg0);
        int height = 0;
        int y = 0;
        while (y < this.ivRows) {
            if (y != 0) {
                height += this.ivVGap;
            }
            height += this.ivHeights[y];
            ++y;
        }
        int width = 0;
        int x = 0;
        while (x < this.ivCols) {
            if (x != 0) {
                width += this.ivHGap;
            }
            width += this.ivWidths[x];
            ++x;
        }
        return new Dimension(width, height);
    }

    public void removeLayoutComponent(Component arg0) {
    }

    private void determineDims(Container arg0) {
        this.ivXOff = 0;
        this.ivYOff = 0;
        int i = 0;
        while (i < this.ivHeights.length) {
            this.ivHeights[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.ivWidths.length) {
            this.ivWidths[i] = 0;
            ++i;
        }
        int y = 0;
        while (y < this.ivRows) {
            int x = 0;
            while (x < this.ivCols) {
                Dimension d;
                Component comp = arg0.getComponent(y * this.ivCols + x);
                if (comp != null && (d = comp.getPreferredSize()) != null) {
                    if (d.width > this.ivWidths[x]) {
                        this.ivWidths[x] = d.width;
                    }
                    if (d.height > this.ivHeights[y]) {
                        this.ivHeights[y] = d.height;
                    }
                }
                ++x;
            }
            ++y;
        }
        if (arg0 != null) {
            int height;
            int width;
            Dimension d = arg0.getSize();
            if (this.ivFillLastWidth) {
                width = 0;
                int x = 0;
                while (x < this.ivCols) {
                    if (x != 0) {
                        width += this.ivHGap;
                    }
                    width += this.ivWidths[x];
                    ++x;
                }
                int soll = d.width - (width -= this.ivWidths[this.ivWidths.length - 1]);
                if (soll > 0) {
                    this.ivWidths[this.ivWidths.length - 1] = soll;
                }
            } else if (this.ivCenterHorizontal) {
                width = 0;
                int x = 0;
                while (x < this.ivCols) {
                    if (x != 0) {
                        width += this.ivHGap;
                    }
                    width += this.ivWidths[x];
                    ++x;
                }
                int soll = d.width - width;
                if (soll > 0) {
                    this.ivXOff = soll / 2;
                }
            }
            if (this.ivFillLastHeight) {
                height = 0;
                int y2 = 0;
                while (y2 < this.ivRows) {
                    if (y2 != 0) {
                        height += this.ivVGap;
                    }
                    height += this.ivHeights[y2];
                    ++y2;
                }
                int soll = d.height - (height -= this.ivHeights[this.ivHeights.length - 1]);
                if (soll > 0) {
                    this.ivHeights[this.ivHeights.length - 1] = soll;
                }
            } else if (this.ivCenterVertical) {
                height = 0;
                int y3 = 0;
                while (y3 < this.ivRows) {
                    if (y3 != 0) {
                        height += this.ivVGap;
                    }
                    height += this.ivHeights[y3];
                    ++y3;
                }
                int soll = d.height - height;
                if (soll > 0) {
                    this.ivYOff = soll / 2;
                }
            }
        }
    }
}

