/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JComponent;
import mausoleum.helper.ImageCreator;

public class ImageComponent
extends JComponent {
    private static final long serialVersionUID = 1378542412137768029L;
    private Image ivImage = null;
    private int imageWidth = 0;
    private int imageHeight = 0;

    public void setImage(Image i) {
        this.ivImage = i;
        if (this.ivImage != null) {
            this.imageWidth = this.ivImage.getWidth(null);
            if (this.imageWidth <= 0) {
                this.imageWidth = ImageCreator.getWidth(this.ivImage);
            }
            this.imageHeight = this.ivImage.getHeight(null);
        } else {
            this.imageWidth = 0;
            this.imageHeight = 0;
        }
        this.repaint();
    }

    public Image getImage() {
        return this.ivImage;
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        if (this.ivImage != null) {
            int x = (d.width - this.imageWidth) / 2;
            int y = (d.height - this.imageHeight) / 2;
            g.drawImage(this.ivImage, x, y, null);
        }
        g.setColor(Color.white);
        g.drawLine(0, d.height - 1, d.width, d.height - 1);
        g.drawLine(d.width - 1, 0, d.width - 1, d.height);
        g.setColor(Color.black);
        g.drawLine(0, 0, 0, d.height);
        g.drawLine(0, 0, d.width, 0);
    }
}

