/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import de.hannse.netobjects.tools.StringHelper;
import java.text.DecimalFormat;
import javax.swing.JTextField;
import mausoleum.gui.documents.DoubleDocument;
import mausoleum.ui.UIDef;

public class KomfortTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    public static char cvDecTrennerChar = (char)44;
    public static String cvDecTrennerString = null;
    private static String cvNullEnder = null;
    private static DecimalFormat cvFormat = null;

    static {
        cvFormat = new DecimalFormat();
        cvFormat.setMaximumFractionDigits(200);
        cvFormat.setMaximumIntegerDigits(200);
        cvFormat.setGroupingUsed(false);
        cvDecTrennerChar = cvFormat.getDecimalFormatSymbols().getDecimalSeparator();
        cvDecTrennerString = Character.toString(cvDecTrennerChar);
        cvNullEnder = String.valueOf(cvDecTrennerString) + "0";
    }

    public KomfortTextField() {
        this.setSelectionColor(UIDef.SELECTED_BACKGROUND);
    }

    public KomfortTextField(double d) {
        this.setSelectionColor(UIDef.SELECTED_BACKGROUND);
        this.setDocument(new DoubleDocument(this));
        this.setDouble(d);
    }

    public void setDouble(double val) {
        String text = cvFormat.format(val);
        if ((text = StringHelper.gSub(text, ".", cvDecTrennerString, true)).endsWith(cvNullEnder)) {
            text = text.substring(0, text.length() - cvNullEnder.length());
        }
        this.setText(text);
    }

    public double getDouble(double defVal) {
        String s = this.getText();
        if ((s = s.trim()).length() != 0) {
            s = StringHelper.gSub(s, cvDecTrennerString, ".", true);
            try {
                return Double.parseDouble(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defVal;
    }

    public int getInt(int defVal) {
        String s = this.getText();
        if ((s = s.trim()).length() != 0) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defVal;
    }

    public Integer getInteger() {
        String s = this.getText();
        if ((s = s.trim()).length() != 0) {
            try {
                return new Integer(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public long getLong(long defVal) {
        String s = this.getText();
        if ((s = s.trim()).length() != 0) {
            try {
                return Long.parseLong(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defVal;
    }

    public void setInt(int val) {
        this.setText(Integer.toString(val));
    }

    public void setLong(long val) {
        this.setText(Long.toString(val));
    }
}

