/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import de.hannse.netobjects.util.Log;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import mausoleum.gui.ColorManager;
import mausoleum.helper.FontManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.inspector.InspectorPanel;
import mausoleum.main.DefaultManager;

public class MGButton
extends JComponent
implements MouseListener {
    private static final long serialVersionUID = -3557884851643848346L;
    private static final Dimension DIM = new Dimension(50, 20);
    private String ivImageKey = "blueButton";
    private String ivOrigImageKey = "blueButton";
    private final HashMap ivFullImagesByKey = new HashMap(5);
    private String ivLabel = "";
    protected boolean ivIsPressed = false;
    private Color ivForeground = Color.black;
    protected boolean ivIsEnabled = true;
    private boolean shouldBePressed = false;
    protected final Vector ivActionListeners = new Vector();
    protected String ivActionCommand = null;
    private Dimension ivLastDim;
    private final double ivAngle = Math.random() * 88.0 + 1.0;
    private final double ivPercent = Math.random();
    private int ivOrientation = 0;
    private Dimension ivPreferredSize = null;
    private boolean ivNonButton = false;
    protected boolean ivShowTooltipTriangle = true;

    public static MGButton getMainInspectorButton(String label, String ac, ActionListener al) {
        MGButton erg = new MGButton();
        erg.setLabel(label);
        erg.ivOrigImageKey = erg.ivImageKey = "greenButton";
        erg.setFont(FontManager.getFont("SSB14"));
        erg.setActionCommand(ac);
        if (al != null) {
            erg.addActionListener(al);
        }
        return erg;
    }

    public static MGButton getRequesterButton(String label) {
        MGButton erg = new MGButton();
        erg.setLabel(label);
        erg.ivOrigImageKey = erg.ivImageKey = "blueButton";
        erg.setFont(FontManager.getFont("SSB24"));
        return erg;
    }

    public static MGButton getInspectorActionButton(String label, String ac) {
        return MGButton.getInspectorActionButton(label, ac, null);
    }

    public static MGButton getInspectorActionButton(String label, String ac, ActionListener al) {
        MGButton erg = new MGButton();
        erg.setLabel(label);
        erg.ivOrigImageKey = erg.ivImageKey = "blueButton";
        erg.setFont(FontManager.getFont("SSB12"));
        erg.setActionCommand(ac);
        if (al != null) {
            erg.addActionListener(al);
        }
        return erg;
    }

    public static MGButton getNewRemSetButton(String label, InspectorPanel ip) {
        MGButton erg = new MGButton();
        erg.setLabel(label);
        erg.ivOrigImageKey = erg.ivImageKey = "blueButton";
        erg.setFont(FontManager.getFont("SSB12"));
        ip.add(erg);
        return erg;
    }

    public MGButton() {
        this.addMouseListener(this);
    }

    public MGButton(String name) {
        this(name, null, null, FontManager.getFont("SSB12"));
    }

    public MGButton(String name, boolean nonButton) {
        this(name);
        this.ivNonButton = nonButton;
    }

    public MGButton(String name, String command) {
        this(name, command, null, FontManager.getFont("SSB12"));
    }

    public MGButton(String name, String command, ActionListener al, Font font) {
        this.addMouseListener(this);
        this.setLabel(name);
        if (command != null) {
            this.ivActionCommand = command;
        }
        if (al != null) {
            this.addActionListener(al);
        }
        this.setFont(font);
    }

    public void dispose() {
        this.ivImageKey = null;
        this.ivFullImagesByKey.clear();
        this.ivLabel = null;
        this.ivForeground = null;
        this.ivActionListeners.clear();
        this.ivActionCommand = null;
        this.ivLastDim = null;
        this.ivPreferredSize = null;
    }

    public void setAlarm(boolean alarm) {
        if (alarm) {
            if (!this.ivImageKey.equals("redButton")) {
                this.ivImageKey = "redButton";
                this.ivForeground = Color.white;
                this.repaint();
            }
        } else if (!this.ivImageKey.equals(this.ivOrigImageKey)) {
            this.ivImageKey = this.ivOrigImageKey;
            this.ivForeground = Color.black;
            this.repaint();
        }
    }

    public void setOrientation(int or) {
        if (or == 0 || or == 2 || or == 4) {
            this.ivOrientation = or;
            return;
        }
        throw new IllegalArgumentException("Orientation not supported");
    }

    public void setImageKey(String imageKey) {
        this.ivImageKey = imageKey;
    }

    public String getText() {
        return this.ivLabel;
    }

    public void setText(String t) {
        this.setLabel(t);
    }

    public void setFont(Font arg0) {
        super.setFont(arg0);
        this.ivPreferredSize = null;
    }

    public void setImage(String imageKey) {
        this.ivImageKey = imageKey;
    }

    public void setLabel(String lab) {
        this.ivLabel = lab;
        this.ivPreferredSize = null;
        this.repaint();
    }

    public void setForeground(Color c) {
        this.ivForeground = c;
        this.repaint();
    }

    public Color getForeground() {
        return this.ivForeground;
    }

    public void setEnabled(boolean b) {
        if (this.ivIsEnabled != b) {
            this.ivIsEnabled = b;
            this.repaint();
        }
    }

    public void setPressed(boolean b) {
        if (this.ivIsPressed != b) {
            this.ivIsPressed = b;
        }
    }

    public boolean isPressed() {
        return this.ivIsPressed;
    }

    public String getLabel() {
        return this.ivLabel;
    }

    public void setLabelNoRepaint(String lab) {
        this.ivLabel = lab;
        this.ivActionCommand = lab;
        this.ivPreferredSize = null;
    }

    public boolean isEnabled() {
        return this.ivIsEnabled;
    }

    public void setVisible(boolean b) {
        this.repaint();
        super.setVisible(b);
    }

    public void addActionListener(ActionListener al) {
        if (this.ivActionListeners.indexOf(al) == -1) {
            this.ivActionListeners.addElement(al);
        }
    }

    public void removeActionListener(ActionListener al) {
        int ind = this.ivActionListeners.indexOf(al);
        if (ind != -1) {
            this.ivActionListeners.removeElement(al);
        }
    }

    public void setActionCommand(String s) {
        this.ivActionCommand = s;
    }

    public String getActionCommand() {
        return this.ivActionCommand;
    }

    public Dimension getMinimumSize() {
        return DIM;
    }

    public Dimension getPreferredSize() {
        if (this.ivPreferredSize == null) {
            if (this.getFont() == null) {
                return DIM;
            }
            int height = this.getFont().getSize() + 2 + 4;
            int width = this.getFontMetrics(this.getFont()).stringWidth(this.getLabel()) + 2 + 4;
            this.ivPreferredSize = new Dimension(width, height);
        }
        return this.ivPreferredSize;
    }

    public void drawExtra(Graphics g) {
    }

    public void paint(Graphics g) {
        boolean remake = false;
        Dimension d = this.getSize();
        if (this.ivLastDim == null) {
            remake = true;
        } else if (d.width != this.ivLastDim.width || d.height != this.ivLastDim.height) {
            remake = true;
        }
        if (remake) {
            this.ivFullImagesByKey.remove(this.ivImageKey);
        }
        this.ivLastDim = d;
        if (this.ivIsEnabled || this.ivNonButton) {
            if (DefaultManager.getDesign().equals("PLAIN")) {
                Color c = ColorManager.getMausoColor(this.ivImageKey);
                if (c != null) {
                    g.setColor(c);
                    g.fillRect(0, 0, d.width, d.height);
                }
            } else {
                Image img = (Image)this.ivFullImagesByKey.get(this.ivImageKey);
                if (img == null) {
                    img = this.makeImage(this.ivImageKey);
                    this.ivFullImagesByKey.put(this.ivImageKey, img);
                }
                g.drawImage(img, 0, 0, null);
            }
            Color fg = this.ivForeground;
            if (this.ivIsPressed && !this.ivNonButton) {
                fg = Color.white;
                g.setColor(new Color(0, 0, 0, 80));
                g.fillRect(0, 0, d.width, d.height);
            }
            int extraOffset = 0;
            if (this.ivShowTooltipTriangle && this.getToolTipText() != null) {
                int x = d.height / 2;
                if (x > 10) {
                    x = 10;
                }
                g.setColor(new Color(255, 255, 255, 120));
                int[] nArray = new int[3];
                nArray[1] = x;
                int[] nArray2 = new int[3];
                nArray2[2] = x;
                g.fillPolygon(nArray, nArray2, 3);
                g.setColor(this.ivIsPressed ? Color.white : Color.black);
                g.drawLine(x, 0, 0, x);
                g.setColor(this.ivIsPressed ? Color.black : Color.white);
                g.drawLine(x - 1, 0, 0, x - 1);
                if (d.height - 2 * x < this.getFont().getSize()) {
                    extraOffset = x - 2;
                }
            }
            this.drawBorder(this.ivIsPressed && !this.ivNonButton, d, g);
            this.drawExtra(g);
            this.drawLabel(g, d, fg, extraOffset);
        } else {
            g.setColor(Color.darkGray);
            g.drawRect(0, 0, d.width - 1, d.height - 1);
            this.drawLabel(g, d, Color.darkGray, 0);
        }
    }

    private Image makeImage(String imageKey) {
        Rectangle r = this.getBounds();
        if (r.width == 0 || r.height == 0) {
            return null;
        }
        BufferedImage img = new BufferedImage(r.width, r.height, 1);
        Graphics g = img.getGraphics();
        while (g == null) {
            try {
                System.out.println(String.valueOf(this.getClass().getName()) + " waiting for img");
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            g = img.getGraphics();
        }
        if (DefaultManager.getDesign() != "PLAIN" && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        MausoleumImageStore.drawImage(g, this.ivImageKey, r, this.ivAngle, this.ivPercent);
        return img;
    }

    private void drawBorder(boolean pressed, Dimension d, Graphics g) {
        g.setColor(pressed ? Color.black : Color.white);
        g.drawLine(0, 0, d.width - 1, 0);
        g.drawLine(0, 0, 0, d.height - 1);
        g.setColor(pressed ? Color.darkGray : Color.lightGray);
        g.drawLine(1, 1, d.width - 2, 1);
        g.drawLine(1, 1, 1, d.height - 2);
        g.setColor(pressed ? Color.white : Color.black);
        g.drawLine(d.width - 1, d.height - 1, 1, d.height - 1);
        g.drawLine(d.width - 1, d.height - 1, d.width - 1, 1);
        g.setColor(pressed ? Color.lightGray : Color.darkGray);
        g.drawLine(d.width - 2, d.height - 2, 2, d.height - 2);
        g.drawLine(d.width - 2, d.height - 2, d.width - 2, 2);
    }

    private void drawLabel(Graphics g, Dimension d, Color dc, int extraOffset) {
        if (this.ivLabel != null && this.ivLabel.length() != 0) {
            g.setFont(this.getFont());
            FontMetrics mfm = g.getFontMetrics();
            int br = mfm.stringWidth(this.ivLabel);
            int ma = mfm.getMaxAscent();
            int md = mfm.getMaxDescent();
            int gesh = ma + md;
            int obka = (d.height - gesh) / 2;
            int y = obka + ma - 1;
            int x = extraOffset;
            if (this.ivOrientation == 0) {
                x = extraOffset + (d.width - extraOffset - br) / 2;
            } else if (this.ivOrientation == 2) {
                x = 4 + extraOffset;
            } else if (this.ivOrientation == 4) {
                x = d.width - 4 - br;
            }
            g.setColor(dc);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawString(this.ivLabel, x, y);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (this.ivIsEnabled) {
            if (this.shouldBePressed) {
                this.ivIsPressed = true;
            }
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.ivIsEnabled) {
            this.ivIsPressed = false;
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.ivIsEnabled) {
            this.ivIsPressed = true;
            this.shouldBePressed = true;
            this.repaint();
        }
    }

    public void setReleasedState() {
        this.ivIsPressed = false;
        this.shouldBePressed = false;
    }

    public void setPresssedState() {
        this.ivIsPressed = true;
        this.shouldBePressed = true;
    }

    public void mouseReleased(MouseEvent e) {
        if (this.ivIsEnabled && !this.ivNonButton) {
            this.ivIsPressed = false;
            this.shouldBePressed = false;
            this.repaint();
            Dimension d = this.getSize();
            if (e.getX() <= d.width && e.getY() <= d.height) {
                if (this.ivActionListeners.isEmpty()) {
                    Log.warn("Button >" + this.ivLabel + "< has no listener", null, this);
                } else {
                    ActionEvent myAE = new ActionEvent(this, 0, this.ivActionCommand == null ? this.ivLabel : this.ivActionCommand, e.getModifiers());
                    Iterator iterator = this.ivActionListeners.iterator();
                    while (iterator.hasNext()) {
                        ActionListener al = (ActionListener)iterator.next();
                        al.actionPerformed(myAE);
                    }
                }
            }
        }
    }
}

