/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.TexturePaint;
import mausoleum.helper.MusterHelper;

public class MusterColor
extends Color {
    private static final long serialVersionUID = 17843545L;
    public final Color ivSecondColor;
    public final int ivMuster;

    public MusterColor(int r, int g, int b) {
        this(new Color(r, g, b), null, 0);
    }

    public MusterColor(int r, int g, int b, Color secondColor, int mode) {
        this(new Color(r, g, b), secondColor, mode);
    }

    public MusterColor(Color firstColor, Color secondColor, int mode) {
        super(firstColor.getRGB());
        this.ivSecondColor = secondColor;
        this.ivMuster = mode;
    }

    public Image getMuster() {
        return MusterHelper.getImage(this.ivMuster, this, this.ivSecondColor);
    }

    public void fill(Dimension d, Graphics g) {
        TexturePaint tp = MusterHelper.getPaint(this.ivMuster, this, this.ivSecondColor);
        if (tp != null && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Paint vp = g2d.getPaint();
            g2d.setPaint(tp);
            g.fillRect(0, 0, d.width, d.height);
            g2d.setPaint(vp);
        } else {
            g.setColor(this);
            g.fillRect(0, 0, d.width, d.height);
        }
    }

    public void fill(int x, int y, int w, int h, Graphics g) {
        MusterColor.fill(this, this.ivSecondColor, this.ivMuster, x, y, w, h, g);
    }

    public static void fill(Color col1, Color col2, int muster, int x, int y, int w, int h, Graphics g) {
        TexturePaint tp = MusterHelper.getPaint(muster, col1, col2);
        if (tp != null && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Paint vp = g2d.getPaint();
            g2d.setPaint(tp);
            g.fillRect(x, y, w, h);
            g2d.setPaint(vp);
        } else {
            g.setColor(col1);
            g.fillRect(x, y, w, h);
        }
    }

    public static void fill(Color col1, Color col2, int muster, Polygon poly, Graphics g) {
        TexturePaint tp = MusterHelper.getPaint(muster, col1, col2);
        if (tp != null && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Paint vp = g2d.getPaint();
            g2d.setPaint(tp);
            g.fillPolygon(poly);
            g2d.setPaint(vp);
        } else {
            g.setColor(col1);
            g.fillPolygon(poly);
        }
    }

    public int hashCode() {
        return super.hashCode() * 17 + (this.ivSecondColor != null ? this.ivSecondColor.hashCode() * 41 : 37) + this.ivMuster * 83;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MusterColor) {
            MusterColor mc = (MusterColor)obj;
            if (this.ivMuster != mc.ivMuster) {
                return false;
            }
            if (this.ivSecondColor == null && mc.ivSecondColor != null) {
                return false;
            }
            if (this.ivSecondColor != null && mc.ivSecondColor == null) {
                return false;
            }
            if (this.ivSecondColor != null && mc.ivSecondColor != null && this.ivSecondColor.getRGB() != mc.ivSecondColor.getRGB()) {
                return false;
            }
            return this.getRGB() == mc.getRGB();
        }
        return false;
    }
}

