/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import mausoleum.gui.MusterColor;

public class PralineColor
extends Color {
    private static final long serialVersionUID = 17843545L;
    public static final int RAHMEN = 2;
    public final int ivFirstMuster;
    public final Color ivFirstSecondColor;
    public final Color ivRahmenColor;

    public PralineColor(Color main, Color rahmen) {
        super(main.getRed(), main.getGreen(), main.getBlue());
        this.ivRahmenColor = rahmen;
        if (main instanceof MusterColor) {
            MusterColor mc = (MusterColor)main;
            this.ivFirstMuster = mc.ivMuster;
            this.ivFirstSecondColor = mc.ivSecondColor;
        } else {
            this.ivFirstMuster = 0;
            this.ivFirstSecondColor = null;
        }
    }

    public PralineColor(int r, int g, int b, Color rahmen) {
        super(r, g, b);
        this.ivFirstMuster = 0;
        this.ivFirstSecondColor = null;
        this.ivRahmenColor = rahmen;
    }

    public void fill(Dimension d, Graphics g) {
        this.fill(0, 0, d.width, d.height, g);
    }

    public void fill(int x, int y, int w, int h, Graphics g) {
        if (this.ivRahmenColor != null) {
            int rand = h / 4;
            if (this.ivRahmenColor instanceof MusterColor) {
                MusterColor mc = (MusterColor)this.ivRahmenColor;
                mc.fill(x, y, w, h, g);
            } else {
                g.setColor(this.ivRahmenColor);
                g.fillRect(x, y, w, h);
            }
            if (this.ivFirstMuster != 0 && this.ivFirstSecondColor != null) {
                MusterColor.fill(this, this.ivFirstSecondColor, this.ivFirstMuster, x + rand, y + rand, w - 2 * rand - 1, h - 2 * rand - 1, g);
                g.setColor(Color.black);
                g.drawRect(x + rand, y + rand, w - 2 * rand - 1, h - 2 * rand - 1);
            } else {
                g.setColor(this);
                g.fillRect(x + rand, y + rand, w - 2 * rand - 1, h - 2 * rand - 1);
                g.setColor(Color.black);
                g.drawRect(x + rand, y + rand, w - 2 * rand - 1, h - 2 * rand - 1);
            }
        } else {
            g.setColor(this);
            g.fillRect(x, y, w, h);
        }
    }

    public int hashCode() {
        return super.hashCode() * 17 + (this.ivRahmenColor != null ? this.ivRahmenColor.hashCode() * 41 : 37);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PralineColor) {
            PralineColor mc = (PralineColor)obj;
            if (this.ivRahmenColor != null || mc.ivRahmenColor != null) {
                if (this.ivRahmenColor != null && mc.ivRahmenColor == null) {
                    return false;
                }
                if (this.ivRahmenColor == null && mc.ivRahmenColor != null) {
                    return false;
                }
                if (this.ivRahmenColor.getRGB() != mc.ivRahmenColor.getRGB()) {
                    return false;
                }
            }
            return this.getRGB() == mc.getRGB();
        }
        return false;
    }
}

