/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import mausoleum.gui.ColorManager;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.main.DefaultManager;
import mausoleum.ui.UIDef;

public class ScrollBarButton
extends JButton {
    private static final long serialVersionUID = -4384393027031251585L;
    public static final int SIZE = UIDef.getScaled(20);
    private static final Dimension DIMENSION = new Dimension(SIZE, SIZE);
    private static final Color SHADOW = new Color(0, 0, 0, 80);
    public static final int MODE_RIGHT = 1;
    public static final int MODE_LEFT = 2;
    public static final int MODE_UP = 3;
    public static final int MODE_DOWN = 4;
    private static final int TIP = UIDef.getScaled(3);
    private static final int EDGE = UIDef.getScaled(3);
    private Image ivImage = null;
    private Polygon ivPolygon = null;
    private Dimension ivLastDim;
    private double ivAngle = Math.random() * 88.0 + 1.0;
    private double ivPercent = Math.random();
    private int ivMode;

    public ScrollBarButton(int mode) {
        this.ivMode = mode;
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent arg0) {
                ScrollBarButton.this.ivPolygon = null;
            }
        });
    }

    public Dimension getPreferredSize() {
        return DIMENSION;
    }

    public void paint(Graphics g) {
        Dimension d;
        this.ivLastDim = d = this.getSize();
        if (this.isEnabled()) {
            boolean pressed;
            boolean bl = pressed = this.getModel().isArmed() && this.getModel().isPressed();
            if (DefaultManager.getDesign().equals("PLAIN")) {
                g.setColor(ColorManager.getMausoColor("blueButton"));
                g.fillRect(0, 0, d.width, d.height);
            } else {
                if (this.ivLastDim == null || d.width != this.ivLastDim.width || d.height != this.ivLastDim.height) {
                    this.ivImage = null;
                }
                if (this.ivImage == null) {
                    this.ivImage = this.makeImage();
                }
                if (this.ivImage != null) {
                    g.drawImage(this.ivImage, 0, 0, null);
                }
            }
            this.drawRim(g, !pressed, d);
            if (this.ivPolygon == null) {
                this.makePolygon();
            }
            if (g instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g.setColor(pressed ? Color.white : Color.black);
            g.fillPolygon(this.ivPolygon);
        } else {
            g.setColor(Color.darkGray);
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        }
    }

    protected Image makeImage() {
        Rectangle r = this.getBounds();
        if (r.width == 0 || r.height == 0) {
            return null;
        }
        BufferedImage img = new BufferedImage(r.width, r.height, 1);
        Graphics g = ((Image)img).getGraphics();
        while (g == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            g = ((Image)img).getGraphics();
        }
        MausoleumImageStore.drawImage(g, "blueButton", r, this.ivAngle, this.ivPercent);
        return img;
    }

    private void makePolygon() {
        int w = this.getSize().width / 2;
        int h = this.getSize().height / 2;
        this.ivPolygon = new Polygon();
        switch (this.ivMode) {
            case 1: {
                this.ivPolygon.addPoint(w - EDGE, h - TIP);
                this.ivPolygon.addPoint(w - EDGE, h + TIP);
                this.ivPolygon.addPoint(w + EDGE, h);
                break;
            }
            case 2: {
                this.ivPolygon.addPoint(w + EDGE, h - TIP);
                this.ivPolygon.addPoint(w + EDGE, h + TIP);
                this.ivPolygon.addPoint(w - EDGE, h);
                break;
            }
            case 3: {
                this.ivPolygon.addPoint(w - TIP, h + EDGE);
                this.ivPolygon.addPoint(w + TIP, h + EDGE);
                this.ivPolygon.addPoint(w, h - EDGE);
                break;
            }
            case 4: {
                this.ivPolygon.addPoint(w - TIP, h - EDGE);
                this.ivPolygon.addPoint(w + TIP, h - EDGE);
                this.ivPolygon.addPoint(w, h + EDGE);
                break;
            }
        }
    }

    private void drawRim(Graphics g, boolean normal, Dimension d) {
        if (!normal) {
            g.setColor(SHADOW);
            g.fillRect(0, 0, d.width, d.height);
        }
        g.setColor(normal ? Color.white : Color.black);
        g.drawLine(0, 0, d.width - 1, 0);
        g.drawLine(0, 0, 0, d.height - 1);
        g.setColor(normal ? Color.lightGray : Color.darkGray);
        g.drawLine(1, 1, d.width - 2, 1);
        g.drawLine(1, 1, 1, d.height - 2);
        g.setColor(normal ? Color.black : Color.white);
        g.drawLine(d.width - 1, d.height - 1, 1, d.height - 1);
        g.drawLine(d.width - 1, d.height - 1, d.width - 1, 1);
        g.setColor(normal ? Color.darkGray : Color.lightGray);
        g.drawLine(d.width - 2, d.height - 2, 2, d.height - 2);
        g.drawLine(d.width - 2, d.height - 2, d.width - 2, 2);
    }
}

