/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import mausoleum.gui.ColorManager;
import mausoleum.gui.TextWrapComponent;
import mausoleum.helper.FontManager;

public class TextWrapComponentInitiale
extends TextWrapComponent {
    private static final long serialVersionUID = 4868321231L;
    private static final Color INNER_COLOR = ColorManager.getColorFromString("firebrick");
    private final Font ivBigFont;
    private final Font ivBigFont2;
    private final String ivInitiale;
    private final int ivInitialWidth;

    public TextWrapComponentInitiale(String s, Font f, int width, int orientation) {
        super(s.substring(1, s.length()), f);
        this.setSize(width, 1000);
        this.setOrientation(orientation);
        this.ivBigFont = new Font(f.getName(), f.getStyle(), f.getSize() * 2);
        this.ivBigFont2 = new Font(f.getName(), f.getStyle(), f.getSize() * 2 + 6);
        this.ivInitiale = s.substring(0, 1);
        this.ivInitialWidth = FontManager.stringWidth(String.valueOf(this.ivInitiale) + " ", this.ivBigFont);
        this.generateElements();
    }

    protected int getZeilenBreite() {
        if (this.ivAktZeile <= 1) {
            return this.ivMaxWidth - this.ivInitialWidth;
        }
        return this.ivMaxWidth;
    }

    protected int getLeftMargin() {
        if (this.ivAktZeile <= 1) {
            return this.ivInitialWidth;
        }
        return 0;
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setFont(this.ivBigFont2);
        int stx = 0;
        int sty = 2 * this.ivFontSize;
        Graphics2D g2 = (Graphics2D)g;
        Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.white);
        g.drawString(this.ivInitiale, stx + 1, sty + 1);
        g.drawString(this.ivInitiale, stx, sty + 1);
        g.drawString(this.ivInitiale, stx - 1, sty + 1);
        g.drawString(this.ivInitiale, stx + 1, sty);
        g.drawString(this.ivInitiale, stx + 1, sty - 1);
        g.setColor(Color.black);
        g.drawString(this.ivInitiale, stx - 1, sty - 1);
        g.drawString(this.ivInitiale, stx - 1, sty);
        g.drawString(this.ivInitiale, stx, sty - 1);
        g.setColor(INNER_COLOR);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.drawString(this.ivInitiale, stx, sty);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawString(this.ivInitiale, stx, sty);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }
}

