/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import mausoleum.helper.FontManager;
import mausoleum.ui.UIDef;

public abstract class VerticalText {
    private static final int COL_DURCHSICHTIG = new Color(255, 0, 0, 0).getRGB();

    public static Icon getIcon(String text) {
        int w = FontManager.stringWidth(text, FontManager.getFont("SSB14"));
        int rw = UIDef.getScaled(20);
        int rh = w + UIDef.getScaled(12);
        Image tres = VerticalText.prepareImage(rh, rw);
        Graphics2D g2d = (Graphics2D)tres.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.black);
        g2d.setFont(FontManager.getFont("SSB14"));
        g2d.drawString(text, UIDef.getScaled(6), UIDef.getScaled(15));
        Image res = VerticalText.prepareImage(rw, rh);
        g2d = (Graphics2D)res.getGraphics();
        g2d.setColor(Color.black);
        g2d.translate(0, rh);
        g2d.rotate(-1.5707963267948966);
        g2d.drawImage(tres, 0, 0, null);
        return new ImageIcon(res);
    }

    private static Image prepareImage(int w, int h) {
        BufferedImage img = new BufferedImage(w, h, 2);
        DataBuffer db = img.getRaster().getDataBuffer();
        int x = 0;
        while (x < w) {
            int y = 0;
            while (y < h) {
                int pos = y * w + x;
                db.setElem(pos, COL_DURCHSICHTIG);
                ++y;
            }
            ++x;
        }
        return img;
    }
}

