/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.StringHelper;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.gui.MFLabel;
import mausoleum.inspector.Inspector;
import mausoleum.license.License;
import mausoleum.line.Line;
import mausoleum.main.DefaultManager;
import mausoleum.mouse.Mouse;
import mausoleum.printing.util.LabelMaker;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.strain.Strain;
import mausoleum.ui.UIDef;

public abstract class AllgUtils {
    public static final Long NIX_ROOM = new Long(-1L);
    public static final int TYPE_LINES = 0;
    public static final int TYPE_STRAINS = 1;
    public static final int TYPE_GENOTYPES = 2;
    public static final int TYPE_COMMENTS = 3;
    public static final int TYPE_SEX = 4;
    public static final int TYPE_GENERATION_MAGDEBURG = 5;
    public static final int TYPE_BIRTHDAY = 6;
    public static final int TYPE_LINE_STRAIN = 7;
    public static final int TYPE_LICENSES = 8;
    public static long ABBRUCH = -2L;
    public static long SEL_NONE = -1L;
    public static final Comparator ID_OBJECT_BY_BROWSERNAME = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof IDObject && arg1 instanceof IDObject) {
                IDObject ido0 = (IDObject)arg0;
                IDObject ido1 = (IDObject)arg1;
                return ido0.getBrowseName().compareToIgnoreCase(ido1.getBrowseName());
            }
            return 0;
        }
    };
    public static final Comparator MOUSE_ET_SORTER = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Mouse && o2 instanceof Mouse) {
                long id2;
                int et2;
                Mouse m1 = (Mouse)o1;
                Mouse m2 = (Mouse)o2;
                int et1 = m1.getInt("MOS_EARTAG", 0);
                if (et1 < (et2 = m2.getInt("MOS_EARTAG", 0))) {
                    return -1;
                }
                if (et1 > et2) {
                    return 1;
                }
                long id1 = m1.getID();
                if (id1 < (id2 = m2.getID())) {
                    return -1;
                }
                if (id1 > id2) {
                    return 1;
                }
            }
            return 0;
        }
    };

    public static Vector getTypeMultiBackground(Vector mice, int mode, Mouse mouse) {
        Vector<MFLabel> erg;
        block23: {
            TreeSet<IDObject> myAttributes;
            block25: {
                block24: {
                    erg = new Vector<MFLabel>();
                    if (mouse == null && mice == null) break block23;
                    myAttributes = new TreeSet<IDObject>();
                    if (mode != 0) break block24;
                    if (mouse != null) {
                        Line line = mouse.getLine();
                        if (line != null && !myAttributes.contains(line)) {
                            myAttributes.add(line);
                        }
                    } else {
                        Iterator mouseIter = mice.iterator();
                        while (mouseIter.hasNext()) {
                            Mouse m = (Mouse)mouseIter.next();
                            Line line = m.getLine();
                            if (line == null || myAttributes.contains(line)) continue;
                            myAttributes.add(line);
                        }
                    }
                    Iterator iter = myAttributes.iterator();
                    while (iter.hasNext()) {
                        Color c;
                        Line line = (Line)iter.next();
                        String s = line.getBrowseName();
                        if (iter.hasNext()) {
                            s = String.valueOf(s) + ", ";
                        }
                        if ((c = (Color)line.get("LIN_COLOR")) == null) {
                            c = UIDef.OBJECT_DEFAULT_COLOR;
                        }
                        erg.add(new MFLabel(s, c));
                    }
                    break block23;
                }
                if (mode != 1) break block25;
                if (mouse != null) {
                    Vector strains = mouse.getStrains();
                    if (strains != null) {
                        myAttributes.addAll(strains);
                    }
                } else {
                    Iterator mouseIter = mice.iterator();
                    while (mouseIter.hasNext()) {
                        Mouse m = (Mouse)mouseIter.next();
                        Vector strains = m.getStrains();
                        if (strains == null) continue;
                        Iterator iter = strains.iterator();
                        while (iter.hasNext()) {
                            Strain strain = (Strain)iter.next();
                            if (myAttributes.contains(strain)) continue;
                            myAttributes.add(strain);
                        }
                    }
                }
                Iterator iter = myAttributes.iterator();
                while (iter.hasNext()) {
                    Color c;
                    Strain strain = (Strain)iter.next();
                    String s = strain.getBrowseName();
                    if (iter.hasNext()) {
                        s = String.valueOf(s) + ", ";
                    }
                    if ((c = (Color)strain.get("STR_COLOR")) == null) {
                        c = UIDef.OBJECT_DEFAULT_COLOR;
                    }
                    erg.add(new MFLabel(s, c));
                }
                break block23;
            }
            if (mode != 8) break block23;
            if (mouse != null) {
                Vector licenses = mouse.getLicenses(null);
                if (licenses != null) {
                    myAttributes.addAll(licenses);
                }
            } else {
                Vector licSammler = new Vector();
                Iterator mouseIter = mice.iterator();
                while (mouseIter.hasNext()) {
                    Mouse m = (Mouse)mouseIter.next();
                    licSammler.clear();
                    Vector licenses = m.getLicenses(licSammler);
                    if (licenses == null) continue;
                    Iterator iter = licenses.iterator();
                    while (iter.hasNext()) {
                        License license = (License)iter.next();
                        if (myAttributes.contains(license)) continue;
                        myAttributes.add(license);
                    }
                }
                licSammler.clear();
                licSammler = null;
            }
            Iterator iter = myAttributes.iterator();
            while (iter.hasNext()) {
                Color c;
                License license = (License)iter.next();
                String s = license.getBrowseName();
                if (iter.hasNext()) {
                    s = String.valueOf(s) + ", ";
                }
                if ((c = (Color)license.get("LIC_COL")) == null) {
                    c = UIDef.OBJECT_DEFAULT_COLOR;
                }
                erg.add(new MFLabel(s, c));
            }
        }
        return erg;
    }

    public static String getTypeString(Cage cage, Vector mice, int mode, boolean withServicePrefix) {
        return AllgUtils.getTypeString(cage, mice, mode, null, ", ", withServicePrefix);
    }

    public static String getTypeString(Cage cage, Vector mice, int mode, String separator, boolean withServicePrefix) {
        return AllgUtils.getTypeString(cage, mice, mode, null, separator, withServicePrefix);
    }

    public static String getTypeString(Cage cage, Vector mice, int mode, HashSet sammler, boolean withServicePrefix) {
        return AllgUtils.getTypeString(cage, mice, mode, sammler, ", ", withServicePrefix);
    }

    public static String getTypeString(Cage cage, Vector mice, int mode, HashSet sammler, String separator, boolean withServicePrefix) {
        if (mice != null && !mice.isEmpty()) {
            String s;
            Mouse m;
            Iterator mouseIter;
            TreeSet<String> myAttributes = new TreeSet<String>();
            if (mode == 0) {
                mouseIter = mice.iterator();
                while (mouseIter.hasNext()) {
                    m = (Mouse)mouseIter.next();
                    Line line = m.getLine();
                    if (line == null) continue;
                    if (sammler != null) {
                        sammler.add(line);
                    }
                    myAttributes.add(withServicePrefix ? line.getBrowseNameInclServicePrefix() : line.getBrowseNameWITHOUTServicePrefix());
                }
            } else if (mode == 7) {
                mouseIter = mice.iterator();
                while (mouseIter.hasNext()) {
                    m = (Mouse)mouseIter.next();
                    Line line = m.getLine();
                    if (line == null) continue;
                    if (line.isBreeder()) {
                        s = line.getBrowseName();
                        Vector strains = m.getStrains();
                        Iterator iter = strains.iterator();
                        while (iter.hasNext()) {
                            Strain strain = (Strain)iter.next();
                            s = String.valueOf(s) + " / " + (withServicePrefix ? strain.getBrowseNameInclServicePrefix() : strain.getBrowseNameWITHOUTServicePrefix());
                        }
                        myAttributes.add(s);
                        continue;
                    }
                    myAttributes.add(withServicePrefix ? line.getBrowseNameInclServicePrefix() : line.getBrowseNameWITHOUTServicePrefix());
                }
            } else if (mode == 1) {
                mouseIter = mice.iterator();
                while (mouseIter.hasNext()) {
                    m = (Mouse)mouseIter.next();
                    Vector strains = m.getStrains();
                    if (sammler != null) {
                        sammler.addAll(strains);
                    }
                    Iterator iter = strains.iterator();
                    while (iter.hasNext()) {
                        Strain strain = (Strain)iter.next();
                        myAttributes.add(withServicePrefix ? strain.getBrowseNameInclServicePrefix() : strain.getBrowseNameWITHOUTServicePrefix());
                    }
                }
            } else if (mode == 2) {
                mouseIter = mice.iterator();
                while (mouseIter.hasNext()) {
                    m = (Mouse)mouseIter.next();
                    String gt = m.getGenotype();
                    if (gt == null) continue;
                    myAttributes.add(gt);
                }
            } else if (mode == 4) {
                mouseIter = mice.iterator();
                while (mouseIter.hasNext()) {
                    myAttributes.add(DefaultManager.getSexString((Mouse)mouseIter.next(), false));
                }
            } else if (mode == 5) {
                mouseIter = mice.iterator();
                while (mouseIter.hasNext()) {
                    m = (Mouse)mouseIter.next();
                    int gen = m.getGeneration(-1, true);
                    if (gen == -1) continue;
                    s = "G:" + gen;
                    myAttributes.add(s);
                }
            } else if (mode == 6) {
                mouseIter = mice.iterator();
                while (mouseIter.hasNext()) {
                    m = (Mouse)mouseIter.next();
                    String bd = LabelMaker.getVeryShortDateString(m.getDate("MOS_BIRTHDAY"));
                    if (bd == null || bd.trim().length() == 0) continue;
                    myAttributes.add(bd);
                }
            } else {
                if (mode == 3) {
                    String erg = cage.getString("CAG_COMMENT");
                    if (erg != null) {
                        erg = StringHelper.gSub(erg, "\n", "");
                        erg = StringHelper.gSub(erg, "\r", "");
                    }
                    return erg;
                }
                return "";
            }
            if (myAttributes.isEmpty()) {
                return "";
            }
            StringBuffer msb = new StringBuffer();
            Iterator iterator = myAttributes.iterator();
            while (iterator.hasNext()) {
                if (msb.length() != 0) {
                    msb.append(separator);
                }
                msb.append((String)iterator.next());
            }
            return msb.toString();
        }
        return "";
    }

    public static long select(Vector idos, String selectNoneChoice, String dialogTitel, IDObject[] returnVal, boolean showETPref) {
        IDObject ido;
        Inspector.getInspector().setCursor(Cursor.getPredefinedCursor(3));
        Collections.sort(idos, IDObject.SORTER_BY_NAME);
        int selNoneZusatz = selectNoneChoice != null ? 1 : 0;
        int posInArray = 0;
        String[] strings = new String[idos.size() + selNoneZusatz];
        if (selectNoneChoice != null) {
            strings[posInArray++] = selectNoneChoice;
        }
        if (idos != null && !idos.isEmpty()) {
            int i = 0;
            while (i < idos.size()) {
                ido = (IDObject)idos.elementAt(i);
                strings[posInArray++] = ido instanceof Line && showETPref ? ((Line)ido).getBrowseNameInclServicePrefixAndEarTagPrefix() : ido.getBrowseNameInclServicePrefix();
                ++i;
            }
        }
        returnVal[0] = null;
        int ind = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), dialogTitel, strings);
        Inspector.getInspector().setCursor(Cursor.getDefaultCursor());
        if (ind == -1) {
            return ABBRUCH;
        }
        if (selNoneZusatz == 1 && ind == 0) {
            return SEL_NONE;
        }
        if (idos != null && !idos.isEmpty()) {
            returnVal[0] = ido = (IDObject)idos.elementAt(ind - selNoneZusatz);
            return ido.getLong("IDO_ID", ABBRUCH);
        }
        return ABBRUCH;
    }

    public static Vector getVec(Object o) {
        Vector<Object> v = new Vector<Object>();
        if (o != null) {
            v.add(o);
        }
        return v;
    }

    public static Vector getVec(Object o1, Object o2) {
        Vector<Object> v = new Vector<Object>();
        if (o1 != null) {
            v.add(o1);
        }
        if (o2 != null) {
            v.add(o2);
        }
        return v;
    }

    public static void enterValueInVector(HashMap map, Object key, Object val) {
        Vector<Object> v = (Vector<Object>)map.get(key);
        if (v == null) {
            v = new Vector<Object>();
            map.put(key, v);
        }
        v.add(val);
    }

    public static boolean extEquals(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 != null && o2 != null) {
            return o1.equals(o2);
        }
        return false;
    }
}

