/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import de.hannse.netobjects.util.Log;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class ClipboardObject
implements Transferable {
    private static Clipboard cvClipboard = null;
    private static DataFlavor cvHTMLFlavor = new DataFlavor("text/html;charset=utf-8;class=java.lang.String", "Htmlflavor");
    private static DataFlavor cvTextFlavor = new DataFlavor("text/plain;charset=utf-8;class=java.lang.String", "Textflavor");
    private static DataFlavor[] cvBothFlavors = new DataFlavor[]{cvTextFlavor, cvHTMLFlavor};
    private static DataFlavor[] cvOnlyTextFlavor = new DataFlavor[]{cvTextFlavor};
    private static ClipboardOwner cvClipBoardOwner = new ClipboardOwner(){

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    };
    private String ivTextData = null;
    private String ivHTMLData = null;
    static /* synthetic */ Class class$0;

    static {
        try {
            cvClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            cvClipboard = new Clipboard("HTMLCP");
        }
    }

    public static void manageCopy(String html, String text) {
        ClipboardObject co = new ClipboardObject(html, text);
        cvClipboard.setContents(co, cvClipBoardOwner);
    }

    public static void copy(Image img) {
        cvClipboard.setContents(new ImageTrans(img), cvClipBoardOwner);
    }

    public static boolean isDataFlavorPresent(DataFlavor df) {
        if (cvClipboard != null && df != null) {
            DataFlavor[] arr = ClipboardObject.getPasteFlavors();
            int i = 0;
            while (i < arr.length) {
                if (df.equals(arr[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static DataFlavor[] getPasteFlavors() {
        return cvClipboard.getAvailableDataFlavors();
    }

    public static Object getPasteObject(DataFlavor df) {
        if (ClipboardObject.isDataFlavorPresent(df)) {
            try {
                return cvClipboard.getData(df);
            }
            catch (Exception e) {
                String string = "Problem bei getPasteObject mit Geschmacksrichtung: " + df;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.helper.ClipboardObject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        return null;
    }

    private ClipboardObject(String html, String text) {
        this.ivHTMLData = html;
        this.ivTextData = text;
    }

    public DataFlavor[] getTransferDataFlavors() {
        if (this.ivHTMLData == null) {
            return cvOnlyTextFlavor;
        }
        return cvBothFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor.equals(cvTextFlavor)) {
            return true;
        }
        return flavor.equals(cvHTMLFlavor) && this.ivHTMLData != null;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(cvTextFlavor)) {
            return this.ivTextData;
        }
        if (flavor.equals(cvHTMLFlavor)) {
            return this.ivHTMLData;
        }
        return null;
    }

    public static class ImageTrans
    implements Transferable {
        private Image ivImage;

        public ImageTrans(Image image) {
            this.ivImage = image;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.ivImage;
        }
    }
}

