/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObjectXMLHandler;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.RequestManager;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.idobjectgroup.IDObjectGroupManager;
import mausoleum.line.Line;
import mausoleum.locus.Locus;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.reports.TrafficReport;
import mausoleum.strain.Strain;

public class ExportHelper {
    public static void collectObjectIDs(Vector mice, HashSet locusIDs, HashSet lineIDs, HashSet strainIDs, String group) {
        Iterator iter = mice.iterator();
        while (iter.hasNext()) {
            Mouse mouse = (Mouse)iter.next();
            mouse.addYourLinesAndStrains(lineIDs, strainIDs);
        }
        Hashtable neededAllelesByLocusID = new Hashtable();
        Iterator iterator = lineIDs.iterator();
        while (iterator.hasNext()) {
            Long lineID = (Long)iterator.next();
            Line line = (Line)ObjectStore.getObjectDeadOrAlive(7, lineID, group, null, false);
            if (line == null) continue;
            line.collectYourData(neededAllelesByLocusID);
        }
        Enumeration en = neededAllelesByLocusID.keys();
        while (en.hasMoreElements()) {
            locusIDs.add(en.nextElement());
        }
    }

    public static String createExportContent(Vector mice, HashSet locusIDs, HashSet lineIDs, HashSet strainIDs, String group, boolean isInInstitue) {
        StringBuilder attachmentBuffer = new StringBuilder();
        Object attRes = RequestManager.createSendAndGetObjectIfFinished((byte)73, null, group);
        if (attRes == null) {
            return null;
        }
        attachmentBuffer.append("<sfp ").append(attRes).append(" />\n");
        Iterator iterator = locusIDs.iterator();
        while (iterator.hasNext()) {
            Long locusID = (Long)iterator.next();
            Locus locus = (Locus)ObjectStore.getObjectDeadOrAlive(14, locusID, group, null, false);
            if (locus == null) continue;
            attachmentBuffer.append(locus.getExportString());
        }
        iterator = lineIDs.iterator();
        while (iterator.hasNext()) {
            Long lineID = (Long)iterator.next();
            Line line = (Line)ObjectStore.getObjectDeadOrAlive(7, lineID, group, null, false);
            if (line == null) continue;
            attachmentBuffer.append(line.getExportString());
        }
        iterator = strainIDs.iterator();
        while (iterator.hasNext()) {
            Long strainID = (Long)iterator.next();
            Strain strain = (Strain)ObjectStore.getClientObject(8, strainID, group);
            if (strain == null) continue;
            attachmentBuffer.append(strain.getExportString());
        }
        Iterator iter = mice.iterator();
        while (iter.hasNext()) {
            Mouse mouse = (Mouse)iter.next();
            Mouse tmouse = new Mouse();
            Iterator iterator2 = mouse.ivProperties.keySet().iterator();
            while (iterator2.hasNext()) {
                String key = (String)iterator2.next();
                tmouse.set(key, mouse.get(key));
            }
            if (mouse.get("IDO_FKEY") == null) {
                tmouse.set("IDO_FKEY", String.valueOf(mouse.getGroup()) + ":" + mouse.getID());
            }
            tmouse.set("MOS_CAME", "MGI:" + mouse.getIdentifierString());
            tmouse.commit(false);
            attachmentBuffer.append(tmouse.getExportString(isInInstitue));
        }
        return Base64Manager.encodeBase64(attachmentBuffer.toString());
    }

    public static String createExportInformation(int mouseCount, HashSet locusIDs, HashSet lineIDs, HashSet strainIDs) {
        StringBuilder attachmentInfoBuffer = new StringBuilder();
        if (mouseCount == 1) {
            attachmentInfoBuffer.append("1_mouse");
        } else {
            attachmentInfoBuffer.append(String.valueOf(mouseCount) + "_mice");
        }
        if (!lineIDs.isEmpty()) {
            if (lineIDs.size() == 1) {
                attachmentInfoBuffer.append("_/_1_line");
            } else {
                attachmentInfoBuffer.append("_/_" + lineIDs.size() + "_lines");
            }
        }
        if (!locusIDs.isEmpty()) {
            if (locusIDs.size() == 1) {
                attachmentInfoBuffer.append("_/_1_locus");
            } else {
                attachmentInfoBuffer.append("_/_" + locusIDs.size() + "_loci");
            }
        }
        if (!strainIDs.isEmpty()) {
            if (strainIDs.size() == 1) {
                attachmentInfoBuffer.append("_/_1_strain");
            } else {
                attachmentInfoBuffer.append("_/_" + strainIDs.size() + "_strains");
            }
        }
        return attachmentInfoBuffer.toString();
    }

    public static String getRemoveMiceCommand(Vector mice, long jmills, int leaveMode, String standardTaskKey, String targetAddress, String trafficDesc) {
        long jetzt = System.currentTimeMillis();
        int actionDate = (int)(jmills / 86400000L);
        StringBuffer msb = new StringBuffer();
        TaskExtended.addExactPoolingTaskFinish(mice, -1L, msb, actionDate);
        TrafficReport.appendTrafficInfoClientSide(mice, jmills, trafficDesc != null ? trafficDesc : "TRD_REMOVE", msb);
        Iterator iter = mice.iterator();
        while (iter.hasNext()) {
            Mouse mouse = (Mouse)iter.next();
            if (standardTaskKey != null) {
                TaskExtended.addTaskFinishsToComBuff(mouse, mouse.getTaskKey(), "TASK_AC_KILL", 0L, msb, actionDate);
            }
            if (msb.length() != 0) {
                msb.append("\n");
            }
            msb.append(CommandManagerExecutive.getServiceRoomTag(mouse, ""));
            msb.append("MR").append(" ");
            msb.append(mouse.getID()).append(" ");
            msb.append(leaveMode).append(" ");
            msb.append(jmills).append(" ");
            String informerIDs = ExportHelper.getInformerIDs(mouse);
            if (informerIDs == null) {
                msb.append(" ");
            } else {
                msb.append(informerIDs).append(" ");
                StringBuilder ssb = new StringBuilder();
                ssb.append(mouse.getID()).append("|");
                if (MausoleumClient.isServiceCaretaker()) {
                    ssb.append("-");
                }
                ssb.append(UserManager.getIDOFUser()).append("|");
                ssb.append(jetzt).append("|");
                Cage cage = mouse.getActCage();
                if (cage != null && cage.isMatingCage() && mouse.isPossMatingPartner()) {
                    ssb.append("1");
                } else {
                    ssb.append("0");
                }
                msb.append(Base64Manager.encodeBase64(ssb.toString()));
            }
            msb.append(" ");
            msb.append(targetAddress == null ? "" : targetAddress);
        }
        return msb.toString();
    }

    private static String getInformerIDs(Mouse mouse) {
        TreeSet<Long> owhs = new TreeSet<Long>();
        long[] owners = (long[])mouse.get("MOS_OWNER");
        if (owners != null && owners.length != 0) {
            int i = 0;
            while (i < owners.length) {
                owhs.add(new Long(owners[i]));
                ++i;
            }
        }
        String group = mouse.getGroup();
        long[] ownerGroups = (long[])mouse.get("MOS_OWNERGROUPS");
        if (ownerGroups != null && ownerGroups.length != 0) {
            int i = 0;
            while (i < ownerGroups.length) {
                IDObjectGroup iog = (IDObjectGroup)IDObjectGroupManager.cvInstance.getObject(ownerGroups[i], group);
                if (iog != null && (owners = (long[])iog.get("IOG_IDS")) != null && owners.length != 0) {
                    int ii = 0;
                    while (ii < owners.length) {
                        owhs.add(new Long(owners[i]));
                        ++ii;
                    }
                }
                ++i;
            }
        }
        if (MausoleumClient.isRegularOrTGService()) {
            owhs.remove(new Long(UserManager.getIDOFUser()));
        }
        if (!owhs.isEmpty()) {
            return IDObjectXMLHandler.getSessionString(owhs);
        }
        return null;
    }
}

