/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import de.hannse.netobjects.util.Log;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import mausoleum.helper.ImageCreator;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.main.DefaultManager;
import mausoleum.ui.UIDef;

public class FontManager {
    public static final String SANS_SERIF = "SansSerif";
    public static final String SERIF = "Serif";
    public static final String COURIER = "Monospaced";
    public static final int GT_NORM = 0;
    public static final int GT_LOCUS = 1;
    public static final int GT_ALLEL = 2;
    public static final int GT_ALLEL_UNKNOWN = 3;
    public static final int GT_OTHER = 4;
    public static final int GT_ARR_SIZ = 5;
    private static final HashMap BOLD_CAGE_FONTS;
    private static final HashMap BOLD_100_FONTS;
    private static final HashMap BOLD_GOMORRHA_FONTS;
    private static final HashMap FONTS;
    private static final HashMap RINGE;
    private static final HashMap RINGE_STERIL;
    private static final HashMap GT_FONTARRAYS;
    public static final String DEFAULT_BUTTON_FONT = "SSB11";
    public static final String DEFAULT_LIST_FONT = "SSB11";
    public static final String DEFAULT_INPUT_FONT = "SSB11";
    public static final String BIG_INPUT_FONT = "SSB13";
    public static final String DEAD_LIST_FONT = "SSP11";
    public static final String MOUSE_CURSOR_FONT = "SSB16";
    private static final BufferedImage OPFER_IMAGE;
    private static final Graphics OPFER_GRAPHICS;
    private static final HashMap FONT_METRICS;
    private static final HashMap FONTS_BY_TAG;
    private static Image cvOriginalRinge;
    static /* synthetic */ Class class$0;

    static {
        FONTS = new HashMap();
        RINGE = new HashMap();
        RINGE_STERIL = new HashMap();
        GT_FONTARRAYS = new HashMap();
        OPFER_IMAGE = new BufferedImage(10, 10, 1);
        OPFER_GRAPHICS = OPFER_IMAGE.getGraphics();
        FONT_METRICS = new HashMap();
        FONTS_BY_TAG = new HashMap();
        cvOriginalRinge = null;
        BOLD_CAGE_FONTS = new HashMap(20);
        FontManager.catagolizeFonts("123456", BOLD_CAGE_FONTS);
        BOLD_100_FONTS = new HashMap(20);
        FontManager.catagolizeFonts("100", BOLD_100_FONTS);
        BOLD_GOMORRHA_FONTS = new HashMap(20);
        FontManager.catagolizeFonts("\u2642\u2642", BOLD_GOMORRHA_FONTS);
    }

    public static void resetFonts() {
        FONTS_BY_TAG.clear();
    }

    public static Font getFont(String tag) {
        Font resFont = (Font)FONTS_BY_TAG.get(tag);
        if (resFont == null) {
            String type;
            int style;
            int size;
            block22: {
                size = 12;
                style = 1;
                type = SANS_SERIF;
                int ind = -1;
                int i = 0;
                while (i < tag.length() && ind == -1) {
                    switch (tag.charAt(i)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            ind = i;
                            break;
                        }
                    }
                    ++i;
                }
                if (ind != -1) {
                    try {
                        String sizs = tag.substring(ind, tag.length());
                        while (sizs.startsWith("0")) {
                            sizs = sizs.substring(1, sizs.length());
                        }
                        size = Integer.parseInt(sizs);
                        String spec = tag.substring(0, ind);
                        if (spec.equalsIgnoreCase("SSP")) {
                            style = 0;
                            type = SANS_SERIF;
                            break block22;
                        }
                        if (spec.equalsIgnoreCase("SSB")) {
                            style = 1;
                            type = SANS_SERIF;
                            break block22;
                        }
                        if (spec.equalsIgnoreCase("SSI")) {
                            style = 2;
                            type = SANS_SERIF;
                            break block22;
                        }
                        if (spec.equalsIgnoreCase("SP")) {
                            style = 0;
                            type = SERIF;
                            break block22;
                        }
                        if (spec.equalsIgnoreCase("SB")) {
                            style = 1;
                            type = SERIF;
                            break block22;
                        }
                        if (spec.equalsIgnoreCase("SI")) {
                            style = 2;
                            type = SERIF;
                            break block22;
                        }
                        if (spec.equalsIgnoreCase("TT")) {
                            style = 1;
                            type = COURIER;
                            break block22;
                        }
                        String string = "Unknown Font " + tag;
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("");
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("mausoleum.helper.FontManager");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.error(string, illegalArgumentException, clazz);
                    }
                    catch (Exception e) {
                        String string = "Unknown Font [2] " + tag;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("mausoleum.helper.FontManager");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.error(string, e, clazz);
                    }
                }
            }
            resFont = new Font(type, style, UIDef.getScaled(size));
            FONTS_BY_TAG.put(tag, resFont);
        }
        return resFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FontMetrics getFontMetrics(Font f) {
        FontMetrics fm = (FontMetrics)FONT_METRICS.get(f);
        if (fm == null) {
            Graphics graphics = OPFER_GRAPHICS;
            synchronized (graphics) {
                fm = OPFER_GRAPHICS.getFontMetrics(f);
                FONT_METRICS.put(f, fm);
            }
        }
        return fm;
    }

    public static synchronized int stringWidth(String s, Font f) {
        return FontManager.getFontMetrics(f).stringWidth(s);
    }

    private static void catagolizeFonts(String test, HashMap target) {
        int h = 6;
        while (h < 30) {
            FontManager.putDefFont(h, test, target);
            ++h;
        }
        h = 30;
        while (h < 100) {
            FontManager.putDefFont(h, test, target);
            h += 4;
        }
    }

    private static void putDefFont(int h, String test, HashMap target) {
        Font f = new Font(SANS_SERIF, 1, h);
        target.put(new Integer(FontManager.stringWidth(test, f)), f);
    }

    public static int getTableRowHeight() {
        return UIDef.getScaled(DefaultManager.cvTableFontSize + 5);
    }

    public static Font getTableFont(boolean alive, boolean useDefaultsize, double zoom) {
        return FontManager.getFont(SANS_SERIF, alive ? 1 : 0, UIDef.getScaled(FontManager.getTableFontSize(useDefaultsize, zoom)));
    }

    private static int getTableFontSize(boolean useDefaultsize, double zoom) {
        return (int)(zoom * (double)(useDefaultsize ? 11 : DefaultManager.cvTableFontSize));
    }

    public static Font getFont(String name, int style, int size) {
        String key = String.valueOf(name) + "|" + style + "|" + size;
        Font f = (Font)FONTS.get(key);
        if (f == null) {
            f = new Font(name, style, size);
            FONTS.put(key, f);
        }
        return f;
    }

    public static Font getBoldFont(Font font) {
        return FontManager.getModFont(font, font.getSize(), font.isItalic(), true);
    }

    public static Font getModFont(Font font, int size, boolean italic, boolean bold) {
        if (italic && bold) {
            return new Font(font.getFontName(), 3, size);
        }
        if (italic) {
            return new Font(font.getFontName(), 2, size);
        }
        if (italic && bold) {
            return new Font(font.getFontName(), 1, size);
        }
        return new Font(font.getFontName(), 0, size);
    }

    public static Font getMatchingCageFont(int width) {
        return FontManager.getMatchingFont(width, BOLD_CAGE_FONTS);
    }

    public static Font getMatching100Font(int width) {
        return FontManager.getMatchingFont(width, BOLD_100_FONTS);
    }

    public static Font getMatchingGommorrahFont(int width) {
        return FontManager.getMatchingFont(width, BOLD_GOMORRHA_FONTS);
    }

    public static Font getMatchingFont(int width, HashMap source) {
        int maxw = 0;
        Iterator iterator = source.keySet().iterator();
        while (iterator.hasNext()) {
            Integer inti = (Integer)iterator.next();
            int w = inti;
            if (w >= width || w <= maxw) continue;
            maxw = w;
        }
        return (Font)source.get(new Integer(maxw));
    }

    public static ImageIcon getRingeIcon(boolean useDefaultsize, boolean steril) {
        int size;
        Integer key;
        HashMap hm = steril ? RINGE_STERIL : RINGE;
        ImageIcon res = (ImageIcon)hm.get(key = new Integer(size = useDefaultsize ? UIDef.getScaled(11) : UIDef.getScaled(DefaultManager.cvTableFontSize)));
        if (res == null) {
            if (cvOriginalRinge == null) {
                cvOriginalRinge = MausoleumImageStore.getRinge();
            }
            int h = cvOriginalRinge.getHeight(null);
            while (h <= 0) {
                try {
                    Thread.sleep(50L);
                    h = cvOriginalRinge.getHeight(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            double fak = (double)size / (double)h;
            int w = (int)((double)cvOriginalRinge.getWidth(null) * fak);
            Image img = ImageCreator.getScaledInstance(cvOriginalRinge, w, size, 4);
            if (steril) {
                h = img.getHeight(null);
                while (h <= 0) {
                    try {
                        Thread.sleep(50L);
                        h = img.getHeight(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int nw = w + 12;
                BufferedImage img2 = new BufferedImage(nw, h, 2);
                Graphics g = ((Image)img2).getGraphics();
                g.drawImage(img, 6, 0, null);
                g.setColor(Color.black);
                g.drawLine(0, 0, 0, h);
                g.drawLine(1, 0, 1, h);
                g.drawLine(0, 0, 4, 0);
                g.drawLine(0, 1, 4, 1);
                g.drawLine(0, h - 1, 4, h - 1);
                g.drawLine(0, h - 2, 4, h - 2);
                g.drawLine(nw - 1, 0, nw - 1, h);
                g.drawLine(nw - 2, 0, nw - 2, h);
                g.drawLine(nw - 5, 0, nw - 1, 0);
                g.drawLine(nw - 5, 1, nw - 1, 1);
                g.drawLine(nw - 5, h - 1, nw - 1, h - 1);
                g.drawLine(nw - 5, h - 2, nw - 1, h - 2);
                img = img2;
            }
            res = new ImageIcon(img);
            hm.put(key, res);
        }
        return res;
    }

    public static Font[] getGenotypeArray(boolean useDefaultsize, Font normFontIfWanted, double zoom) {
        return FontManager.getGenotypeArray(useDefaultsize, normFontIfWanted, true, zoom);
    }

    public static Font[] getGenotypeArray(boolean useDefaultsize, Font normFontIfWanted, boolean diffSize, double zoom) {
        int size = FontManager.getTableFontSize(useDefaultsize, zoom);
        if (normFontIfWanted != null) {
            size = normFontIfWanted.getSize();
        }
        int diff = diffSize ? 1 : 0;
        String key = String.valueOf(size) + ":" + diff;
        Font[] res = (Font[])GT_FONTARRAYS.get(key);
        if (res == null) {
            res = new Font[]{FontManager.getFont(SANS_SERIF, 1, size - diff), FontManager.getFont(SANS_SERIF, 2, size - diff), FontManager.getFont(SANS_SERIF, 1, size), FontManager.getFont(SANS_SERIF, 2, size - diff), FontManager.getFont(SANS_SERIF, 0, size - diff)};
            GT_FONTARRAYS.put(key, res);
        }
        return res;
    }
}

