/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import java.awt.Color;
import mausoleum.gui.ColorManager;
import mausoleum.helper.HTMLEncoder;

public abstract class HTMLHelper {
    public static String getTDLine(String content, boolean bold, Color background, int rowspan, int colspan, boolean convertContent) {
        StringBuilder msb = new StringBuilder();
        Color fg = background != null ? ColorManager.getForegroundColorForBackground(background) : null;
        msb.append("<td valign=\"top\"");
        if (background != null) {
            msb.append(" bgcolor=\"").append(ColorManager.getHTMLColorString(background)).append("\"");
        }
        if (rowspan > 1) {
            msb.append(" rowspan=\"").append(rowspan).append("\"");
        }
        if (colspan > 1) {
            msb.append(" colspan=\"").append(colspan).append("\"");
        }
        msb.append(">");
        if (fg != null) {
            msb.append("<font color=\"").append(ColorManager.getHTMLColorString(fg)).append("\">");
        }
        if (bold) {
            msb.append("<b>");
        }
        msb.append("&nbsp;").append(convertContent ? HTMLEncoder.convertToHTML(content) : content).append("&nbsp;");
        if (bold) {
            msb.append("</b>");
        }
        if (fg != null) {
            msb.append("</font>");
        }
        msb.append("</td>\n");
        return msb.toString();
    }

    public static String makeToolTipTable(StringBuilder tableInner, String tablattr) {
        StringBuilder msb = new StringBuilder("<HTML><body marginwidth=\"5\" marginheight=\"5\">");
        msb.append("<b>");
        msb.append("<table");
        if (tablattr != null) {
            msb.append(" ").append(tablattr);
        }
        msb.append(">\n");
        msb.append((CharSequence)tableInner);
        msb.append("</table>\n");
        msb.append("</b>");
        msb.append("</body>");
        return msb.toString();
    }
}

