/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;

public class Image2String {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage java mausoleum.helper.Image2String [file] [1 bei wei\u00df != durchsichtig]");
            System.exit(1);
        }
        try {
            boolean nimmWeiss = args.length >= 2 && args[1].equals("1");
            Vector<Integer> rgbInts = new Vector<Integer>();
            File file = new File(args[0]);
            BufferedImage image = ImageIO.read(file);
            int w = image.getWidth();
            int h = image.getHeight();
            StringBuilder linesBuilder = new StringBuilder("\t\tnew String[]\n");
            linesBuilder.append("\t\t{\n");
            int y = 0;
            while (y < h) {
                linesBuilder.append("\t\t\t\"");
                int x = 0;
                while (x < w) {
                    int clr = image.getRGB(x, y);
                    int red = (clr & 0xFF0000) >> 16;
                    int green = (clr & 0xFF00) >> 8;
                    int blue = clr & 0xFF;
                    int tag = 0;
                    if (nimmWeiss || red != 255 || green != 255 || blue != 255) {
                        Integer key = new Integer(clr);
                        int index = rgbInts.indexOf(key);
                        if (index == -1) {
                            rgbInts.add(key);
                            tag = rgbInts.size();
                        } else {
                            tag = index + 1;
                        }
                    }
                    linesBuilder.append(tag == 0 ? (char)' ' : "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ,.-;:_#'+*!$%&/()=?".charAt(tag));
                    ++x;
                }
                linesBuilder.append("\",\n");
                ++y;
            }
            linesBuilder.append("\t\t},\n");
            StringBuilder colorsBuilder = new StringBuilder();
            colorsBuilder.append("\t\tnew int[]\n");
            colorsBuilder.append("\t\t{\n");
            colorsBuilder.append("\t\t\tCOL_DURCHSICHTIG,\n");
            Iterator iterator = rgbInts.iterator();
            while (iterator.hasNext()) {
                Integer inti = (Integer)iterator.next();
                colorsBuilder.append("\t\t\t0x").append(Integer.toHexString(inti)).append(",\n");
            }
            colorsBuilder.append("\t\t}\n");
            System.out.println("public static final ImageIcon _ICON =");
            System.out.println("\tgetIcon");
            System.out.println("\t(");
            System.out.println(linesBuilder);
            System.out.println(colorsBuilder);
            System.out.println("\t);");
        }
        catch (Exception e) {
            System.out.println("Riesenkack " + e);
        }
    }
}

