/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import de.hannse.netobjects.tools.StringHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.TaskColor;
import mausoleum.gui.ColorManager;
import mausoleum.helper.FontManager;
import mausoleum.rack.frame.CageDisplayManager;
import mausoleum.rack.frame.RackGraphicsManager;
import mausoleum.ui.UIDef;
import mausoleum.util.InstallationType;

public class ImageProvider {
    public static final String TAGS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ,.-;:_#'+*!$%&/()=?";
    public static int COL_DURCHSICHTIG = new Color(255, 0, 0, 0).getRGB();
    public static int COL_WHITE = Color.white.getRGB();
    public static int COL_BLACK = Color.black.getRGB();
    private static final int[] SCHWARZ_NIX = new int[]{COL_DURCHSICHTIG, COL_BLACK};
    private static final HashMap TRIANGLES_BY_COLOR = new HashMap();
    private static final HashMap BULLET_ICONS = new HashMap(20);
    private static final String[] BULLET = new String[]{"              ", "              ", "     1112     ", "   51151121   ", "   16565122   ", "  1556511223  ", "  1151112233  ", "  2111222334  ", "  2222223343  ", "   22233344   ", "   33333443   ", "     3443     ", "              ", "              "};
    public static final ImageIcon CLEAR_BULLET_ICON = ImageProvider.getIcon(new String[]{"              ", "              ", "              ", "              ", "              ", "              ", "              ", "              ", "              ", "              ", "              ", "              ", "              ", "              "}, SCHWARZ_NIX);
    public static final ImageIcon HAKEN_ICON = ImageProvider.getIcon(new String[]{"         1", "        1 ", "       1  ", "      1   ", "     1    ", "11  1     ", " 1 11     ", " 111      ", "  11      ", "  1       "}, SCHWARZ_NIX);
    public static final ImageIcon EXCEL_ICON = ImageProvider.getIcon(new String[]{"1111111111111111", "1111111111111111", "11            11", "11 1111   111 11", "11 11111 1111 11", "11 1 11111111 11", "11  1 111111  11", "11   1 1111   11", "11  111 11111 11", "11 11111 1111 11", "11 111111 111 11", "11 1111111 11111", "11       1111111", "11            11", "1111111111111111", "1111111111111111"}, new int[]{COL_WHITE, new Color(4, 102, 4).getRGB()});
    public static final ImageIcon CHECK_SEL_ICON = ImageProvider.getIcon(new String[]{"1111111111111", "1           1", "1        1  1", "1       11  1", "1  1   111  1", "1  11 111   1", "1  11111    1", "1   111     1", "1    1      1", "1           1", "1111111111111"}, SCHWARZ_NIX);
    public static ImageIcon CHECK_UNSEL_ICON = ImageProvider.getIcon(new String[]{"1111111111111", "1           1", "1           1", "1           1", "1           1", "1           1", "1           1", "1           1", "1           1", "1           1", "1111111111111"}, SCHWARZ_NIX);
    public static ImageIcon CHECK_EMPTY_ICON = ImageProvider.getIcon(new String[]{"             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             ", "             "}, SCHWARZ_NIX);
    public static final ImageIcon SUM_ICON = new ImageIcon(ImageProvider.generateImage(new String[]{"            ", " 1111111111 ", " 1111111111 ", " 11      11 ", "  11        ", "   11       ", "    11      ", "   11       ", "  11     11 ", " 1111111111 ", " 1111111111 ", "            "}, SCHWARZ_NIX));
    public static final ImageIcon EMPTY_SUM_ICON = new ImageIcon(ImageProvider.generateImage(new String[]{"            ", "            ", "            ", "            ", "            ", "            ", "            ", "            ", "            ", "            ", "            ", "            "}, SCHWARZ_NIX));
    private static final String[] TRIANGLE = new String[]{"222222221 ", "22222221  ", "2222221   ", "222221    ", "22221     ", "2221      ", "221       ", "21        ", "1         "};
    public static final Image SCHRAFF_IMAGE = ImageProvider.generateImage(new String[]{"1111    ", "111    1", "11    11", "1    111", "    1111", "   1111 ", "  1111  ", " 1111   "}, new int[]{Color.lightGray.getRGB(), Color.white.getRGB()});
    public static final ImageIcon EMPTY_HAKEN_ICON = ImageProvider.getIcon(new String[]{"          ", "          ", "          ", "          ", "          ", "          ", "          ", "          ", "          ", "          "}, SCHWARZ_NIX);
    public static final ImageIcon BROWSE_WEITER_ICON = ImageProvider.getIcon(new String[]{" 1          ", " 11         ", " 1 1        ", " 1  1       ", " 1   2      ", " 1  2       ", " 1 2        ", " 12         "}, new int[]{COL_DURCHSICHTIG, COL_BLACK, COL_WHITE});
    private static final String[] CAGE_MARK_STRING = new String[]{" 111 ", "13332", "13332", "13332", " 222 "};
    public static final Image CAGE_MARK_IMAGE = ImageProvider.generateImage(CAGE_MARK_STRING, new int[]{COL_DURCHSICHTIG, COL_BLACK, COL_WHITE, new Color(10, 10, 70).getRGB()});
    public static final Image CAGE_MATING_IMAGE = ImageProvider.generateImage(CAGE_MARK_STRING, new int[]{COL_DURCHSICHTIG, COL_WHITE, COL_BLACK, Color.yellow.getRGB()});
    public static final Image CAGE_STERILE_MATING_IMAGE = ImageProvider.generateImage(CAGE_MARK_STRING, new int[]{COL_DURCHSICHTIG, COL_WHITE, COL_BLACK, COL_DURCHSICHTIG});
    public static final ImageIcon HAND_ICON = ImageProvider.getIcon(new String[]{"            ", "            ", "            ", "     111111 ", " 11112222221", " 1112221111 ", " 11121121   ", " 11122211   ", " 111111     ", "            ", "            "}, new int[]{COL_DURCHSICHTIG, -16777216, -19052});
    public static final Image PLUS_IMAGE = ImageProvider.generateImage(new String[]{"11111111111111", "12222222222223", "12222333122223", "12222344122223", "12222344122223", "12333344333123", "12344444444123", "12344444444123", "12111344111123", "12222344122223", "12222344122223", "12222111122223", "12222222222223", "13333333333333"}, new int[]{COL_DURCHSICHTIG, -1, -3223858, -16777216, -16734960});
    public static final Image MINUS_IMAGE = ImageProvider.generateImage(new String[]{"11111111111111", "12222222222223", "12222222222223", "12222222222223", "12222222222223", "12333333333223", "12344444444123", "12344444444123", "12111111111123", "12222222222223", "12222222222223", "12222222222223", "12222222222223", "13333333333333"}, new int[]{COL_DURCHSICHTIG, -1, -3223858, -16777216, -3274744});
    public static final Image MAUS_IMAGE = ImageProvider.generateImage(new String[]{"                                ", "                                ", "                                ", "                                ", "                                ", "                                ", "                                ", "                                ", "                                ", "                                ", "                                ", "               11               ", "              1221              ", "             122221      11     ", "             1222211111   11    ", "            122222122211    1   ", "          111222221222211   1   ", "         11222222122221211 11   ", "       111212221122221222111    ", "   11111221122222222212221      ", "   11222222222222222212221      ", "     112222212222211122221      ", "       111212212221222111       ", "         1111122111121          ", "            1221    1           ", "            121                 ", "            11                  ", "                                ", "                                ", "                                ", "                                ", "                                "}, new int[]{COL_DURCHSICHTIG, -16777216, -2064320});
    public static final Image MAEUSE_IMAGE = ImageProvider.generateImage(new String[]{"                                ", "                                ", "                 11             ", "                1221            ", "               122221      11   ", "               1222211111   11  ", "              122222122211    1 ", "            111222221222211   1 ", "           11331222122221211 11 ", "         111333311122221122111  ", "     11111213333111112211121    ", "     11222133333133311212211    ", "       111133333133331122211    ", "       11333333133331311111     ", "     111313331133111333111      ", " 11111331133333314413331        ", " 11333333333333144441331   11   ", "   1133333133331444411111   11  ", "     111313313144444144411    1 ", "       11111111444441444411   1 ", "          111444444144441411 11 ", "         111414441144441444111  ", "     11111441144444444414441    ", "     11444444444444444414441    ", "       114444414444411144441    ", "         111414414441444111     ", "           1111144111141        ", "              1441    1         ", "              141               ", "              11                ", "                                ", "                                "}, new int[]{COL_DURCHSICHTIG, -16777216, -8355776, -2039680, -2064320});
    public static final Image ONE_FISH_IMAGE = ImageProvider.generateImage(new String[]{"                                ", "                                ", "                                ", "                                ", "            3444                ", "           54677                ", "        5 5486698335        55  ", "        3344a888698355   53aba45", "     5a66c84aa4ac48985 3cbbddda ", "    4c66e6ca8a8acac6c4a76bbddb4 ", "   4c7767dc9c966f776cce7dded6a5 ", "  569cdc7ee66777e7f7ee7feeea45  ", "53976bgb7ed6ff7f667ede777eb4    ", " 8fff66c7eeffff9f7ed6a896d685   ", " aede6ff7ee6f77eeeeec5 3a7793   ", "  5cdddeedeeeeeddb6f95  58f795  ", "    54abddbdddee355335   587f85 ", "      555534ac9983        58455 ", "            53353               ", "                                ", "                                ", "                                ", "                                ", "                                ", "                                ", "                                ", "                                ", "                                ", "                                ", "                                ", "                                ", "                                "}, new int[]{COL_DURCHSICHTIG, -196869, -16449796, -595034, -1124718, -265260, -1982417, -2178286, -1319577, -1451467, -1783184, -3693260, -1652657, -3759344, -3427568, -1584109, -7576060});
    public static final Image TWO_FISH_IMAGE = ImageProvider.generateImage(new String[]{"                                ", "                                ", "                                ", "                                ", "            3445                ", "           34677                ", "           58899553         3   ", "        5554aaaa98b5 3    54645 ", "      4698aaa4aaa4bcb  58d6deea ", "    489d77aaa8aa8888848776deee4 ", "   569787d688899c7778679ddd76a3 ", "  36c8e8777999777999777c7d765   ", " 5b796fd7dd9c99c799ded779d74    ", " 8gc98787d79c9c997dd68b87775    ", " 47dd7c99dd9997dddddc5 3a77933  ", "  36ddd7dedddddddd7cgb333b97g3ba", "     466ddddded78bagbbgb 3b97c99", "     3 b8c9979ccc8ab8bgbbbc99c97", "      58gccc99gbccgggcg88cg99998", "     3bg87bc99cgcccccggc9cg999b3", "    3bcg8e9cc9gggggggc99ccgg9c5 ", "    bggggggg9ccgggggcc9cbbbccc5 ", "    bc99cgcccccgcccccccb  3bgcg3", "      bc9ccc99cccc999cgg3  3bggb", "       35a8999999cc3  33     bgg", "          3 3 5bbbbb3        335", "                3333            ", "                                ", "                                ", "                                ", "                                ", "                                "}, new int[]{COL_DURCHSICHTIG, -197384, -16449796, -530011, -1262965, -601448, -3109814, -2584806, -1789618, -2447847, -1526417, -1518757, -2573797, -3705331, -3907568, -7590396, -1651170});

    public static Image getTriangle(Color col) {
        Image res;
        if (col == null) {
            col = TaskColor.STANDARD_TASK_TRIANGLE_COLOR;
        }
        if ((res = (Image)TRIANGLES_BY_COLOR.get(col)) == null) {
            res = ImageProvider.generateImage(TRIANGLE, new int[]{COL_DURCHSICHTIG, ColorManager.getForegroundColorForBackground(col).getRGB(), col.getRGB()});
            TRIANGLES_BY_COLOR.put(col, res);
        }
        return res;
    }

    public static ImageIcon getBulletIcon(Color ocol) {
        ImageIcon ii = (ImageIcon)BULLET_ICONS.get(ocol);
        if (ii == null) {
            int[] colors = new int[7];
            colors[0] = COL_DURCHSICHTIG;
            colors[1] = ocol.getRGB();
            colors[6] = COL_WHITE;
            Color hc = new Color(ocol.getRed() / 2, ocol.getGreen() / 2, ocol.getRed() / 2);
            colors[3] = hc.getRGB();
            Color hc2 = new Color(hc.getRed() / 2, hc.getGreen() / 2, hc.getRed() / 2);
            colors[4] = hc2.getRGB();
            Color hc3 = new Color((ocol.getRed() + hc.getRed()) / 2, (ocol.getGreen() + hc.getGreen()) / 2, (ocol.getRed() + hc.getRed()) / 2);
            colors[2] = hc3.getRGB();
            Color hc4 = new Color((ocol.getRed() + 255) / 2, (ocol.getGreen() + 255) / 2, (ocol.getRed() + 255) / 2);
            colors[5] = hc4.getRGB();
            ii = ImageProvider.getIcon(BULLET, colors);
            BULLET_ICONS.put(ocol, ii);
        }
        return ii;
    }

    public static ImageIcon getIcon(String[] arr, int[] colorarr) {
        return new ImageIcon(ImageProvider.generateImage(arr, colorarr));
    }

    public static Image generateImage(String[] arr, int[] colorarr) {
        int x;
        int h = arr.length;
        int w = arr[0].length();
        int[][] parr = new int[w][h];
        int y = 0;
        while (y < h) {
            String s = StringHelper.gSub(arr[y], " ", "0", true);
            x = 0;
            while (x < w) {
                parr[x][y] = TAGS.indexOf(s.charAt(x));
                ++x;
            }
            ++y;
        }
        BufferedImage img = new BufferedImage(w, h, 2);
        DataBuffer db = img.getRaster().getDataBuffer();
        x = 0;
        while (x < w) {
            int y2 = 0;
            while (y2 < h) {
                int col = parr[x][y2];
                db.setElem(y2 * w + x, colorarr[col]);
                ++y2;
            }
            ++x;
        }
        return ImageProvider.scaleIfNecess(img);
    }

    public static BufferedImage getCageImage(Vector cages) {
        BufferedImage img = null;
        if (cages != null && !cages.isEmpty()) {
            int sizz = RackGraphicsManager.getCageWidth() + 4;
            Dimension bd = Toolkit.getDefaultToolkit().getBestCursorSize(sizz, sizz);
            if (bd.width < sizz) {
                sizz = bd.width;
            }
            img = new BufferedImage(sizz, sizz, 2);
            ImageProvider.machEsDurchsichtig(img);
            int stapelOffset = 3;
            int singleWidth = sizz - 4;
            if (cages.size() == 2) {
                singleWidth -= stapelOffset;
            } else if (cages.size() >= 3) {
                singleWidth -= 2 * stapelOffset;
            }
            int i = 0;
            while (i < cages.size() && i < 3) {
                Cage cageToHandle = (Cage)cages.elementAt(i);
                cageToHandle = cageToHandle.getSuperCageIfThere();
                CageDisplayManager.paintCage(cageToHandle, img.getGraphics(), 2 + i * stapelOffset, 2 + i * stapelOffset, singleWidth, (sizz - 4) / 2, null, null);
                ++i;
            }
        }
        return img;
    }

    public static Image getDefMouseImage(Vector mice) {
        return InstallationType.isMouse() ? (mice.size() == 1 ? MAUS_IMAGE : MAEUSE_IMAGE) : (mice.size() == 1 ? ONE_FISH_IMAGE : TWO_FISH_IMAGE);
    }

    public static BufferedImage getMiceImage(Vector mice) {
        BufferedImage img = null;
        if (mice != null && !mice.isEmpty()) {
            Image mimg = ImageProvider.getDefMouseImage(mice);
            int sizz = mimg.getWidth(null);
            img = new BufferedImage(sizz, sizz, 2);
            ImageProvider.machEsDurchsichtig(img);
            ImageProvider.drawMiceStuff(img.getGraphics(), mimg, sizz, sizz, mice.size());
        }
        return img;
    }

    public static void drawMiceStuff(Graphics g, Image mimg, int width, int height, int anz) {
        int bx = (width - mimg.getWidth(null)) / 2;
        int by = (height - mimg.getHeight(null)) / 2;
        g.drawImage(mimg, bx, by, null);
        CageDisplayManager.drawNumber(g, 0, 0, String.valueOf(anz), true, 0, width, height, FontManager.getFont("SSB16"));
    }

    public static void machEsDurchsichtig(BufferedImage img) {
        DataBuffer db = img.getRaster().getDataBuffer();
        int siz = db.getSize();
        int i = 0;
        while (i < siz) {
            db.setElem(i, COL_DURCHSICHTIG);
            ++i;
        }
    }

    public static Image scaleIfNecess(Image img) {
        int aw;
        double sf = UIDef.getScaleFactor();
        if (sf != 1.0 && (aw = ImageProvider.gw(img)) != -1) {
            int ah = img.getHeight(null);
            img = img.getScaledInstance((int)((double)aw * sf), (int)((double)ah * sf), 4);
            ImageProvider.gw(img);
        }
        return img;
    }

    private static int gw(Image img) {
        int max = 50;
        int aw = img.getWidth(null);
        while (aw == -1 && max > 0) {
            aw = img.getWidth(null);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            --max;
        }
        return aw;
    }
}

