/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MilliSpender;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.cage.Cage;
import mausoleum.factsheets.VisitReport;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.inspector.Inspector;
import mausoleum.line.Line;
import mausoleum.line.LineAddRequester;
import mausoleum.line.LineManager;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.requester.mouse.SelectMouseRequester;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.result.embryotransfer.MResEmbryoTransfer;
import mausoleum.visit.Visit;

public abstract class LitterHelper {
    private static final double MISCHUNGS_MINIMUM = 4.8828125E-4;
    public static final long HOT_START_DEFAULT = 28L;
    public static final long HOT_END_DEFAULT = 16L;
    public static final long HOT_START_TOLERANCE = 6L;
    public static final long HOT_END_TOLERANCE = 6L;

    public static Mouse findSuitableFatherForLittering(Date datum, Mouse weibchen, boolean[] mussPetzen) {
        boolean cont;
        long tol;
        Vector v;
        long hotEnd;
        if (weibchen == null) {
            return LitterHelper.complain(Babel.get("LH_ALERT_NO_MOUSE"));
        }
        if (weibchen.get("IDO_END_DATE") != null) {
            return LitterHelper.complain(Babel.get("LH_ALERT_MOUSE_DEAD"));
        }
        if (weibchen.getSex() != 2) {
            return LitterHelper.complain(Babel.get("LH_ALERT_FEMALE"));
        }
        long hotStart = datum.getTime() - 2419200000L;
        Vector candidateFathers = LitterHelper.getCandidateFathers(weibchen, hotStart, hotEnd = datum.getTime() - 1382400000L, null, null);
        if (candidateFathers.size() == 1) {
            return (Mouse)candidateFathers.elementAt(0);
        }
        if (candidateFathers.isEmpty()) {
            v = new Vector();
            tol = 1L;
            long endeInteressant = hotStart + 86400000L;
            cont = true;
            while (cont) {
                v = LitterHelper.getCandidateFathers(weibchen, hotStart - tol * 86400000L, endeInteressant, null, null);
                if (v.size() == 1) {
                    return (Mouse)v.elementAt(0);
                }
                if (v.size() > 1) {
                    cont = false;
                    continue;
                }
                if (tol >= 6L) {
                    cont = false;
                    continue;
                }
                ++tol;
            }
        }
        if (candidateFathers.isEmpty()) {
            v = new Vector();
            tol = 1L;
            long beginnInteressant = hotEnd - 86400000L;
            cont = true;
            while (cont) {
                v = LitterHelper.getCandidateFathers(weibchen, beginnInteressant, hotEnd + tol * 86400000L, null, null);
                if (v.size() == 1) {
                    return (Mouse)v.elementAt(0);
                }
                if (v.size() > 1) {
                    cont = false;
                    continue;
                }
                if (tol >= 6L) {
                    cont = false;
                    continue;
                }
                ++tol;
            }
        }
        if (candidateFathers.size() > 1 && Privileges.hasPrivilege("MOS_LITTER_MULTIPLE_FATHER") && PopeAlert.getAnswer(Babel.get("LH_ALERT_POTENTIAL_FATHERS"))) {
            mussPetzen[0] = true;
            return SelectMouseRequester.getSelectedMouse(Inspector.getInspector(), candidateFathers);
        }
        if (candidateFathers.isEmpty()) {
            if (Privileges.hasPrivilege("MOS_LITTER_CAGE_MATE_FATHER")) {
                Vector v2;
                Visit[] visArr;
                HashMap allMice;
                Vector<Mouse> alleKumpel = new Vector<Mouse>();
                HashMap allCages = VisitReport.collectCages(weibchen);
                if (allCages != null && !allCages.isEmpty() && (allMice = VisitReport.collectMice(allCages, weibchen.getGroup())) != null && (visArr = (Visit[])weibchen.get("MOS_VISIT")) != null) {
                    int i = 0;
                    while (i < visArr.length) {
                        Cage c = (Cage)allCages.get(new Long(visArr[i].ivCageID));
                        Vector cagePals = VisitReport.getCagePals(c, weibchen, visArr[i], allMice, null);
                        Iterator iter = cagePals.iterator();
                        while (iter.hasNext()) {
                            Mouse maus = (Mouse)iter.next();
                            if (maus.getSex() != 1 || !maus.isSexActive(hotEnd)) continue;
                            alleKumpel.add(maus);
                        }
                        ++i;
                    }
                }
                Vector<Mouse> aktuelleKumpel = new Vector<Mouse>();
                Cage c = weibchen.getActCage();
                if (c != null && (v2 = c.getActualMice()) != null && !v2.isEmpty()) {
                    Iterator iter = v2.iterator();
                    while (iter.hasNext()) {
                        Mouse maus = (Mouse)iter.next();
                        if (maus.getSex() != 1 || !maus.isSexActive(hotEnd)) continue;
                        aktuelleKumpel.add(maus);
                    }
                }
                if (!(aktuelleKumpel.isEmpty() && alleKumpel.isEmpty() || !PopeAlert.getAnswer(Babel.get("LH_NO_MATINGS_BUT_CAGE_MATES")))) {
                    mussPetzen[0] = true;
                    return SelectMouseRequester.getSelectedMouse(Inspector.getInspector(), new Vector[]{aktuelleKumpel, alleKumpel}, new String[]{Babel.get("ACTUAL_MALE_CAGEMATES"), Babel.get("ALL_MALE_CAGEMATES")});
                }
            }
            if (MausoleumClient.isRegularOrTGService() && Privileges.hasPrivilege("MOS_LITTER_ALL_MICE_LITTER") && PopeAlert.getAnswer(Babel.get("LH_NO_MATINGS_BUT_ALL_POTENTIALMICE"))) {
                candidateFathers.clear();
                Vector allMice = MouseManager.getActualObjects(weibchen.getGroup());
                Iterator iter = allMice.iterator();
                while (iter.hasNext()) {
                    Mouse maus = (Mouse)iter.next();
                    if (maus.getSex() != 1 || !maus.isSexActive(hotEnd)) continue;
                    candidateFathers.add(maus);
                }
                mussPetzen[0] = true;
                return SelectMouseRequester.getSelectedMouse(Inspector.getInspector(), candidateFathers);
            }
        }
        return null;
    }

    public static Vector getCandidateFathers(Mouse weibchen, long hotStart, long hotEnd, Vector candidateMotherVisits, Vector candidateFatherVisits) {
        Vector candidateFathers = new Vector();
        Visit[] visits = (Visit[])weibchen.get("MOS_VISIT");
        if (visits != null && visits.length != 0) {
            Vector<Visit> mothersCandidateVisits = new Vector<Visit>();
            int i = 0;
            while (i < visits.length) {
                Visit tv = visits[i];
                if (tv.ivStartDate != null && tv.ivStartDate.getTime() < hotEnd) {
                    if (tv.ivEndDate == null) {
                        mothersCandidateVisits.addElement(tv);
                    } else if (tv.ivStartDate.getTime() < tv.ivEndDate.getTime() && tv.ivEndDate.getTime() > hotStart) {
                        mothersCandidateVisits.addElement(tv);
                    }
                }
                ++i;
            }
            if (!mothersCandidateVisits.isEmpty()) {
                String wgroup = weibchen.getGroup();
                long wid = weibchen.getID();
                Iterator iterator = mothersCandidateVisits.iterator();
                while (iterator.hasNext()) {
                    Visit[] cvisits;
                    Visit motherVisit = (Visit)iterator.next();
                    Cage c = (Cage)ObjectStore.getObjectDeadOrAlive(2, motherVisit.ivCageID, wgroup, null, false);
                    if (c == null || (cvisits = (Visit[])c.get("CAG_VISIT")) == null) continue;
                    int j = 0;
                    while (j < cvisits.length) {
                        Visit tv = cvisits[j];
                        if (tv.ivStartDate != null) {
                            long tsd = tv.ivStartDate.getTime();
                            if (tv.ivMouseID != wid && tsd < hotEnd) {
                                boolean probiers = false;
                                if (tv.ivEndDate == null) {
                                    probiers = true;
                                } else {
                                    long ted = tv.ivEndDate.getTime();
                                    if (ted > tsd && ted > hotStart) {
                                        probiers = true;
                                    }
                                }
                                if (probiers && LitterHelper.addCandidateIfMale(tv, candidateFathers, hotEnd, wgroup, candidateFatherVisits) && candidateMotherVisits != null) {
                                    candidateMotherVisits.add(motherVisit);
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
        }
        return candidateFathers;
    }

    private static Mouse complain(String message) {
        Alert.showAlert(message, true);
        return null;
    }

    private static boolean addCandidateIfMale(Visit visit, Vector candidateFathers, long hotEnd, String group, Vector candidateFatherVisits) {
        boolean takeit = false;
        Mouse maus = (Mouse)ObjectStore.getObjectDeadOrAlive(1, visit.ivMouseID, group, null, false);
        if (maus != null && maus.getSex() == 1) {
            if (maus.getDate("MOS_BIRTHDAY") != null) {
                long maturityLimit = maus.getMaturityLimit();
                long alter = maus.getDate("MOS_BIRTHDAY").getTime();
                Date todesDatum = maus.getDate("IDO_END_DATE");
                if (todesDatum != null && todesDatum.getTime() - alter < maturityLimit) {
                    return false;
                }
                if (hotEnd - alter >= maturityLimit) {
                    takeit = true;
                }
            } else {
                takeit = true;
            }
            if (takeit) {
                if (!candidateFathers.contains(maus)) {
                    candidateFathers.addElement(maus);
                }
                if (candidateFatherVisits != null) {
                    candidateFatherVisits.add(visit);
                }
            }
        }
        return takeit;
    }

    public static long determineLineIDForOffspring(Mouse mum, Mouse dad, boolean createLineIfPossible, long defVal) {
        if (ProcessDefinition.isClient()) {
            IDObject matchline = null;
            if (mum != null && dad != null) {
                Vector<Mouse> v = new Vector<Mouse>();
                v.add(mum);
                v.add(dad);
                String commonGroup = IDObject.commonGroup(v);
                if (commonGroup != null) {
                    Line mumLine = mum.getLine();
                    Line dadLine = dad.getLine();
                    if (mumLine != null && dadLine != null && (matchline = Line.getMatchingLineIfThere(mumLine, dadLine, LineManager.cvInstance.getActualObjectVector(commonGroup))) == null && createLineIfPossible && Privileges.hasPrivilege("CREATE_LINE_DURING_LITTER") && (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Alert.showAlert(Babel.get("NOLINEFOUND"), false) && (matchline = LineAddRequester.createMixtureLine(Inspector.getInspector(), mumLine, dadLine)) != null) {
                        long lineUniqueLong = matchline.getLong("IDO_UNIQUELONG", 0L);
                        if (lineUniqueLong == 0L) {
                            lineUniqueLong = MilliSpender.getMillis();
                            matchline.setLong("IDO_UNIQUELONG", lineUniqueLong);
                        }
                        matchline.set("IDO_GROUP", commonGroup);
                        Line.createLineOnServer((Line)matchline);
                        matchline = LineManager.getLineWithUniqueID(lineUniqueLong, commonGroup);
                    }
                }
                if (matchline != null) {
                    return matchline.getID();
                }
            }
        }
        return defVal;
    }

    public static Mouse makeModel(Date birthDate, Mouse mum, Mouse dad, long lineID, LocusAndAlleles[] lalArr, MResEmbryoTransfer embryoTransfer, Hashtable objectBag) {
        Mouse model = new Mouse();
        model.set("IDO_START_DATE", birthDate);
        model.set("MOS_BIRTHDAY", birthDate);
        if (embryoTransfer != null) {
            lineID = embryoTransfer.ivLineID;
            model.setLong("MOS_LINEID", lineID);
            Line line = (Line)ObjectStore.getObjectDeadOrAlive(7, lineID, mum.getGroup(), objectBag, false);
            if (line != null) {
                model.set("MOS_LINLICID", line.get("LIN_LIC"));
            }
            model.set("MOS_STRAIN", embryoTransfer.ivStrains);
            model.setInt("MOS_STARTMODE", 11);
            model.set("MOS_FOSTID", mum.getLongID());
            mum.set("MOS_WFOST", true);
        } else {
            model.set("MOS_MOTHER", mum.getLongID());
            int genMa = mum.getGeneration(0, false);
            if (genMa != 0) {
                model.setInt("MOS_GENMO", genMa);
            }
            if (dad != null) {
                model.setLong("MOS_FATHER", dad.getID());
                int genPa = dad.getGeneration(0, false);
                if (genPa != 0) {
                    model.setInt("MOS_GENFA", genPa);
                }
                if (lineID != 0L) {
                    model.setLong("MOS_LINEID", lineID);
                    Line line = (Line)ObjectStore.getObjectDeadOrAlive(7, lineID, mum.getGroup(), objectBag, false);
                    if (line != null) {
                        model.set("MOS_LINLICID", line.get("LIN_LIC"));
                    }
                    if (lalArr != null) {
                        model.set("MOS_LOCUSGENOTYPES", lalArr);
                    }
                }
            }
            model.set("MOS_STRAIN", LitterHelper.getPupStrain(dad, mum));
            model.set("MOS_COHORTS", LitterHelper.getPupCohorts(dad, mum));
            model.setInt("MOS_STARTMODE", 1);
        }
        return model;
    }

    private static long[] getPupCohorts(Mouse dad, Mouse mum) {
        long[] erg = null;
        HashSet hs = new HashSet();
        LitterHelper.addInheritableCohortIDs(dad, hs);
        LitterHelper.addInheritableCohortIDs(mum, hs);
        if (!hs.isEmpty()) {
            erg = new long[hs.size()];
            int pos = 0;
            Iterator iter = hs.iterator();
            while (iter.hasNext()) {
                Long l = (Long)iter.next();
                erg[pos++] = l;
            }
        }
        return erg;
    }

    private static void addInheritableCohortIDs(Mouse mouse, HashSet target) {
        long[] cohIDs;
        if (mouse != null && target != null && (cohIDs = (long[])mouse.get("MOS_COHORTS")) != null) {
            int i = 0;
            while (i < cohIDs.length) {
                IDObjectGroup iog = (IDObjectGroup)ObjectStoreServer.getObjectDeadOrAlive(19, cohIDs[i], mouse.getGroup(), null, true, false);
                if (iog != null && iog.isAliveAndVisible() && iog.getBoolean("IOG_INHERITABLE", false)) {
                    target.add(iog.get("IDO_ID"));
                }
                ++i;
            }
        }
    }

    public static IndexObject[] getPupStrain(Mouse dad, Mouse mum) {
        if (mum != null && dad != null) {
            Vector modelStrains = new Vector();
            LitterHelper.copyLSV((IndexObject[])mum.get("MOS_STRAIN"), modelStrains);
            LitterHelper.copyLSV((IndexObject[])dad.get("MOS_STRAIN"), modelStrains);
            if (modelStrains.size() != 0) {
                IndexObject se;
                int i;
                Vector erg = null;
                if (modelStrains.size() > 1) {
                    erg = new Vector();
                    i = 0;
                    while (i < modelStrains.size()) {
                        se = (IndexObject)modelStrains.elementAt(i);
                        LitterHelper.fitIndexObjInVector(se, erg);
                        ++i;
                    }
                } else {
                    erg = modelStrains;
                }
                i = 0;
                while (i < erg.size()) {
                    se = (IndexObject)erg.elementAt(i);
                    se.ivNumber /= 2.0;
                    ++i;
                }
                Vector<IndexObject> ukerg = new Vector<IndexObject>();
                int i2 = 0;
                while (i2 < erg.size()) {
                    IndexObject se2 = (IndexObject)erg.elementAt(i2);
                    if (se2.ivNumber > 4.8828125E-4) {
                        ukerg.addElement(se2);
                    }
                    ++i2;
                }
                if (!ukerg.isEmpty()) {
                    IndexObject[] arr = new IndexObject[ukerg.size()];
                    int i3 = 0;
                    while (i3 < ukerg.size()) {
                        arr[i3] = (IndexObject)ukerg.elementAt(i3);
                        ++i3;
                    }
                    return arr;
                }
            }
        }
        return null;
    }

    private static void copyLSV(IndexObject[] from, Vector to) {
        if (from != null) {
            int i = 0;
            while (i < from.length) {
                to.addElement(new IndexObject(from[i]));
                ++i;
            }
        }
    }

    private static void fitIndexObjInVector(IndexObject se, Vector erg) {
        int i = 0;
        while (i < erg.size()) {
            IndexObject ve = (IndexObject)erg.elementAt(i);
            if (se.ivObjectID == ve.ivObjectID) {
                ve.ivNumber += se.ivNumber;
                return;
            }
            ++i;
        }
        erg.addElement(se);
    }

    public static void fillInLitterMouse(Mouse litterMaus, Mouse modellMaus, Hashtable objectBag) {
        long birthdayMillis = modellMaus.getDate("MOS_BIRTHDAY").getTime();
        litterMaus.setDate("IDO_START_DATE", modellMaus.getDate("IDO_START_DATE").getTime());
        litterMaus.setInt("MOS_STARTMODE", modellMaus.getInt("MOS_STARTMODE"));
        litterMaus.set("MOS_BIRTHDAY", new Date(birthdayMillis));
        litterMaus.set("MOS_FATHER", modellMaus.get("MOS_FATHER"));
        litterMaus.set("MOS_MOTHER", modellMaus.get("MOS_MOTHER"));
        litterMaus.set("MOS_FOSTID", modellMaus.get("MOS_FOSTID"));
        litterMaus.set("MOS_LOCUSGENOTYPES", LocusAndAlleles.createCopy((LocusAndAlleles[])modellMaus.get("MOS_LOCUSGENOTYPES")));
        litterMaus.setInt("MOS_GENFA", modellMaus.getInt("MOS_GENFA", 0), 0);
        litterMaus.setInt("MOS_GENMO", modellMaus.getInt("MOS_GENMO", 0), 0);
        litterMaus.set("MOS_LINEID", modellMaus.get("MOS_LINEID"));
        litterMaus.set("MOS_LINLICID", modellMaus.get("MOS_LINLICID"));
        litterMaus.set("MOS_STRAIN", LitterHelper.getACopyOfLSV((IndexObject[])modellMaus.get("MOS_STRAIN")));
        long[] lcohortIDs = null;
        long[] mcohortIDs = (long[])modellMaus.get("MOS_COHORTS");
        if (mcohortIDs != null) {
            lcohortIDs = new long[mcohortIDs.length];
            int i = 0;
            while (i < mcohortIDs.length) {
                lcohortIDs[i] = mcohortIDs[i];
                IDObject cohort = ObjectStore.getObjectDeadOrAlive(19, mcohortIDs[i], litterMaus.getGroup(), objectBag, true);
                if (cohort != null) {
                    IDObject.handleLongToArr(cohort, "IOG_IDS", litterMaus.getID(), true);
                }
                ++i;
            }
        }
        litterMaus.set("MOS_COHORTS", lcohortIDs);
    }

    public static void incKidArrays(Mouse parent, long[] kidIDs, int birthDay, Mouse kidModel) {
        if (parent != null) {
            long[] newKids = null;
            long[] oldKids = (long[])parent.get("MOS_KID");
            if (oldKids == null) {
                newKids = kidIDs;
            } else {
                newKids = new long[oldKids.length + kidIDs.length];
                int i = 0;
                while (i < oldKids.length) {
                    newKids[i] = oldKids[i];
                    ++i;
                }
                i = 0;
                while (i < kidIDs.length) {
                    newKids[i + oldKids.length] = kidIDs[i];
                    ++i;
                }
            }
            parent.set("MOS_KID", newKids);
            LitterHelper.incIntArr(parent, "MOS_KID_BD", kidIDs.length, birthDay);
            LitterHelper.incIntArr(parent, "MOS_KID_SX", kidIDs.length, 0);
            long opVal = -3L;
            long kfid = kidModel.getLong("MOS_FATHER", -3L);
            long kmid = kidModel.getLong("MOS_MOTHER", -3L);
            long amid = parent.getID();
            if (amid == kfid) {
                opVal = kmid;
            } else if (amid == kmid) {
                opVal = kfid;
            }
            if (opVal <= 0L) {
                opVal = -3L;
            }
            LitterHelper.incLongArr(parent, "MOS_KID_OP", kidIDs.length, opVal);
        }
    }

    private static void incIntArr(Mouse parent, String arrKey, int anz, int value) {
        int[] newKidArray = null;
        int[] oldKidArray = (int[])parent.get(arrKey);
        if (oldKidArray == null) {
            newKidArray = new int[anz];
            int i = 0;
            while (i < newKidArray.length) {
                newKidArray[i] = value;
                ++i;
            }
        } else {
            newKidArray = new int[oldKidArray.length + anz];
            int i = 0;
            while (i < oldKidArray.length) {
                newKidArray[i] = oldKidArray[i];
                ++i;
            }
            i = 0;
            while (i < anz) {
                newKidArray[i + oldKidArray.length] = value;
                ++i;
            }
        }
        parent.set(arrKey, newKidArray);
    }

    private static void incLongArr(Mouse parent, String arrKey, int anz, long value) {
        long[] newKidArray = null;
        long[] oldKidArray = (long[])parent.get(arrKey);
        if (oldKidArray == null) {
            newKidArray = new long[anz];
            int i = 0;
            while (i < newKidArray.length) {
                newKidArray[i] = value;
                ++i;
            }
        } else {
            newKidArray = new long[oldKidArray.length + anz];
            int i = 0;
            while (i < oldKidArray.length) {
                newKidArray[i] = oldKidArray[i];
                ++i;
            }
            i = 0;
            while (i < anz) {
                newKidArray[i + oldKidArray.length] = value;
                ++i;
            }
        }
        parent.set(arrKey, newKidArray);
    }

    private static IndexObject[] getACopyOfLSV(IndexObject[] from) {
        IndexObject[] res = null;
        if (from != null && from.length != 0) {
            res = new IndexObject[from.length];
            int i = 0;
            while (i < from.length) {
                res[i] = new IndexObject(from[i]);
                ++i;
            }
        }
        return res;
    }
}

