/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import java.io.File;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class MFF
extends FileFilter {
    public static final int TYPE_TXT = 0;
    public static final int TYPE_CSV = 1;
    public static final int TYPE_XLS = 2;
    public static final int TYPE_PDF = 3;
    public static final int TYPE_XML = 4;
    public static final int TYPE_IMAGE = 5;
    public static final int TYPE_ZIP = 6;
    public static final Object[] EXTENSIONS = new Object[]{new String[]{".txt"}, new String[]{".csv"}, new String[]{".xls"}, new String[]{".pdf"}, new String[]{".xml"}, new String[]{".gif", ".jpg", ".jpe", ".jpeg", ".png"}, new String[]{".zip"}};
    public static final String[] DESCRIPTIONS = new String[]{"TXT files (*.txt)", "CSV files (*.csv)", "Excel files (*.xls)", "PDF files (*.pdf)", "XML files (*.xml)", "Images (*.gif, *.jpg, *.jpe, *.jpeg, *.png)", "ZIP files (*.zip)"};
    private static Hashtable cvStandardFilters = new Hashtable();
    private String[] ivExtensions = null;
    private String ivDescription = null;

    public static MFF getFilter(int typ) {
        Integer key = new Integer(typ);
        MFF res = (MFF)cvStandardFilters.get(key);
        if (res == null) {
            res = new MFF(typ);
            cvStandardFilters.put(key, res);
        }
        return res;
    }

    public MFF(int standardTyp) {
        if (standardTyp < 0 || standardTyp >= EXTENSIONS.length) {
            throw new IllegalArgumentException("Unknown type of FileFilter: " + standardTyp);
        }
        this.ivExtensions = (String[])EXTENSIONS[standardTyp];
        this.ivDescription = DESCRIPTIONS[standardTyp];
    }

    public MFF(String[] extensions, String descriprion) {
        if (extensions == null || extensions.length == 0) {
            throw new IllegalArgumentException("Illegal value for extensions for FileFilter: " + extensions);
        }
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i] == null || extensions[i].trim().length() == 0) {
                throw new IllegalArgumentException("Illegal value for extensions for FileFilter: " + extensions[i]);
            }
            extensions[i] = extensions[i].toLowerCase().trim();
            ++i;
        }
        if (descriprion == null) {
            throw new IllegalArgumentException("Illegal value for descriprion for FileFilter: " + descriprion);
        }
        if ((descriprion = descriprion.trim()).length() == 0) {
            throw new IllegalArgumentException("Illegal value for descriprion for FileFilter: " + descriprion);
        }
        this.ivExtensions = extensions;
        this.ivDescription = descriprion;
    }

    public String polishFullPath(String fullPath) {
        if (this.ivExtensions == null || this.ivExtensions.length != 1) {
            return fullPath;
        }
        if (fullPath.toLowerCase().trim().endsWith(this.ivExtensions[0].toLowerCase())) {
            return fullPath;
        }
        return String.valueOf(fullPath) + this.ivExtensions[0];
    }

    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String filename = f.getName();
            if (filename.startsWith(".")) {
                return false;
            }
            int i = 0;
            while (i < this.ivExtensions.length) {
                if (filename.toLowerCase().endsWith(this.ivExtensions[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getDescription() {
        return this.ivDescription;
    }
}

