/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;

public abstract class NumberFormatter {
    private static final HashMap FORMATTERS = new HashMap();
    public static final NumberFormat STRAIN_FROMATTER = new DecimalFormat("0.######%");
    public static final NumberFormat STRAIN_FROMATTER_M1NKS = new DecimalFormat("0.#%");
    private static DecimalFormat cvFormatter = new DecimalFormat();
    private static NumberFormat cvDefaultFormatter = NumberFormat.getInstance();

    public static String formatNumberString(double value, int numDecimals) {
        if (numDecimals < 0) {
            return cvDefaultFormatter.format(value);
        }
        Integer key = new Integer(numDecimals);
        DecimalFormat df = (DecimalFormat)FORMATTERS.get(key);
        if (df == null) {
            df = new DecimalFormat(NumberFormatter.getNumberFormatString(numDecimals));
            FORMATTERS.put(key, df);
        }
        return NumberFormatter.getFormatted(value, df);
    }

    public static String getNumberFormatString(int numDecimals) {
        if (numDecimals < 0) {
            numDecimals = 0;
        }
        StringBuffer msb = new StringBuffer("##0");
        if (numDecimals > 0) {
            msb.append(".");
            int i = 0;
            while (i < numDecimals) {
                msb.append("#");
                ++i;
            }
        }
        return msb.toString();
    }

    public static String formatNumberString(String value, boolean withSpaces) {
        StringBuffer msb = new StringBuffer();
        if (value != null && value.trim().length() != 0) {
            if (withSpaces) {
                msb.append(" ");
            }
            double d = Double.parseDouble(value);
            msb.append(NumberFormatter.getFormatted(d, cvFormatter));
            if (withSpaces) {
                msb.append(" ");
            }
        }
        return msb.toString();
    }

    private static String getFormatted(double d, DecimalFormat df) {
        int anzDec = df.getMaximumFractionDigits();
        if (df.getMultiplier() == 100) {
            anzDec += 2;
        }
        BigDecimal myDec = new BigDecimal(Double.toString(d));
        myDec = myDec.setScale(anzDec, 4);
        return df.format(myDec.doubleValue());
    }
}

