/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.helper;

import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import java.awt.Desktop;
import java.io.File;
import mausoleum.alert.Alert;

public class OpenStandardFiles
implements Runnable {
    private File ivFile = null;

    static {
        if (new File("tmpclientfiles").exists()) {
            FileManager.deleteDir("tmpclientfiles", true);
        }
    }

    public static String getTempDir() {
        return "tmpclientfiles";
    }

    public static String getPath(String proposedFilename) {
        FileManager.prepareDirs("tmpclientfiles");
        proposedFilename = StringHelper.gSub(proposedFilename, "/", "_", true);
        proposedFilename = StringHelper.gSub(proposedFilename, "\\", "_", true);
        proposedFilename = StringHelper.gSub(proposedFilename, "\"", "_", true);
        proposedFilename = StringHelper.gSub(proposedFilename, "'", "_", true);
        proposedFilename = StringHelper.gSub(proposedFilename, ";", "_", true);
        proposedFilename = StringHelper.gSub(proposedFilename, ",", "_", true);
        String path = "tmpclientfiles/" + MilliSpender.getMillis() + "_" + proposedFilename;
        File f = new File(path);
        f.deleteOnExit();
        return path;
    }

    public static void openStandardFile(byte[] data, String proposedFilename) {
        String path = OpenStandardFiles.getPath(proposedFilename);
        FileManager.saveBytesToFile(path, data);
        new OpenStandardFiles(new File(path));
    }

    public static void openStandardFile(String path) {
        OpenStandardFiles.openStandardFile(new File(path));
    }

    public static void openStandardFile(File f) {
        boolean success = false;
        try {
            Desktop.getDesktop().open(f);
            success = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!success) {
            try {
                Runtime.getRuntime().exec(new String[]{"rundll32", "url.dll,FileProtocolHandler", f.getAbsolutePath()});
            }
            catch (Exception e) {
                Alert.showAlert(Babel.get("COULDNOTOPENFILE"), true);
            }
        }
    }

    private OpenStandardFiles(File pdfFile) {
        this.ivFile = pdfFile;
        new Thread(this).start();
    }

    public void run() {
        if (this.ivFile != null) {
            try {
                Thread.sleep(1000L);
                OpenStandardFiles.openStandardFile(this.ivFile);
            }
            catch (Exception e) {
                Log.error("Problem bei \u00d6ffnen von Datei: " + this.ivFile, e, this);
            }
        }
    }
}

