/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MilliSpender;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.tables.MausoleumTableFrame;
import mausoleum.tables.TableFrameTasks;
import mausoleum.ui.UIDef;

public class AlertLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private static final int MODE_UNKNOWN = 0;
    public static final int MODE_MAIL = 1;
    public static final int MODE_TASKS = 2;
    private static final long SPANNE = 5000L;
    private long ivActAlertMillis = -1L;
    private int ivActMode = 0;

    public AlertLabel() {
        this.setFont(FontManager.getFont("SSB11"));
        this.setHorizontalAlignment(0);
        this.setForeground(Color.white);
        this.setBorder(new EtchedBorder(Color.black, Color.white));
        this.setFocusable(false);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent arg0) {
                if (AlertLabel.this.ivActMode == 1) {
                    MausoleumTableFrame.showMainTableForType(11);
                    Inspector.removeAlarm(Babel.get("MAIL"), null);
                } else if (AlertLabel.this.ivActMode == 2) {
                    JFrame mtf = MausoleumTableFrame.showMainTableForType(15);
                    if (mtf != null) {
                        TableFrameTasks.showTaskTree();
                    }
                    Inspector.removeAlarm(Babel.get("TASKS"), null);
                }
                AlertLabel.this.doClear();
            }
        });
    }

    public boolean hasAlert() {
        return this.ivActAlertMillis != -1L;
    }

    public void setAlert(String s, int mode) {
        this.setBackground(UIDef.ALARM_COLOR);
        this.setOpaque(true);
        this.setText(s);
        this.ivActMode = mode;
        this.ivActAlertMillis = MilliSpender.getMillis();
        new Thread(new AlertWaiter(this.ivActAlertMillis)).start();
    }

    public void clearAlert(String s) {
        if (this.getText().equals(s)) {
            this.doClear();
        }
    }

    public void doClear() {
        if (this.ivActAlertMillis != -1L) {
            this.setText("");
            this.setBackground(null);
            this.setOpaque(false);
            this.ivActAlertMillis = -1L;
            this.ivActMode = 0;
        }
    }

    class AlertWaiter
    implements Runnable {
        private final long ivSigMillis;

        public AlertWaiter(long millis) {
            this.ivSigMillis = millis;
        }

        public void run() {
            try {
                Thread.sleep(50000L);
                if (AlertLabel.this.ivActAlertMillis == this.ivSigMillis) {
                    if (AlertLabel.this.ivActMode == 2) {
                        Inspector.removeAlarm(Babel.get("TASKS"), null);
                    }
                    AlertLabel.this.doClear();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

