/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import mausoleum.gui.MGButton;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;
import mausoleum.ui.UIDef;
import mausoleum.util.SystemIconManager;

public class DocumentsTable
extends JTable {
    private static final long serialVersionUID = 1456432L;
    private JLabel ivTableLabel = new JLabel("Qyaq");
    private MGButton ivHeaderButton = MGButton.getInspectorActionButton("", "");
    private final Vector ivDocuZeilen = new Vector();
    private final Vector ivDocuZeilenGroup = new Vector();
    static /* synthetic */ Class class$0;

    public static String getValue(Zeile z, int column) {
        long l;
        if (column == 0) {
            return z.getString(1, "");
        }
        if (column == 1) {
            long l2 = z.getLong(2, -1L);
            if (l2 != -1L) {
                return DatumFormat.getJustDateString(new Date(l2));
            }
        } else if (column == 2) {
            long l3 = z.getLong(3, -1L);
            if (l3 != -1L) {
                return DatumFormat.getJustDateString(new Date(l3));
            }
        } else if (column == 3 && (l = z.getLong(4, -1L)) != -1L) {
            int kb = (int)((l + 1024L) / 1024L);
            return String.valueOf(kb) + " kB";
        }
        return "";
    }

    public DocumentsTable() {
        this.setModel(new TableModel(){

            public int getRowCount() {
                return DocumentsTable.this.ivDocuZeilen.size();
            }

            public int getColumnCount() {
                return 4;
            }

            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return Babel.get("DTAB_FILENAME");
                    }
                    case 1: {
                        return Babel.get("DTAB_FILEDATE");
                    }
                    case 2: {
                        return Babel.get("DTAB_UPLOADDATE");
                    }
                    case 3: {
                        return Babel.get("DTAB_FILESIZE");
                    }
                }
                return "";
            }

            public Class getColumnClass(int arg0) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }

            public boolean isCellEditable(int row, int column) {
                return false;
            }

            public Object getValueAt(int row, int column) {
                Zeile z;
                if (row >= 0 && row < DocumentsTable.this.ivDocuZeilen.size() && (z = (Zeile)DocumentsTable.this.ivDocuZeilen.elementAt(row)) != null) {
                    return DocumentsTable.getValue(z, column);
                }
                return "";
            }

            public void setValueAt(Object arg0, int arg1, int arg2) {
            }

            public void addTableModelListener(TableModelListener arg0) {
            }

            public void removeTableModelListener(TableModelListener arg0) {
            }
        });
        this.getSelectionModel().setSelectionMode(0);
        this.getTableHeader().setPreferredSize(new Dimension(UIDef.getScaled(100), UIDef.getScaled(20)));
        this.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.getColumnModel().getColumn(2).setPreferredWidth(80);
        this.getColumnModel().getColumn(3).setPreferredWidth(60);
        this.setOpaque(false);
        this.getTableHeader().setDefaultRenderer(new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DocumentsTable.this.ivHeaderButton.setLabel(" " + DocumentsTable.this.getColumnName(column) + " ");
                return DocumentsTable.this.ivHeaderButton;
            }
        });
        this.ivTableLabel.setOpaque(false);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultRenderer(clazz, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DocumentsTable.this.ivTableLabel.setText(" " + value + " ");
                if (isSelected) {
                    DocumentsTable.this.ivTableLabel.setOpaque(true);
                    DocumentsTable.this.ivTableLabel.setBackground(UIDef.SELECTED_BACKGROUND);
                } else {
                    DocumentsTable.this.ivTableLabel.setOpaque(true);
                    DocumentsTable.this.ivTableLabel.setBackground(Color.white);
                }
                if (column == 3) {
                    DocumentsTable.this.ivTableLabel.setHorizontalAlignment(4);
                } else {
                    DocumentsTable.this.ivTableLabel.setHorizontalAlignment(2);
                }
                Icon icon = null;
                if (column == 0) {
                    icon = SystemIconManager.getIcon((String)value);
                }
                DocumentsTable.this.ivTableLabel.setIcon(icon);
                return DocumentsTable.this.ivTableLabel;
            }
        });
        this.setRowHeight(this.ivTableLabel.getPreferredSize().height);
    }

    public String getSelectedKennung(String defVal) {
        int row = this.getSelectedRow();
        if (row >= 0 && row < this.ivDocuZeilen.size()) {
            Zeile z = (Zeile)this.ivDocuZeilen.elementAt(row);
            return z.getString(0, defVal);
        }
        return defVal;
    }

    public String getSelectedDocuGroup(String defVal) {
        int row = this.getSelectedRow();
        if (row >= 0 && row < this.ivDocuZeilen.size()) {
            return (String)this.ivDocuZeilenGroup.elementAt(row);
        }
        return defVal;
    }

    public String getSelectedFilename(String defVal) {
        int row = this.getSelectedRow();
        if (row >= 0 && row < this.ivDocuZeilen.size()) {
            Zeile z = (Zeile)this.ivDocuZeilen.elementAt(row);
            return z.getString(1, defVal);
        }
        return defVal;
    }

    public void setData(HashMap hs) {
        this.ivDocuZeilen.clear();
        this.ivDocuZeilenGroup.clear();
        if (hs != null) {
            Iterator iter = hs.keySet().iterator();
            while (iter.hasNext()) {
                String dz = (String)iter.next();
                String group = (String)hs.get(dz);
                this.ivDocuZeilen.add(new Zeile(dz, '|'));
                this.ivDocuZeilenGroup.add(group);
            }
        }
        this.tableChanged(new TableModelEvent(this.getModel()));
    }
}

