/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.util.Babel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import mausoleum.gui.MGButton;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.gui.TextWrapComponent;
import mausoleum.helper.FontManager;
import mausoleum.inspector.DormantRequester;
import mausoleum.inspector.Inspector;
import mausoleum.ui.UIDef;
import mausoleum.util.Standards;

public class DormantPanel
extends JPanel {
    private static final long serialVersionUID = 1234234L;
    private static final long CHECK_INTERVALL = 180000L;
    private static final long WATCH_INTERVALL = Standards.getDormantThresholdInMillis();
    private static boolean cvWatchDogStarted = false;
    private static long cvLastAction = System.currentTimeMillis();
    private final TextWrapComponent ivText = new TextWrapComponent(Babel.get("DORMANT_MODE"), FontManager.getFont("SSB14"));
    private final MGButton ivAwakeButton = MGButton.getInspectorActionButton(Babel.get("AWAKE"), "awake");
    private final MGButton ivExitButton = MGButton.getInspectorActionButton(Babel.get("EXIT_CLIENT"), "exit");

    public static void startWatchDog() {
        if (!cvWatchDogStarted) {
            new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        Inspector inspector;
                        try {
                            Thread.sleep(180000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (System.currentTimeMillis() - cvLastAction <= WATCH_INTERVALL || (inspector = Inspector.getInspectorIfThere()) == null || !inspector.isAliveAndAwake()) continue;
                        DormantRequester smr = new DormantRequester();
                        if (smr.ivWarOK) {
                            inspector.goToSleep();
                            continue;
                        }
                        DormantPanel.actionDone();
                    }
                }
            }).start();
            cvWatchDogStarted = true;
        }
    }

    public static void actionDone() {
        cvLastAction = System.currentTimeMillis();
    }

    public DormantPanel() {
        this.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                int y = 0;
                int x = 0;
                DormantPanel.this.ivText.setSize(d.width, 100);
                DormantPanel.this.ivText.generateElements();
                int th = DormantPanel.this.ivText.getNecessaryHeight();
                DormantPanel.this.ivText.setBounds(x, y, d.width, th);
                y = d.height - UIDef.BUT_HEIGHT;
                DormantPanel.this.ivExitButton.setBounds(x, y, d.width, UIDef.BUT_HEIGHT);
                DormantPanel.this.ivAwakeButton.setBounds(x, y -= UIDef.BUT_HEIGHT + Inspector.RAND, d.width, UIDef.BUT_HEIGHT);
            }
        });
        this.setOpaque(false);
        this.ivText.setOrientation(1112);
        this.add(this.ivText);
        this.ivExitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Inspector inspector = Inspector.getInspectorIfThere();
                if (inspector != null && !inspector.isAliveAndAwake()) {
                    Inspector.exit();
                }
            }
        });
        this.add(this.ivExitButton);
        this.ivAwakeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Inspector inspector = Inspector.getInspectorIfThere();
                if (inspector != null && !inspector.isAliveAndAwake()) {
                    inspector.awake();
                }
            }
        });
        this.add(this.ivAwakeButton);
    }
}

