/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.session.UndoRedoState;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;
import mausoleum.alert.Alert;
import mausoleum.cage.CageManager;
import mausoleum.factsheets.FactSheetGroup;
import mausoleum.factsheets.groupreport.GroupStatistics;
import mausoleum.factsheets.sessionreports.SessionReport;
import mausoleum.genealogy.GenealogyFrame;
import mausoleum.gui.MGButton;
import mausoleum.gui.WindowMinimalSizer;
import mausoleum.helper.FontManager;
import mausoleum.helper.KomfortHashMap;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.AlertLabel;
import mausoleum.inspector.DormantPanel;
import mausoleum.inspector.InspectorMainPanel;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.InspectorPanelBuilding;
import mausoleum.inspector.InspectorPanelCage;
import mausoleum.inspector.InspectorPanelExperiment;
import mausoleum.inspector.InspectorPanelLicense;
import mausoleum.inspector.InspectorPanelLine;
import mausoleum.inspector.InspectorPanelLocus;
import mausoleum.inspector.InspectorPanelMail;
import mausoleum.inspector.InspectorPanelMouse;
import mausoleum.inspector.InspectorPanelMouseCohorts;
import mausoleum.inspector.InspectorPanelOwnerGroups;
import mausoleum.inspector.InspectorPanelRack;
import mausoleum.inspector.InspectorPanelRoom;
import mausoleum.inspector.InspectorPanelStrain;
import mausoleum.inspector.InspectorPanelTask;
import mausoleum.inspector.InspectorPanelUser;
import mausoleum.inspector.InspectorPanelUserGroup;
import mausoleum.inspector.InspectorPanelWedding;
import mausoleum.inspector.ObjectPopup;
import mausoleum.inspector.actions.IAManager;
import mausoleum.inspector.actions.room.RoomAction;
import mausoleum.inspector.sensitives.CSEartag;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.MouseIDCard;
import mausoleum.mouse.MouseManager;
import mausoleum.rack.frame.RackFrame;
import mausoleum.rack.frame.RackOverview;
import mausoleum.rack.frame.cagecard.RackCageCardFrame;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.requester.InfoDialog;
import mausoleum.requester.cage.HighlightCageRequester;
import mausoleum.requester.preferences.Preferences;
import mausoleum.search.SearchFrame;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableFrame;
import mausoleum.tables.PoolFrame;
import mausoleum.tables.TableFrameCage;
import mausoleum.tables.TableFrameMouse;
import mausoleum.tables.TableFrameTasks;
import mausoleum.task.DisplayTask;
import mausoleum.ui.UIDef;
import mausoleum.util.HelloMessage;
import mausoleum.util.InstallationType;
import mausoleum.util.Standards;
import mausoleum.util.calendar.InstituteHolidayDialog;

public class Inspector
extends JFrame
implements ActionListener,
LayoutManager {
    private static final long serialVersionUID = 8723005059668006690L;
    private static final int BREITE = UIDef.getScaled(400);
    private static final int HOEHE = UIDef.getScaled(624);
    private static final int MIN_BREITE = UIDef.getScaled(300);
    private static final int MIN_HOEHE = UIDef.getScaled(500);
    private static final int COMBO_HOEHE = UIDef.getScaled(32);
    private static final Dimension NORM_SIZE = new Dimension(BREITE, HOEHE);
    private static final Dimension MIN_SIZE = new Dimension(MIN_BREITE, MIN_HOEHE);
    public static final int RAND = UIDef.getScaled(6);
    protected static final int INTER_BUT = UIDef.getScaled(4);
    private static final int OBUT_HEIGHT = UIDef.getScaled(22);
    private static final int OBUT_RAND = UIDef.getScaled(2);
    private static final int OBUTS_PER_ROW = UIDef.getScaled(4);
    private static final int UBUT_HEIGHT = OBUT_HEIGHT;
    private static final int ALERT_HEIGHT = UIDef.getScaled(19);
    private static final String COM_MICE = "mice";
    private static final String COM_CAGES = "cages";
    private static final String COM_RACKS = "racks";
    private static final String COM_ROOMS = "room";
    private static final String COM_BUILDINGS = "building";
    private static final String COM_LOCI = "loci";
    private static final String COM_LINES = "lines";
    private static final String COM_STRAINS = "strains";
    private static final String COM_MATINGS = "weddings";
    private static final String COM_MAIL = "mail";
    private static final String COM_USERS = "users";
    private static final String COM_EXPERIMENTS = "experiments";
    private static final String COM_TASKS = "tasks";
    private static final String COM_LICENSES = "licenses";
    private static final String COM_USERGROUPS = "usergroups";
    private static final String COM_COHORTS = "cohorts";
    private static final String COM_OWNERGROUPS = "ownergroups";
    private static final String COM_PREFERENCES = "preferences";
    private static final String COM_SEARCH = "search";
    private static final String COM_REPORT = "report";
    protected static final String COM_INFO = "info";
    private static final String COM_STANDARDS = "standards";
    private static String[] VISIBLE_NORMAL_REAL_USER = new String[]{"mice", "cages", "racks", "tasks", "room", "loci", "lines", "strains", "weddings", "mail", "users", "ownergroups", "experiments", "licenses", "cohorts", "search", "report", "preferences"};
    private static String[] VISIBLE_NORMAL_HOS_USER = new String[]{"mice", "cages", "racks", "tasks", "room", "loci", "lines", "strains", "weddings", "users", "ownergroups", "experiments", "licenses", "cohorts", "search", "report", "preferences"};
    private static String[] VISIBLE_HEAD_OF_SERVICE = new String[]{"room", "racks", "building", "users", "usergroups", "mail", "tasks", "loci", "lines", "strains", "licenses", "experiments", "report", "preferences", "standards"};
    private static String[] VISIBLE_SERVICE_CARETAKER = new String[]{"mice", "cages", "racks", "tasks", "weddings", "mail", "loci", "lines", "strains", "users", "search", "report", "preferences"};
    private static String[] VISIBLE_CARETAKER = new String[]{"mice", "cages", "racks", "tasks", "room", "loci", "lines", "strains", "weddings", "mail", "users", "ownergroups", "experiments", "licenses", "cohorts", "search", "report", "preferences"};
    private static String[] VISIBLE_CARETAKER_TGSERVICE = new String[]{"mice", "cages", "racks", "tasks", "room", "loci", "lines", "strains", "weddings", "mail", "users", "ownergroups", "experiments", "licenses", "cohorts", "search", "report", "preferences"};
    private static String[] VISIBLE_HEAD_OF_TGSERVICE = new String[]{"mice", "cages", "racks", "tasks", "room", "loci", "lines", "strains", "weddings", "mail", "users", "ownergroups", "experiments", "licenses", "cohorts", "search", "report", "preferences"};
    private static final KomfortHashMap TYPES_BY_COMMAND = new KomfortHashMap();
    private static final Hashtable PANELS_BY_TYPE = new Hashtable(8);
    private static Inspector cvInstance = null;
    public static final Vector OBJECT_STRINGS = new Vector();
    public static final Vector OBJECT_COMMANDS = new Vector();
    private static final KomfortHashMap OBJECT_STRINGS_BY_OBJECTTYPE = new KomfortHashMap();
    public static final Color ALARM_BACKGROUND = new Color(255, 80, 80, 128);
    private static final AlertLabel ALERT_LABEL = new AlertLabel();
    public static InspectorPanel cvActPanel = null;
    public static MausoleumTable cvActTable = null;
    public static UndoRedoState cvLastUndoRedoState = null;
    private static final int SEARCH_CAGE_SIMPLE = 1;
    private static final int SEARCH_MOUSE_SIMPLE = 2;
    private static final int SEARCH_MOUSE_EXTENDED = 3;
    private static final int SEARCH_MOUSE_PRO = 4;
    private static final String[] SEARCH_CHOICES = new String[]{Babel.get("SIMPLE_CAGE_SEARCH"), Babel.get("SIMPLE_MOUSE_SEARCH"), Babel.get("EXTENDED_MOUSE_SEARCH"), Babel.get("PROFI_MOUSE_SEARCH")};
    private static final int[] SEARCH_MODES = new int[]{1, 2, 3, 4};
    private static final String[] SEARCH_CHOICES_SERVICE_CARETAKER = new String[]{Babel.get("SIMPLE_CAGE_SEARCH"), Babel.get("SIMPLE_MOUSE_SEARCH")};
    private static final int[] SEARCH_MODES_SERVICE_CARETAKER = new int[]{1, 2};
    private static final int STD_HOLIDAYS = 1;
    private static final int STD_MATLIM = 2;
    private static final int STD_WEANING_PERIOD = 3;
    private static final int STD_MATING_LINE_MAIL = 4;
    private static final int STD_EXPORT_TARGET_MAND = 5;
    private static final int STD_HELLO_MESSAGE = 99;
    private static final int STD_INST_INFO_MESSAGE = 98;
    private static final String[] STANDARD_CHOICES_FISH = new String[]{Babel.get("HOLIDAYS"), Babel.get("MATLIM"), Babel.get("WEANING_PERIOD")};
    private static final String[] STANDARD_CHOICES_MOUSE = new String[]{Babel.get("HOLIDAYS"), Babel.get("MATLIM"), Babel.get("WEANING_PERIOD"), Babel.get("MATING_LINE_MAIL"), Babel.get("ADDRESS_MANDATORY_EXIT")};
    private static final int[] STANDARDS_MOUSE = new int[]{1, 2, 3, 4, 5};
    private static final int[] STANDARDS_FISH = new int[]{1, 2, 3, 5};
    private static final MGButton UNDO_BUTTON;
    private static final MGButton REDO_BUTTON;
    private static final MGButton SLEEP_BUTTON;
    private static final MGButton INFO_BUTTON;
    private static MGButton REPORT_BUTTON;
    private static final Vector VIS_BUTTONS;
    private JLabel ivObjectLabel = new JLabel();
    private DormantPanel ivDormantPanel = new DormantPanel();
    private ObjectPopup ivPopup = null;
    private boolean ivAlive = true;
    private boolean ivAwake = true;
    private boolean ivComboResponds = true;

    static {
        REPORT_BUTTON = null;
        VIS_BUTTONS = new Vector();
        UNDO_BUTTON = MGButton.getMainInspectorButton(Babel.get("UNDO"), "", null);
        UNDO_BUTTON.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Boolean poss;
                ObjectRequest mor = new ObjectRequest(26, null, UserManager.getFirstGroup(), null);
                if ((mor = RequestManager.sendObjectRequestAndGetAnswer(mor)) != null && mor.isFinished() && !(poss = (Boolean)mor.ivObject).booleanValue()) {
                    Alert.showAlert(Babel.get("UNDOIMPOSSIBLE"), true);
                    return;
                }
                if (cvActTable != null) {
                    cvActTable.setIsActive(true);
                }
                RequestManager.sendObjectRequestAndGetAnswer(new ObjectRequest(21, null, null, null));
                if (cvActTable != null) {
                    cvActTable.setIsActive(true);
                }
            }
        });
        REDO_BUTTON = MGButton.getMainInspectorButton(Babel.get("REDO"), "", null);
        REDO_BUTTON.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Boolean poss;
                ObjectRequest mor = new ObjectRequest(27, null, UserManager.getFirstGroup(), null);
                if ((mor = RequestManager.sendObjectRequestAndGetAnswer(mor)) != null && mor.isFinished() && !(poss = (Boolean)mor.ivObject).booleanValue()) {
                    Alert.showAlert(Babel.get("REDOIMPOSSIBLE"), true);
                    return;
                }
                if (cvActTable != null) {
                    cvActTable.setIsActive(true);
                }
                RequestManager.sendObjectRequestAndGetAnswer(new ObjectRequest(22, null, null, null));
                if (cvActTable != null) {
                    cvActTable.setIsActive(true);
                }
            }
        });
        SLEEP_BUTTON = MGButton.getMainInspectorButton(Babel.get("SLEEP"), "", null);
        SLEEP_BUTTON.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (cvInstance != null) {
                    if (cvInstance.ivAwake) {
                        cvInstance.goToSleep();
                    } else {
                        cvInstance.awake();
                    }
                }
            }
        });
        INFO_BUTTON = MGButton.getMainInspectorButton(Babel.get("INFO"), COM_INFO, null);
        INFO_BUTTON.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfoDialog.showDialog();
            }
        });
    }

    public static Inspector getInspector() {
        if (cvInstance == null) {
            IAManager.init();
            cvInstance = new Inspector();
            Inspector.setAppropriateTitle();
        }
        return cvInstance;
    }

    public static Inspector getInspectorIfThere() {
        return cvInstance;
    }

    public static void removeInspector() {
        if (cvInstance != null) {
            Iterator iterator = VIS_BUTTONS.iterator();
            while (iterator.hasNext()) {
                MGButton but = (MGButton)iterator.next();
                but.removeActionListener(cvInstance);
            }
            VIS_BUTTONS.clear();
            MouseListener[] arr = Inspector.cvInstance.ivObjectLabel.getMouseListeners();
            int i = 0;
            while (i < arr.length) {
                Inspector.cvInstance.ivObjectLabel.removeMouseListener(arr[i]);
                ++i;
            }
            OBJECT_STRINGS.clear();
            OBJECT_COMMANDS.clear();
            OBJECT_STRINGS_BY_OBJECTTYPE.clear();
            cvInstance.setVisible(false);
            cvInstance.dispose();
            cvInstance = null;
        }
    }

    public static void userChanged() {
        if (cvInstance != null) {
            cvInstance.adaptToUser();
            cvInstance.validate();
            Inspector.setAppropriateTitle();
            if (cvInstance.isVisible()) {
                cvInstance.repaint();
            }
        }
    }

    public static void addAlarm(String objectName, String labelText, int mode) {
        Inspector inspector;
        boolean alarmVor = ALERT_LABEL.hasAlert();
        if (objectName != null && (inspector = Inspector.getInspectorIfThere()) != null) {
            inspector.ivPopup.addAlarm(objectName);
        }
        if (labelText != null) {
            ALERT_LABEL.setAlert(labelText, mode);
        }
        boolean alarmNach = ALERT_LABEL.hasAlert();
        Inspector.manageAlarmVorherNachher(alarmVor, alarmNach);
    }

    public static void removeAlarm(String objectName, String labelText) {
        Inspector inspector;
        boolean alarmVor = ALERT_LABEL.hasAlert();
        if (objectName != null && (inspector = Inspector.getInspectorIfThere()) != null) {
            inspector.ivPopup.removeAlarm(objectName);
        }
        if (labelText != null) {
            ALERT_LABEL.clearAlert(labelText);
        } else {
            ALERT_LABEL.doClear();
        }
        boolean alarmNach = ALERT_LABEL.hasAlert();
        Inspector.manageAlarmVorherNachher(alarmVor, alarmNach);
    }

    private static void manageAlarmVorherNachher(boolean alarmVor, boolean alarmNach) {
        Inspector inspector = Inspector.getInspectorIfThere();
        if (inspector != null) {
            if (inspector.ivAlive && inspector.ivAwake && alarmVor != alarmNach) {
                inspector.getContentPane().getLayout().layoutContainer(cvInstance.getContentPane());
                inspector.repaint();
            }
            inspector.ivObjectLabel.setBackground(alarmNach ? ALARM_BACKGROUND : null);
            inspector.ivObjectLabel.setOpaque(alarmNach);
        }
    }

    private Inspector() {
        this.setIconImage(MausoleumImageStore.getLogo());
        this.setContentPane(new InspectorMainPanel());
        this.getContentPane().setLayout(this);
        TYPES_BY_COMMAND.clear();
        this.addButtons(true);
        this.ivPopup = new ObjectPopup();
        Inspector.setObjectLabelText(null);
        this.ivObjectLabel.setOpaque(false);
        this.ivObjectLabel.setHorizontalAlignment(0);
        this.ivObjectLabel.setBorder(new EtchedBorder(Color.black, Color.white));
        this.ivObjectLabel.setFocusable(false);
        this.ivObjectLabel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent arg0) {
                Inspector inspector = Inspector.getInspectorIfThere();
                if (inspector != null && inspector.ivAlive && inspector.ivAwake && inspector.ivComboResponds) {
                    inspector.ivPopup.showUp(Inspector.this.getContentPane(), inspector.ivObjectLabel);
                }
            }
        });
        this.getContentPane().add(this.ivObjectLabel);
        this.getContentPane().add(ALERT_LABEL);
        if (MausoleumClient.isRegular()) {
            new InspectorPanelUser();
            new InspectorPanelStrain();
            new InspectorPanelLine();
            new InspectorPanelLocus();
            new InspectorPanelCage();
            new InspectorPanelMouse();
            if (InstallationType.useMatings()) {
                new InspectorPanelWedding();
            }
            if (UserManager.isRealUser()) {
                new InspectorPanelMail();
            }
            new InspectorPanelRoom();
            new InspectorPanelExperiment();
            new InspectorPanelTask();
            new InspectorPanelLicense();
            new InspectorPanelMouseCohorts();
            new InspectorPanelOwnerGroups();
        } else if (MausoleumClient.isHeadOfService()) {
            new InspectorPanelUser();
            new InspectorPanelRoom();
            new InspectorPanelUserGroup();
            new InspectorPanelRack();
            new InspectorPanelMail();
            new InspectorPanelBuilding();
            new InspectorPanelStrain();
            new InspectorPanelLine();
            new InspectorPanelLocus();
            new InspectorPanelLicense();
            new InspectorPanelExperiment();
        } else if (MausoleumClient.isServiceCaretaker()) {
            new InspectorPanelCage();
            new InspectorPanelMouse();
            if (InstallationType.useMatings()) {
                new InspectorPanelWedding();
            }
            new InspectorPanelMail();
            new InspectorPanelExperiment();
            new InspectorPanelTask();
            new InspectorPanelLicense();
            new InspectorPanelStrain();
            new InspectorPanelLine();
            new InspectorPanelLocus();
            new InspectorPanelUser();
        } else if (MausoleumClient.isHeadOfTGService()) {
            new InspectorPanelUser();
            new InspectorPanelStrain();
            new InspectorPanelLine();
            new InspectorPanelLocus();
            new InspectorPanelCage();
            new InspectorPanelMouse();
            if (InstallationType.useMatings()) {
                new InspectorPanelWedding();
            }
            if (UserManager.isRealUser()) {
                new InspectorPanelMail();
            }
            new InspectorPanelRoom();
            new InspectorPanelExperiment();
            new InspectorPanelTask();
            new InspectorPanelLicense();
            new InspectorPanelMouseCohorts();
            new InspectorPanelOwnerGroups();
        } else if (MausoleumClient.isTGServiceCaretaker()) {
            new InspectorPanelUser();
            new InspectorPanelStrain();
            new InspectorPanelLine();
            new InspectorPanelLocus();
            new InspectorPanelCage();
            new InspectorPanelMouse();
            if (InstallationType.useMatings()) {
                new InspectorPanelWedding();
            }
            if (UserManager.isRealUser()) {
                new InspectorPanelMail();
            }
            new InspectorPanelRoom();
            new InspectorPanelExperiment();
            new InspectorPanelTask();
            new InspectorPanelLicense();
            new InspectorPanelMouseCohorts();
            new InspectorPanelOwnerGroups();
        }
        this.pack();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Inspector.exit();
            }
        });
        this.setResizable(true);
        Insets inni = this.getInsets();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle defVal = new Rectangle(screen.width - (BREITE + inni.left + inni.right), 0, BREITE + inni.left + inni.right, HOEHE + inni.top + inni.bottom);
        WindowUtils.setRememberedBounds(this, defVal);
        new WindowMinimalSizer(this, MIN_BREITE, MIN_HOEHE, true);
    }

    public static void setUndoRedoState(UndoRedoState ur) {
        Inspector inspector = Inspector.getInspectorIfThere();
        if (inspector != null && ur != null) {
            cvLastUndoRedoState = ur;
            if (inspector.ivAlive && inspector.ivAwake) {
                UNDO_BUTTON.setEnabled(ur.ivU);
                REDO_BUTTON.setEnabled(ur.ivR);
            }
        }
    }

    protected static void addPanel(InspectorPanel ip, int objectType) {
        PANELS_BY_TYPE.put(new Integer(objectType), ip);
    }

    public static void setToDefault() {
        if (cvActPanel == null) {
            cvActTable = null;
            return;
        }
        if (cvActTable != null) {
            cvActTable.setIsActive(false);
        }
        cvActTable = null;
        cvInstance.getContentPane().remove(cvActPanel);
        cvInstance.getContentPane().repaint();
        cvActPanel = null;
        Inspector.setObjectLabelText(null);
        Inspector.setAppropriateTitle();
    }

    public static void setAppropriateTitle() {
        Inspector inspector = Inspector.getInspectorIfThere();
        if (inspector != null) {
            User user = UserManager.getUser();
            String userDescr = user == null ? "" : String.valueOf(user.getName("?")) + "/" + user.getGroup() + "/" + User.getStringForStatus(user.getInt("USR_MODE"));
            inspector.setTitle(String.valueOf(InstallationType.getCapitalProgramName()) + " " + "6.9.8 \u03b23" + " <" + userDescr + ">" + (RoomAction.cvRoomName != null ? " [" + RoomAction.cvRoomName + "]" : ""));
        }
    }

    public static void adjustToTable(MausoleumTable mt) {
        Inspector inspector = Inspector.getInspectorIfThere();
        if (inspector != null) {
            if (cvActTable != null && (mt == null || cvActTable != mt)) {
                cvActTable.setIsActive(false);
            }
            if (mt == null) {
                Inspector.setToDefault();
            } else if (mt.ivInspectorWillReact && inspector.ivAwake) {
                Integer obTypeInt = new Integer(mt.ivModel.getObjectType());
                InspectorPanel ip = (InspectorPanel)PANELS_BY_TYPE.get(obTypeInt);
                if (ip == null) {
                    Inspector.setToDefault();
                } else {
                    if (mt != cvActTable) {
                        cvActTable = mt;
                        cvActTable.setIsActive(true);
                    }
                    if (cvActPanel == ip) {
                        ip.adjustToSelectionChange(cvActTable);
                    } else {
                        if (cvActPanel != null) {
                            cvInstance.getContentPane().remove(cvActPanel);
                        }
                        cvInstance.getContentPane().add(ip);
                        cvActPanel = ip;
                        cvInstance.getContentPane().validate();
                        ip.adjustToSelectionChange(cvActTable);
                        String name = OBJECT_STRINGS_BY_OBJECTTYPE.getString(obTypeInt, "");
                        inspector.ivComboResponds = false;
                        Inspector.setObjectLabelText(name);
                        inspector.ivComboResponds = true;
                        cvInstance.repaint();
                    }
                }
            }
        }
    }

    private static void setObjectLabelText(String name) {
        Inspector inspector = Inspector.getInspectorIfThere();
        if (inspector != null) {
            if (name != null && name.trim().length() != 0) {
                inspector.ivObjectLabel.setFont(FontManager.getFont("SSB22"));
                inspector.ivObjectLabel.setText(name);
            } else {
                inspector.ivObjectLabel.setFont(FontManager.getFont("SSI20"));
                inspector.ivObjectLabel.setText(Babel.get("CLICK_TO_SELECT"));
            }
        }
    }

    public static void refreshInspector() {
        if (cvActPanel != null) {
            cvActPanel.adjustToSelectionChange(Inspector.cvActPanel.ivActTable);
        }
    }

    public static void checkReportButton() {
        if (MausoleumClient.isServiceCaretaker() && REPORT_BUTTON != null && !REPORT_BUTTON.isEnabled() && SessionReport.cvSessionReportAvailable) {
            REPORT_BUTTON.setEnabled(true);
        }
    }

    public static void exit() {
        boolean res = Alert.showAlert(Babel.get("WANTQUIT"), false);
        if (res) {
            Inspector.setToDefault();
            cvInstance.disableButtons();
            CSEartag.storeLastUsedEartag();
            GroupStatistics.saveStatisticsFromClient();
            if (UserManager.isPseudoGuruSession()) {
                MausoleumClient.returnFromHosGuru();
            } else {
                RequestManager.sendLogoutRequest();
                MausoleumClient.exit();
            }
        }
    }

    public void dispose() {
        this.getContentPane().removeAll();
        this.ivDormantPanel = null;
        super.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        String com;
        if (this.ivAlive && this.ivAwake && (com = e.getActionCommand()) != null && com.length() != 0) {
            DormantPanel.actionDone();
            int type = TYPES_BY_COMMAND.getInt(com, -1);
            if (type != -1) {
                MausoleumTableFrame.showMainTableForType(type);
            } else if (com.equals(COM_RACKS)) {
                RackFrame.showRackFrame();
            } else if (com.equals(COM_PREFERENCES)) {
                Preferences.showPreferences(Inspector.getInspector());
            } else if (COM_STANDARDS.equals(com)) {
                int[] val;
                String[] choices = InstallationType.isMouse() ? STANDARD_CHOICES_MOUSE : STANDARD_CHOICES_FISH;
                int[] nArray = val = InstallationType.isMouse() ? STANDARDS_MOUSE : STANDARDS_FISH;
                if (Privileges.hasPrivilege("EDIT_WELCOME_MESSAGE")) {
                    val = ArrayHelper.enlargeIntArray(val, 99);
                    choices = ArrayHelper.enlargeStringArray(choices, Babel.get("EDIT_HELLO_MESSAGE"));
                }
                if (Privileges.hasPrivilege("EDIT_INSTITUTE_INFO")) {
                    val = ArrayHelper.enlargeIntArray(val, 98);
                    choices = ArrayHelper.enlargeStringArray(choices, Babel.get("EDIT_INST_INFO_MESSAGE"));
                }
                String[] realChoices = new String[val.length];
                int i = 0;
                while (i < realChoices.length) {
                    String choice = choices[i];
                    if (val[i] != 1) {
                        if (val[i] == 2) {
                            choice = String.valueOf(choice) + " " + StringHelper.gSub(Babel.get("CURRENT_VAL"), "_VAL_", String.valueOf(Integer.toString(Standards.getMaturityLimitInDays())) + " " + Babel.get("DAYS"));
                        } else if (val[i] == 3) {
                            choice = String.valueOf(choice) + " " + StringHelper.gSub(Babel.get("CURRENT_VAL"), "_VAL_", String.valueOf(Integer.toString(Standards.getWeanPeriodInDays())) + " " + Babel.get("DAYS"));
                        } else if (val[i] == 4) {
                            choice = String.valueOf(choice) + " " + StringHelper.gSub(Babel.get("CURRENT_VAL"), "_VAL_", Babel.get(Standards.extendedAlertFoMatingWithoutMatchingLine() ? "YES" : "NO"));
                        } else if (val[i] == 5) {
                            choice = String.valueOf(choice) + " " + StringHelper.gSub(Babel.get("CURRENT_VAL"), "_VAL_", Babel.get(Standards.isExportAdressManadatory() ? "YES" : "NO"));
                        }
                    }
                    realChoices[i] = choice;
                    ++i;
                }
                int index = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), Babel.get("SELECT_STANDARD_TYPE"), realChoices);
                if (index != -1) {
                    if (val[index] == 1) {
                        InstituteHolidayDialog.editDefinitions(Inspector.getInspector());
                    } else if (val[index] == 2) {
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        Standards.setConfigInt("MATURITY_VAL", this, Babel.get("ENTER_MATURITY_LIMIT"));
                        this.setCursor(Cursor.getDefaultCursor());
                    } else if (val[index] == 3) {
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        Standards.setConfigInt("WEANING_VAL", this, Babel.get("ENTER_WEANING_LIMIT"));
                        this.setCursor(Cursor.getDefaultCursor());
                    } else if (val[index] == 4) {
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        Standards.setConfigInt("MATING_MIT_LINE_MAIL", this, Babel.get("MATING_LINE_MAIL"));
                        this.setCursor(Cursor.getDefaultCursor());
                    } else if (val[index] == 5) {
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        Standards.setConfigInt("ADDRESS_MANDATORY_EXIT", this, Babel.get("ADDRESS_MANDATORY_EXIT"));
                        this.setCursor(Cursor.getDefaultCursor());
                    } else if (val[index] == 99) {
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        HelloMessage.editSystemMessage(this, 1, Babel.get("EDIT_HELLO_MESSAGE"), null);
                        this.setCursor(Cursor.getDefaultCursor());
                    } else if (val[index] == 98) {
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        HelloMessage.editSystemMessage(this, 2, Babel.get("EDIT_INST_INFO_MESSAGE"), null);
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            } else if (com.equals(COM_SEARCH)) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                String[] choices = SEARCH_CHOICES;
                int[] modes = SEARCH_MODES;
                if (MausoleumClient.isServiceCaretaker()) {
                    choices = SEARCH_CHOICES_SERVICE_CARETAKER;
                    modes = SEARCH_MODES_SERVICE_CARETAKER;
                }
                int ind = AllgChoiceRequester.getIndexAnswer((Frame)this, Babel.get("SELECT_SEARCH"), choices);
                Inspector.getInspector().setCursor(Cursor.getDefaultCursor());
                if (ind != -1) {
                    int mode = modes[ind];
                    if (mode == 1) {
                        new HighlightCageRequester(this).setVisible(true);
                    } else if (mode == 2) {
                        SearchFrame.showMouseSearch(0);
                    } else if (mode == 3) {
                        SearchFrame.showMouseSearch(1);
                    } else if (mode == 4) {
                        SearchFrame.showMouseSearch(2);
                    }
                }
            } else if (com.equals(COM_REPORT)) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    FactSheetGroup.groupReportForReportButton();
                }
                catch (Exception exc) {
                    Log.error("Problem mit Group FactSheet ", exc, this);
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public void goToSleep() {
        if (this.ivAwake) {
            ObjectRequest mor = new ObjectRequest(44, null, UserManager.getFirstGroup(), null);
            if ((mor = RequestManager.sendObjectRequestAndGetAnswer(mor)) != null && mor.isFinished()) {
                this.goToSleepInner();
            }
        }
    }

    public void goToSleepInner() {
        RackFrame rf;
        this.ivAwake = false;
        Inspector.setToDefault();
        UNDO_BUTTON.setEnabled(false);
        REDO_BUTTON.setEnabled(false);
        SLEEP_BUTTON.setEnabled(false);
        this.disableButtons();
        MausoleumTableFrame.removeAllTables(true);
        RackCageCardFrame.hideCageCardFrame();
        RackOverview.hideIt();
        GenealogyFrame.hideIt();
        PoolFrame.hideIt();
        TableFrameMouse.hideIt();
        TableFrameCage.hideIt();
        SearchFrame.hideIt();
        MouseIDCard.hideIt();
        if (MausoleumClient.isRegularOrTGService() && (rf = RackFrame.getInstanceIfPresent()) != null) {
            rf.setVisible(false);
        }
        Inspector.setToDefault();
        this.getContentPane().add(this.ivDormantPanel);
        this.getContentPane().validate();
        Inspector.setAppropriateTitle();
        this.repaint();
    }

    public boolean isInSchlummer() {
        return !this.ivAwake;
    }

    public void awake() {
        ObjectRequest mor = RequestManager.createSendAndGetAnswer((byte)45, null, UserManager.getFirstGroup());
        if (mor != null && mor.isFinished()) {
            this.ivAwake = true;
            this.getContentPane().remove(this.ivDormantPanel);
            Inspector.setToDefault();
            Inspector.setUndoRedoState(cvLastUndoRedoState);
            SLEEP_BUTTON.setEnabled(true);
            MausoleumTableFrame.initMainTables();
            if (MausoleumClient.isRegularOrTGService()) {
                TableFrameTasks.restAlertWindowMarker();
                CageManager.performWeanControl(false);
                MouseManager.performPlugAlertControl(false);
                DisplayTask.init();
                TableFrameTasks.showWindowIfNecessary();
            }
            this.enableButtons();
            this.repaint();
            DormantPanel.actionDone();
        } else {
            Alert.showAlert(Babel.get("AWAKE_NOT_POSSIBLE"), true);
        }
    }

    public boolean isAliveAndAwake() {
        return this.ivAlive && this.ivAwake;
    }

    private void addButtons(boolean alsoDoUndoSleep) {
        HashSet<String> hs = new HashSet<String>();
        String[] acCommands = null;
        if (MausoleumClient.isRegular()) {
            acCommands = UserManager.cvIsCareTaker ? VISIBLE_CARETAKER : (UserManager.isRealUser() ? VISIBLE_NORMAL_REAL_USER : VISIBLE_NORMAL_HOS_USER);
        } else if (MausoleumClient.isHeadOfService()) {
            acCommands = VISIBLE_HEAD_OF_SERVICE;
        } else if (MausoleumClient.isServiceCaretaker()) {
            acCommands = VISIBLE_SERVICE_CARETAKER;
        } else if (MausoleumClient.isHeadOfTGService()) {
            acCommands = VISIBLE_HEAD_OF_TGSERVICE;
        } else if (MausoleumClient.isTGServiceCaretaker()) {
            acCommands = VISIBLE_CARETAKER_TGSERVICE;
        }
        if (acCommands != null) {
            int i = 0;
            while (i < acCommands.length) {
                hs.add(acCommands[i]);
                ++i;
            }
        }
        this.doSingleButton(hs, "MICE", COM_MICE, 1);
        this.doSingleButton(hs, "CAGES", COM_CAGES, 2);
        int typFuerRack = -2;
        if (MausoleumClient.isHeadOfService()) {
            typFuerRack = 3;
        }
        this.doSingleButton(hs, "RACKS", COM_RACKS, typFuerRack);
        this.doSingleButton(hs, "TASKS", COM_TASKS, 15);
        this.doSingleButton(hs, "ROOMS", COM_ROOMS, 10);
        this.doSingleButton(hs, "BUILDINGS", COM_BUILDINGS, 22);
        this.doSingleButton(hs, "LOCI", COM_LOCI, 14);
        this.doSingleButton(hs, "LINES", COM_LINES, 7);
        this.doSingleButton(hs, "STRAINS", COM_STRAINS, 8);
        if (InstallationType.useMatings()) {
            this.doSingleButton(hs, "WEDDINGS", COM_MATINGS, 4);
        }
        this.doSingleButton(hs, "MAIL", COM_MAIL, 11);
        this.doSingleButton(hs, "USERS", COM_USERS, 6);
        this.doSingleButton(hs, "OWNER_GROUPS", COM_OWNERGROUPS, 20);
        this.doSingleButton(hs, "EXPS", COM_EXPERIMENTS, 12);
        this.doSingleButton(hs, "LICENSES", COM_LICENSES, 16);
        this.doSingleButton(hs, "GROUPS", COM_USERGROUPS, 18);
        this.doSingleButton(hs, "COHORTS", COM_COHORTS, 21);
        this.doSingleButton(hs, "SEARCH_BIG", COM_SEARCH, -1);
        this.doSingleButton(hs, "REPORT", COM_REPORT, -1);
        this.doSingleButton(hs, "PREFS", COM_PREFERENCES, -1);
        this.doSingleButton(hs, "STANDARDS", COM_STANDARDS, -1);
        if (alsoDoUndoSleep) {
            UNDO_BUTTON.setEnabled(false);
            this.getContentPane().add(UNDO_BUTTON);
            REDO_BUTTON.setEnabled(false);
            this.getContentPane().add(REDO_BUTTON);
            SLEEP_BUTTON.setEnabled(true);
            this.getContentPane().add(SLEEP_BUTTON);
            INFO_BUTTON.setEnabled(true);
            this.getContentPane().add(INFO_BUTTON);
        }
    }

    private void doSingleButton(HashSet hs, String nameBabel, String command, int objTyp) {
        if (hs != null && hs.contains(command)) {
            if (objTyp == -1) {
                MGButton tb = MGButton.getMainInspectorButton(Babel.get(nameBabel), command, this);
                VIS_BUTTONS.add(tb);
                if (command.equals(COM_REPORT)) {
                    REPORT_BUTTON = tb;
                    tb.setEnabled(Privileges.hasPrivilege("VIEW_REPORTS"));
                } else if (command.equals(COM_STANDARDS)) {
                    tb.setEnabled(Privileges.hasPrivilege("EDIT_STANDARDS"));
                }
                this.getContentPane().add(tb);
            } else {
                String name = Babel.get(nameBabel);
                OBJECT_STRINGS.add(name);
                OBJECT_COMMANDS.add(command);
                if (objTyp != -2) {
                    TYPES_BY_COMMAND.put((Object)command, objTyp, -2);
                    OBJECT_STRINGS_BY_OBJECTTYPE.put((Object)new Integer(objTyp), name);
                }
            }
        }
    }

    private void adaptToUser() {
        Iterator iter = VIS_BUTTONS.iterator();
        while (iter.hasNext()) {
            MGButton but = (MGButton)iter.next();
            but.removeActionListener(this);
            this.getContentPane().remove(but);
        }
        VIS_BUTTONS.clear();
        OBJECT_STRINGS.clear();
        OBJECT_COMMANDS.clear();
        OBJECT_STRINGS_BY_OBJECTTYPE.clear();
        this.addButtons(false);
        this.ivPopup.adaptToNewUser();
    }

    public void disableButtons() {
        this.enDisButtons(false);
    }

    public void enableButtons() {
        this.enDisButtons(true);
    }

    private void enDisButtons(boolean enabled) {
        Iterator iter = VIS_BUTTONS.iterator();
        while (iter.hasNext()) {
            MGButton but = (MGButton)iter.next();
            String command = but.getActionCommand();
            if (command.equals(COM_REPORT)) {
                but.setEnabled(enabled && (Privileges.hasPrivilege("VIEW_REPORTS") || MausoleumClient.isServiceCaretaker() && SessionReport.cvSessionReportAvailable));
                continue;
            }
            if (command.equals(COM_STANDARDS)) {
                but.setEnabled(enabled && Privileges.hasPrivilege("EDIT_STANDARDS"));
                continue;
            }
            but.setEnabled(enabled);
        }
        this.ivObjectLabel.setEnabled(enabled);
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void layoutContainer(Container parent) {
        Dimension d = parent.getSize();
        int innerBreite = d.width - 2 * RAND;
        int nbw = (innerBreite - OBUT_RAND * (OBUTS_PER_ROW - 1)) / OBUTS_PER_ROW;
        int lbw = innerBreite - (OBUTS_PER_ROW - 1) * (nbw + OBUT_RAND);
        int x = RAND;
        int y = RAND;
        this.ivObjectLabel.setBounds(RAND, y, innerBreite, COMBO_HOEHE);
        int panelStart = y += COMBO_HOEHE + RAND;
        int uButY = d.height - RAND - UBUT_HEIGHT;
        if (ALERT_LABEL.hasAlert() && this.ivAlive && this.ivAwake) {
            int alerty = d.height - RAND - ALERT_HEIGHT;
            ALERT_LABEL.setBounds(RAND, alerty, innerBreite, ALERT_HEIGHT);
            uButY = alerty - UBUT_HEIGHT - INTER_BUT;
        } else {
            ALERT_LABEL.setBounds(0, 0, 0, 0);
        }
        int anzbuts = 4;
        nbw = (innerBreite - (anzbuts - 1) * INTER_BUT) / anzbuts;
        lbw = innerBreite - (anzbuts - 1) * (INTER_BUT + nbw);
        x = RAND;
        UNDO_BUTTON.setBounds(x, uButY, nbw, UBUT_HEIGHT);
        REDO_BUTTON.setBounds(x += nbw + INTER_BUT, uButY, nbw, UBUT_HEIGHT);
        SLEEP_BUTTON.setBounds(x += nbw + INTER_BUT, uButY, nbw, UBUT_HEIGHT);
        INFO_BUTTON.setBounds(x += nbw + INTER_BUT, uButY, lbw, UBUT_HEIGHT);
        if (!VIS_BUTTONS.isEmpty()) {
            uButY -= UBUT_HEIGHT + INTER_BUT;
            anzbuts = VIS_BUTTONS.size();
            nbw = (innerBreite - (anzbuts - 1) * INTER_BUT) / anzbuts;
            lbw = innerBreite - (anzbuts - 1) * (INTER_BUT + nbw);
            x = RAND;
            int i = 0;
            while (i < VIS_BUTTONS.size()) {
                int w = nbw;
                if (i == VIS_BUTTONS.size() - 1) {
                    w = lbw;
                }
                JComponent jc = (JComponent)VIS_BUTTONS.elementAt(i);
                jc.setBounds(x, uButY, w, UBUT_HEIGHT);
                x += w + INTER_BUT;
                ++i;
            }
        }
        int panelHeight = uButY - RAND - panelStart;
        if (this.ivDormantPanel != null) {
            this.ivDormantPanel.setBounds(RAND, panelStart, innerBreite, panelHeight);
        }
        if (cvActPanel != null) {
            cvActPanel.setBounds(RAND, panelStart, innerBreite, panelHeight);
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return MIN_SIZE;
    }

    public Dimension preferredLayoutSize(Container parent) {
        return NORM_SIZE;
    }

    public void removeLayoutComponent(Component comp) {
    }
}

